package com.ejianc.business.steelstructure.prosub.settle.service;


import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.steelstructure.prosub.settle.bean.SettleEntity;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;
import java.util.List;

/**
 * 结算主实体
 *
 * @author generator
 */
public interface IFinishSettleService extends IBaseService<SettleEntity> {

    CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType);

    CommonResponse queryFinishFlag(Long contractId);

    /**
     * 推送目标成本SettleVO
     *
     * @param settleEntity 最终结算实体
     *
     * @return 结算单VO
     */
    SettleVO getPushTargetCostSettleVO(SettleEntity settleEntity);

    ExecutionVO targetCost(SettleVO settleVO, String linkUrl, Integer contractType);

    ParamsCheckVO mnyCtrl(SettleVO settleVO);

    ParamsCheckVO numCtrl(SettleVO settleVO, Boolean flag);

    /**
     * 最终结算保存、更新
     *
     * @param saveOrUpdateVO
     * @return
     */
    SettleVO saveFinishSettle(SettleVO saveOrUpdateVO);

    /**
     * 结算单批量删除
     *
     * @param billIds
     * @return
     */
    String delBatch(List<Long> billIds);
}
