package com.ejianc.business.steelstructure.prosub.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractEntity;
import com.ejianc.business.steelstructure.prosub.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractService;
import com.ejianc.business.steelstructure.prosub.settle.bean.SettleDetailEntity;
import com.ejianc.business.steelstructure.prosub.settle.bean.SettleEntity;
import com.ejianc.business.steelstructure.prosub.settle.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.prosub.settle.service.IFinishSettleService;
import com.ejianc.business.steelstructure.prosub.settle.service.ISettleService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author baipengyan
 */
@Service("finishSettle")
public class FinishSettleBpmServiceImpl implements ICommonBusinessService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IFinishSettleService service;

    @Autowired
    private ISettleService settleService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IContractService contractService;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IFinishSettleService finishSettleService;
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
/*         // 结算单日期校验
        SettleEntity settleEntity = service.selectById(billId);
        if (settleEntity == null) {
            return CommonResponse.error("查询不到该单据信息！");
        }
        // 打印结算单日志
        logger.info("结算单提交前回调，结算单信息：{}", JSON.toJSONString(settleEntity));
        QueryWrapper<SettleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", settleEntity.getContractId());
        queryWrapper.select("ifnull(max(settle_date),0) as max_settle_date");
        Map<String, Object> map = service.getMap(queryWrapper);
        // 打印结果日志
        logger.info("查询结算单最大日期：{}", JSON.toJSONString(map));
        // 结算单日期不能小于等于最大结算日期
        if (settleEntity.getSettleDate().compareTo((Date) map.get("max_settle_date")) <= 0) {
            return CommonResponse.error("结算单日期不能小于等于最大结算日期！");
        } */
        return CommonResponse.success("完工结算-提交前回调成功！");
    }

    /**
     * 终审审核完回调
     *
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);
        if (settleEntity != null) {
            settleEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            //直审时添加单据提交人等信息
            UserContext userContext = sessionManager.getUserContext();
            settleEntity.setCommitDate(new Date());
            settleEntity.setCommitUserCode(userContext.getUserCode());
            settleEntity.setCommitUserName(userContext.getUserName());
        }

        //查询该单据是否支持协同分享，则向供方协同服务推送该单据
        CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
        if (!cooperateResp.isSuccess()) {
            logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
            settleEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }

        service.saveOrUpdate(settleEntity, false);

        // 协同推送
        if (cooperateResp.isSuccess()) {
            settleService.pushBillToSupCenter(BeanMapper.map(settleEntity, SettleEntity.class), billTypeCode, cooperateResp.getData());
        }
        // 结算池推送
        String msg = settleService.pushSettleToPool(BeanMapper.map(settleEntity, SettleVO.class));
        if(StringUtils.isNotBlank(msg)) {
            logger.error("最终结算-【{}】推送合同池失败， 原因：{}", JSONObject.toJSONString(settleEntity), msg);
        }

        // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"approve"审批通过后，"back"撤回后
        updateContractPoolTotalSettleMnyAfterSettle(settleEntity, "approve");

        // 完工结算修改合同状态为已封账
//        QueryParam param = new QueryParam();
//        param.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
//        List<ContractEntity> contractEntities = contractService.queryList(param, false);
//        contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.已封账.getCode());
//        logger.info("======完工结算终审审核完回调,已封账======,{}", JSONObject.toJSONString(contractEntities.get(0)));
//        contractService.saveOrUpdate(contractEntities.get(0), false);

        // 推送 实际成本
        //settleService.costPush(settleEntity);

        SettleVO settleVO = service.getPushTargetCostSettleVO(settleEntity);
        String linkUrl;
        if (settleVO.getContractType() == 0) {
            linkUrl = BaseHost + "ejc-prosub-frontend/#/finishSettle/laborsub/card?id=" + settleVO.getId();
        } else {
            linkUrl = BaseHost + "ejc-prosub-frontend/#/finishSettle/prosub/card?id=" + settleVO.getId();
        }
//        ExecutionVO executionVO = finishSettleService.targetCost(settleVO,linkUrl,settleVO.getContractType());
//        logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
//        CommonResponse<String> response = executionApi.aggPush(executionVO);
//        if (!response.isSuccess()){
//            throw new BusinessException("目标成本推送失败,"+response.getMsg());
//        }


        // String linkUrl;
        // for(ContractEntity contractEntity:contractEntityList){
        //     ContractVO cv = BeanMapper.map(contractEntity, ContractVO.class);
        //     if (null != cv.getSupplementFlag() && 1 == cv.getSupplementFlag()) {
        //         linkUrl = contractService.getSupplementLinkUrl(cv);
        //     } else {
        //         linkUrl = contractService.getLinkUrl(cv);
        //     }
        //     contractEntity.setDetailList(contractDetailEntities);
        //     ExecutionVO executionVO = finishSettleService.targetCost(cv,linkUrl,cv.getContractType());
        //     logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
        //     CommonResponse<String> response = executionApi.aggPush(executionVO);
        //     if (!response.isSuccess()){
        //         throw new BusinessException("目标成本推送失败,"+response.getMsg());
        //     }
        // }

        return CommonResponse.success("完工结算终审回调成功！");
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);
        // //查询合同
        // LambdaQueryWrapper<ContractEntity> contractQuery = new LambdaQueryWrapper<>();
        // contractQuery.eq(ContractEntity::getId, settleEntity.getContractId());
        // contractQuery.in(ContractEntity::getBillState,1,3);
        // contractQuery.eq(ContractEntity::getDr,0);
        // List<ContractEntity> contractEntityList = contractService.list(contractQuery); // 完工结算
        //
        // //推送目标成本
        // List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        // //  List<ContractEntity>  contractEntityList = new ArrayList<>();
        // for (ContractEntity contractEntity : contractEntityList) {
        //     ExecutionVO executionVO = settleService.targetCost(BeanMapper.map(contractEntity, ContractVO.class),"",contractEntity.getContractType());
        //     totalExecutionVOList.add(executionVO.getTotalVO());
        // }

        // 删除目标成本数据
        executionAggDel(settleEntity);
        return bpmBackCheck(billId, state, billTypeCode);
    }

    private void executionAggDel(SettleEntity settleEntity) {

        // 过滤明细表叶子结点
        List<SettleDetailEntity> detailEntities = settleEntity.getSettleDetailList().stream().filter(item -> item.getSettleNum() != null).collect(Collectors.toList());
        settleEntity.setSettleDetailList(detailEntities);

        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        ExecutionVO executionVO = finishSettleService.targetCost(BeanMapper.map(settleEntity, SettleVO.class), "", settleEntity.getContractType());
        totalExecutionVOList.add(executionVO.getTotalVO());
        logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本删除失败," + response.getMsg());
        }
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);
      //   //查询合同
      //   LambdaQueryWrapper<ContractEntity> contractQuery = new LambdaQueryWrapper<>();
      //   contractQuery.eq(ContractEntity::getId, settleEntity.getContractId());
      //   contractQuery.in(ContractEntity::getBillState,1,3);
      //   contractQuery.eq(ContractEntity::getDr,0);
      //   List<ContractEntity> contractEntityList = contractService.list(contractQuery); // 完工结算
      //
      //   //推送目标成本
      //   List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
      // //  List<ContractEntity>  contractEntityList = new ArrayList<>();
      //   for (ContractEntity contractEntity : contractEntityList) {
      //       ExecutionVO executionVO = settleService.targetCost(BeanMapper.map(contractEntity, ContractVO.class),"",contractEntity.getContractType());
      //       totalExecutionVOList.add(executionVO.getTotalVO());
      //   }

        // 删除目标成本数据
        executionAggDel(settleEntity);
        return bpmBackCheck(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

        logger.info("完工单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);

        // 签章流程校验
        SettleEntity settleEntity = service.selectById(billId);
        if (settleEntity == null) {
            return CommonResponse.error("查询不到该单据信息！");
        }
        logger.info("完工结算弃审/撤回前回调结算实体信息为：{}", JSONObject.toJSONString(settleEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        //检测单据是否供应商已签字，
        if (SupplierSignStatusEnum.乙方已签字.getCode().equals(settleEntity.getSupplierSignStatus())) {
            return CommonResponse.error("供应商已签字，无法执行此操作！");
        }

        // 审批可以撤回的签章状态集合
        ArrayList<Integer> statusList = new ArrayList<>();
        statusList.add(SignatureStatusEnum.未签章.getCode());
        statusList.add(SignatureStatusEnum.已退回.getCode());
        statusList.add(SignatureStatusEnum.已撤回.getCode());
        statusList.add(SignatureStatusEnum.已过期.getCode());

        if (!statusList.contains(settleEntity.getSignatureStatus())) {
            return CommonResponse.error("当前单据已走签章流程，不能弃审/撤回！");
        }

        //合同是否被其他单据引用
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

        if (!res.isSuccess()) {
            return CommonResponse.error("当前单据已被下游业务引用，不能弃审/撤回！");
        }

        //提交或审批通过的单据进行撤回，需更新结算池、合同池
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(settleEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(settleEntity.getBillState())){
            // 从结算池中删除数据
            String unPushRes = settleService.delSettleFromPool(settleEntity.getId());
            if (StringUtils.isBlank(unPushRes)) {
                settleEntity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
            } else {
                logger.error("将完工结算单-{}从结算池删除失败！", settleEntity);
                return CommonResponse.error("操作失败，单据从结算池删除失败，原因：" + unPushRes);
            }

            // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"approve"审批通过后，"back"撤回后
            updateContractPoolTotalSettleMnyAfterSettle(settleEntity, "back");
        }

        //将推送至供方的单据作废
        if (BillPushStatusEnum.推送成功.getStatus().equals(settleEntity.getBillPushFlag())) {
            boolean pushResult = settleService.delPushBill(settleEntity, billTypeCode);

            if (!pushResult) {
                return CommonResponse.error("完工结算审批回调失败，删除协同服务单据失败！");
            } else {
                settleEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
                service.saveOrUpdate(settleEntity, false);
            }
        }
        //删除实际成本数据
        if ("1".equals(settleEntity.getRelationFlag())){
            settleService.costDeletePush(settleEntity);
        }
        // 完工结算撤回修改合同状态为履约中
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
        List<ContractEntity> contractEntities = contractService.queryList(param, false);
        contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
        logger.info("======完工结算弃审前回调,修改合同状态为履约中======,{}", JSONObject.toJSONString(contractEntities.get(0)));
        contractService.saveOrUpdate(contractEntities.get(0), false);

        return CommonResponse.success("弃审/撤回前校验回调成功！");
    }

    private void updateContractPoolTotalSettleMnyAfterSettle(SettleEntity settleEntity, String type) {
        boolean updateRes = settleService.updateContractPoolTotalSettleMnyAfterSettle(settleEntity, type);
        if (updateRes) {
            logger.info("结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额）成功");
        } else {
            logger.error("结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额）失败");
        }
    }

}
