package com.ejianc.business.steelstructure.prosub.settle.service.impl;


import com.ejianc.business.steelstructure.prosub.settle.bean.SettleDeductEntity;
import com.ejianc.business.steelstructure.prosub.settle.mapper.SettleDeductMapper;
import com.ejianc.business.steelstructure.prosub.settle.service.ISettleDeductService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 结算子表-奖罚扣款单
 *
 * @author generator
 */
@Service("settleDeductService")
public class SettleDeductServiceImpl extends BaseServiceImpl<SettleDeductMapper, SettleDeductEntity> implements ISettleDeductService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    SettleDeductMapper mapper;

    /**
     * 查询奖罚扣款单列表数据（已生效、没有被过程结算引用、日期小于等于结算日期、日期倒序排列）
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettleDeductEntity>
     */
    @Override
    public List<SettleDeductEntity> queryDeductList(Integer settleType, Long contractId, Date settleDate) {
        return mapper.queryDeductList(settleType, contractId, settleDate);
    }
}
