package com.ejianc.business.steelstructure.prosub.settle.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.steelstructure.prosub.settle.bean.SettleSalaryEntity;
import com.ejianc.business.steelstructure.prosub.settle.mapper.SettleSalaryMapper;
import com.ejianc.business.steelstructure.prosub.settle.service.ISettleSalaryService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 结算子表-工人工资单
 *
 * @author generator
 */
@Service("settleSalaryService")
public class SettleSalaryServiceImpl extends BaseServiceImpl<SettleSalaryMapper, SettleSalaryEntity> implements ISettleSalaryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    SettleSalaryMapper mapper;

    /**
     * 查询工人工资单列表数据（已生效、没有被过程结算引用、日期小于等于结算日期、日期倒序排列）
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettleSalaryEntity>
     */
    @Override
    public List<SettleSalaryEntity> querySalaryList(Integer settleType, Long contractId, Date settleDate) {
        return mapper.querySalaryList(settleType, contractId, settleDate);
    }

    @Override
    public IPage<SettleSalaryEntity> selectPageSalary(Page<SettleSalaryEntity> page, Integer settleType, Long contractId, String settleDate) {
        return mapper.selectPageSalary(page, settleType, contractId, settleDate);
    }
}
