package com.ejianc.business.steelstructure.prosub.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import com.ejianc.business.steelstructure.prosub.settle.bean.SettleEntity;
import com.ejianc.business.steelstructure.prosub.settle.service.ISettleService;
import com.ejianc.business.steelstructure.prosub.settle.service.ISettleSignatureService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("settleSignatureService")
public class SettleSignatureServiceImpl implements ISettleSignatureService {

    private final Logger logger = LoggerFactory.getLogger(SettleSignatureServiceImpl.class);

    //@Value("#{'${settle.settleRefCode}'.split(',')}")
    private List<String> settleRefCode;

    @Autowired
    private ISettleService service;


    /**
     * 修改结算单签章状态
     *
     * @param id              结算单据id
     * @param signatureStatus 签章状态
     * @param refCode         唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> changeSignatureStatus(Long id, int signatureStatus, String refCode) {
        logger.info("更新结算单据签章状态，入参--id；{}，signatureStatus：{}，refCode：{}", id, signatureStatus, refCode);
        // 判断是否是结算标识
        if (!settleRefCode.contains(refCode)) {
            return CommonResponse.error("结算单据签章状态更新失败！");
        }
        SettleEntity entity = service.selectById(id);
        logger.info("即将修改的结算单信息--{}", JSONObject.toJSONString(entity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        entity.setSignatureStatus(signatureStatus);
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("结算单据签章状态更新成功！");
    }
}
