/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.income.bean.ProjectSetEntity;
import com.ejianc.business.steelstructure.income.service.IProjectSetService;
import com.ejianc.business.steelstructure.income.service.ISummaryService;
import com.ejianc.business.steelstructure.income.vo.ProjectSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectSet"})
public class ProjectSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "pro-market-project-001";
    @Autowired
    private IProjectSetService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISummaryService summaryService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectSetVO> saveOrUpdate(@RequestBody ProjectSetVO saveOrUpdateVO) {
        ProjectSetEntity entity = (ProjectSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectSetEntity.class));
        QueryParam param = new QueryParam();
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (entity.getCode() == null) {
                if (billCode.isSuccess()) {
                    entity.setCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            if (saveOrUpdateVO.getProjectDepartmentId() != null) {
                param.getParams().put("projectDepartmentId", new Parameter("eq", (Object)saveOrUpdateVO.getProjectDepartmentId()));
                List list = this.service.queryList(param, false);
                if (!list.isEmpty()) {
                    return CommonResponse.error((String)"\u6240\u9009\u65bd\u5de5\u9879\u76ee\u90e8\u5df2\u7acb\u9879\uff0c\u65e0\u6cd5\u65b0\u589e\u7acb\u9879\uff01");
                }
            }
        } else if (saveOrUpdateVO.getProjectDepartmentId() != null) {
            param.getParams().put("projectDepartmentId", new Parameter("eq", (Object)saveOrUpdateVO.getProjectDepartmentId()));
            List list = this.service.queryList(param, false);
            if (!list.isEmpty() && !((ProjectSetEntity)((Object)list.get(0))).getId().equals(saveOrUpdateVO.getId())) {
                return CommonResponse.error((String)"\u6240\u9009\u65bd\u5de5\u9879\u76ee\u90e8\u5df2\u7acb\u9879\uff0c\u65e0\u6cd5\u4fee\u6539\u6210\u8be5\u65bd\u5de5\u9879\u76ee\u90e8\u7acb\u9879\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getBillSourceType().equals("2")) {
            this.summaryService.changeUseFlag(entity.getSourceBillId(), 1);
        }
        ProjectSetVO vo = (ProjectSetVO)BeanMapper.map((Object)((Object)entity), ProjectSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveBid"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectSetVO> saveBid(@RequestBody ProjectSetVO saveOrUpdateVO) {
        ProjectSetEntity entity = (ProjectSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectSetEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.summaryService.changeUseFlag(entity.getSourceBillId(), 1);
        ProjectSetVO vo = (ProjectSetVO)BeanMapper.map((Object)((Object)entity), ProjectSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectSetVO> queryDetail(Long id) {
        ProjectSetEntity entity = (ProjectSetEntity)((Object)this.service.selectById(id));
        ProjectSetVO vo = (ProjectSetVO)BeanMapper.map((Object)((Object)entity), ProjectSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectSetVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectSetVO projectSetVO : vos) {
            }
        }
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectSetVO vo : vos) {
                ProjectSetEntity entity = (ProjectSetEntity)((Object)this.service.selectById(vo.getId()));
                this.summaryService.changeUseFlag(entity.getSourceBillId(), 0);
                if (entity.getProjectDepartmentId() == null) continue;
                CommonResponse response = this.iOrgApi.getOneById(entity.getProjectDepartmentId());
                if (!response.isSuccess()) {
                    return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01\u67e5\u8be2\u65bd\u5de5\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + response.getMsg()));
                }
                OrgVO orgVO = (OrgVO)response.getData();
                if (!StringUtils.isNotEmpty((CharSequence)orgVO.getProjectCode())) continue;
                orgVO.setProjectCode(null);
                CommonResponse resp = this.iOrgApi.saveOrgInfo(orgVO);
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01\u4fee\u6539\u65bd\u5de5\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectSetVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("project_management_name");
        param.getFuzzyFields().add("projectDate");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (departmentIds.size() != 0) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)new Page(1L, (long)param.getPageSize(), 0L));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, ProjectSetVO.class);
            for (ProjectSetVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("projectSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectSetVO>> refProjectSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Parameter orgIdValue;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        Long orgId = (orgIdValue = (Parameter)param.getParams().get("orgId")) == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getCurrentOrgParentInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgVO> getCurrentOrgParentInfo() {
        return this.iOrgApi.findParentByOrgId(InvocationInfoProxy.getOrgId());
    }

    @RequestMapping(value={"/getTotalInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getTotalInfo(@RequestBody QueryParam param) {
        JSONObject res = new JSONObject();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("project_management_name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (departmentIds.size() != 0) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            res.put("total", (Object)0);
            res.put("fatherTotal", (Object)0);
            res.put("eTotal", (Object)0);
            return CommonResponse.success((Object)res);
        }
        List setEntities = this.service.queryList(param, false);
        res.put("total", (Object)setEntities.size());
        if (param.getParams().get("attribute") != null) {
            Parameter parameter = (Parameter)param.getParams().get("attribute");
            if ("1".equals(parameter.getValue())) {
                res.put("fatherTotal", (Object)setEntities.size());
                res.put("eTotal", (Object)0);
            } else {
                res.put("fatherTotal", (Object)0);
                res.put("eTotal", (Object)setEntities.size());
            }
        } else {
            param.getParams().put("attribute", new Parameter("eq", (Object)1));
            setEntities = this.service.queryList(param, false);
            res.put("fatherTotal", (Object)setEntities.size());
            param.getParams().put("attribute", new Parameter("eq", (Object)2));
            setEntities = this.service.queryList(param, false);
            res.put("eTotal", (Object)setEntities.size());
        }
        return CommonResponse.success((Object)res);
    }

    @RequestMapping(value={"/pushProjectPoolSetNoInitial"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushProjectPoolSet(Long id) {
        ProjectSetEntity entity = (ProjectSetEntity)((Object)this.service.selectById(id));
        return this.service.pushProjectPoolSetNoInitial(entity, "3");
    }

    @RequestMapping(value={"/queryProjectDetailByOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProjectSetVO>> queryProjectDetailByOrgId(@RequestParam(value="orgId") Long orgId, @RequestParam(value="capitalStatus", required=false) String capitalStatus) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectDepartmentId", new Parameter("eq", (Object)orgId));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (StringUtils.isEmpty((CharSequence)capitalStatus)) {
            param.getParams().put("capitalStatus", new Parameter("ne", (Object)16));
        }
        List projectSetEntities = this.service.queryList(param);
        List projectSetVOS = BeanMapper.mapList((Iterable)projectSetEntities, ProjectSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)projectSetVOS);
    }

    @RequestMapping(value={"/queryThisYearAddNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Long> queryThisYearAddNum() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDateTime yearStart = now.with(TemporalAdjusters.firstDayOfYear()).with(LocalTime.MIN);
        LocalDateTime yearEnd = now.with(TemporalAdjusters.lastDayOfYear()).with(LocalTime.MAX);
        param.getParams().put("createTime", new Parameter("between", (Object)(yearStart.format(fmt) + "," + yearEnd.format(fmt))));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        IPage page = this.service.queryPage(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page.getTotal());
    }

    @RequestMapping(value={"/queryEnrollArea"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryEnrollArea(@RequestParam(value="range", required=false) String range, @RequestParam(value="name", required=false) String name, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.enrollArea(range, name, dateIn, orgId);
    }
}

