/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.consts.ProjectSurveyEnum;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectCountVO;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectDataVO;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectVo;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.business.steelstructure.income.bean.ProjectSetEntity;
import com.ejianc.business.steelstructure.income.mapper.ProjectSetMapper;
import com.ejianc.business.steelstructure.income.service.IProjectSetService;
import com.ejianc.business.steelstructure.income.utils.AddressResolutionUtil;
import com.ejianc.business.steelstructure.income.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectSurveyTreeVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectSetService")
public class ProjectSetServiceImpl
extends BaseServiceImpl<ProjectSetMapper, ProjectSetEntity>
implements IProjectSetService {
    @Autowired
    private IProjectSetApi iProjectSetApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectSetService service;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<String> pushProjectPoolSet(ProjectSetEntity projectSetEntity, String billTypeCode) {
        CommonResponse resp;
        ProjectSetVO projectSetVO = (ProjectSetVO)BeanMapper.map((Object)((Object)projectSetEntity), ProjectSetVO.class);
        OrgVO projectDepartment = null;
        if (null == projectSetVO.getProjectDepartmentId()) {
            projectDepartment = this.generateProjectDepartment(projectSetVO, true);
            projectSetEntity.setProjectDepartmentId(projectDepartment.getId());
            projectSetEntity.setProjectDepartmentName(projectDepartment.getName());
        } else {
            projectDepartment = (OrgVO)this.orgApi.getOneById(projectSetVO.getProjectDepartmentId()).getData();
            if (projectDepartment != null) {
                projectDepartment.setProjectCode(projectSetVO.getCode());
            }
        }
        if (null != projectDepartment && !(resp = this.orgApi.saveOrgInfo(projectDepartment)).isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
        }
        this.service.saveOrUpdate((Object)projectSetEntity, false);
        ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)projectSetEntity), ProjectPoolSetVO.class);
        this.logger.info("\u63a8\u9001\u9879\u76ee\u6c60\u4fe1\u606f\u4e3a{}", (Object)projectPoolSetVO);
        return this.iProjectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString((Object)projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public CommonResponse<String> pushProjectPoolSetNoInitial(ProjectSetEntity projectSetEntity, String billTypeCode) {
        CommonResponse resp;
        ProjectSetVO projectSetVO = (ProjectSetVO)BeanMapper.map((Object)((Object)projectSetEntity), ProjectSetVO.class);
        OrgVO projectDepartment = null;
        if (null == projectSetVO.getProjectDepartmentId()) {
            projectDepartment = this.generateProjectDepartment(projectSetVO, true);
            projectSetEntity.setProjectDepartmentId(projectDepartment.getId());
            projectSetEntity.setProjectDepartmentName(projectDepartment.getName());
        } else {
            projectDepartment = (OrgVO)this.orgApi.getOneById(projectSetVO.getProjectDepartmentId()).getData();
            if (projectDepartment != null) {
                projectDepartment.setProjectCode(projectSetVO.getCode());
            }
        }
        if (null != projectDepartment && !(resp = this.orgApi.saveOrgInfo(projectDepartment)).isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
        }
        this.service.saveOrUpdate((Object)projectSetEntity, false);
        ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)projectSetEntity), ProjectPoolSetVO.class);
        this.logger.info("\u63a8\u9001\u9879\u76ee\u6c60\u4fe1\u606f\u4e3a{}", (Object)projectPoolSetVO);
        return this.iProjectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString((Object)projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
    }

    private OrgVO generateProjectDepartment(ProjectSetVO projectSetVO, boolean isSyncProject) {
        if (projectSetVO.getOrgId() == null) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        CommonResponse response = this.orgApi.getOneById(projectSetVO.getOrgId());
        OrgVO parentOrg = null;
        if (!response.isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        OrgVO projectDepartment = new OrgVO();
        OrgVO paramVo = new OrgVO();
        paramVo.setName(projectSetVO.getName());
        paramVo.setOrgType(Integer.valueOf(5));
        paramVo.setTenantId(InvocationInfoProxy.getTenantid());
        response = this.orgApi.findOneByOrgVO(paramVo);
        if (response.isSuccess()) {
            if (response.getData() != null) {
                projectDepartment = (OrgVO)response.getData();
            } else {
                projectDepartment.setId(Long.valueOf(IdWorker.getId()));
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setState(Integer.valueOf(1));
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
            }
        } else {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setProjectCode(projectSetVO.getCode());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setParentId(projectSetVO.getOrgId());
        projectDepartment.setProjectState(Integer.valueOf(1));
        return projectDepartment;
    }

    @Override
    public CommonResponse<JSONObject> enrollArea(String range, String name, String dateIn, Long orgId) {
        Map<String, List<ProjectCountVO>> map;
        String projectStatus = null;
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)) {
            projectStatus = "1";
        }
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() + "";
        }
        ArrayList<ProjectCountVO> list = new ArrayList<ProjectCountVO>();
        List listTree = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List enrollEntities = this.list((Wrapper)queryWrapper);
        ArrayList<ProjectSurveyVO> projectSurveyVOS = new ArrayList<ProjectSurveyVO>();
        if (ListUtil.isNotEmpty((List)enrollEntities)) {
            for (ProjectSetEntity enrollEntity : enrollEntities) {
                ProjectSurveyVO projectSurveyVO = new ProjectSurveyVO();
                projectSurveyVO.setId(enrollEntity.getId());
                projectSurveyVO.setProjectName(enrollEntity.getName());
                projectSurveyVO.setOrgId(enrollEntity.getOrgId());
                String[] split = enrollEntity.getAreaName().split("/");
                projectSurveyVO.setArea(enrollEntity.getAreaName());
                projectSurveyVO.setProvince(split[0]);
                projectSurveyVO.setCity(split[1]);
                projectSurveyVO.setCounty(split[2]);
                projectSurveyVOS.add(projectSurveyVO);
            }
            List dataTree = BeanMapper.mapList(projectSurveyVOS, ProjectSurveyTreeVO.class);
            listTree = TreeNodeBUtil.buildTree((List)dataTree);
            List projectCountVOS = BeanMapper.mapList(listTree, ProjectCountVO.class);
            list.addAll(projectCountVOS);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashSet<Object> provinceSet = new HashSet<Object>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pName = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getArea())) {
                if (vo.getArea().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMap = AddressResolutionUtil.addressResolution(vo.getArea());
                if (areaMap != null) {
                    String province = areaMap.get("province") == null ? "\u5176\u4ed6" : areaMap.get("province");
                    String string = areaMap.get("city") == null ? "\u5176\u4ed6" : areaMap.get("city");
                    String string2 = areaMap.get("county") == null ? "\u5176\u4ed6" : areaMap.get("county");
                    vo.setProvince(province);
                    vo.setCity(string);
                    vo.setCounty(string2);
                    provinceSet.add(province);
                    citySet.add(string);
                    countySet.add(string2);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string.equals(name)) continue;
                    pName = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pName) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, list, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, ProjectDataVO> countyMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    BigDecimal contractTaxMny;
                    String string = projectCountVO.getCounty();
                    BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!countyMap.containsKey(string)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        pvo.setContractMoney(contractTaxMny);
                        countyMap.put(string, pvo);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)countyMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
                for (ProjectDataVO projectDataVO : dataVOS) {
                    if (!map.containsKey(projectDataVO.getName())) continue;
                    List<ProjectCountVO> projectCountVOS = map.get(projectDataVO.getName());
                    ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                    for (ProjectCountVO projectCountVO : projectCountVOS) {
                        ProjectVo projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                        projectVos.add(projectVo);
                    }
                    projectDataVO.setProjectList(projectVos);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, ProjectDataVO> cityMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    BigDecimal contractTaxMny;
                    String string = projectCountVO.getCity();
                    BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!cityMap.containsKey(string)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        pvo.setContractMoney(contractTaxMny);
                        cityMap.put(string, pvo);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)cityMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
                for (ProjectDataVO projectDataVO : dataVOS) {
                    if (!map.containsKey(projectDataVO.getName())) continue;
                    List<ProjectCountVO> projectCountVOS = map.get(projectDataVO.getName());
                    ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                    for (ProjectCountVO projectCountVO : projectCountVOS) {
                        ProjectVo projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                        projectVos.add(projectVo);
                    }
                    projectDataVO.setProjectList(projectVos);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, ProjectDataVO> provinceMap = new HashMap<String, ProjectDataVO>();
            for (ProjectCountVO projectCountVO : list) {
                BigDecimal contractTaxMny;
                String string = projectCountVO.getProvince();
                BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                if (!provinceMap.containsKey(string)) {
                    ProjectDataVO pvo = new ProjectDataVO();
                    pvo.setName(string);
                    pvo.setValue(Integer.valueOf(1));
                    pvo.setContractMoney(contractTaxMny);
                    provinceMap.put(string, pvo);
                    continue;
                }
                ProjectDataVO projectDataVO = (ProjectDataVO)provinceMap.get(string);
                projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                provinceMap.put(string, projectDataVO);
            }
            map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (ProjectDataVO projectDataVO : dataVOS) {
                if (!map.containsKey(projectDataVO.getName())) continue;
                List<ProjectCountVO> projectCountVOS = map.get(projectDataVO.getName());
                ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                for (ProjectCountVO projectCountVO : projectCountVOS) {
                    ProjectVo projectVo = new ProjectVo();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getProjectName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                    projectVos.add(projectVo);
                }
                projectDataVO.setProjectList(projectVos);
            }
        }
        int allProjectNumber = list.size();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", (Object)allProjectNumber);
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<ProjectDataVO>(){

                @Override
                public int compare(ProjectDataVO o1, ProjectDataVO o2) {
                    int a = "\u5176\u4ed6".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "\u5176\u4ed6".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        jsonObject.put("data", dataVOS);
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "shanghai";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        jsonObject.put("range", (Object)(rangeType == null || rangeType.contains("null") ? "China" : rangeType));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<ProjectDataVO> projectCountByName(String name, List<ProjectCountVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, ProjectDataVO> map = new HashMap<String, ProjectDataVO>();
        for (ProjectCountVO vo : list) {
            BigDecimal contractTaxMny;
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            BigDecimal bigDecimal = contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
            if (!map.containsKey(childrenName)) {
                ProjectDataVO pvo = new ProjectDataVO();
                pvo.setName(childrenName);
                pvo.setValue(Integer.valueOf(1));
                pvo.setContractMoney(contractTaxMny);
                map.put(childrenName, pvo);
                continue;
            }
            ProjectDataVO projectDataVO = (ProjectDataVO)map.get(childrenName);
            projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
            map.put(childrenName, projectDataVO);
        }
        Map<String, List<ProjectCountVO>> projectCountVOMap = null;
        projectCountVOMap = type == 0 ? list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity)) : list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
        ArrayList<ProjectDataVO> projectDataVOS = new ArrayList<ProjectDataVO>(map.values());
        for (ProjectDataVO dataVO : projectDataVOS) {
            if (!map.containsKey(dataVO.getName())) continue;
            List<ProjectCountVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
            ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
            for (ProjectCountVO projectCountVO : projectCountVOS) {
                ProjectVo projectVo = new ProjectVo();
                projectVo.setId(projectCountVO.getId());
                projectVo.setName(projectCountVO.getProjectName());
                projectVo.setOrgId(projectCountVO.getOrgId());
                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                projectVos.add(projectVo);
            }
            dataVO.setProjectList(projectVos);
        }
        return projectDataVOS;
    }
}

