/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.prosub.prosub.pricelib.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.pricelib.vo.PriceGuideDetailVO;
import com.ejianc.business.prosub.pricelib.vo.PriceGuideVO;
import com.ejianc.business.steelstructure.prosub.prosub.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.pricelib.bean.PriceGuideEntity;
import com.ejianc.business.steelstructure.prosub.prosub.pricelib.service.IPriceGuideService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"priceGuide"})
public class PriceGuideController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String LABOR_BILL_CODE = "LABOR_GUIDE_PRICE";
    private static final String PRO_BILL_CODE = "PRO_GUIDE_PRICE";
    @Autowired
    private IPriceGuideService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PriceGuideVO> saveOrUpdate(@RequestBody PriceGuideVO saveOrUpdateVO) {
        PriceGuideEntity entity = (PriceGuideEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PriceGuideEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)(0 == saveOrUpdateVO.getContractType() ? LABOR_BILL_CODE : PRO_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PriceGuideVO vo = (PriceGuideVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), PriceGuideVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PriceGuideVO> queryDetail(Long id) {
        PriceGuideEntity entity = (PriceGuideEntity)((Object)this.service.selectById(id));
        PriceGuideVO vo = (PriceGuideVO)BeanMapper.map((Object)((Object)entity), PriceGuideVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceGuideVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PriceGuideVO priceGuideVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PriceGuideVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("theme");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findParentsByOrgId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0a\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIdList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PriceGuideVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("theme");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List guideVOS = BeanMapper.mapList((Iterable)list, PriceGuideVO.class);
        guideVOS.stream().forEach(item -> {
            item.setFlagName(item.getFlag() == 0 ? "\u542f\u7528" : "\u7981\u7528");
            item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", guideVOS);
        String exportFileName = ((Parameter)param.getParams().get("contractType")).getValue().equals("0") ? "laborSubPriceGuide-export.xlsx" : "proSubPriceGuide-export.xlsx";
        ExcelExport.getInstance().export(exportFileName, beans, response);
    }

    @RequestMapping(value={"/startUpdate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PriceGuideVO> startUpdate(@RequestParam Long id, Integer state) {
        PriceGuideEntity priceGuideEntity = (PriceGuideEntity)((Object)this.service.selectById(id));
        priceGuideEntity.setFlag(state);
        this.service.saveOrUpdate((Object)priceGuideEntity, false);
        PriceGuideVO vo = (PriceGuideVO)BeanMapper.map((Object)((Object)priceGuideEntity), PriceGuideVO.class);
        return CommonResponse.success((String)"\u542f\u7528\u505c\u7528\u72b6\u6001\u8c03\u6574\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/copyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PriceGuideDetailVO>> copyDetail(@RequestParam Long id) {
        PriceGuideEntity priceGuideEntity = (PriceGuideEntity)((Object)this.service.selectById(id));
        List<PriceGuideDetailEntity> detailList = priceGuideEntity.getPriceGuideDetailList();
        detailList.forEach(detail -> {
            detail.setId(IdWorker.getId());
            detail.setRowState("add");
            detail.setVersion(null);
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setCreateUserCode(null);
            detail.setUpdateUserCode(null);
        });
        return CommonResponse.success((String)"\u590d\u5236\u5b50\u8868\u6210\u529f\uff01", (Object)BeanMapper.mapList(detailList, PriceGuideDetailVO.class));
    }
}

