/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.service.impl;

import com.ejianc.business.steelstructure.income.bean.BudgetEntity;
import com.ejianc.business.steelstructure.income.bean.ProductionDetailEntity;
import com.ejianc.business.steelstructure.income.mapper.ProductionDetailMapper;
import com.ejianc.business.steelstructure.income.service.IBudgetService;
import com.ejianc.business.steelstructure.income.service.IProductionDetailService;
import com.ejianc.business.steelstructure.income.service.IProductionService;
import com.ejianc.business.steelstructure.income.utils.DetailListUtil;
import com.ejianc.business.steelstructure.income.utils.IncomeSortUtil;
import com.ejianc.business.steelstructure.income.utils.TreeNodeBUtil;
import com.ejianc.business.steelstructure.income.vo.LastVO;
import com.ejianc.business.steelstructure.income.vo.ProductionDetailCostVO;
import com.ejianc.business.steelstructure.income.vo.ProductionDetailFeeVO;
import com.ejianc.business.steelstructure.income.vo.ProductionDetailMeasureVO;
import com.ejianc.business.steelstructure.income.vo.ProductionDetailOtherVO;
import com.ejianc.business.steelstructure.income.vo.ProductionDetailPubVO;
import com.ejianc.business.steelstructure.income.vo.ProductionDetailSubVO;
import com.ejianc.business.steelstructure.income.vo.ProductionDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="productionDetailService")
public class ProductionDetailServiceImpl
extends BaseServiceImpl<ProductionDetailMapper, ProductionDetailEntity>
implements IProductionDetailService {
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private DetailListUtil detailListUtil;

    @Override
    public ProductionDetailVO queryBudgetDetail(Long id) {
        ProductionDetailPubVO pub;
        Map<Long, ProductionDetailPubVO> pubMap = this.getPubVOSumMap(id);
        BudgetEntity entity = (BudgetEntity)((Object)this.budgetService.selectById(id));
        ProductionDetailVO vo = (ProductionDetailVO)BeanMapper.map((Object)((Object)entity), ProductionDetailVO.class);
        List costList = BeanMapper.mapList(entity.getCostVos(), ProductionDetailCostVO.class);
        List subList = BeanMapper.mapList(entity.getSubVos(), ProductionDetailSubVO.class);
        List measureList = BeanMapper.mapList(entity.getMeasureVos(), ProductionDetailMeasureVO.class);
        List otherList = BeanMapper.mapList(entity.getOtherVos(), ProductionDetailOtherVO.class);
        List feeList = BeanMapper.mapList(entity.getFeeVos(), ProductionDetailFeeVO.class);
        LastVO lastVO = new LastVO();
        if (CollectionUtils.isNotEmpty((Collection)costList)) {
            for (ProductionDetailCostVO dvo : costList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastProductionNum(pub.getProductionNum());
                dvo.setLastProductionMny(pub.getProductionMny());
                dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(costList);
            vo.setCostList(TreeNodeBUtil.buildTree((List)costList));
        }
        if (CollectionUtils.isNotEmpty((Collection)subList)) {
            for (ProductionDetailCostVO dvo : subList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastProductionNum(pub.getProductionNum());
                dvo.setLastProductionMny(pub.getProductionMny());
                dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(subList);
            vo.setSubList(TreeNodeBUtil.buildTree((List)subList));
        }
        if (CollectionUtils.isNotEmpty((Collection)measureList)) {
            for (ProductionDetailCostVO dvo : measureList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastProductionNum(pub.getProductionNum());
                dvo.setLastProductionMny(pub.getProductionMny());
                dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(measureList);
            vo.setMeasureList(TreeNodeBUtil.buildTree((List)measureList));
        }
        if (CollectionUtils.isNotEmpty((Collection)otherList)) {
            for (ProductionDetailCostVO dvo : otherList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastProductionNum(pub.getProductionNum());
                dvo.setLastProductionMny(pub.getProductionMny());
                dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(otherList);
            vo.setOtherList(TreeNodeBUtil.buildTree((List)otherList));
        }
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            for (ProductionDetailCostVO dvo : feeList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastProductionNum(pub.getProductionNum());
                dvo.setLastProductionMny(pub.getProductionMny());
                dvo.setLastProductionTaxMny(pub.getProductionTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(feeList);
            vo.setFeeList(TreeNodeBUtil.buildTree((List)feeList));
        }
        vo.setLastProductionMny(lastVO.getLastMny());
        vo.setLastProductionTaxMny(lastVO.getLastTaxMny());
        return vo;
    }

    private void computeLast(LastVO lastVO, ProductionDetailPubVO pub) {
        lastVO.setLastMny(ComputeUtil.safeAdd((BigDecimal)lastVO.getLastMny(), (BigDecimal)pub.getProductionMny()));
        lastVO.setLastTaxMny(ComputeUtil.safeAdd((BigDecimal)lastVO.getLastTaxMny(), (BigDecimal)pub.getProductionTaxMny()));
    }

    private Map<Long, ProductionDetailPubVO> getPubVOSumMap(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List productionList = this.productionService.queryList(queryParam);
        HashMap<Long, ProductionDetailPubVO> pubMap = new HashMap<Long, ProductionDetailPubVO>();
        if (CollectionUtils.isNotEmpty((Collection)productionList)) {
            List productionIds = productionList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("productionId", new Parameter("in", productionIds));
            param.getParams().put("budgetId", new Parameter("eq", (Object)id));
            List detailList = super.queryList(param);
            this.detailListUtil.setDetailList(detailList);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                detailList.forEach(detail -> {
                    ArrayList pubList = new ArrayList();
                    if (CollectionUtils.isNotEmpty(detail.getCostList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getCostList(), ProductionDetailPubVO.class));
                    }
                    if (CollectionUtils.isNotEmpty(detail.getSubList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getSubList(), ProductionDetailPubVO.class));
                    }
                    if (CollectionUtils.isNotEmpty(detail.getMeasureList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getMeasureList(), ProductionDetailPubVO.class));
                    }
                    if (CollectionUtils.isNotEmpty(detail.getOtherList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getOtherList(), ProductionDetailPubVO.class));
                    }
                    if (CollectionUtils.isNotEmpty(detail.getFeeList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getFeeList(), ProductionDetailPubVO.class));
                    }
                    pubList.forEach(vo -> {
                        ProductionDetailPubVO pub = new ProductionDetailPubVO();
                        if (!pubMap.containsKey(vo.getBudgetDetailId())) {
                            pub.setBudgetDetailId(vo.getBudgetDetailId());
                            pub.setProductionNum(vo.getProductionNum());
                            pub.setProductionMny(vo.getProductionMny());
                            pub.setProductionTaxMny(vo.getProductionTaxMny());
                            pubMap.put(vo.getBudgetDetailId(), pub);
                        } else {
                            pub = (ProductionDetailPubVO)pubMap.get(vo.getBudgetDetailId());
                            pub.setProductionNum(ComputeUtil.safeAdd((BigDecimal)pub.getProductionNum(), (BigDecimal)vo.getProductionNum()));
                            pub.setProductionMny(ComputeUtil.safeAdd((BigDecimal)pub.getProductionMny(), (BigDecimal)vo.getProductionMny()));
                            pub.setProductionTaxMny(ComputeUtil.safeAdd((BigDecimal)pub.getProductionTaxMny(), (BigDecimal)vo.getProductionTaxMny()));
                        }
                    });
                });
            }
        }
        return pubMap;
    }
}

