/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class AddressResolutionUtil {
    public static Map<String, String> addressResolution(String address) {
        String regex = "(?<province>[^\u7701]+\u81ea\u6cbb\u533a|.*?\u7701|.*?\u884c\u653f\u533a|.*?\u5e02)(?<city>[^\u5e02]+\u81ea\u6cbb\u5dde|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|\u5e02\u8f96\u533a|.*?\u5e02|.*?\u53bf|.*?\u533a)(?<county>[^\u53bf]+\u53bf|[^\u533a]+\u533a|[^\u5e02]+\u5e02|[^\u65d7]+\u65d7|.+\u6d77\u57df|[^\u5c9b]+\u5c9b)?(?<town>[^\u533a]+\u533a|.+\u9547)?(?<village>.*)";
        Matcher m = Pattern.compile(regex).matcher(address);
        String province = null;
        String city = null;
        String county = null;
        Object town = null;
        Object village = null;
        ArrayList table = new ArrayList();
        LinkedHashMap<String, String> row = null;
        while (m.find()) {
            row = new LinkedHashMap<String, String>();
            province = m.group("province");
            row.put("province", province == null ? "" : province.trim());
            city = m.group("city");
            row.put("city", city == null ? "" : city.trim());
            county = m.group("county");
            row.put("county", county == null ? "" : county.trim());
            table.add(row);
        }
        return row;
    }

    public static void main(String[] args) {
        String str = "\u5317\u4eac\u5e02/\u5e02\u8f96\u533a/\u4e1c\u57ce\u533a";
        String replace = str.replace("/", "");
        System.out.println(replace);
        Map<String, String> list = AddressResolutionUtil.addressResolution(replace);
        System.out.println(list);
    }

    public static String getProvincePinYin(String province) {
        String pinYin = null;
        switch (province) {
            case "\u5b89\u5fbd\u7701": {
                pinYin = "anhui";
                break;
            }
            case "\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a": {
                pinYin = "aomen";
                break;
            }
            case "\u5317\u4eac\u5e02": {
                pinYin = "beijing";
                break;
            }
            case "\u91cd\u5e86\u5e02": {
                pinYin = "chongqing";
                break;
            }
            case "\u798f\u5efa\u7701": {
                pinYin = "fujian";
                break;
            }
            case "\u7518\u8083\u7701": {
                pinYin = "gansu";
                break;
            }
            case "\u5e7f\u4e1c\u7701": {
                pinYin = "guangdong";
                break;
            }
            case "\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a": {
                pinYin = "guangxi";
                break;
            }
            case "\u8d35\u5dde\u7701": {
                pinYin = "guizhou";
                break;
            }
            case "\u6d77\u5357\u7701": {
                pinYin = "hainan";
                break;
            }
            case "\u6cb3\u5317\u7701": {
                pinYin = "hebei";
                break;
            }
            case "\u9ed1\u9f99\u6c5f\u7701": {
                pinYin = "heilongjiang";
                break;
            }
            case "\u6cb3\u5357\u7701": {
                pinYin = "henan";
                break;
            }
            case "\u6e56\u5317\u7701": {
                pinYin = "hubei";
                break;
            }
            case "\u6e56\u5357\u7701": {
                pinYin = "hunan";
                break;
            }
            case "\u6c5f\u82cf\u7701": {
                pinYin = "jiangsu";
                break;
            }
            case "\u6c5f\u897f\u7701": {
                pinYin = "jiagnxi";
                break;
            }
            case "\u5409\u6797\u7701": {
                pinYin = "jilin";
                break;
            }
            case "\u8fbd\u5b81\u7701": {
                pinYin = "liaoning";
                break;
            }
            case "\u5185\u8499\u53e4\u81ea\u6cbb\u533a": {
                pinYin = "neimenggu";
                break;
            }
            case "\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a": {
                pinYin = "ningxiahuizu";
                break;
            }
            case "\u9752\u6d77\u7701": {
                pinYin = "qinghai";
                break;
            }
            case "\u5c71\u4e1c\u7701": {
                pinYin = "shandong";
                break;
            }
            case "\u4e0a\u6d77\u5e02": {
                pinYin = "shanghai";
                break;
            }
            case "\u9655\u897f\u7701": {
                pinYin = "shanxi";
                break;
            }
            case "\u5c71\u897f\u7701": {
                pinYin = "shanxi2";
                break;
            }
            case "\u56db\u5ddd\u7701": {
                pinYin = "sichuan";
                break;
            }
            case "\u5929\u6d25\u5e02": {
                pinYin = "tianjin";
                break;
            }
            case "\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a": {
                pinYin = "xianggang";
                break;
            }
            case "\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a": {
                pinYin = "xinjiangweiwuer";
                break;
            }
            case "\u897f\u85cf\u81ea\u6cbb\u533a": {
                pinYin = "xizang";
                break;
            }
            case "\u4e91\u5357\u7701": {
                pinYin = "yunnan";
                break;
            }
            case "\u6d59\u6c5f\u7701": {
                pinYin = "zhejiang";
                break;
            }
            case "\u53f0\u6e7e\u7701": {
                pinYin = "taiwan";
                break;
            }
        }
        return pinYin;
    }

    public static String getNamePinYinChar(String zn_str, int caseType) {
        if (zn_str != null && !zn_str.trim().equalsIgnoreCase("")) {
            char[] strChar = zn_str.toCharArray();
            HanyuPinyinOutputFormat hanYuPinOutputFormat = new HanyuPinyinOutputFormat();
            if (1 == caseType) {
                hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            } else {
                hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
            }
            hanYuPinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            hanYuPinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
            StringBuffer pyStringBuffer = new StringBuffer();
            for (int i = 0; i < strChar.length; ++i) {
                char c = strChar[i];
                if (Character.isWhitespace(c)) continue;
                if (AddressResolutionUtil.isHanZi(c)) {
                    try {
                        String[] pyStirngArray = PinyinHelper.toHanyuPinyinStringArray((char)strChar[i], (HanyuPinyinOutputFormat)hanYuPinOutputFormat);
                        if (null == pyStirngArray || pyStirngArray[0] == null) continue;
                        pyStringBuffer.append(pyStirngArray[0]);
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (AddressResolutionUtil.isEnglish(c)) {
                    if (1 == caseType) {
                        pyStringBuffer.append(String.valueOf(c).toLowerCase(Locale.ENGLISH));
                        continue;
                    }
                    pyStringBuffer.append(String.valueOf(c).toUpperCase(Locale.ENGLISH));
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (i == 0) {
                        pyStringBuffer.append("#");
                    }
                    pyStringBuffer.append(c);
                    continue;
                }
                if (i != 0) continue;
                pyStringBuffer.append("#");
            }
            return pyStringBuffer.toString();
        }
        return null;
    }

    public static boolean isHanZi(char c) {
        Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
        Matcher matcher = pattern.matcher(String.valueOf(c));
        return matcher.matches();
    }

    public static boolean isEnglish(char c) {
        return String.valueOf(c).matches("^[a-zA-Z]*");
    }
}

