/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.contract.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractEntity;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractDetailService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractService;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractMaterialReportVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialMaterialReportVO;
import com.ejianc.business.steelstructure.prosub.vo.ReferenceDetailVO;
import com.ejianc.business.steelstructure.prosub.vo.ReferenceMapVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderApi;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"promaterialcontract"})
@Api(value="\u4e3b\u5408\u540c\u5b9e\u4f53", tags={"\u4e3b\u5408\u540c\u5b9e\u4f53"})
public class PromaterialContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITenderApi tenderApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPromaterialContractService service;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPromaterialContractDetailService contractDetailService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PromaterialContractVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody PromaterialContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return this.service.saveOrUpdate(saveorUpdateVO, authority, false);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PromaterialContractVO> saveOrUpdateSupplement(@RequestBody PromaterialContractVO supplement, HttpServletRequest req) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        String authority = req.getHeader("authority");
        PromaterialContractVO vo = this.service.saveOrUpdateSupplement(supplement, authority, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PromaterialContractVO> addConvertByConId(Long contractId) {
        PromaterialContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PromaterialContractVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u624b\u673a\u53f7")
    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PromaterialContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (PromaterialContractVO promaterialContractVO : vos) {
                PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.service.selectById(promaterialContractVO.getId()));
                if (promaterialContractEntity.getPurchaseType().equals("1")) {
                    ExecutionVO executionVO = this.service.targetCost((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class), "", 0, promaterialContractEntity.getContractType());
                    totalExecutionVOList.add(executionVO.getTotalVO());
                }
                this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
                if (promaterialContractEntity.getId() == null || promaterialContractEntity.getTargetResultId() == null) continue;
                this.service.updateTargetResult((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class), 1);
            }
        }
        this.service.removeByIds(vos.stream().map(PromaterialContractVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            boolean filingFlag = this.service.checkContractFiling(id);
            if (!filingFlag) {
                return CommonResponse.error((String)"\u5408\u540c\u672a\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
            }
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u65e0\u6cd5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        param.getParams().put("contract_type", new Parameter("eq", (Object)0));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.queryContractList(param));
    }

    @RequestMapping(value={"/pageConcreteList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageConcreteList(@RequestBody QueryParam param) {
        param.getParams().put("contract_type", new Parameter("eq", (Object)1));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.queryContractList(param));
    }

    private JSONObject queryContractList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam(null, false));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.putAll(param.getOrderMap());
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), PromaterialContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return page;
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PromaterialContractVO> querySupplementRecord(Long id) {
        PromaterialContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addRelieveFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u89e3\u9664\u5355\u636e\u6210\u529f\uff01", (Object)this.service.addRelieveFlag(id));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("contract_type", new Parameter("eq", (Object)0));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("proMaterialContract-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u6df7\u51dd\u571f\u5408\u540c\u5bfc\u51fa")
    @RequestMapping(value={"/concreteExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void concreteExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("contract_type", new Parameter("eq", (Object)1));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("proConcreteContract-export.xlsx", beans, response);
    }

    private Map<String, Object> commonExcelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam(null, false));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, PromaterialContractVO.class);
            voList.forEach(c -> {
                if (StringUtils.isBlank((String)c.getPerformanceStatus())) {
                    c.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getDescription());
                } else {
                    c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                }
                if (StringUtils.isBlank((String)c.getSignatureStatus())) {
                    c.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getDescription());
                } else {
                    c.setSignatureStatus(SignatureStatusEnum.getEnumByCode(c.getSignatureStatus()).getDescription());
                }
                c.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription());
            });
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        return beans;
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PromaterialContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("contract_type", new Parameter("eq", (Object)0));
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (conditionMap != null && conditionMap.containsKey("draftType")) {
            param.getParams().put("draftType", new Parameter("in", (Object)conditionMap.get("draftType").toString()));
        }
        IPage<PromaterialContractEntity> page = this.queryContractListByRef(param, condition);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PromaterialContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u6df7\u51dd\u571f\u53c2\u7167")
    @RequestMapping(value={"/refContractConcreteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PromaterialContractVO>> refContractConcreteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("contract_type", new Parameter("eq", (Object)1));
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (conditionMap != null && conditionMap.containsKey("draftType")) {
            param.getParams().put("draftType", new Parameter("in", (Object)conditionMap.get("draftType").toString()));
        }
        IPage<PromaterialContractEntity> page = this.queryContractListByRef(param, condition);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PromaterialContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private IPage<PromaterialContractEntity> queryContractListByRef(QueryParam param, String condition) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("signature_status", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        param.getParams().put("performanceStatus", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        String valueData = this.service.getContractFilingCode();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"orgId")) {
                param.getComplexParams().add(this.getPageQueryParam(Long.valueOf(String.valueOf(_con.get((Object)"orgId"))), true));
            } else {
                param.getComplexParams().add(this.getPageQueryParam(null, true));
            }
            if ("1".equals(valueData)) {
                if (_con.containsKey((Object)"filingType") && "1".equals(_con.getString("filingType"))) {
                    param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
                }
            } else if ("2".equals(valueData)) {
                param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
            }
        } else {
            param.getComplexParams().add(this.getPageQueryParam(null, true));
            if ("2".equals(valueData)) {
                param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
            }
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        return this.service.queryPage(param, false);
    }

    public ComplexParam getPageQueryParam(Long orgId, boolean isRef) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        Object orgVOList = null;
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
        CommonResponse childOrgResp = this.iOrgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.iOrgApi.findParentsByOrgId(orgId);
        if (!(orgResp.isSuccess() && childOrgResp.isSuccess() && parentOrgResp.isSuccess())) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        OrgVO orgVO = (OrgVO)orgResp.getData();
        if (5 == orgVO.getOrgType()) {
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("org_id", new Parameter("eq", (Object)orgId));
            if (isRef) {
                c2.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            }
            c1.getComplexParams().add(c2);
            if (CollectionUtils.isNotEmpty(parentOrgIds)) {
                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("purchase_type", new Parameter("eq", (Object)PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode()));
                c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
                c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
                c1.getComplexParams().add(c3);
            }
        } else {
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("org_id", new Parameter("in", childIds));
            if (isRef) {
                c2.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            }
            c1.getComplexParams().add(c2);
            if (CollectionUtils.isNotEmpty(parentOrgIds)) {
                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("purchase_type", new Parameter("eq", (Object)PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode()));
                c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
                c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
                c1.getComplexParams().add(c3);
            }
        }
        return c1;
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody PromaterialContractVO promaterialContractVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.targetCostCtrl(promaterialContractVO, authority));
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.viewTargetCostCtrlInfo(id));
    }

    @ApiOperation(value="\u540c\u6b65\u5408\u540c\u6c60\u6570\u636e")
    @RequestMapping(value={"/pushContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PromaterialContractVO> pushContract(@RequestParam Long id) {
        return CommonResponse.success((String)"\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f\uff01", (Object)this.service.syncPushContract(id));
    }

    @RequestMapping(value={"/pushTargetCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return this.service.pushTargetCost(id);
    }

    @RequestMapping(value={"/queryPaymentApplyList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractPaymentResultVO> query(Long id) {
        ContractPaymentResultVO vo = this.service.queryPaymentApplyList(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/quueryMaterialByProject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> quueryMaterialByProject(@RequestBody QueryParam param) {
        Long projectId = null;
        if (param.getParams().containsKey("projectId")) {
            projectId = Long.valueOf(((Parameter)param.getParams().get("projectId")).getValue().toString());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PromaterialMaterialReportVO> list = this.service.quueryMaterialByProject(page, wrapper, projectId);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @ApiOperation(value="\u9879\u76ee\u6750\u6599\u6267\u884c\u60c5\u51b5\u5bfc\u51fa")
    @RequestMapping(value={"/projectMaterialExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void projectMaterialExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        Long projectId = null;
        if (param.getParams().containsKey("projectId")) {
            projectId = Long.valueOf(((Parameter)param.getParams().get("projectId")).getValue().toString());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PromaterialMaterialReportVO> list = this.service.quueryMaterialByProject(page, wrapper, projectId);
        HashMap<String, List<PromaterialMaterialReportVO>> beans = new HashMap<String, List<PromaterialMaterialReportVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectMaterial-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u5408\u540c\u6750\u6599\u6267\u884c\u60c5\u51b5\u5217\u8868\u67e5\u8be2")
    @RequestMapping(value={"/quueryMaterialByOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> quueryMaterialByOrg(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("spec");
        Long orgId = null;
        if (param.getParams().containsKey("treeOrgId")) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("treeOrgId")).getValue().toString());
            Integer orgType = Integer.valueOf(((Parameter)param.getParams().get("orgType")).getValue().toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (!param.getParams().containsKey("treeOrgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().remove("orgType");
        param.getParams().remove("treeOrgId");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PromaterialContractMaterialReportVO> promaterialContractMaterialReportVOList = this.service.quueryMaterialByOrg(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", promaterialContractMaterialReportVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @ApiOperation(value="\u5408\u540c\u6750\u6599\u6267\u884c\u60c5\u51b5\u5bfc\u51fa")
    @RequestMapping(value={"/contractExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void contractExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("spec");
        Long orgId = null;
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().containsKey("treeOrgId")) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("treeOrgId")).getValue().toString());
            Integer orgType = Integer.valueOf(((Parameter)param.getParams().get("orgType")).getValue().toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (!param.getParams().containsKey("treeOrgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().remove("orgType");
        param.getParams().remove("treeOrgId");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PromaterialContractMaterialReportVO> promaterialContractMaterialReportVOList = this.service.quueryMaterialByOrg(page, wrapper);
        HashMap<String, List<PromaterialContractMaterialReportVO>> beans = new HashMap<String, List<PromaterialContractMaterialReportVO>>();
        beans.put("records", promaterialContractMaterialReportVOList);
        ExcelExport.getInstance().export("ContractExcelExport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/asyncWatermarkById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> asyncWatermarkById(@RequestParam(value="id") Long id) {
        this.service.asyncWatermarkById(id);
        return CommonResponse.success((String)"\u6c34\u5370\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/checkContractFiling"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkContractFiling(Long id) {
        boolean filingFlag = this.service.checkContractFiling(id);
        if (filingFlag) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u65e0\u6cd5\u65b0\u589e");
    }

    @GetMapping(value={"/getReferenceMap"})
    @ResponseBody
    public CommonResponse<List<ReferenceMapVO>> getReferenceMap(@RequestParam String type, @RequestParam Long id) {
        Map<String, String> queryParam = this.getQueryDataParam(id.toString());
        CommonResponse dataResp = this.mdApi.queryDataList(queryParam);
        if (!dataResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540cid-{}\u83b7\u53d6\u5f15\u7528\u5355\u636e\u4fe1\u606f\u5217\u8868\u5931\u8d25{}", (Object)id, (Object)dataResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5f15\u7528\u7ed3\u7b97\u5355\u7684\u5355\u636e\u4fe1\u606f\u5217\u8868\u5931\u8d25\uff01");
        }
        List<ReferenceMapVO> resp = this.getReferenceMapData((Map)dataResp.getData());
        return CommonResponse.success(resp);
    }

    private Map<String, String> getQueryDataParam(String id) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        StringBuilder sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,check_all_tax_mny as mny  FROM `ejc_promaterial_check`\nwhere dr = 0 and contract_id =  ").append(id);
        queryParam.put("BT220215000000006", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,reconciliation_tax_mny as mny  FROM `ejc_promaterial_reconciliation`\nwhere dr = 0 and contract_id = ").append(id);
        queryParam.put("BT220310000000001", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,settlement_tax_mny as mny  FROM `ejc_promaterial_settlement`\nwhere dr = 0 and contract_id = ").append(id);
        queryParam.put("BT220309000000003", sp.toString());
        sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, project_name AS bill_code, parent_org_name,bill_state,cost_mny as mny  from ejc_procost_share ").append(" where id in (select DISTINCT share_id from ejc_procost_share_detail where source_id = ").append(id).append(" and dr = 0) and dr = 0");
        queryParam.put("BT220316000000002", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT id, create_user_code, create_time, bill_code, org_name,bill_state,apply_mny as mny FROM `ejc_payment_apply` where dr = 0 and contract_id = ").append(id);
        queryParam.put("BT220223000000003", sp.toString());
        return queryParam;
    }

    private List<ReferenceMapVO> getReferenceMapData(Map<String, List<JSONObject>> data) {
        ArrayList<ReferenceMapVO> resp = new ArrayList<ReferenceMapVO>();
        ReferenceMapVO tmp = null;
        ReferenceDetailVO tmpDetail = null;
        List<JSONObject> dataList = null;
        HashSet<String> userCodes = new HashSet<String>();
        for (String billType : data.keySet()) {
            dataList = data.get(billType);
            if (!CollectionUtils.isNotEmpty(dataList)) continue;
            String billName = "";
            String billUrl = "";
            switch (billType) {
                case "BT220215000000006": {
                    billName = "\u9a8c\u6536\u5355";
                    billUrl = "ejc-steelstructure-frontend/#/check/card?id=";
                    break;
                }
                case "BT220310000000001": {
                    billName = "\u5bf9\u8d26\u5355";
                    billUrl = "ejc-steelstructure-frontend/#/reconciliation/card?id=";
                    break;
                }
                case "BT220309000000003": {
                    billName = "\u91c7\u8d2d\u7ed3\u7b97\u5355";
                    billUrl = "ejc-steelstructure-frontend/#/settlementList/settlementCard?id=";
                    break;
                }
                case "BT220316000000002": {
                    billName = "\u6210\u672c\u5f52\u96c6\u5355";
                    billUrl = "ejc-share-frontend/#/costShare/card?id=";
                    break;
                }
                case "BT220223000000003": {
                    billName = "\u6709\u5408\u540c\u4ed8\u6b3e\u7533\u8bf7";
                    billUrl = "ejc-profinance-frontend/#/paymentList/contractCard?id=";
                }
            }
            tmp = new ReferenceMapVO();
            tmp.setId(billType);
            tmp.setModuleName(billName);
            tmp.setReferenceNum(Integer.valueOf(dataList.size()));
            BigDecimal sumMny = new BigDecimal(0);
            for (JSONObject dataRow : dataList) {
                tmpDetail = new ReferenceDetailVO();
                tmpDetail.setId(dataRow.getString("id"));
                tmpDetail.setBillCode(dataRow.getString("bill_code"));
                tmpDetail.setBillState(BillStateEnum.getEnumByStateCode((Integer)dataRow.getInteger("bill_state")).getDescription());
                tmpDetail.setCreateTime(dataRow.getDate("create_time"));
                tmpDetail.setEmployeeName(dataRow.getString("create_user_code"));
                tmpDetail.setModuleName(tmp.getModuleName());
                tmpDetail.setOrgName(dataRow.getString("org_name"));
                tmpDetail.setMny(dataRow.getBigDecimal("mny"));
                tmpDetail.setDetailPcUrl(this.BaseHost + billUrl + tmpDetail.getId());
                tmp.getDetailList().add(tmpDetail);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tmpDetail.getEmployeeName())) {
                    userCodes.add(tmpDetail.getEmployeeName());
                }
                if (tmpDetail.getMny() == null) continue;
                sumMny = sumMny.add(dataRow.getBigDecimal("mny"));
            }
            tmp.setSumMny(sumMny);
            resp.add(tmp);
        }
        if (CollectionUtils.isNotEmpty(userCodes)) {
            CommonResponse userResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if (!userResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7528\u6237\u7f16\u7801\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)userResp.getMsg());
            } else {
                Map<String, UserVO> userMap = ((List)userResp.getData()).stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item));
                resp.stream().forEach(item -> item.getDetailList().stream().forEach(detail -> {
                    if (userMap.containsKey(detail.getEmployeeName())) {
                        detail.setEmployeeName(((UserVO)userMap.get(detail.getEmployeeName())).getUserName());
                    }
                }));
            }
        }
        return resp;
    }
}

