/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractRelieveEntity;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.mapper.PromaterialContractRelieveMapper;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractRelieveService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractService;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractDetailVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractRelieveVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractVO;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementDetailEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementDetailService;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="promaterialContractRelieveService")
public class PromaterialPromaterialContractRelieveServiceImpl
extends BaseServiceImpl<PromaterialContractRelieveMapper, PromaterialContractRelieveEntity>
implements IPromaterialContractRelieveService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MATERIAL_BILL_CODE = "CONTRACT_RELIEVE";
    private static final String CONCRETE_BILL_CODE = "CONTRACT_CONCRETE_RELIEVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPromaterialContractService contractService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IPromaterialSettlementService settlementService;
    @Autowired
    private IPromaterialSettlementDetailService settlementDetailService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public PromaterialContractRelieveVO save(PromaterialContractRelieveVO saveOrUpdateVO) {
        List list;
        PromaterialContractRelieveEntity entity = (PromaterialContractRelieveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PromaterialContractRelieveEntity.class));
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (promaterialContractEntity == null || !PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(promaterialContractEntity.getPerformanceStatus())) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5408\u540c\u6216\u5408\u540c\u72b6\u6001\u975e\u5c65\u7ea6\u4e2d\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam;
            CommonResponse billCode;
            String billCodeStr = MATERIAL_BILL_CODE;
            if (promaterialContractEntity.getContractType() == 1) {
                billCodeStr = CONCRETE_BILL_CODE;
            }
            if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)entity.getContractId()));
        if (entity.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam)))) {
            throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u5408\u540c\u89e3\u9664\u534f\u8bae\uff01");
        }
        if (entity.getDraftType() == 1) {
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        }
        this.contractService.checkContract(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId());
        super.saveOrUpdate((Object)entity, false);
        return (PromaterialContractRelieveVO)BeanMapper.map((Object)((Object)entity), PromaterialContractRelieveVO.class);
    }

    @Override
    public CommonResponse<String> relieveContract(String billId, String status, String refCode) {
        this.logger.info("\u66f4\u65b0\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u548c\u5408\u540c\u72b6\u6001\uff0c\u5165\u53c2\uff1aid:{}\uff0csignatureStatus\uff1a{}\uff0crefCode\uff1a{}", new Object[]{billId, status, refCode});
        Long id = Long.valueOf(billId);
        PromaterialContractRelieveEntity promaterialContractRelieveEntity = (PromaterialContractRelieveEntity)((Object)super.selectById((Serializable)id));
        promaterialContractRelieveEntity.setSignatureStatus(status);
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(promaterialContractRelieveEntity.getContractId()));
        if (promaterialContractEntity == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        this.logger.info("\u4fee\u6539\u5408\u540c\u4fe1\u606f-----{}", (Object)JSONObject.toJSONString((Object)((Object)promaterialContractEntity)));
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(status) && PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(promaterialContractEntity.getPerformanceStatus())) {
            promaterialContractRelieveEntity.setEffectiveDate(new Date());
            promaterialContractRelieveEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
            promaterialContractRelieveEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode());
            promaterialContractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode());
            this.contractService.saveOrUpdate((Object)promaterialContractEntity, false);
            this.contractService.pushContract((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class));
            String linkUrl = promaterialContractEntity.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure--frontend/#/contractMaterial/contractRelieve/card?id=" + promaterialContractRelieveEntity.getId() : this.BaseHost + "ejc-steelstructure--frontend/#/contractConcrete/contractRelieve/card?id=" + promaterialContractRelieveEntity.getId();
            if (promaterialContractEntity.getPurchaseType().equals("1")) {
                ExecutionVO executionVO = this.targetCost((PromaterialContractRelieveVO)BeanMapper.map((Object)((Object)promaterialContractRelieveEntity), PromaterialContractRelieveVO.class), linkUrl, promaterialContractEntity.getContractType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
            this.logger.info("\u5408\u540c\u5df2\u89e3\u9664\uff01");
        }
        super.saveOrUpdate((Object)promaterialContractRelieveEntity, false);
        return CommonResponse.success((String)"\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
    }

    @Override
    public ExecutionVO targetCost(PromaterialContractRelieveVO promaterialContractRelieveVO, String linkUrl, Integer contractType) {
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PromaterialSettlementEntity::getContractId, (Object)promaterialContractRelieveVO.getContractId());
        wrapper.eq(PromaterialSettlementEntity::getSignatureType, (Object)0);
        wrapper.in(PromaterialSettlementEntity::getBillState, Arrays.asList(1, 3));
        wrapper.eq(BaseEntity::getDr, (Object)0);
        List list = this.settlementService.list((Wrapper)wrapper);
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(PromaterialSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(PromaterialSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        PromaterialContractVO promaterialContractVO = this.contractService.queryDetail(promaterialContractRelieveVO.getContractId());
        List contractDetailList = promaterialContractVO.getContractDetailList();
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(promaterialContractRelieveVO.getId());
        totalVO.setTenantId(promaterialContractRelieveVO.getTenantId());
        totalVO.setBillCode(promaterialContractRelieveVO.getBillCode());
        if (contractType == 0) {
            totalVO.setBillType("BT220218000000003");
        } else {
            totalVO.setBillType("BT220219000000001");
        }
        switch (promaterialContractVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(promaterialContractRelieveVO.getProjectId());
        totalVO.setOrgId(promaterialContractRelieveVO.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)promaterialContractVO.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)promaterialContractVO.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        List settleIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(settleIdList)) {
            LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
            detailWrapper.in(PromaterialSettlementDetailEntity::getSettlementId, settleIdList);
            List settleDetailList = this.settlementDetailService.list((Wrapper)detailWrapper);
            Map<Long, List<PromaterialSettlementDetailEntity>> detailMaterialMap = settleDetailList.stream().collect(Collectors.groupingBy(PromaterialSettlementDetailEntity::getMaterialId));
            Map<Long, List<PromaterialContractDetailVO>> contractDetailMap = contractDetailList.stream().collect(Collectors.groupingBy(PromaterialContractDetailVO::getMaterialId));
            for (Long materialId : detailMaterialMap.keySet()) {
                List<PromaterialSettlementDetailEntity> detailMaterialList = detailMaterialMap.get(materialId);
                List<PromaterialContractDetailVO> contractDetailList1 = contractDetailMap.get(materialId);
                BigDecimal contractSumNum = contractDetailList1.stream().filter(e -> e.getNum() != null).map(PromaterialContractDetailVO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal contractSumMny = contractDetailList1.stream().filter(e -> e.getMoney() != null).map(PromaterialContractDetailVO::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal contractSumTaxMny = contractDetailList1.stream().filter(e -> e.getDetailTaxMny() != null).map(PromaterialContractDetailVO::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumNum = detailMaterialList.stream().filter(e -> e.getNum() != null).map(PromaterialSettlementDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumMny = detailMaterialList.stream().filter(e -> e.getMny() != null).map(PromaterialSettlementDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sumTaxMny = detailMaterialList.stream().filter(e -> e.getTaxMny() != null).map(PromaterialSettlementDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                PromaterialSettlementDetailEntity planDetailVO = detailMaterialList.get(0);
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(planDetailVO.getSettlementId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                if (planDetailVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                }
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
                detailExecutionVO.setNum(ComputeUtil.safeSub((BigDecimal)sumNum, (BigDecimal)contractSumNum));
                detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)contractSumMny));
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)contractSumTaxMny));
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                detailList.add(detailExecutionVO);
            }
        } else if (contractDetailList != null) {
            for (PromaterialContractDetailVO planDetailVO : promaterialContractVO.getContractDetailList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(promaterialContractRelieveVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                if (planDetailVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                }
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnitName());
                detailExecutionVO.setNum(BigDecimal.ZERO.subtract(planDetailVO.getNum()));
                detailExecutionVO.setMoney(BigDecimal.ZERO.subtract(planDetailVO.getMoney()));
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(BigDecimal.ZERO.subtract(planDetailVO.getDetailTaxMny()));
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getDetailTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getDetailTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}

