/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.steelstructure.finance.service.IPaymentApplyService;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractChangeEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractDetailEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractRelieveEntity;
import com.ejianc.business.steelstructure.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.DraftTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.SuplementFlagEnum;
import com.ejianc.business.steelstructure.promaterial.contract.mapper.PromaterialContractMapper;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractAsyncService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractChangeService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractDetailService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractFreezeService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractRelieveService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractService;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractChangeVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractDetailVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractMaterialReportVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractRelieveVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialMaterialMnyVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialMaterialReportVO;
import com.ejianc.business.steelstructure.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.steelstructure.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementService;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSettlementVO;
import com.ejianc.business.steelstructure.promaterial.utils.CommonUtils;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="promaterialContractService")
public class PromaterialPromaterialContractServiceImpl
extends BaseServiceImpl<PromaterialContractMapper, PromaterialContractEntity>
implements IPromaterialContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PURCHASE_CONTRACT_BILL_CODE = "CONTRACT_MATERIAL";
    private static final String PURCHASE_CONTRACT_CONCRETE_BILL_CODE = "CONTRACT_CONCRETE";
    private static final String PURCHASE_CONTRACT_YNJT = "CONTRACT_MATERIAL_YNJT";
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IPromaterialContractChangeService contractChangeService;
    @Autowired
    private IPromaterialContractDetailService contractDetailService;
    @Autowired
    private IPromaterialContractService service;
    @Autowired
    private IPromaterialContractRelieveService relieveService;
    @Autowired
    private IPromaterialContractFreezeService freezeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITenderApi tenderApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IPromaterialSettlementService settlementService;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IDutyApi iDutyApi;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IPromaterialContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private String GenerateBillCodeType = "contractMaterial";
    private final String MAIN_CONTRACT_REFCODE = "contractMaterial";
    private static final String CHECK_PARAM_CODE = "P-434f5499";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String M_SUP_CODE = "P-CO2iY888";
    private static final String C_SUP_CODE = "P-K496W490";
    private static final String M_PLAN_CODE = "P-CcZ6rO87";
    private static final String C_PLAN_CODE = "P-00g5A089";
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134";
    private static final String UPDATE_CON_SIGN_DATE_PARAM_NAME = "P-U9uddl0182";
    @Autowired
    private IPaymentApplyService paymentApplyApi;

    @Override
    public CommonResponse<PromaterialContractVO> saveOrUpdate(PromaterialContractVO promaterialContractVo, String authority, Boolean isControl) {
        PromaterialContractEntity contract;
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Object orgResponse;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        List entitiesc = null;
        if (promaterialContractVo.getId() != null) {
            PromaterialContractVO delVo = this.queryDetail(promaterialContractVo.getId());
            if (PurchaseTypeEnum.\u9879\u76ee\u81ea\u91c7.getCode().equals(delVo.getPurchaseType()) && !delVo.getContractPropertyCode().equals(promaterialContractVo.getContractPropertyCode())) {
                ArrayList<TotalExecutionVO> totalExecutionVODelList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVODel = this.service.targetCost(delVo, "", 0, delVo.getContractType());
                totalExecutionVODelList.add(executionVODel.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVODelList));
                CommonResponse response = this.executionApi.aggDel(totalExecutionVODelList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
        }
        if (promaterialContractVo.getOrgId() != null && (StringUtils.isEmpty((CharSequence)promaterialContractVo.getOrgCode()) || StringUtils.isEmpty((CharSequence)promaterialContractVo.getParentOrgCode()) || StringUtils.isEmpty((CharSequence)promaterialContractVo.getOrgName())) && (orgResponse = this.iOrgApi.getOneById(promaterialContractVo.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            promaterialContractVo.setOrgCode(orgVO.getCode());
            if (StringUtils.isEmpty((CharSequence)promaterialContractVo.getOrgName())) {
                promaterialContractVo.setOrgName(orgVO.getName());
            }
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    promaterialContractVo.setParentOrgId(parentOrgVO.getId());
                    promaterialContractVo.setParentOrgCode(parentOrgVO.getCode());
                    promaterialContractVo.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                promaterialContractVo.setParentOrgId(promaterialContractVo.getOrgId());
                promaterialContractVo.setParentOrgCode(promaterialContractVo.getOrgCode());
                promaterialContractVo.setParentOrgName(promaterialContractVo.getOrgName());
            }
        }
        if (promaterialContractVo.getTargetResultId() != null && CollectionUtils.isNotEmpty((Collection)promaterialContractVo.getContractDetailList())) {
            for (PromaterialContractDetailVO detailVO : promaterialContractVo.getContractDetailList()) {
                detailVO.setInitNum(detailVO.getNum());
            }
        }
        PromaterialContractEntity entity = (PromaterialContractEntity)((Object)BeanMapper.map((Object)promaterialContractVo, PromaterialContractEntity.class));
        if (!isControl.booleanValue() && StringUtils.isEmpty((CharSequence)promaterialContractVo.getBillCode())) {
            entity.setBillCode(this.getContractBillCode(promaterialContractVo));
        }
        if (entity.getId() == null) {
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            }
            entity.setFilingRef(0);
        }
        if (promaterialContractVo.getId() != null && promaterialContractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(PromaterialContractEntity::getBillCode, (Object)promaterialContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)promaterialContractVo.getId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)promaterialContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)promaterialContractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(PromaterialContractEntity::getBillCode, (Object)promaterialContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)promaterialContractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(promaterialContractVo.getContractMny() == null ? BigDecimal.ZERO : promaterialContractVo.getContractMny());
        entity.setBaseMoneyWithTax(promaterialContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : promaterialContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(promaterialContractVo.getContractMny() == null ? BigDecimal.ZERO : promaterialContractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(promaterialContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : promaterialContractVo.getContractTaxMny());
        if (!(entity.getContractFileId() == null || (contract = (PromaterialContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        if (!isControl.booleanValue()) {
            this.checkDetailTenderNum(promaterialContractVo.getContractDetailList(), promaterialContractVo.getId(), promaterialContractVo.getTargetResultId());
            boolean saveFlag = super.saveOrUpdate((Object)entity, false);
            if (!saveFlag) {
                throw new BusinessException("\u5408\u540c\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            if (promaterialContractVo.getId() == null && promaterialContractVo.getTargetResultId() != null) {
                this.updateTargetResult(promaterialContractVo, 0);
            }
            if (promaterialContractVo.getId() != null && promaterialContractVo.getTargetResultId() != null) {
                PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)super.selectById((Serializable)promaterialContractVo.getId()));
                this.updateTargetResult((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class), 1);
                this.updateTargetResult(promaterialContractVo, 0);
            }
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
                entity.setContractFileSyncFlag(false);
            }
            if (entity.getPurchaseType().equals("1")) {
                String linkUrl = entity.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/card?id=" + entity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/card?id=" + entity.getId();
                ExecutionVO executionVO = this.service.targetCost((PromaterialContractVO)BeanMapper.map((Object)((Object)entity), PromaterialContractVO.class), linkUrl, 0, entity.getContractType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), PromaterialContractVO.class));
    }

    private String getContractBillCode(PromaterialContractVO promaterialContractVo) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
        if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(promaterialContractVo.getContractType())) {
            billCodeStr = PURCHASE_CONTRACT_CONCRETE_BILL_CODE;
        }
        if (!(billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)promaterialContractVo))).isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String contractBillCode = (String)billCode.getData();
        return contractBillCode;
    }

    @Override
    public PromaterialContractVO saveOrUpdateSupplement(PromaterialContractVO promaterialContractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PromaterialContractEntity entity = (PromaterialContractEntity)((Object)BeanMapper.map((Object)promaterialContractVo, PromaterialContractEntity.class));
        List entities = null;
        List entitiesc = null;
        PromaterialContractEntity mainContract = (PromaterialContractEntity)((Object)this.service.selectById(promaterialContractVo.getMainContractId()));
        if (null == mainContract) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        if (!isControl.booleanValue() && StringUtils.isEmpty((CharSequence)promaterialContractVo.getBillCode())) {
            QueryParam billCodeParam = new QueryParam();
            billCodeParam.getParams().put("main_contract_id", new Parameter("eq", (Object)promaterialContractVo.getMainContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            billCodeParam.getParams().put("bill_state", new Parameter("in", billStateList));
            List billCOdeSupplementList = this.service.queryList(billCodeParam, false);
            String supplementNum = "";
            supplementNum = billCOdeSupplementList.size() < 9 ? supplementNum + "0" + (billCOdeSupplementList.size() + 1) : supplementNum + (billCOdeSupplementList.size() + 1);
            entity.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }
        if (promaterialContractVo.getId() != null && promaterialContractVo.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(PromaterialContractEntity::getBillCode, (Object)promaterialContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)promaterialContractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)promaterialContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)promaterialContractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)promaterialContractVo.getMainContractId()));
            List supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(PromaterialContractEntity::getBillCode, (Object)promaterialContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)promaterialContractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        this.checkContract(promaterialContractVo.getMainContractId(), promaterialContractVo.getId());
        entity.setBaseMoney(promaterialContractVo.getContractMny() == null ? BigDecimal.ZERO : promaterialContractVo.getContractMny());
        entity.setBaseMoneyWithTax(promaterialContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : promaterialContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(promaterialContractVo.getContractMny() == null ? BigDecimal.ZERO : promaterialContractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(promaterialContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : promaterialContractVo.getContractTaxMny());
        if (FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                PromaterialContractEntity contract = (PromaterialContractEntity)((Object)super.getById((Serializable)entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    if (!isControl.booleanValue()) {
                        this.delContractFile(entity.getContractFileId(), authority);
                    }
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                if (!isControl.booleanValue()) {
                    this.delContractFile(entity.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)entity, false);
            if (entity.getPurchaseType().equals("1")) {
                String linkUrl = entity.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/supplement/card?id=" + entity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/supplementConcrete/card?id=" + entity.getId();
                ExecutionVO executionVO = this.service.targetCost((PromaterialContractVO)BeanMapper.map((Object)((Object)entity), PromaterialContractVO.class), linkUrl, 0, entity.getContractType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
        }
        return (PromaterialContractVO)BeanMapper.map((Object)((Object)entity), PromaterialContractVO.class);
    }

    @Override
    public PromaterialContractVO addConvertByConId(Long contractId) {
        PromaterialContractEntity contractVO = (PromaterialContractEntity)((Object)super.selectById((Serializable)contractId));
        PromaterialContractVO supplementVO = new PromaterialContractVO();
        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());
        supplementVO.setSignPlace(contractVO.getSignPlace());
        supplementVO.setCustomerEmployeeId(contractVO.getCustomerEmployeeId());
        supplementVO.setCustomerEmployeeName(contractVO.getCustomerEmployeeName());
        supplementVO.setCustomerEmployeeMobile(contractVO.getCustomerEmployeeMobile());
        supplementVO.setSupplierEmployeeName(contractVO.getSupplierEmployeeName());
        supplementVO.setSupplierEmployeeMobile(contractVO.getSupplierEmployeeMobile());
        supplementVO.setPricingType(contractVO.getPricingType());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setContractCategoryName(contractVO.getContractCategoryName());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectPlace(contractVO.getProjectPlace());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setSignDate(new Date());
        supplementVO.setSupplementFlag(Integer.valueOf(1));
        supplementVO.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().toString());
        supplementVO.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().toString());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        supplementVO.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        supplementVO.setMainContractCreateDate(contractVO.getMainContractCreateDate());
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setContractPropertyCode(contractVO.getContractPropertyCode());
        supplementVO.setContractPropertyName(contractVO.getContractPropertyName());
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public PromaterialContractVO queryDetail(Long id) {
        PromaterialContractEntity entity = (PromaterialContractEntity)((Object)super.selectById((Serializable)id));
        entity.setContractDetailList(null);
        PromaterialContractVO promaterialContractVo = (PromaterialContractVO)BeanMapper.map((Object)((Object)entity), PromaterialContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PromaterialContractDetailEntity::getContractId, (Object)id);
        lambda.ne(PromaterialContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u4e2d\u6b62\u9879);
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            promaterialContractVo.setContractDetailList(BeanMapper.mapList((Iterable)details, PromaterialContractDetailVO.class));
        }
        return promaterialContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = PromaterialPromaterialContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_money_with_tax) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public PromaterialContractVO querySupplementRecord(Long id) {
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)super.selectById((Serializable)id));
        PromaterialContractVO recordVO = new PromaterialContractVO();
        BigDecimal contractTaxMny = promaterialContractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : promaterialContractEntity.getContractTaxMny();
        recordVO.setId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setChangeStatus(promaterialContractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"signature_status", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        recordVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, PromaterialContractVO.class));
        recordVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            allSupplementAmt = supplementEntities.stream().map(e -> e.getContractTaxMny() == null ? BigDecimal.ZERO : e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        recordVO.setSupplementAmtRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(promaterialContractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(promaterialContractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(promaterialContractEntity.getBillState()))) {
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        this.logger.info("\u8fdb\u5165\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u65b9\u6cd5\uff0c\u4fee\u6539\u53c2\u6570\uff1abillId:{},status:{},refCode:{}", new Object[]{billId, status, refCode});
        PromaterialContractEntity contract = (PromaterialContractEntity)((Object)super.selectById((Serializable)billId));
        if (contract != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                contract.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contract.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contract.setFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
                contract.setFilingRef(0);
                contract.setEffectiveDate(new Date());
                CommonResponse response = this.paramConfigApi.getByCode(UPDATE_CON_SIGN_DATE_PARAM_NAME);
                if (!response.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u7535\u4e2d\u7b7e\u7ae0\u5408\u540c-\u3010id-{}\u3011\u662f\u5426\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570\u5931\u8d25\uff0c\u6682\u4e0d\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f: {}", (Object)billId, (Object)JSONObject.toJSONString((Object)response));
                }
                if (null != response.getData() && "1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    this.logger.info("\u5408\u540c\u3010id-{}\uff0c\u539f\u7b7e\u8ba2\u65e5\u671f\uff1a{}, \u6839\u636e\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570:{}\uff0c\u5c06\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u6539\u4e3a\u5f53\u524d\u7b7e\u7ae0\u5b8c\u6210\u65e5\u671f:{}\u3011", new Object[]{billId, sdf.format(contract.getSignDate()), JSONObject.toJSONString((Object)response.getData()), sdf.format(new Date())});
                    contract.setSignDate(new Date());
                }
            } else {
                contract.setSignatureStatus(String.valueOf(status));
            }
        } else {
            return false;
        }
        super.saveOrUpdate((Object)contract, false);
        this.pushContract((PromaterialContractVO)BeanMapper.map((Object)((Object)contract), PromaterialContractVO.class));
        this.logger.info("\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539\uff0c\u4fee\u6539\u540e\u7b7e\u7ae0\u72b6\u6001:{}---------------->", (Object)contract.getSignatureStatus());
        return true;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)super.selectById((Serializable)id));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(promaterialContractEntity.getPerformanceStatus())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PromaterialContractEntity::getMainContractId, (Object)id);
        lambda.eq(PromaterialContractEntity::getSupplementFlag, (Object)1);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(PromaterialContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(PromaterialContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ExecutionVO targetCost(PromaterialContractVO promaterialContractVO, String linkUrl, Integer type, Integer contractType) {
        List contractDetailList;
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(promaterialContractVO.getId());
        totalVO.setTenantId(promaterialContractVO.getTenantId());
        totalVO.setBillCode(promaterialContractVO.getBillCode());
        if (contractType == 0) {
            if (type == 0) {
                contractDetailList = promaterialContractVO.getContractDetailList();
                totalVO.setBillType(BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c.getCode());
            } else {
                contractDetailList = promaterialContractVO.getContractDetailList();
                totalVO.setLastSourceId(promaterialContractVO.getMainContractId());
                totalVO.setBillType(BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c\u53d8\u66f4.getCode());
            }
        } else if (type == 0) {
            contractDetailList = promaterialContractVO.getContractDetailList();
            totalVO.setBillType(BillTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getCode());
        } else {
            contractDetailList = promaterialContractVO.getContractDetailList();
            totalVO.setLastSourceId(promaterialContractVO.getMainContractId());
            totalVO.setBillType(BillTypeEnum.\u6df7\u51dd\u571f\u53d8\u66f4\u5408\u540c.getCode());
        }
        switch (promaterialContractVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(promaterialContractVO.getProjectId());
        totalVO.setOrgId(promaterialContractVO.getOrgId());
        totalVO.setMoney(promaterialContractVO.getContractMny());
        totalVO.setTaxMoney(promaterialContractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (contractDetailList != null) {
            for (PromaterialContractDetailVO planDetailVO : promaterialContractVO.getContractDetailList()) {
                if ("del".equals(planDetailVO.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(promaterialContractVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                if (planDetailVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                }
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnitName());
                detailExecutionVO.setNum(planDetailVO.getNum());
                detailExecutionVO.setMoney(planDetailVO.getMoney());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getDetailTaxMny());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getDetailTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getDetailTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public Boolean pushContract(PromaterialContractVO promaterialContractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)promaterialContractVO, (Object)data);
            data.setPurchaseType(Integer.valueOf(promaterialContractVO.getPurchaseType()));
            data.setSourceType(ContractTypeEnum.\u94a2\u6784\u516c\u53f8\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
            int targetType = promaterialContractVO.getTargetResultId() == null ? 1 : 0;
            data.setPcCardUrl("/ejc-steelstructure-frontend/#/contractMaterial/contractApprove?id=" + promaterialContractVO.getId() + "&supplementFlag=" + promaterialContractVO.getSupplementFlag() + "&targetType=" + targetType + "&performanceStatus=" + promaterialContractVO.getPerformanceStatus());
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(promaterialContractVO.getContractType())) {
                data.setSourceType(ContractTypeEnum.\u94a2\u6784\u516c\u53f8\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                data.setPcCardUrl("/ejc-steelstructure-frontend/#/contractConcrete/contractApprove?id=" + promaterialContractVO.getId() + "&supplementFlag=" + promaterialContractVO.getSupplementFlag() + "&targetType=" + targetType + "&performanceStatus=" + promaterialContractVO.getPerformanceStatus());
            }
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u6c60>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)promaterialContractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)promaterialContractVO.getId(), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public PromaterialContractVO syncPushContract(Long id) {
        PromaterialContractEntity entity = (PromaterialContractEntity)((Object)super.selectById((Serializable)id));
        PromaterialContractVO vo = (PromaterialContractVO)BeanMapper.map((Object)((Object)entity), PromaterialContractVO.class);
        this.pushContract(vo);
        return vo;
    }

    @Override
    public void pushDelContract(PromaterialContractVO promaterialContractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)promaterialContractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u94a2\u6784\u516c\u53f8\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(promaterialContractVO.getContractType())) {
                data.setSourceType(ContractTypeEnum.\u94a2\u6784\u516c\u53f8\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
            }
            this.logger.info("\u5f00\u59cb\u5220\u9664\u5408\u540c\u6c60\u5408\u540c>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.deleteContract(data);
            this.logger.info("\u5220\u9664\u5408\u540c\u6c60\u5408\u540c\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)promaterialContractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)promaterialContractVO.getId(), (Object)e);
        }
    }

    @Override
    public boolean addRelieveFlag(Long id) {
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)super.selectById((Serializable)id));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(promaterialContractEntity.getPerformanceStatus())) {
            return false;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        List relieveEntityList = this.relieveService.queryList(queryParam, false);
        return CollectionUtils.isEmpty((Collection)relieveEntityList);
    }

    @Override
    public boolean checkContract(Long id, Long otherId) {
        List promaterialContractChangeEntityList;
        Long orgId;
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)super.selectById((Serializable)id));
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(promaterialContractEntity.getPurchaseType()) && !(orgId = InvocationInfoProxy.getOrgId()).equals(promaterialContractEntity.getOrgId())) {
            throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u65e0\u6cd5\u5bf9\u8be5\u5408\u540c\u8fdb\u884c\u64cd\u4f5c\uff01");
        }
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(promaterialContractChangeEntityList = this.contractChangeService.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5408\u540c\uff01");
        }
        List relieveEntityList = this.relieveService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)relieveEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u89e3\u9664\u5355\u636e\uff01");
        }
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        List freezeEntityList = this.freezeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)freezeEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u51bb\u7ed3\u6216\u5408\u540c\u89e3\u51bb\u5355\u636e\uff01");
        }
        return true;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(PromaterialContractVO promaterialContractVO, String authority) {
        CommonResponse<PromaterialContractVO> masterPlanVOCommonResponse = this.saveOrUpdate(promaterialContractVO, authority, true);
        PromaterialContractVO promaterialContractVO1 = (PromaterialContractVO)masterPlanVOCommonResponse.getData();
        String linkUrl = promaterialContractVO1.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/card?id=" + promaterialContractVO1.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/card?id=" + promaterialContractVO1.getId();
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a7\u5236\u5408\u540c\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)promaterialContractVO1));
        ExecutionVO executionVO = this.service.targetCost(promaterialContractVO1, linkUrl, 0, promaterialContractVO1.getContractType());
        this.logger.error("\u4fdd\u5b58\u63a8\u9001\u76ee\u6807\u6210\u672c\u63a7\u5236\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a7\u5236\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)response));
        ParamsCheckVO paramsCheckVO = this.checkParams(promaterialContractVO1, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        PromaterialContractVO promaterialContractVO = this.queryDetail(id);
        if (promaterialContractVO.getContractType() == 0) {
            String linkUrl = this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/card?id=" + promaterialContractVO.getId();
        } else {
            String linkUrl = this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/card?id=" + promaterialContractVO.getId();
        }
        return null;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        CommonResponse response;
        ExecutionVO executionVO;
        String linkUrl;
        PromaterialContractVO promaterialContractVO = this.service.queryDetail(id);
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(promaterialContractVO.getPurchaseType())) {
            return CommonResponse.error((String)"\u516c\u53f8\u96c6\u91c7\u4e0d\u652f\u6301\u76ee\u6807\u6210\u672c\u63a8\u9001\uff01");
        }
        if (PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(promaterialContractVO.getPerformanceStatus())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)id);
            PromaterialContractRelieveEntity promaterialContractRelieveEntity = (PromaterialContractRelieveEntity)((Object)this.relieveService.getOne((Wrapper)queryWrapper));
            linkUrl = promaterialContractVO.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/contractRelieve/card?id=" + promaterialContractRelieveEntity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/contractRelieve/card?id=" + promaterialContractRelieveEntity.getId();
            executionVO = this.relieveService.targetCost((PromaterialContractRelieveVO)BeanMapper.map((Object)((Object)promaterialContractRelieveEntity), PromaterialContractRelieveVO.class), linkUrl, promaterialContractVO.getContractType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5408\u540c\u89e3\u9664\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("createTime", "desc");
        List changeEntityList = this.contractChangeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)changeEntityList)) {
            PromaterialContractChangeEntity changeEntity = (PromaterialContractChangeEntity)((Object)changeEntityList.get(0));
            PromaterialContractChangeVO changeVO = this.contractChangeService.queryDetail(changeEntity.getId());
            linkUrl = changeEntity.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/contractChange/card?id=" + changeEntity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/contractChange/card?id=" + changeEntity.getId();
            executionVO = this.service.targetCost((PromaterialContractVO)BeanMapper.map((Object)changeVO, PromaterialContractVO.class), linkUrl, 1, changeEntity.getContractType());
        } else {
            linkUrl = promaterialContractVO.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/card?id=" + promaterialContractVO.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/card?id=" + promaterialContractVO.getId();
            executionVO = this.service.targetCost(promaterialContractVO, linkUrl, 0, promaterialContractVO.getContractType());
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ParamsCheckVO checkParams(PromaterialContractVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        if (!"proMaterial-2".equals(vo.getContractPropertyCode()) || !MaterialContractTypeEnum.\u6d88\u8017\u6750.getCode().equals(vo.getContractType())) {
            paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));
        }
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), SuplementFlagEnum.\u662f\u8865\u5145\u534f\u8bae.getCode())) {
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnySup(PromaterialContractVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(vo.getPurchaseType())) {
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)super.selectById((Serializable)vo.getMainContractId()));
        BigDecimal contractTaxMny = promaterialContractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : promaterialContractEntity.getContractTaxMny();
        BigDecimal totalSupMoney = contractTaxMnySup;
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            for (PromaterialContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)totalSupMoney);
            }
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getContractType()) {
            case 0: {
                CHECK_PARAM_CODE = M_SUP_CODE;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = C_SUP_CODE;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySup.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(totalSupMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSupMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(PromaterialContractVO vo) {
        List list;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(vo.getPurchaseType())) {
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        BigDecimal planTaxMny = BigDecimal.ZERO;
        BigDecimal totalMoney = contractTaxMny;
        LambdaQueryWrapper planLambda = new LambdaQueryWrapper();
        planLambda.eq(MasterPlanEntity::getProjectId, (Object)vo.getProjectId());
        planLambda.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        planLambda.eq(BaseEntity::getDr, (Object)0);
        planLambda.eq(MasterPlanEntity::getPlanType, (Object)vo.getContractType());
        List planList = this.masterPlanService.list((Wrapper)planLambda);
        if (!CollectionUtils.isNotEmpty((Collection)planList)) {
            return paramsCheckVOS;
        }
        planTaxMny = planList.stream().filter(e -> e.getTotalPlanAmt() != null).map(MasterPlanEntity::getTotalPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper Lambda = new LambdaQueryWrapper();
        Lambda.eq(PromaterialContractEntity::getProjectId, (Object)vo.getProjectId());
        Lambda.orderByDesc(BaseEntity::getCreateTime);
        Lambda.eq(PromaterialContractEntity::getContractType, (Object)vo.getContractType());
        if (MaterialContractTypeEnum.\u6d88\u8017\u6750.getCode().equals(vo.getContractType())) {
            Lambda.ne(PromaterialContractEntity::getContractPropertyCode, (Object)"proMaterial-2");
        }
        if (vo.getId() != null) {
            Lambda.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)Lambda)))) {
            List<Long> collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<PromaterialContractChangeVO> contractChangeList = ((PromaterialContractMapper)this.baseMapper).getContractChangeList(collect);
            Map<Long, PromaterialContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(PromaterialContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
            List<PromaterialSettlementVO> settlementList = ((PromaterialContractMapper)this.baseMapper).getSettlementList(collect);
            Map<Long, PromaterialSettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(PromaterialSettlementVO::getContractId, item -> item, (v1, v2) -> v2));
            for (PromaterialContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;
                if (PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode().equals(entity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(entity.getPerformanceStatus())) {
                    if (mapSettle.containsKey(entity.getId())) {
                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
                    }
                } else {
                    zero = mapChange.containsKey(entity.getId()) ? mapChange.get(entity.getId()).getContractTaxMny() : entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd((BigDecimal)zero, (BigDecimal)totalMoney);
            }
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getContractType()) {
            case 0: {
                CHECK_PARAM_CODE = M_PLAN_CODE;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = C_PLAN_CODE;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u91c7\u8d2d\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u91c7\u8d2d\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\uff1a").append(totalMoney.setScale(2, 4)).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(PromaterialContractVO vo) {
        CommonResponse contractionData = this.contractPoolApi.queryContractionTaxMny(vo.getProjectId());
        if (!contractionData.isSuccess() || null == contractionData.getData()) {
            this.logger.info(contractionData.getMsg());
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        BigDecimal contractionTaxMny = new BigDecimal(String.valueOf(contractionData.getData()));
        this.logger.info("\u83b7\u53d6\u9879\u76ee\uff1a{}\u4e0b\uff0c\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)vo.getProjectId(), (Object)contractionTaxMny);
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        if (BigDecimal.ZERO.compareTo(contractionTaxMny) == 0) {
            return paramsCheckVOList;
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                CommonResponse projectData = this.executionApi.queryTotalContMny(vo.getProjectId());
                if (!projectData.isSuccess() || null == projectData.getData()) {
                    this.logger.info(projectData.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                BigDecimal allExpenseContractTaxMny = new BigDecimal(String.valueOf(projectData.getData()));
                this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u9879\u76ee\uff1a{}\u4e0b\uff0c\u6240\u6709\u652f\u51fa\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)vo.getProjectId(), (Object)allExpenseContractTaxMny);
                BigDecimal thisTimeChangeTaxMny = BigDecimal.ZERO;
                PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.service.selectById(vo.getId()));
                thisTimeChangeTaxMny = null != promaterialContractEntity ? ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)promaterialContractEntity.getContractTaxMny()).setScale(2, 4) : vo.getContractTaxMny();
                this.logger.info("\u672c\u6b21\u53d8\u52a8\u91d1\u989d\uff1a{}", (Object)thisTimeChangeTaxMny);
                for (BillParamVO billParamVO : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractionTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    this.logger.info("\u65bd\u5de5\u5408\u540c\u91d1\u989d*\u6bd4\u4f8b\u540e\u91d1\u989d\uff1a{}", (Object)comMny);
                    BigDecimal sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)allExpenseContractTaxMny, (BigDecimal)thisTimeChangeTaxMny).setScale(2, 4);
                    this.logger.info("\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a{}", (Object)sumPayContractTaxMny);
                    if (sumPayContractTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u652f\u51fa\u8d85\u65bd\u5de5\u5408\u540c");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u652f\u51fa\u5408\u540c\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(vo.getContractTaxMny()).append("\u5143\uff0c\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(sumPayContractTaxMny).append("\u5143\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumPayContractTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    this.logger.info("paramsCheckDsVO:{}", (Object)JSONObject.toJSONString((Object)paramsCheckDsVO));
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        PromaterialContractEntity promaterialContractEntity;
        List<PaymentApplyVO> paymentApplyVOList;
        List<PaymentApplyVO> paymentApplyVOS = this.paymentApplyApi.queryListByContractId(id);
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        if (paymentApplyVOS != null && CollectionUtils.isNotEmpty(paymentApplyVOList = paymentApplyVOS)) {
            resultVO.setTotalApplyMny(paymentApplyVOList.stream().filter(p -> p.getApplyMny() != null).map(PaymentApplyVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalActualMny(paymentApplyVOList.stream().filter(p -> p.getActualMny() != null).map(PaymentApplyVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalApprovalMny(paymentApplyVOList.stream().filter(p -> p.getApprovalMny() != null).map(PaymentApplyVO::getApprovalMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            paymentApplyVOList.forEach(item -> {
                item.setApplyMny(item.getApplyMny() != null ? item.getApplyMny() : BigDecimal.ZERO);
                item.setActualMny(item.getActualMny() != null ? item.getActualMny() : BigDecimal.ZERO);
                item.setApprovalMny(item.getApprovalMny() != null ? item.getApprovalMny() : BigDecimal.ZERO);
            });
            resultVO.setPaymentApplyList(paymentApplyVOList);
        }
        if (null != (promaterialContractEntity = (PromaterialContractEntity)((Object)this.service.selectById(id)))) {
            resultVO.setContractId(id);
            resultVO.setAddType(Integer.valueOf(promaterialContractEntity.getTargetResultId() == null ? 1 : 0));
            resultVO.setContractFlag(promaterialContractEntity.getSupplementFlag());
            resultVO.setContractMny(promaterialContractEntity.getContractTaxMny());
            if (null != resultVO.getTotalActualMny()) {
                resultVO.setPaymentRate(resultVO.getTotalActualMny().divide(resultVO.getContractMny(), 8, 5).multiply(new BigDecimal(100)));
            } else {
                resultVO.setPaymentRate(BigDecimal.ZERO);
            }
            resultVO.setTotalApplyMny(null != resultVO.getTotalApplyMny() ? resultVO.getTotalApplyMny() : BigDecimal.ZERO);
            resultVO.setTotalActualMny(null != resultVO.getTotalActualMny() ? resultVO.getTotalActualMny() : BigDecimal.ZERO);
            resultVO.setTotalApprovalMny(null != resultVO.getTotalApprovalMny() ? resultVO.getTotalApprovalMny() : BigDecimal.ZERO);
        }
        return resultVO;
    }

    @Override
    public List<PromaterialMaterialReportVO> quueryMaterialByProject(Page pages, QueryWrapper queryWrapper, Long projectId) {
        List<PromaterialMaterialReportVO> list = ((PromaterialContractMapper)this.baseMapper).quueryMaterialByProject(pages, queryWrapper, projectId);
        CommonResponse resDate = this.iDutyApi.queryDoc(projectId);
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6210\u672c\u6570\u91cf\u4fe1\u606f\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        Map map = (Map)resDate.getData();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> {
                if (null != map && map.containsKey(e.getMaterialId())) {
                    e.setMbNum(map.get(e.getMaterialId()) == null ? BigDecimal.ZERO : (BigDecimal)map.get(e.getMaterialId()));
                }
            });
        }
        return list;
    }

    @Override
    public List<PromaterialContractMaterialReportVO> quueryMaterialByOrg(Page page, QueryWrapper wrapper) {
        List<PromaterialContractMaterialReportVO> promaterialContractMaterialReportVOList = ((PromaterialContractMapper)this.baseMapper).quueryMaterialByOrg(page, wrapper);
        if (CollectionUtils.isNotEmpty(promaterialContractMaterialReportVOList)) {
            for (PromaterialContractMaterialReportVO promaterialContractMaterialReportVO : promaterialContractMaterialReportVOList) {
                if (promaterialContractMaterialReportVO.getContractNum() == null || BigDecimal.ZERO.compareTo(promaterialContractMaterialReportVO.getContractNum()) == 0) {
                    promaterialContractMaterialReportVO.setContractTaxPrice(BigDecimal.ZERO);
                } else {
                    promaterialContractMaterialReportVO.setContractTaxPrice(promaterialContractMaterialReportVO.getContractTaxMny().divide(promaterialContractMaterialReportVO.getContractNum(), 8, 5));
                }
                if (promaterialContractMaterialReportVO.getContractMny() == null || BigDecimal.ZERO.compareTo(promaterialContractMaterialReportVO.getContractMny()) == 0) {
                    promaterialContractMaterialReportVO.setContractTaxRate(BigDecimal.ZERO);
                    continue;
                }
                BigDecimal contractTaxRate = promaterialContractMaterialReportVO.getContractTaxMny().divide(promaterialContractMaterialReportVO.getContractMny(), 8, 5).subtract(new BigDecimal(1));
                promaterialContractMaterialReportVO.setContractTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
            }
            List<Long> contractIds = promaterialContractMaterialReportVOList.stream().map(PromaterialContractMaterialReportVO::getContractId).collect(Collectors.toList());
            List<PromaterialContractMaterialReportVO> orderList = ((PromaterialContractMapper)this.baseMapper).getOrderNum(contractIds);
            List<PromaterialContractMaterialReportVO> checkList = ((PromaterialContractMapper)this.baseMapper).getCheckNum(contractIds);
            List<PromaterialContractMaterialReportVO> settleList = ((PromaterialContractMapper)this.baseMapper).getSettleNum(contractIds);
            if (CollectionUtils.isNotEmpty(settleList)) {
                for (PromaterialContractMaterialReportVO promaterialContractMaterialReportVO : settleList) {
                    if (BigDecimal.ZERO.compareTo(promaterialContractMaterialReportVO.getSettlementNum()) == 0) {
                        promaterialContractMaterialReportVO.setSettlementTaxPrice(BigDecimal.ZERO);
                    } else {
                        promaterialContractMaterialReportVO.setSettlementTaxPrice(promaterialContractMaterialReportVO.getSettlementTaxMny().divide(promaterialContractMaterialReportVO.getSettlementNum(), 8, 5));
                    }
                    if (BigDecimal.ZERO.compareTo(promaterialContractMaterialReportVO.getSettlementMny()) == 0) {
                        promaterialContractMaterialReportVO.setSettlementTaxRate(BigDecimal.ZERO);
                        continue;
                    }
                    BigDecimal contractTaxRate = promaterialContractMaterialReportVO.getSettlementTaxMny().divide(promaterialContractMaterialReportVO.getSettlementMny(), 8, 5).subtract(new BigDecimal(1));
                    promaterialContractMaterialReportVO.setSettlementTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                }
            }
            for (PromaterialContractMaterialReportVO promaterialContractMaterialReportVO : promaterialContractMaterialReportVOList) {
                for (PromaterialContractMaterialReportVO order : orderList) {
                    if (!promaterialContractMaterialReportVO.getContractId().equals(order.getContractId()) || !promaterialContractMaterialReportVO.getMaterialId().equals(order.getMaterialId())) continue;
                    promaterialContractMaterialReportVO.setOrderNum(order.getOrderNum());
                }
                for (PromaterialContractMaterialReportVO check : checkList) {
                    if (!promaterialContractMaterialReportVO.getContractId().equals(check.getContractId()) || !promaterialContractMaterialReportVO.getMaterialId().equals(check.getMaterialId())) continue;
                    promaterialContractMaterialReportVO.setCheckNum(check.getCheckNum());
                }
                for (PromaterialContractMaterialReportVO settle : settleList) {
                    if (!promaterialContractMaterialReportVO.getContractId().equals(settle.getContractId()) || !promaterialContractMaterialReportVO.getMaterialId().equals(settle.getMaterialId())) continue;
                    promaterialContractMaterialReportVO.setSettlementNum(settle.getSettlementNum());
                    promaterialContractMaterialReportVO.setSettlementTaxRate(settle.getSettlementTaxRate());
                    promaterialContractMaterialReportVO.setSettlementTaxPrice(settle.getSettlementTaxPrice());
                    promaterialContractMaterialReportVO.setSettlementTaxMny(settle.getSettlementTaxMny());
                }
            }
        }
        return promaterialContractMaterialReportVOList;
    }

    @Override
    public void updateTargetResult(PromaterialContractVO vo, Integer type) {
        if (vo.getTargetResultId() == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)vo.getContractDetailList())) {
            return;
        }
        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId());
        picketageVO.setContractMoneyTax(vo.getContractTaxMny());
        picketageVO.setContractMoney(vo.getContractMny());
        ArrayList<TenderPicketageDetailVO> list = new ArrayList<TenderPicketageDetailVO>();
        for (PromaterialContractDetailVO detailVO : vo.getContractDetailList()) {
            if ("del".equals(detailVO.getRowState())) continue;
            TenderPicketageDetailVO tenderDetailVo = new TenderPicketageDetailVO();
            tenderDetailVo.setId(Long.valueOf(detailVO.getSourceId()));
            tenderDetailVo.setSignNum(detailVO.getNum());
            list.add(tenderDetailVo);
        }
        picketageVO.setTenderPicketageDetailList(list);
        String typeStr = 0 == type ? "\u5360\u7528" : "\u91ca\u653e";
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)picketageVO));
        CommonResponse response = 0 == type ? this.tenderApi.updateStatus(picketageVO) : this.tenderApi.delUpdateStatus(picketageVO);
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "\u5b9a\u6807\u7ed3\u679c\u5931\u8d25\uff01");
        }
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        ArrayList<SignContractVo> rtnList = new ArrayList<SignContractVo>();
        if (CollectionUtils.isEmpty(targetResultIdList)) {
            return rtnList;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter("in", targetResultIdList));
        queryParam.getOrderMap().put("signDate", "desc");
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return rtnList;
        }
        for (PromaterialContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getBillCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignDate());
            vo.setBillState(entity.getBillState());
            vo.setLinkUrl(this.getContractLinkUrl(entity.getTargetResultId(), entity.getId(), entity.getSupplementFlag(), entity.getPerformanceStatus(), entity.getContractType()));
            rtnList.add(vo);
        }
        return rtnList;
    }

    private String getContractLinkUrl(Long targetResultId, Long contractId, Integer supplementFlag, String performanceStatus, Integer contractType) {
        int targetType = targetResultId == null ? 1 : 0;
        String url = "/ejc-steelstructure-frontend/#/contractMaterial/contractApprove?id=" + contractId + "&supplementFlag=" + supplementFlag + "&targetType=" + targetType + "&performanceStatus=" + performanceStatus;
        if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractType)) {
            url = "/ejc-steelstructure-frontend/#/contractConcrete/contractApprove?id=" + contractId + "&supplementFlag=" + supplementFlag + "&targetType=" + targetType + "&performanceStatus=" + performanceStatus;
        }
        return url;
    }

    private void checkDetailTenderNum(List<PromaterialContractDetailVO> detailList, Long contractId, Long targetResultId) {
        List detailEntityList;
        if (targetResultId == null) {
            return;
        }
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        for (PromaterialContractDetailVO vo : detailList) {
            if (vo.getSignNum() != null && vo.getSignNum().compareTo(vo.getNum()) >= 0) continue;
            throw new BusinessException("\u7b7e\u8ba2\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53ef\u7b7e\u8ba2\u6570\u91cf");
        }
        List sourceIdList = detailList.stream().map(PromaterialContractDetailVO::getSourceId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("sourceId", new Parameter("in", sourceIdList));
        if (contractId != null) {
            detailParam.getParams().put("contractId", new Parameter("ne", (Object)contractId));
        }
        if (CollectionUtils.isEmpty((Collection)(detailEntityList = this.contractDetailService.queryList(detailParam, false)))) {
            return;
        }
        Map<String, List<PromaterialContractDetailEntity>> queryMap = detailEntityList.stream().collect(Collectors.groupingBy(PromaterialContractDetailEntity::getSourceId));
        for (PromaterialContractDetailVO detail : detailList) {
            List<PromaterialContractDetailEntity> queryDetailList = queryMap.get(detail.getSourceId());
            BigDecimal tenderNum = CommonUtils.setBigDecimalDefaultValue(detail.getTenderNum());
            if (CollectionUtils.isEmpty(queryDetailList)) continue;
            BigDecimal signTenderNum = BigDecimal.ZERO;
            for (PromaterialContractDetailEntity detailEntity : queryDetailList) {
                signTenderNum = signTenderNum.add(CommonUtils.setBigDecimalDefaultValue(detailEntity.getInitNum()));
            }
            BigDecimal sy = tenderNum.subtract(signTenderNum);
            if (sy.compareTo(detail.getNum()) >= 0) continue;
            throw new BusinessException(detail.getMaterialName() + "\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7" + sy);
        }
    }

    @Override
    public void asyncWatermarkById(Long id) {
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)super.selectById((Serializable)id));
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            String billType = "BT211227000000003";
            String sourceType = "contractMaterial";
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(promaterialContractEntity.getContractType())) {
                billType = "BT220215000000001";
                sourceType = "contractConcrete";
            }
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(promaterialContractEntity.getContractFileId(), promaterialContractEntity.getId(), promaterialContractEntity.getBillCode(), billType, sourceType);
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    @Override
    public String getContractFilingCode() {
        CommonResponse response = this.paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        this.logger.info("\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        return StringUtils.isNotEmpty((CharSequence)valueData) ? valueData : "0";
    }

    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)super.selectById((Serializable)contractId));
        if ("0".equals(valueData)) {
            return true;
        }
        return FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(promaterialContractEntity.getFilingStatus());
    }

    @Override
    public CommonResponse<List<PromaterialMaterialMnyVO>> queryMaterialMnyByYear(String year, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        List contractList = super.queryList(param);
        List materialMnyList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)contractList)) {
            List contractIds = contractList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u5408\u540cid\uff1a{}", (Object)JSONObject.toJSONString(contractIds));
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"DATE_FORMAT(create_time,'%Y')", (Object)year);
            wrapper.in((Object)"contract_id", contractIds);
            wrapper.eq((Object)"dr", (Object)0);
            wrapper.isNotNull((Object)"material_type_name");
            wrapper.select(new String[]{"material_type_name as materialTypeName, material_type_id as materialTypeId, sum( detail_tax_mny ) AS detailTaxMny"});
            wrapper.groupBy((Object[])new String[]{"material_type_id"});
            wrapper.orderByDesc((Object)"detailTaxMny");
            wrapper.last("limit 5");
            List contractDetailList = this.contractDetailService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)contractDetailList)) {
                this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u5408\u540cid\uff1a{}", (Object)JSONObject.toJSONString((Object)contractDetailList));
                materialMnyList = BeanMapper.mapList((Iterable)contractDetailList, PromaterialMaterialMnyVO.class);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u6599\u91d1\u989d\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", materialMnyList);
    }
}

