/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.plan.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.promaterial.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.steelstructure.promaterial.plan.bean.MonthPlanEntity;
import com.ejianc.business.steelstructure.promaterial.plan.mapper.MonthPlanMapper;
import com.ejianc.business.steelstructure.promaterial.plan.service.IMonthPlanDetailService;
import com.ejianc.business.steelstructure.promaterial.plan.service.IMonthPlanService;
import com.ejianc.business.steelstructure.promaterial.plan.vo.MonthPlanVO;
import com.ejianc.business.steelstructure.promaterial.plan.vo.PlanTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="promaterialMonthPlanService")
public class MonthPlanServiceImpl
extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity>
implements IMonthPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE_C = "MONTH_PLAN_CODE";
    private static final String BILL_CODE_H = "HNTYJH01";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMonthPlanService service;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private MonthPlanMapper mapper;

    @Override
    public IPage<MonthPlanVO> queryConcreteList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6df7\u6ce5\u571f.getCode()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthPlanVO.class));
        return pageData;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public void excelConcreteExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6df7\u6ce5\u571f.getCode()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            voList = BeanMapper.mapList((Iterable)list, MonthPlanVO.class);
            voList.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("ConcreteMonthPlan-export.xlsx", beans, response);
    }

    @Override
    public boolean monthQueryPlan(Long projectId, Date planMonth, Integer planType, Long id) {
        try {
            String monthDate = DateFormatUtil.formatDate((String)"yyyy-MM", (Date)planMonth);
            List<MonthPlanVO> list = ((MonthPlanMapper)this.baseMapper).monthQueryPlan(projectId, monthDate, planType, id);
            if (CollectionUtils.isNotEmpty(list)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8be5\u9879\u76ee\u672c\u6708\u5df2\u662f\u5426\u5b58\u5728\u6708\u8ba1\u5212\u6821\u9a8c\u5931\u8d25\uff01");
        }
        return false;
    }

    @Override
    public CommonResponse<MonthPlanVO> saveOrUpdate(MonthPlanVO saveorUpdateVO) {
        boolean b;
        MonthPlanEntity entity = (MonthPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, MonthPlanEntity.class));
        if (StringUtils.isNotBlank((CharSequence)entity.getBillCode())) {
            MonthPlanVO voByCode = this.service.queryByCode(entity.getBillCode(), entity.getPlanType());
            if (!(null == voByCode || null != entity.getId() && voByCode.getId().equals(entity.getId()))) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            String BILL_CODE = "";
            switch (entity.getPlanType()) {
                case 0: {
                    BILL_CODE = BILL_CODE_C;
                    break;
                }
                case 1: {
                    BILL_CODE = BILL_CODE_H;
                }
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse codeResp = this.billCodeApi.generateBillCode(billCodeParam);
            if (!codeResp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            entity.setBillCode((String)codeResp.getData());
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            String today = DateUtil.today();
            DateTime date = DateUtil.parse((String)today);
            entity.setBillDate((Date)date);
        }
        if (b = this.service.monthQueryPlan(entity.getProjectId(), entity.getPlanMonth(), entity.getPlanType(), entity.getId())) {
            String msg = "";
            switch (entity.getPlanType()) {
                case 0: {
                    msg = "\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u672c\u6708\u5df2\u5b58\u5728\u6d88\u8017\u6750\u6708\u8ba1\u5212\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01";
                    break;
                }
                case 1: {
                    msg = "\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u672c\u6708\u5df2\u5b58\u5728\u6df7\u51dd\u571f\u6708\u8ba1\u5212\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01";
                }
            }
            throw new BusinessException(msg);
        }
        entity.setName(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getPlanMonth()) + " " + entity.getBillCode());
        List<MonthPlanDetailEntity> monthPlanDetailEntities = entity.getMonthPlanDetailEntities();
        ArrayList masterDetailList = new ArrayList();
        for (MonthPlanDetailEntity monthPlanDetailEntitie : monthPlanDetailEntities) {
            monthPlanDetailEntitie.setSurplusNums(monthPlanDetailEntitie.getMonthPlanNum());
            monthPlanDetailEntitie.setName(entity.getName());
        }
        super.saveOrUpdate((Object)entity, false);
        MonthPlanVO vo = (MonthPlanVO)BeanMapper.map((Object)((Object)entity), MonthPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public MonthPlanVO queryByCode(String planCode, Integer planType) {
        MonthPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        MonthPlanEntity entity = (MonthPlanEntity)((Object)this.mapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MonthPlanVO)BeanMapper.map((Object)((Object)entity), MonthPlanVO.class);
        }
        return resp;
    }
}

