/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.proother.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractEntity;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractAsyncService;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractService;
import com.ejianc.business.steelstructure.proother.contract.vo.ContractVO;
import com.ejianc.business.steelstructure.proother.enums.BillPushStatusEnum;
import com.ejianc.business.steelstructure.proother.enums.DraftTypeEnum;
import com.ejianc.business.steelstructure.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.steelstructure.proother.enums.SignatureStatusEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="prootherContract")
public class ProotherContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProotherContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IProotherContractAsyncService contractAsyncService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        ProotherContractEntity e = (ProotherContractEntity)((Object)this.contractService.selectById(billId));
        this.logger.info("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u524d\u56de\u8c03:  \u5f53\u524d\u6570\u636e-{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        if ((DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(e.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(e.getDraftType())) && !e.getContractFileSyncFlag().booleanValue()) {
            return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ProotherContractEntity e = (ProotherContractEntity)((Object)this.contractService.selectById(billId));
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(e.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(e.getDraftType())) {
            if (null == e.getContractFileId()) {
                return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
            }
            if (!e.getContractFileSyncFlag().booleanValue()) {
                return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
            }
        }
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.contractService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u5408\u540c\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        boolean pushResult;
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(billId));
        if (prootherContractEntity != null) {
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(prootherContractEntity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(prootherContractEntity.getDraftType())) {
                if (null == prootherContractEntity.getContractFileId()) {
                    return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
                }
                if (!prootherContractEntity.getContractFileSyncFlag().booleanValue()) {
                    return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
                }
            }
            if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(prootherContractEntity.getDraftType())) {
                this.logger.info("\u5408\u540cid-{}\u4e3a\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u4e3a\u7b7e\u7ae0\u72b6\u6001\u5e76\u8bbe\u7f6e\u4e3a\u5c65\u7ea6\u4e2d", (Object)billId);
                prootherContractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                prootherContractEntity.setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
                prootherContractEntity.setEffectiveDate(new Date());
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(prootherContractEntity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(prootherContractEntity.getDraftType())) {
                if (null == prootherContractEntity.getContractFileId()) {
                    return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
                }
                if (!prootherContractEntity.getContractFileSyncFlag().booleanValue()) {
                    return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u5408\u540c\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u5408\u540c\u6587\u4ef6\uff01");
                }
            }
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            prootherContractEntity.setCommitDate(new Date());
            prootherContractEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            prootherContractEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        if (pushResult = this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)prootherContractEntity), ContractVO.class))) {
            prootherContractEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            prootherContractEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.checkContractFile(prootherContractEntity);
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(prootherContractEntity.getContractFileId(), prootherContractEntity.getId(), prootherContractEntity.getBillCode(), "ZZYJ202401160004", "proOtherContract");
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
        this.contractService.saveOrUpdate((Object)prootherContractEntity);
        return CommonResponse.success((String)"\u5408\u540c\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        boolean delWatermarkflag;
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(billId));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(prootherContractEntity.getDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().equals(prootherContractEntity.getDraftType())) {
            if (!statusList.contains(prootherContractEntity.getSignatureStatus())) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
            }
        } else if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(prootherContractEntity.getSignatureStatus())) {
            prootherContractEntity.setSignatureStatus(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
        }
        if (ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode().equals(prootherContractEntity.getPerformanceStatus())) {
            prootherContractEntity.setPerformanceStatus(ContractPerformanceStateEnum.\u672a\u7b7e\u8ba2.getStateCode());
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(prootherContractEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(prootherContractEntity.getBillState())) {
            String delResult = this.contractService.delContractFromPool(prootherContractEntity.getId());
            if (!StringUtils.isBlank((CharSequence)delResult)) {
                this.logger.error("\u5408\u540c-[{}]\u5f03\u5ba1\uff0c\u4ece\u5408\u540c\u6c60\u5220\u9664\u5931\u8d25!", (Object)JSONObject.toJSONString((Object)((Object)prootherContractEntity)));
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4ece\u5408\u540c\u6c60\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + delResult));
            }
            prootherContractEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(prootherContractEntity.getDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.equals(prootherContractEntity.getDraftType())) {
                prootherContractEntity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            }
        }
        if (prootherContractEntity.getWatermarkContractFileId() != null && (delWatermarkflag = this.contractService.delWatermarkContractFile(prootherContractEntity.getWatermarkContractFileId()))) {
            prootherContractEntity.setWatermarkContractFileId(null);
        }
        this.contractService.saveOrUpdate((Object)prootherContractEntity, false);
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    private void checkContractFile(ProotherContractEntity prootherContractEntity) {
        CommonResponse attachResp = this.attachmentApi.queryDetail(prootherContractEntity.getContractFileId().toString());
        if (!attachResp.isSuccess() || null == attachResp.getData()) {
            this.logger.info("\u5408\u540c\u5b58\u50a8\u6587\u4ef6Id-{}\u5728\u6587\u4ef6\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f", new Object[]{prootherContractEntity.getContractFileId(), prootherContractEntity.getId(), "2".equals(prootherContractEntity.getDraftType()) || "3".equals(prootherContractEntity.getDraftType()) ? "subContractFile" : "contractFile", ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getBillTypeCode()});
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(prootherContractEntity.getId(), ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getBillTypeCode(), "2".equals(prootherContractEntity.getDraftType()) || "3".equals(prootherContractEntity.getDraftType()) ? "subContractFile" : "contractFile", "desc");
            this.logger.info("\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u7ed3\u679c\uff1a{}", new Object[]{prootherContractEntity.getId(), "2".equals(prootherContractEntity.getDraftType()) || "3".equals(prootherContractEntity.getDraftType()) ? "subContractFile" : "contractFile", ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getBillTypeCode(), JSONObject.toJSONString((Object)attachListResp)});
            if (attachListResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)attachListResp.getData()))) {
                AttachmentVO attachmentVO = (AttachmentVO)((List)attachListResp.getData()).get(0);
                this.logger.info("\u5c06\u5408\u540cid-{}\u5bf9\u5e94\u5408\u540c\u6587\u4ef6Id-{}\u6539\u4e3a{}", new Object[]{prootherContractEntity.getId(), prootherContractEntity.getContractFileId(), attachmentVO.getId()});
                prootherContractEntity.setContractFileId(attachmentVO.getId());
                prootherContractEntity.setContractFilePath(attachmentVO.getTruePath());
            } else {
                throw new BusinessException("\u5ba1\u6279\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u5931\u8d25, \u8bf7\u68c0\u67e5\u5408\u540c\u6587\u4ef6\uff01");
            }
        }
    }
}

