/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.prosub.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.prosub.prosub.bean.CategoryDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.CategoryEntity;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.CategoryDetailMapper;
import com.ejianc.business.steelstructure.prosub.prosub.service.ICategoryDetailService;
import com.ejianc.business.steelstructure.prosub.prosub.service.ICategoryService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="categoryDetailService")
public class CategoryDetailServiceImpl
extends BaseServiceImpl<CategoryDetailMapper, CategoryDetailEntity>
implements ICategoryDetailService {
    @Autowired
    private ICategoryDetailService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CategoryDetailMapper labsubItemMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "LSI_CODE";
    private final String PLANT_CODE = "P-su39U70181";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ICategoryService labsubCategoryService;

    @Override
    public CommonResponse<LabsubItemVO> saveOrUpdateLabsubItem(LabsubItemVO saveorUpdateVO) {
        CategoryDetailEntity entity = (CategoryDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CategoryDetailEntity.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("trawlingCode", new Parameter("eq", (Object)saveorUpdateVO.getTrawlingCode()));
        List labsubItemEntities = this.service.queryList(queryParam);
        if (saveorUpdateVO.getId() != null) {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getTrawlingCode())) {
                return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            CategoryDetailEntity labsubItemEntity = (CategoryDetailEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            if (!labsubItemEntity.getTrawlingCode().equals(saveorUpdateVO.getTrawlingCode()) && CollectionUtils.isNotEmpty((Collection)labsubItemEntities)) {
                return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else if (CollectionUtils.isNotEmpty((Collection)labsubItemEntities)) {
            return CommonResponse.error((String)"\u5206\u5305\u6863\u6848\u7f16\u7801\u91cd\u590d\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                if (null == entity.getSubjectId()) {
                    Long categoryId = entity.getCategoryId();
                    CategoryEntity labsubCategoryEntity = (CategoryEntity)((Object)this.labsubCategoryService.selectById(categoryId));
                    entity.setSubjectId(labsubCategoryEntity.getSubjectId());
                    entity.setSubjectName(labsubCategoryEntity.getSubjectName());
                }
                if (saveorUpdateVO.getTrawlingCode() == null) {
                    entity.setTrawlingCode((String)billCode.getData());
                }
                entity.setEnabled(1);
                entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
                entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
                CategoryEntity labsubCategoryEntity = (CategoryEntity)((Object)this.labsubCategoryService.selectById(entity.getCategoryId()));
                if (labsubCategoryEntity != null) {
                    entity.setCategoryName(labsubCategoryEntity.getCategoryName());
                }
            }
        } else {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            updateWrapper.set(CategoryDetailEntity::getTrawlingName, (Object)saveorUpdateVO.getTrawlingName());
            updateWrapper.set(CategoryDetailEntity::getPriceType, (Object)saveorUpdateVO.getPriceType());
            updateWrapper.set(CategoryDetailEntity::getUnitName, (Object)saveorUpdateVO.getUnitName());
            updateWrapper.set(CategoryDetailEntity::getJobContent, (Object)saveorUpdateVO.getJobContent());
            updateWrapper.set(CategoryDetailEntity::getOrgId, (Object)this.sessionManager.getUserContext().getOrgId());
            updateWrapper.set(CategoryDetailEntity::getOrgName, (Object)this.sessionManager.getUserContext().getOrgName());
            updateWrapper.set(CategoryDetailEntity::getSubjectId, (Object)saveorUpdateVO.getSubjectId());
            updateWrapper.set(CategoryDetailEntity::getTrawlingCode, (Object)saveorUpdateVO.getTrawlingCode());
            updateWrapper.set(CategoryDetailEntity::getSubjectName, (Object)saveorUpdateVO.getSubjectName());
            updateWrapper.set(CategoryDetailEntity::getRemarks, (Object)saveorUpdateVO.getRemarks());
            updateWrapper.set(BaseEntity::getUpdateTime, (Object)new Date());
            updateWrapper.set(BaseEntity::getUpdateUserCode, (Object)InvocationInfoProxy.getUsercode());
            this.service.update((Wrapper)updateWrapper);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        LabsubItemVO vo = (LabsubItemVO)BeanMapper.map((Object)((Object)entity), LabsubItemVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<LabsubItemVO> queryLabsubItemList(Page<LabsubItemVO> page, QueryWrapper wrapper) {
        return ((CategoryDetailMapper)this.baseMapper).queryProsubItemList(page, wrapper);
    }

    @Override
    public CommonResponse<List<Map<String, Object>>> queryWholeTreeItemsById(String idStr, String type) {
        List<Long> idList = Arrays.stream(idStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
        this.logger.info("LabsubItemServiceImpl***queryWholeTreeItemsById()\u65b9\u6cd5***begin***param\uff1aid={}\uff0ctype={}", (Object)idStr, (Object)type);
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Map<String, Object>> itemMapList = null;
        if ("lab".equals(type)) {
            itemMapList = this.labsubItemMapper.queryLabItemListByIds(idList, tenantId);
        }
        if (CollectionUtils.isEmpty(itemMapList)) {
            this.logger.error("\u67e5\u8be2\u4e0d\u5230\u6863\u6848\u6570\u636e\uff0cparam\uff1aids={}\uff0ctype={}", (Object)idStr, (Object)type);
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u6863\u6848\u6570\u636e");
        }
        Boolean queryCategoryFlag = false;
        CommonResponse response = this.paramConfigApi.getByCode("P-su39U70181");
        if (!response.isSuccess() || response.getData() == null) {
            this.logger.error("\u6839\u636e\u7cfb\u7edf\u53c2\u6570\u7f16\u7801-{}\uff0c\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff08\u6863\u6848\u6765\u6e90\u6570\u636e\u662f\u5426\u67e5\u8be2\u7236\u7ea7\u5206\u7c7b\uff09\u914d\u7f6e\u4fe1\u606f\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)"P-su39U70181", (Object)response.getMsg());
            queryCategoryFlag = true;
        } else if ("1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
            queryCategoryFlag = true;
        }
        List<Object> categoryMapList = new ArrayList();
        if (queryCategoryFlag.booleanValue()) {
            ArrayList<Long> categoryIdList = new ArrayList();
            for (Map<String, Object> itemMap2 : itemMapList) {
                String innerCode = itemMap2.get("innerCode").toString();
                if (StringUtils.isBlank((CharSequence)innerCode)) {
                    this.logger.error("\u67e5\u8be2\u5230\u7684innerCode\u4e3a\u7a7a\uff0cparam\uff1aids={}\uff0ctype={}", (Object)idStr, (Object)type);
                    return CommonResponse.error((String)"\u67e5\u8be2\u5230\u7684innerCode\u4e3a\u7a7a");
                }
                List categoryIds = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).collect(Collectors.toList());
                categoryIdList.addAll(categoryIds);
            }
            categoryIdList = categoryIdList.stream().distinct().collect(Collectors.toList());
            if ("lab".equals(type)) {
                categoryMapList = this.labsubItemMapper.queryLabCategoryListByCategoryIds(categoryIdList, tenantId);
            }
            if (CollectionUtils.isEmpty(categoryMapList) && categoryIdList.size() > 1) {
                this.logger.error("\u67e5\u8be2\u4e0d\u5230\u5206\u7c7b\u6570\u636e");
                return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u5206\u7c7b\u6570\u636e");
            }
            categoryMapList = categoryMapList.stream().distinct().collect(Collectors.toList());
            categoryMapList.forEach(categoryMap -> {
                categoryMap.put("flag", "1");
                categoryMap.put("docId", null);
                categoryMap.put("id", categoryMap.get("category_id"));
            });
        }
        itemMapList = itemMapList.stream().distinct().collect(Collectors.toList());
        itemMapList.forEach(itemMap -> {
            itemMap.put("docId", Long.parseLong(itemMap.get("id").toString()));
            itemMap.put("flag", "2");
            itemMap.put("category_id", itemMap.get("parentId"));
        });
        ArrayList distinctList = new ArrayList();
        distinctList.addAll(categoryMapList);
        distinctList.addAll(itemMapList);
        ArrayList resList = new ArrayList();
        for (Map en : distinctList) {
            if (MapUtils.isEmpty((Map)en)) continue;
            HashMap map = new HashMap();
            map.put("flag", en.get("flag"));
            map.put("detailName", en.get("trawling_name"));
            map.put("unitName", en.get("unit_name"));
            map.put("detailUnit", en.get("unit_name"));
            map.put("priceType", en.get("price_type"));
            map.put("jobContent", en.get("job_content"));
            map.put("id", en.get("id"));
            map.put("detailCode", en.get("trawling_code"));
            map.put("remarks", en.get("remarks"));
            map.put("parentId", en.get("parentId"));
            map.put("categoryId", en.get("category_id"));
            map.put("docId", en.get("docId"));
            map.put("unitId", null);
            resList.add(map);
        }
        this.logger.info("LabsubItemServiceImpl***queryWholeTreeItemsById()\u65b9\u6cd5***end***\u67e5\u8be2\u6863\u6848\u6570\u636e\u6210\u529f\uff0c\u67e5\u8be2\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(resList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((String)"\u67e5\u8be2\u6863\u6848\u6570\u636e\u6210\u529f", resList);
    }

    @Override
    public CommonResponse updateByCategoryId(Long categoryId, Long subjectId, String subjectName) {
        int i = this.labsubItemMapper.updateByCategoryId(categoryId, subjectId, subjectName);
        return CommonResponse.success();
    }
}

