/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.steelstructure.income.bean.ClaimEntity;
import com.ejianc.business.steelstructure.income.bean.ClaimRecordsEntity;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.ContractReviewEntity;
import com.ejianc.business.steelstructure.income.bean.CostAdjustEntity;
import com.ejianc.business.steelstructure.income.mapper.ContractRegisterMapper;
import com.ejianc.business.steelstructure.income.service.IBudgetService;
import com.ejianc.business.steelstructure.income.service.IClaimRecordsService;
import com.ejianc.business.steelstructure.income.service.IClaimService;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IContractReviewService;
import com.ejianc.business.steelstructure.income.service.ICostAdjustService;
import com.ejianc.business.steelstructure.income.utils.DateUtil;
import com.ejianc.business.steelstructure.income.vo.BudgetVO;
import com.ejianc.business.steelstructure.income.vo.ContractRegisterVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contractWarn/"})
public class ContractWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-steelstructure-frontend/#/contractRegister/card?id=";
    private static final String PC_B_URL = "/ejc-share-frontend/#/projectPool/projectPoolCard?id=";
    private static final String PC_C_URL = "/ejc-steelstructure-frontend/#/costAdjust/card?id=";
    private static final String PC_D_URL = "/ejc-steelstructure-frontend/#/contractReview/card?id=";
    private static final String PC_E_URL = "/ejc-steelstructure-frontend/#/claimRecords/card?id=";
    private static final String PC_A_URL = "/ejc-steelstructure-frontend/#/";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IContractRegisterService service;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private ICostAdjustService costAdjustService;
    @Autowired
    private IContractReviewService contractReviewService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IClaimRecordsService claimRecordsService;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostAdjustService cent;
    @Autowired
    private ContractRegisterMapper mapper;
    @Autowired
    private IProjectPoolApi projectSetApi;

    @PostMapping(value={"budgetWarnExecute"})
    public CommonResponse<String> budgetWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            List contractEntities = this.service.queryList(param);
            if (!ListUtil.isNotEmpty((List)contractEntities)) continue;
            for (ContractRegisterEntity contractEntity : contractEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = contractEntity.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                QueryParam param1 = new QueryParam();
                param1.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
                param1.getParams().put("billState", new Parameter("in", (Object)"1,3"));
                List list = this.budgetService.queryList(param1);
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    BigDecimal parameterValue;
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        parameterValue = set.getBigDecimal("parameterValue");
                        if (CollectionUtils.isEmpty((Collection)list) && DateUtil.getBetweenDays(new Date(), contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                            high = true;
                            useSetHigh = set;
                        }
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        parameterValue = set.getBigDecimal("parameterValue");
                        if (CollectionUtils.isEmpty((Collection)list) && DateUtil.getBetweenDays(new Date(), contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                            meddle = true;
                            useSetMeddle = set;
                        }
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    parameterValue = set.getBigDecimal("parameterValue");
                    if (!CollectionUtils.isEmpty((Collection)list) || DateUtil.getBetweenDays(new Date(), contractEntity.getSignDate()) <= new Integer(parameterValue.toString())) continue;
                    low = true;
                    useSetLow = set;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + contractEntity.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
                vo.setPcUrl(PC_URL + contractEntity.getId());
                vo.setOrgId(contractEntity.getOrgId());
                vo.setSendOrgId(contractEntity.getOrgId() + "");
                vo.setOrgName(contractEntity.getOrgName());
                vo.setSourceId(contractEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#signDate#", sdf.format(contractEntity.getSignDate())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#signDate#", sdf.format(contractEntity.getSignDate())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#signDate#", sdf.format(contractEntity.getSignDate())));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.get("contractCode").toString());
            vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", m.get("contractName").toString()).replaceAll("#signDate#", m.get("signDate").toString()));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }

    @PostMapping(value={"costWarnExecute"})
    public CommonResponse<String> costWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        CommonResponse duty = this.dutyApi.queryDuty();
        if (!duty.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u76ee\u6807\u8d23\u4efb\u6210\u672c\u5931\u8d25\uff01\uff01");
            return CommonResponse.error((String)"\u67e5\u8be2\u76ee\u6807\u8d23\u4efb\u6210\u672c\u5931\u8d25\uff01");
        }
        this.logger.info("\u76ee\u6807\u8d23\u4efb\u6210\u672c\u4fe1\u606f" + JSONObject.toJSONString((Object)duty.getData()));
        Map dutyMap = ((List)duty.getData()).stream().collect(Collectors.toMap(e -> e.get("projectId"), Function.identity()));
        this.logger.info("\u76ee\u6807\u8d23\u4efb\u6210\u672cMap\u4fe1\u606f" + JSONObject.toJSONString(dutyMap));
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            List contractEntities = this.service.queryList(param);
            if (!ListUtil.isNotEmpty((List)contractEntities)) continue;
            for (ContractRegisterEntity contractEntity : contractEntities) {
                int i1;
                if (null == contractEntity.getProjectId()) continue;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = contractEntity.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                Map map = (Map)dutyMap.get(contractEntity.getProjectId().toString());
                this.logger.info("\u76ee\u6807\u8d23\u4efb\u6210\u672cMap\u4fe1\u606f" + JSONObject.toJSONString((Object)map));
                if (null != map) {
                    this.logger.info("costCount ===== " + JSONObject.toJSONString((Object)Integer.parseInt(map.get("costCount").toString())));
                }
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    BigDecimal parameterValue;
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        parameterValue = set.getBigDecimal("parameterValue");
                        if ((null == map || Integer.parseInt(map.get("costCount").toString()) == 0) && DateUtil.getBetweenDays(new Date(), contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                            high = true;
                            useSetHigh = set;
                        }
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        parameterValue = set.getBigDecimal("parameterValue");
                        if ((null == map || Integer.parseInt(map.get("costCount").toString()) == 0) && DateUtil.getBetweenDays(new Date(), contractEntity.getSignDate()) > new Integer(parameterValue.toString())) {
                            meddle = true;
                            useSetMeddle = set;
                        }
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    parameterValue = set.getBigDecimal("parameterValue");
                    if (null != map && Integer.parseInt(map.get("costCount").toString()) != 0 || DateUtil.getBetweenDays(new Date(), contractEntity.getSignDate()) <= new Integer(parameterValue.toString())) continue;
                    low = true;
                    useSetLow = set;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + contractEntity.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
                vo.setPcUrl(PC_URL + contractEntity.getId());
                vo.setOrgId(contractEntity.getOrgId());
                vo.setSendOrgId(contractEntity.getOrgId() + "");
                vo.setOrgName(contractEntity.getOrgName());
                vo.setSourceId(contractEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#signDate#", sdf.format(contractEntity.getSignDate())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#signDate#", sdf.format(contractEntity.getSignDate())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#signDate#", sdf.format(contractEntity.getSignDate())));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    @PostMapping(value={"contractRegisterWarnExecute"})
    public CommonResponse<String> contractRegisterWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            List contractEntities = this.service.queryList(param);
            if (!ListUtil.isNotEmpty((List)contractEntities)) continue;
            for (ContractRegisterEntity contractEntity : contractEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = contractEntity.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                QueryParam param1 = new QueryParam();
                param1.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
                param1.getParams().put("billState", new Parameter("in", (Object)"1,3"));
                List list = this.cent.queryList(param1);
                BigDecimal settlement = new BigDecimal("0.00");
                if (ListUtil.isNotEmpty((List)list)) {
                    for (CostAdjustEntity entity : list) {
                        settlement = settlement.add(entity.getApplyChangeMny());
                    }
                }
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                BigDecimal overAmtHigh = null;
                BigDecimal overAmtMeddle = null;
                BigDecimal overAmtLow = null;
                BigDecimal contractMoney = contractEntity.getNotIncludeProvisionalMny() == null ? new BigDecimal("0.00") : contractEntity.getNotIncludeProvisionalMny();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney).compareTo(settlement) < 1) {
                        overAmtHigh = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney).compareTo(settlement) < 1) {
                        overAmtMeddle = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney).compareTo(settlement) >= 1) continue;
                    overAmtLow = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                    low = true;
                    useSetLow = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + contractEntity.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
                vo.setPcUrl(PC_URL + contractEntity.getId());
                vo.setOrgId(contractEntity.getOrgId());
                vo.setSendOrgId(contractEntity.getOrgId() + "");
                vo.setOrgName(contractEntity.getOrgName());
                vo.setSourceId(contractEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#totalApplyChangeMny#", df.format(settlement)).replaceAll("#notIncludeProvisionalMny#", df.format(contractMoney)).replaceAll("#percent#", useSetHigh.getString("parameterValue")).replaceAll("#overAmt#", df.format(overAmtHigh)));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#totalApplyChangeMny#", df.format(settlement)).replaceAll("#notIncludeProvisionalMny#", df.format(contractMoney)).replaceAll("#percent#", useSetMeddle.getString("parameterValue")).replaceAll("#overAmt#", df.format(overAmtMeddle)));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", contractEntity.getContractName()).replaceAll("#totalApplyChangeMny#", df.format(settlement)).replaceAll("#notIncludeProvisionalMny#", df.format(contractMoney)).replaceAll("#percent#", useSetLow.getString("parameterValue")).replaceAll("#overAmt#", df.format(overAmtLow)));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"settleReportWarnExecute"})
    public CommonResponse<String> settleReportWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ContractRegisterVO> contractVOS = this.mapper.querySettleReportWarnContract(tenantId);
            if (!ListUtil.isNotEmpty(contractVOS)) continue;
            for (ContractRegisterVO cvo : contractVOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = cvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) <= -1) continue;
                    low = true;
                    useSetLow = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + cvo.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
                vo.setPcUrl(PC_URL + cvo.getId());
                vo.setOrgId(cvo.getOrgId());
                vo.setSendOrgId(cvo.getOrgId() + "");
                vo.setOrgName(cvo.getOrgName());
                vo.setSourceId(cvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", cvo.getContractName()).replaceAll("#days#", df.format(cvo.getDays())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", cvo.getContractName()).replaceAll("#days#", df.format(cvo.getDays())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", cvo.getContractName()).replaceAll("#days#", df.format(cvo.getDays())));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"finalizedWarnExecute"})
    public CommonResponse<String> finalizedWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ContractRegisterVO> contractVOS = this.mapper.queryFinalizedWarnContract(tenantId);
            if (!ListUtil.isNotEmpty(contractVOS)) continue;
            for (ContractRegisterVO cvo : contractVOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = cvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) <= -1) continue;
                    low = true;
                    useSetLow = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + cvo.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
                vo.setPcUrl(PC_URL + cvo.getId());
                vo.setOrgId(cvo.getOrgId());
                vo.setSendOrgId(cvo.getOrgId() + "");
                vo.setOrgName(cvo.getOrgName());
                vo.setSourceId(cvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", cvo.getContractName()).replaceAll("#days#", df.format(cvo.getDays())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", cvo.getContractName()).replaceAll("#days#", df.format(cvo.getDays())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", cvo.getContractName()).replaceAll("#days#", df.format(cvo.getDays())));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"budgetInWarnExecute"})
    public CommonResponse<String> budgetInWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        List proList = new ArrayList();
        CommonResponse resp = this.projectSetApi.queryProjectPoolList(null, null, null);
        if (resp.isSuccess()) {
            proList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectPoolSetVO.class);
        } else {
            this.logger.error(resp.getMsg());
        }
        if (CollectionUtils.isEmpty(proList)) {
            return CommonResponse.success();
        }
        Map<Long, List<ProjectPoolSetVO>> projectMap = proList.stream().collect(Collectors.groupingBy(BaseVO::getTenantId));
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            if (!projectMap.containsKey(tenantId)) continue;
            List<ProjectPoolSetVO> projectList = projectMap.get(tenantId);
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            List budgetEntities = this.budgetService.queryList(param);
            List budgetVOS = BeanMapper.mapList((Iterable)budgetEntities, BudgetVO.class);
            List resultList = projectList.stream().filter(ProjectPoolSetVO2 -> !budgetVOS.stream().map(BudgetVO::getProjectId).collect(Collectors.toList()).contains(ProjectPoolSetVO2.getId()) && ProjectPoolSetVO2.getProjectDate() != null).collect(Collectors.toList());
            if (!ListUtil.isNotEmpty(resultList)) continue;
            for (ProjectPoolSetVO pvo : resultList) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = pvo.getProjectDepartmentId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && new BigDecimal(DateUtil.getBetweenDays(new Date(), pvo.getProjectDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && new BigDecimal(DateUtil.getBetweenDays(new Date(), pvo.getProjectDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || new BigDecimal(DateUtil.getBetweenDays(new Date(), pvo.getProjectDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) <= -1) continue;
                    low = true;
                    useSetLow = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName("\u9879\u76ee-" + pvo.getCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
                vo.setPcUrl(PC_B_URL + pvo.getId());
                vo.setOrgId(pvo.getProjectDepartmentId());
                vo.setSendOrgId(pvo.getProjectDepartmentId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(pvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                BigDecimal days = new BigDecimal(DateUtil.getBetweenDays(new Date(), pvo.getProjectDate()).toString());
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getName()).replaceAll("#days#", df.format(days)));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getName()).replaceAll("#days#", df.format(days)));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getName()).replaceAll("#days#", df.format(days)));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"costAdjustWarnExecute"})
    public CommonResponse<String> costAdjustWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            GregorianCalendar calendar = new GregorianCalendar();
            String endTime = sdf.format(calendar.getTime());
            ((Calendar)calendar).add(5, -3);
            String startTime = sdf.format(calendar.getTime());
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            param.getParams().put("create_time", new Parameter("between", (Object)(startTime + "," + endTime)));
            List costAdjustEntities = this.costAdjustService.queryList(param);
            if (!ListUtil.isNotEmpty((List)costAdjustEntities)) continue;
            for (CostAdjustEntity costAdjustEntity : costAdjustEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = costAdjustEntity.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.service.selectById(costAdjustEntity.getContractId()));
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    this.logger.info("\u65bd\u5de5\u5408\u540c\u91d1\u989d(\u4e0d\u542b\u6682\u5217\u91d1\u989d)\u4e58\u4ee5\u7ba1\u63a7\u503c\u4e3a{}", (Object)set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractRegisterEntity.getNotIncludeProvisionalMny()));
                    this.logger.info("\u5de5\u7a0b\u9020\u4ef7\u7533\u8bf7\u91d1\u989d\u4e3a{}", (Object)costAdjustEntity.getApplyChangeMny());
                    if ("\u9ad8".equals(set.getString("warningLevel")) && set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractRegisterEntity.getNotIncludeProvisionalMny()).compareTo(costAdjustEntity.getApplyChangeMny()) < 1) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractRegisterEntity.getNotIncludeProvisionalMny()).compareTo(costAdjustEntity.getApplyChangeMny()) < 1) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractRegisterEntity.getNotIncludeProvisionalMny()).compareTo(costAdjustEntity.getApplyChangeMny()) >= 1) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + costAdjustEntity.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c-\u5de5\u7a0b\u9020\u4ef7\u8c03\u6574");
                vo.setPcUrl(PC_C_URL + costAdjustEntity.getId());
                vo.setOrgId(costAdjustEntity.getOrgId());
                vo.setSendOrgId(costAdjustEntity.getOrgId() + "");
                vo.setOrgName(costAdjustEntity.getOrgName());
                vo.setSourceId(costAdjustEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#project#", costAdjustEntity.getProjectName()).replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#percent#", useSetHigh.getString("parameterValue")));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#project#", costAdjustEntity.getProjectName()).replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#percent#", useSetHigh.getString("parameterValue")));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#project#", costAdjustEntity.getProjectName()).replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#percent#", useSetHigh.getString("parameterValue")));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"claimWarnExecute"})
    public CommonResponse<String> claimWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        Integer day = 30;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            param.getParams().put("reply_status", new Parameter("eq", (Object)0));
            param.getParams().put("is_replay_bill", new Parameter("eq", (Object)0));
            List claimEntities = this.claimService.queryList(param);
            if (!ListUtil.isNotEmpty((List)claimEntities)) continue;
            for (ClaimEntity costAdjustEntity : claimEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = costAdjustEntity.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getBigDecimal("parameterValue").intValue();
                    if ("\u9ad8".equals(set.getString("warningLevel")) && (now.getTime() - costAdjustEntity.getSubmitDate().getTime()) / 86400000L >= (long)day.intValue()) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && (now.getTime() - costAdjustEntity.getSubmitDate().getTime()) / 86400000L >= (long)day.intValue()) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || (now.getTime() - costAdjustEntity.getSubmitDate().getTime()) / 86400000L < (long)day.intValue()) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + costAdjustEntity.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c-\u4e8c\u6b21\u7ecf\u8425");
                String url = PC_A_URL;
                if ("QZ".equals(costAdjustEntity.getBillType())) {
                    url = url + "visa/card?id=";
                } else if ("QS".equals(costAdjustEntity.getBillType())) {
                    url = url + "negotiate/card?id=";
                } else if ("SP".equals(costAdjustEntity.getBillType())) {
                    url = url + "claim/card?id=";
                }
                vo.setPcUrl(url + costAdjustEntity.getId());
                vo.setOrgId(costAdjustEntity.getOrgId());
                vo.setSendOrgId(costAdjustEntity.getOrgId() + "");
                vo.setOrgName(costAdjustEntity.getOrgName());
                vo.setSourceId(costAdjustEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#project#", costAdjustEntity.getProjectName()).replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#day#", day.toString()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#project#", costAdjustEntity.getProjectName()).replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#day#", day.toString()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#project#", costAdjustEntity.getProjectName()).replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#day#", day.toString()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"contractReviewWarnExecute"})
    public CommonResponse<String> contractReviewWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        Integer day = 15;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            param.getParams().put("filing_flag", new Parameter("eq", (Object)0));
            List contractReviewEntities = this.contractReviewService.queryList(param);
            if (!ListUtil.isNotEmpty((List)contractReviewEntities)) continue;
            for (ContractReviewEntity costAdjustEntity : contractReviewEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = costAdjustEntity.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getBigDecimal("parameterValue").intValue();
                    if ("\u9ad8".equals(set.getString("warningLevel")) && (now.getTime() - costAdjustEntity.getCreateTime().getTime()) / 86400000L >= (long)day.intValue()) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && (now.getTime() - costAdjustEntity.getCreateTime().getTime()) / 86400000L >= (long)day.intValue()) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || (now.getTime() - costAdjustEntity.getCreateTime().getTime()) / 86400000L < (long)day.intValue()) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + costAdjustEntity.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c-\u65bd\u5de5\u5408\u540c\u8bc4\u5ba1");
                vo.setPcUrl(PC_D_URL + costAdjustEntity.getId());
                vo.setOrgId(costAdjustEntity.getOrgId());
                vo.setSendOrgId(costAdjustEntity.getOrgId() + "");
                vo.setOrgName(costAdjustEntity.getOrgName());
                vo.setSourceId(costAdjustEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#day#", day.toString()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#day#", day.toString()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", costAdjustEntity.getContractName()).replaceAll("#day#", day.toString()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"claimRecordsWarnExecute"})
    public CommonResponse<String> claimRecordsWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        Integer day = 30;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            GregorianCalendar calendar = new GregorianCalendar();
            String endTime = sdf.format(calendar.getTime());
            ((Calendar)calendar).add(5, -30);
            String startTime = sdf.format(calendar.getTime());
            QueryParam param = new QueryParam();
            param.getParams().put("supplementFlag", new Parameter("eq", (Object)0));
            param.getParams().put("isFinish", new Parameter("eq", (Object)0));
            param.getParams().put("isRelieve", new Parameter("eq", (Object)0));
            param.getParams().put("isSuspend", new Parameter("eq", (Object)0));
            param.getParams().put("create_time", new Parameter("between", (Object)("2000-01-01 01:01:01," + startTime)));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("billState", new Parameter("in", billStatus));
            List contractRegisterEntities = this.service.queryList(param);
            this.logger.info("\u67e5\u627e\u51fa\u7b26\u5408\u89c4\u5b9a\u7684\u5408\u540c\u4e2a\u6570\uff1a{}", (Object)contractRegisterEntities.size());
            if (!ListUtil.isNotEmpty((List)contractRegisterEntities)) continue;
            for (ContractRegisterEntity contractRegisterEntity : contractRegisterEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = contractRegisterEntity.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date lastRecordByContractId = this.claimRecordsService.getLastRecordByContractId(contractRegisterEntity.getId());
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getBigDecimal("parameterValue").intValue();
                    if ("\u9ad8".equals(set.getString("warningLevel")) && (lastRecordByContractId == null || (now.getTime() - lastRecordByContractId.getTime()) / 86400000L >= (long)day.intValue())) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && (lastRecordByContractId == null || (now.getTime() - lastRecordByContractId.getTime()) / 86400000L >= (long)day.intValue())) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || lastRecordByContractId != null && (now.getTime() - lastRecordByContractId.getTime()) / 86400000L < (long)day.intValue()) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + contractRegisterEntity.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c-\u7b7e\u8bc1\u6d3d\u5546\u7d22\u8d54\u8bb0\u5f55");
                vo.setPcUrl(PC_E_URL + contractRegisterEntity.getId());
                vo.setOrgId(contractRegisterEntity.getOrgId());
                vo.setSendOrgId(contractRegisterEntity.getOrgId() + "");
                vo.setOrgName(contractRegisterEntity.getOrgName());
                vo.setSourceId(contractRegisterEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", contractRegisterEntity.getContractName()).replaceAll("#day#", day.toString()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", contractRegisterEntity.getContractName()).replaceAll("#day#", day.toString()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", contractRegisterEntity.getContractName()).replaceAll("#day#", day.toString()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"claimRecordsNewWarnExecute"})
    public CommonResponse<String> claimRecordsNewWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        Integer day = 30;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam param = new QueryParam();
            param.getParams().put("isClose", new Parameter("eq", (Object)0));
            param.getParams().put("quoteStatus", new Parameter("eq", (Object)0));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("billState", new Parameter("in", billStatus));
            List claimRecordsEntities = this.claimRecordsService.queryList(param);
            this.logger.info("\u67e5\u627e\u51fa\u7b26\u5408\u89c4\u5b9a\u7684\u8bb0\u5f55\u4e2a\u6570\uff1a{}", (Object)claimRecordsEntities.size());
            if (!ListUtil.isNotEmpty((List)claimRecordsEntities)) continue;
            for (ClaimRecordsEntity claimRecordsEntity : claimRecordsEntities) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = claimRecordsEntity.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                Date now = new Date();
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    day = set.getBigDecimal("parameterValue").intValue();
                    if ("\u9ad8".equals(set.getString("warningLevel")) && (now.getTime() - claimRecordsEntity.getRecordDate().getTime()) / 86400000L >= (long)day.intValue()) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && (now.getTime() - claimRecordsEntity.getRecordDate().getTime()) / 86400000L >= (long)day.intValue()) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || (now.getTime() - claimRecordsEntity.getRecordDate().getTime()) / 86400000L < (long)day.intValue()) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + claimRecordsEntity.getBillCode());
                vo.setPcTitle("\u65bd\u5de5\u5408\u540c-\u7b7e\u8bc1\u6d3d\u5546\u7d22\u8d54\u8bb0\u5f55");
                vo.setPcUrl(PC_E_URL + claimRecordsEntity.getId());
                vo.setOrgId(claimRecordsEntity.getOrgId());
                vo.setSendOrgId(claimRecordsEntity.getOrgId() + "");
                vo.setOrgName(claimRecordsEntity.getOrgName());
                vo.setSourceId(claimRecordsEntity.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", claimRecordsEntity.getContractName()).replaceAll("#day#", day.toString()));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", claimRecordsEntity.getContractName()).replaceAll("#day#", day.toString()));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#contract#", claimRecordsEntity.getContractName()).replaceAll("#day#", day.toString()));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

