/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.steelstructure.income.service.IBudgetService;
import com.ejianc.business.steelstructure.income.vo.RevenueMaterialsVO;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report/"})
public class BudgetReportController {
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private IBudgetService budgetService;

    @PostMapping(value={"revenueMaterialsSummaryList"})
    public CommonResponse<JSONObject> revenueMaterials(@RequestBody QueryParam queryParam) {
        QueryParam subjectQuery = new QueryParam();
        subjectQuery.getParams().put("subject_code", new Parameter("like_right", (Object)"02"));
        subjectQuery.getParams().put("enabled", new Parameter("eq", (Object)1));
        subjectQuery.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        CommonResponse subjectOrgIds = this.shareSubjectOrgApi.querySubjectOrg(subjectQuery);
        queryParam.getParams().put("subjectIds", new Parameter("in", ((List)subjectOrgIds.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((Object)this.budgetService.pageRevenueMaterials(queryParam));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        QueryParam subjectQuery = new QueryParam();
        subjectQuery.getParams().put("subject_code", new Parameter("like_right", (Object)"02"));
        subjectQuery.getParams().put("enabled", new Parameter("eq", (Object)1));
        subjectQuery.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        CommonResponse subjectOrgIds = this.shareSubjectOrgApi.querySubjectOrg(subjectQuery);
        param.getParams().put("subjectIds", new Parameter("in", ((List)subjectOrgIds.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List<RevenueMaterialsVO> list = this.budgetService.getMaterialSummarylist(param);
        HashMap<String, List<RevenueMaterialsVO>> beans = new HashMap<String, List<RevenueMaterialsVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RevenueMaterialList-export.xlsx", beans, response);
    }
}

