/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.controller.api;

import com.ejianc.business.steelstructure.income.bean.BudgetEntity;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.service.IBudgetService;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projectCostManagementApi"})
public class ProjectCostManagementApi {
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IContractRegisterService contractService;

    @GetMapping(value={"/queryBudgetDivideIncome"})
    public CommonResponse<BigDecimal> queryBudgetDivideIncome(@RequestParam(value="orgId") Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        param.getParams().put("incomeFlag", new Parameter("eq", (Object)1));
        List budgetEntities = this.budgetService.queryList(param);
        BigDecimal sumBudgetMny = new BigDecimal(0);
        sumBudgetMny = budgetEntities.stream().map(BudgetEntity::getBudgetTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        QueryParam param1 = new QueryParam();
        param1.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param1.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param1.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        List contractRegisterEntities = this.contractService.queryList(param1);
        BigDecimal incomeMny = new BigDecimal(0);
        if (contractRegisterEntities != null && contractRegisterEntities.size() > 0) {
            incomeMny = ((ContractRegisterEntity)((Object)contractRegisterEntities.get(0))).getNicContractMny();
        }
        if (sumBudgetMny.compareTo(BigDecimal.ZERO) == 0 || incomeMny.compareTo(BigDecimal.ZERO) == 0) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)sumBudgetMny.divide(incomeMny, 4, 1));
    }
}

