/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.ContractReviewEntity;
import com.ejianc.business.steelstructure.income.enums.ContractStatusEnum;
import com.ejianc.business.steelstructure.income.mapper.ContractRegisterMapper;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IContractReviewService;
import com.ejianc.business.steelstructure.income.service.ISupplierService;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRegister")
public class ContractRegisterBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractRegisterService service;
    @Autowired
    private IContractReviewService reviewService;
    @Autowired
    private ContractRegisterMapper contractRegisterMapper;
    @Autowired
    private ISupplierService supplierService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u56de\u5199\u5408\u540c\u72b6\u6001\u5f00\u59cb");
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(ContractRegisterEntity::getContractStatus, (Object)ContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        wrapper.eq(BaseEntity::getId, (Object)billId);
        this.service.update((Wrapper)wrapper);
        this.logger.info("\u63d0\u4ea4\u56de\u5199\u5408\u540c\u72b6\u6001\u7ed3\u675f");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.service.selectById(billId));
        if (contractEntity.getReviewId() != null && contractEntity.getIsEstimation() != 1) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ContractReviewEntity::getFilingFlag, (Object)1);
            wrapper.set(ContractReviewEntity::getFilingId, (Object)contractEntity.getId());
            wrapper.set(ContractReviewEntity::getFilingDate, (Object)new Date());
            wrapper.eq(BaseEntity::getId, (Object)contractEntity.getReviewId());
            this.reviewService.update((Wrapper)wrapper);
        }
        CustomerIncomeInfoVO customerInfoVO = this.service.queryCustomerInfo(contractEntity.getCustomerId());
        customerInfoVO.setCustomerId(contractEntity.getCustomerId());
        this.supplierService.updateIncomeMny(customerInfoVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.service.selectById(billId));
        if (entity.getSupplementFlag() == 1) {
            return CommonResponse.error((String)"\u8865\u5145\u534f\u8bae\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

