/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.vo.OtherContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"otherContract"})
public class OtherContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOtherContractService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OtherContractVO> saveOrUpdate(@RequestBody OtherContractVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherContractVO> queryDetail(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.service.selectById(id));
        OtherContractVO vo = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OtherContractVO otherContractVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(OtherContractVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), OtherContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), OtherContractVO.class);
            list.forEach(vo -> {
                if (null != vo.getContractStatus()) {
                    if ("1".equals(vo.getContractStatus())) {
                        vo.setContractStatusName("\u672a\u7b7e\u8ba2");
                    } else if ("2".equals(vo.getContractStatus())) {
                        vo.setContractStatusName("\u5c65\u7ea6\u4e2d");
                    } else if ("3".equals(vo.getContractStatus())) {
                        vo.setContractStatusName("\u5df2\u5c01\u8d26");
                    } else if ("4".equals(vo.getContractStatus())) {
                        vo.setContractStatusName("\u5df2\u51bb\u7ed3");
                    } else if ("5".equals(vo.getContractStatus())) {
                        vo.setContractStatusName("\u5df2\u89e3\u9664");
                    }
                } else {
                    vo.setContractStatusName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("other-contract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherContractEntity>> queryRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getParams().put("is_finish", new Parameter("eq", (Object)0));
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("is_relieve", new Parameter("eq", (Object)0));
        queryParam.getParams().put("is_suspend", new Parameter("eq", (Object)0));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            boolean flag;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("isFinishFlag") && !(flag = Boolean.valueOf(conditionMap.get("isFinishFlag").toString()).booleanValue())) {
                queryParam.getParams().remove("is_finish");
            }
            if (null != conditionMap.get("contractStatus")) {
                Long contractStatus = Long.valueOf(conditionMap.get("contractStatus").toString());
                queryParam.getParams().put("contractStatus", new Parameter("ne", (Object)contractStatus));
            }
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
        queryParam.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryPage(queryParam, false));
    }

    @RequestMapping(value={"/contractDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherContractVO> contractDetail(@RequestParam Long id) {
        OtherContractVO vo = this.service.contractDetail(id);
        return CommonResponse.success((Object)vo);
    }

    @PostMapping(value={"changeState"})
    public CommonResponse<String> changeState(@RequestBody OtherContractVO OtherContractVO2) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)OtherContractVO2.getId());
        updateWrapper.set(OtherContractEntity::getContractStatus, (Object)OtherContractVO2.getContractStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/sumMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> sumMny(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.service.queryList(param, false);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal sumBaseMoney = BigDecimal.ZERO;
        BigDecimal sumContractMny = BigDecimal.ZERO;
        for (OtherContractEntity entity : list) {
            if (entity.getBaseTaxMoney() != null) {
                sumBaseMoney = sumBaseMoney.add(entity.getBaseTaxMoney());
            }
            if (entity.getContractTaxMny() == null) continue;
            sumContractMny = sumContractMny.add(entity.getContractTaxMny());
        }
        map.put("sumBaseMoney", sumBaseMoney);
        map.put("sumContractMny", sumContractMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u6c47\u603b\u91d1\u989d\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/getSignDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Date> getSignDate(Long contractId) {
        Date date = this.service.getSignDate(contractId);
        return CommonResponse.success((String)"\u67e5\u5408\u540c\u7b7e\u7ea6\u65e5\u671f\u6210\u529f\uff01", (Object)date);
    }

    @GetMapping(value={"/syncPushContract"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushContract(@RequestParam(value="id") Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.service.selectById(id));
        OtherContractVO vo = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        return CommonResponse.success((String)"\u540c\u6b65\u5408\u540c\u6c60\u6210\u529f\uff01", (Object)this.service.pushContract(vo, false));
    }
}

