/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherContractRelieveEntity;
import com.ejianc.business.steelstructure.other.history.OtherContractRelieveHistoryVO;
import com.ejianc.business.steelstructure.other.mapper.OtherContractRelieveMapper;
import com.ejianc.business.steelstructure.other.service.IOtherContractRelieveService;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.vo.OtherContractRelieveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherContractRelieveService")
public class OtherContractRelieveServiceImpl
extends BaseServiceImpl<OtherContractRelieveMapper, OtherContractRelieveEntity>
implements IOtherContractRelieveService {
    private static final String OTHER_CONTRACT_RELIEVE = "OTHER_CONTRACT_RELIEVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOtherContractService service;

    @Override
    public OtherContractRelieveVO saveOrUpdate(OtherContractRelieveVO saveorUpdateVO) {
        OtherContractRelieveEntity entity = (OtherContractRelieveEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherContractRelieveEntity.class));
        this.validateContract(entity.getContractId(), entity.getId());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)OTHER_CONTRACT_RELIEVE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (OtherContractRelieveVO)BeanMapper.map((Object)this.selectById(entity.getId()), OtherContractRelieveVO.class);
    }

    @Override
    public OtherContractRelieveHistoryVO queryRelieveRecord(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.service.selectById(id));
        OtherContractRelieveHistoryVO vo = new OtherContractRelieveHistoryVO();
        vo.setContractId(entity.getId());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OtherContractRelieveEntity::getContractId, (Object)id);
        wrapper.orderByDesc(OtherContractRelieveEntity::getRelieveDate);
        List list = super.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, OtherContractRelieveVO.class));
        return vo;
    }

    public Boolean validateContract(Long contractId, Long id) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        if (!Objects.equals(null, id)) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (ListUtil.isNotEmpty((List)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u5408\u540c\u89e3\u9664\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return true;
    }
}

