/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherSettleEntity;
import com.ejianc.business.steelstructure.other.history.OtherSettleHistoryVO;
import com.ejianc.business.steelstructure.other.mapper.OtherSettleMapper;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.service.IOtherSettleService;
import com.ejianc.business.steelstructure.other.vo.OtherContractVO;
import com.ejianc.business.steelstructure.other.vo.OtherSettleVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="otherSettleService")
public class OtherSettleServiceImpl
extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity>
implements IOtherSettleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String OTHER_SETTLE_CODE = "OTHER_SETTLE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private OtherSettleMapper otherSettleMapper;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public OtherSettleVO saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        int num;
        OtherContractEntity contractEntity;
        if (saveorUpdateVO.getId() == null) {
            Long tenantId = InvocationInfoProxy.getTenantid();
            BillCodeParam billCodeParam = BillCodeParam.build((String)OTHER_SETTLE_CODE, (Long)tenantId, (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(saveorUpdateVO.getContractId()))) != null && "2".equals(contractEntity.getChangeStatus())) {
            throw new BusinessException("\u8be5\u5408\u540c\u5904\u4e8e\u53d8\u66f4\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u505a\u5408\u540c\u7ed3\u7b97!");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(OtherContractEntity::getMainContractId, (Object)saveorUpdateVO.getContractId());
        lambda.eq(OtherContractEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.eq(OtherContractEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.eq(OtherContractEntity::getSupplementFlag, (Object)1);
        int conNum = this.contractService.count((Wrapper)lambda);
        if (conNum > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u505a\u5408\u540c\u7ed3\u7b97!");
        }
        if ("3".equals(contractEntity.getContractStatus()) && "0".equals(saveorUpdateVO.getSettleType())) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5c01\u8d26\uff0c\u4e0d\u80fd\u505a\u8fc7\u7a0b\u7ed3\u7b97!");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)saveorUpdateVO.getContractId());
        lambdaQuery.notIn(OtherSettleEntity::getBillState, new Object[]{1, 3});
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        if ((num = this.count((Wrapper)lambdaQuery)) > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u7ed3\u7b97!");
        }
        Date signDate = contractEntity.getSignDate();
        if (null != signDate && saveorUpdateVO.getSettleDate().getTime() < signDate.getTime()) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e\u5176\u4ed6\u6536\u5165\u5408\u540c\u7684\u7b7e\u7ea6\u65e5\u671f");
        }
        OtherSettleEntity entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherSettleEntity.class));
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OtherContractEntity::getIsFinish, (Object)1);
        updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        OtherSettleVO vo = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
        return vo;
    }

    @Override
    public OtherSettleHistoryVO querySettleHistory(Long id) {
        BigDecimal sumSettleTaxMny;
        List quoteEntities = this.otherSettleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).orderByDesc((Object[])new String[]{"settle_date", "create_time"}));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        OtherSettleHistoryVO vo = new OtherSettleHistoryVO();
        vo.setContractId(id);
        vo.setSettleFlag(Integer.valueOf("2".equals(contractEntity.getContractStatus()) ? 0 : 1));
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setIsSuspend(contractEntity.getIsSuspend());
        vo.setIsRelieve(contractEntity.getIsRelieve());
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setTotalSettleTaxMny(contractEntity.getSumSettleTaxMny());
        BigDecimal bigDecimal = sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        if (contractEntity.getContractTaxMny() == null || contractEntity.getContractTaxMny().compareTo(BigDecimal.ZERO) == 0) {
            vo.setTotalSettleRate(BigDecimal.ZERO);
        } else {
            vo.setTotalSettleRate(sumSettleTaxMny.divide(contractEntity.getContractTaxMny(), 8, 4).multiply(new BigDecimal(100)));
        }
        vo.setSettleRecord(BeanMapper.mapList((Iterable)quoteEntities, OtherSettleVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(OtherSettleVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean pushContract(OtherContractVO vo, String performanceStatus) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            CommonResponse transDataResp;
            this.contractService.delContractFromPool(vo.getId());
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setPerformanceStatus(performanceStatus);
            data.setChangeStatus(Integer.valueOf(Integer.parseInt(vo.getChangeStatus())));
            data.setContractProperty(Integer.valueOf(1));
            data.setSourceType(ContractTypeEnum.\u5176\u4ed6\u6536\u5165\u5408\u540c.getTypeCode());
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-steelstructure-frontend/#/otherContract/otherContractApprove?id=" + vo.getId() : "/ejc-steelstructure-frontend/#/otherContract/otherContractSupplement?id=" + vo.getId();
            data.setPcCardUrl(url);
            CommonResponse projectPoolSetVO = this.projectSetApi.getProjectId(data.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
                CommonResponse defDocById;
                ProjectPoolSetVO data1 = (ProjectPoolSetVO)projectPoolSetVO.getData();
                if (data1.getAreaName() != null) {
                    data.setAreaName(data1.getAreaName());
                }
                if (data1.getAddress() != null) {
                    data.setAddress(data1.getAddress());
                }
                if (data1.getEngineeringType() != null && (defDocById = this.defdocApi.getDefDocById(data1.getEngineeringTypeId())).getCode() == 0 && defDocById.getData() != null) {
                    data.setEngineeringType(((DefdocDetailVO)defDocById.getData()).getName());
                }
            }
            if ((transDataResp = this.contractPoolApi.saveOrUpdateContract(data)).isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    private void convertSettleVOToSettlePoolVO(OtherSettleVO vo, SettlePoolVO spv) {
        spv.setSourceType("other_in");
        spv.setSourceId(vo.getId());
        spv.setId(vo.getId());
        spv.setSettleProperty(Integer.valueOf(1));
        spv.setUltimateFlag(Integer.valueOf("1".equals(vo.getSettleType()) ? 1 : 0));
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setBillCodeUrl("/ejc-steelstructure-frontend/#/otherSettle/card?id=" + vo.getId());
        if (vo.getContractId() != null) {
            OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            spv.setContractType("otherIn");
            spv.setContractFlag(Integer.valueOf(1));
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getBillCode());
            spv.setPartyaId(contractEntity.getCustomerId());
            spv.setPartyaName(contractEntity.getCustomerName());
            spv.setPartybId(contractEntity.getSupplierId());
            spv.setPartybName(contractEntity.getSupplierName());
            spv.setSignDate(contractEntity.getSignDate());
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal lastTax = BigDecimal.ZERO;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            wrapper.in(OtherSettleEntity::getBillState, new Object[]{1, 3});
            wrapper.eq(BaseEntity::getDr, (Object)0);
            wrapper.eq(OtherSettleEntity::getContractId, (Object)vo.getContractId());
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (OtherSettleEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getSettleTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getSettleTaxMny();
                    BigDecimal settMny = settlementEntity.getSettleMny() == null ? BigDecimal.ZERO : settlementEntity.getSettleMny();
                    BigDecimal settTax = settlementEntity.getTax() == null ? BigDecimal.ZERO : settlementEntity.getTax();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);
            spv.setLastMny(lastMny);
            spv.setLastTax(lastTax);
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210");
    }
}

