/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.plan.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.steelstructure.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.steelstructure.promaterial.plan.service.IBatPlanDetailService;
import com.ejianc.business.steelstructure.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.tender.api.ITenderCostApi;
import com.ejianc.business.tender.cost.vo.PlanControlRuleDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"promaterialbatPlan"})
@Api(value="\u6750\u6599\u6279\u6b21\u91c7\u8d2d\u8ba1\u5212\u4e3b\u8868", tags={"\u6750\u6599\u6279\u6b21\u91c7\u8d2d\u8ba1\u5212\u4e3b\u8868"})
public class BatPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PARCEL_PLAN_CODE";
    @Autowired
    private IBatPlanService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITenderCostApi tenderCostApi;
    @Autowired
    private IBatPlanDetailService batPlanDetailService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BatPlanVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody BatPlanVO saveorUpdateVO) {
        BatPlanVO vo = this.service.saveOrUpdateByVo(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BatPlanVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryBatPlanDetailById(id));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BatPlanVO> vos) {
        List collect = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper batPlanDetailEntityQueryWrapper = new QueryWrapper();
        batPlanDetailEntityQueryWrapper.in((Object)"plan_id", collect);
        List list = this.batPlanDetailService.list((Wrapper)batPlanDetailEntityQueryWrapper);
        List batPlanDetailVOS = BeanMapper.mapList((Iterable)list, BatPlanDetailVO.class);
        this.tenderCostApi.delete(batPlanDetailVOS);
        this.service.removeByIds(collect, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BatPlanVO>> queryList(@RequestBody QueryParam param) {
        IPage<BatPlanVO> pageData = this.service.queryBatPlanPage(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<BatPlanVO> list = this.service.excelExportBatPlan(param);
        HashMap<String, List<BatPlanVO>> beans = new HashMap<String, List<BatPlanVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BatPlan-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refBatPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BatPlanVO>> refBatPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        IPage<BatPlanVO> pageData = this.service.refBatPlanData(param, condition, searchObject);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    @ApiOperation(value="\u91c7\u8d2d\u7c7b\u522b\u4e0b\u62c9\u53c2\u7167")
    @RequestMapping(value={"/refPurchaseDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, List<DefdocDetailVO>>> refPurchaseDate() {
        List<DefdocDetailVO> pageData = this.service.refPurchaseDate();
        HashMap<String, List<DefdocDetailVO>> map = new HashMap<String, List<DefdocDetailVO>>();
        map.put("data", pageData);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", map);
    }

    @ApiOperation(value="\u67e5\u8be2\u62db\u6807\u5f85\u529e")
    @RequestMapping(value={"/tenderPending"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BatPlanVO>> tenderPending() {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"trustees_id", (Object)this.sessionManager.getUserContext().getEmployeeId())).eq((Object)"plan_state", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).in((Object)"bill_state", Arrays.asList(1, 3))).orderByDesc((Object)"create_time");
        CommonResponse orgResponse = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgResponse.getData();
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            wrapper.in((Object)"parent_org_id", commonOrgIds);
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            wrapper.in((Object)"org_id", departmentIds);
        }
        List voList = BeanMapper.mapList((Iterable)this.service.list((Wrapper)wrapper), BatPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)voList);
    }

    @ApiOperation(value="\u63d0\u4ea4\u524d\u6821\u9a8c\u76ee\u6807\u8d23\u4efb\u6210\u672c")
    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PlanControlRuleDetailVO>> check(@RequestParam Long id) {
        BatPlanEntity batPlanEntity = (BatPlanEntity)((Object)this.service.selectById(id));
        BatPlanVO batPlanVO = (BatPlanVO)BeanMapper.map((Object)((Object)batPlanEntity), BatPlanVO.class);
        CommonResponse check = this.tenderCostApi.check(batPlanVO);
        if (check.getCode() == 0) {
            List data = (List)check.getData();
            return CommonResponse.success((String)"\u67e5\u8be2\u8ba1\u5212\u7ba1\u63a7\u6570\u636e\u6210\u529f\uff01", (Object)data);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u8ba1\u5212\u7ba1\u63a7\u6570\u636e\u5931\u8d25\uff01");
    }
}

