/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.vo.BatPlanControlVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.steelstructure.promaterial.plan.bean.BatPlanControlEntity;
import com.ejianc.business.steelstructure.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.steelstructure.promaterial.plan.mapper.BatPlanMapper;
import com.ejianc.business.steelstructure.promaterial.plan.service.IBatPlanControlService;
import com.ejianc.business.steelstructure.promaterial.plan.service.IBatPlanDetailService;
import com.ejianc.business.steelstructure.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.steelstructure.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.api.ITenderCostApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="promaterialBatPlanService")
public class BatPlanServiceImpl
extends BaseServiceImpl<BatPlanMapper, BatPlanEntity>
implements IBatPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONDITION_TRUSTEES_ID = "employeeId";
    private static final String CONDITION_PROJECT_ID = "projectId";
    private static final String CONDITION_ORG_ID = "orgId";
    private static final String BILL_CODE = "PARCEL_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IBatPlanDetailService batPlanDetailService;
    @Autowired
    private ITenderCostApi tenderCostApi;
    @Autowired
    private IBatPlanControlService batPlanControlService;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public BatPlanVO saveOrUpdateByVo(BatPlanVO batPlanVO) {
        BatPlanEntity entity;
        CommonResponse orgResponse;
        if (StringUtils.isEmpty((CharSequence)batPlanVO.getParentOrgCode()) && batPlanVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(batPlanVO.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            batPlanVO.setParentOrgCode(orgVO.getCode());
        }
        if ((entity = (BatPlanEntity)((Object)BeanMapper.map((Object)batPlanVO, BatPlanEntity.class))).getId() == null || entity.getId() == 0L) {
            this.logger.info("\u8ba1\u5212\u4fdd\u5b58\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)batPlanVO));
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)batPlanVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getPlanState() == null) {
            entity.setPlanState(BatPlanEnum.PLAN_STATE_WAIT.getPlanState());
        }
        super.saveOrUpdate((Object)entity, false);
        List batPlanDetailList = batPlanVO.getBatPlanDetailList();
        List collect = batPlanDetailList.stream().filter(s -> "del".equals(s.getRowState())).collect(Collectors.toList());
        this.tenderCostApi.delete(collect);
        BatPlanEntity batPlanEntity = (BatPlanEntity)((Object)super.selectById((Serializable)entity.getId()));
        BatPlanVO batPlanVO1 = this.copyVoByEntity(batPlanEntity);
        CommonResponse allPlanDetailVOCommonResponse = this.tenderCostApi.saveOrUpdateBatch(batPlanVO1);
        if (allPlanDetailVOCommonResponse.getCode() == 0) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BatPlanControlEntity::getPId, (Object)entity.getId());
            updateWrapper.set(BaseEntity::getDr, (Object)1);
            this.batPlanControlService.update((Wrapper)updateWrapper);
            List batPlanControlEntities = BeanMapper.mapList((Iterable)((Iterable)allPlanDetailVOCommonResponse.getData()), BatPlanControlEntity.class);
            for (BatPlanControlEntity batPlanControlEntity : batPlanControlEntities) {
                batPlanControlEntity.setPId(entity.getId());
                batPlanControlEntity.setId(null);
            }
            this.batPlanControlService.saveBatch(batPlanControlEntities);
            List batPlanControlVOS = BeanMapper.mapList((Iterable)((Iterable)allPlanDetailVOCommonResponse.getData()), BatPlanControlVO.class);
            for (BatPlanControlVO batPlanControlVO : batPlanControlVOS) {
                String planIds = batPlanControlVO.getPlanIds();
                List planIdList = Arrays.stream(planIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (Long aLong : planIdList) {
                    for (BatPlanDetailVO batPlanDetailVO : batPlanVO1.getBatPlanDetailList()) {
                        if (!aLong.equals(batPlanDetailVO.getId())) continue;
                        batPlanControlVO.getChildren().add(batPlanDetailVO);
                    }
                }
            }
            batPlanVO1.setBatPlanControlList(batPlanControlVOS);
        }
        return batPlanVO1;
    }

    @Override
    public BatPlanVO queryBatPlanDetailById(Long id) {
        BatPlanEntity entity = (BatPlanEntity)((Object)super.selectById((Serializable)id));
        BatPlanVO batPlanVO = this.copyVoByEntity(entity);
        for (BatPlanControlVO batPlanControlVO : batPlanVO.getBatPlanControlList()) {
            String planIds = batPlanControlVO.getPlanIds();
            List planIdList = Arrays.stream(planIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            for (Long aLong : planIdList) {
                for (BatPlanDetailVO batPlanDetailVO : batPlanVO.getBatPlanDetailList()) {
                    if (!aLong.equals(batPlanDetailVO.getId())) continue;
                    batPlanControlVO.getChildren().add(batPlanDetailVO);
                }
            }
        }
        return batPlanVO;
    }

    @Override
    public IPage<BatPlanVO> queryBatPlanPage(QueryParam param) {
        this.setDefaultParam(param);
        return this.queryBatPlanVO(param);
    }

    @Override
    public List<BatPlanVO> excelExportBatPlan(QueryParam param) {
        this.setDefaultParam(param);
        param.setPageIndex(1);
        param.setPageSize(10000);
        List entityList = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            List list = BeanMapper.mapList((Iterable)entityList, BatPlanVO.class);
            for (BatPlanVO vo : list) {
                vo.setBillStateName(this.getBillStateName(vo.getBillState()));
                vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
            }
            return list;
        }
        return new ArrayList<BatPlanVO>();
    }

    @Override
    public IPage<BatPlanVO> refBatPlanData(QueryParam param, String condition, String searchObject) {
        IPage<BatPlanVO> pageData;
        this.setDefaultParam(param);
        param.getParams().put("planState", new Parameter("eq", (Object)BatPlanEnum.PLAN_STATE_WAIT.getPlanState()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)searchObject)) {
            param.setSearchObject(null);
            JSONObject searchJson = JSONObject.parseObject((String)searchObject);
            this.logger.info("\u53c2\u7167\u67e5\u8be2searchObject\uff1a\u3010{}\u3011", (Object)searchJson);
            if (searchJson != null && !searchJson.isEmpty()) {
                for (Map.Entry entry : searchJson.entrySet()) {
                    param.getParams().put(entry.getKey(), new Parameter("like", entry.getValue()));
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("\u53c2\u7167\u67e5\u8be2condition\uff1a\u3010{}\u3011", (Object)_con);
            if (_con.containsKey((Object)CONDITION_TRUSTEES_ID)) {
                param.getParams().put("trusteesId", new Parameter("eq", _con.get((Object)CONDITION_TRUSTEES_ID)));
            }
            if (_con.containsKey((Object)CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get((Object)CONDITION_PROJECT_ID).toString());
                CommonResponse projectResponse = this.projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put(CONDITION_PROJECT_ID, new Parameter("in", projectResponse.getData()));
            }
            if (_con.containsKey((Object)CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get((Object)CONDITION_ORG_ID).toString());
                CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
                OrgVO orgVO = (OrgVO)orgResp.getData();
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("eq", (Object)orgId));
                } else {
                    param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(pageData = this.queryBatPlanVO(param)).getRecords())) {
            List batPlanVOList = pageData.getRecords();
            List idList = batPlanVOList.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("planId", new Parameter("in", idList));
            List detailEntityList = this.batPlanDetailService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, BatPlanDetailVO.class);
            HashMap detailMap = new HashMap();
            for (BatPlanDetailVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getPlanId())) {
                    ((List)detailMap.get(vo.getPlanId())).add(vo);
                    continue;
                }
                ArrayList<BatPlanDetailVO> mapList = new ArrayList<BatPlanDetailVO>();
                mapList.add(vo);
                detailMap.put(vo.getPlanId(), mapList);
            }
            batPlanVOList.forEach(batPlanVO -> batPlanVO.setBatPlanDetailList((List)detailMap.get(batPlanVO.getId())));
        }
        return pageData;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState, Integer establishType) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)BatPlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (BatPlanEntity entity : entityList) {
                if (establishType == 0 && BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                    this.logger.info("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010{}\u3011\u8ba1\u5212\u540d\u79f0\u3010{}\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01", (Object)entity.getBillCode(), (Object)entity.getPlanName());
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getBillCode() + "\u3011\u8ba1\u5212\u540d\u79f0\u3010" + entity.getPlanName() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setPlanState(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }

    @Override
    public List<DefdocDetailVO> refPurchaseDate() {
        CommonResponse zzcRes;
        String wzDefCode = "pro-supply-material-supply-content";
        String zzcDefCode = "pro-supply-revolving-materials-supply-content";
        ArrayList list = new ArrayList();
        CommonResponse wzRes = this.defdocApi.getDefDocByDefCode(wzDefCode);
        if (wzRes.isSuccess()) {
            list.addAll((Collection)wzRes.getData());
        }
        if ((zzcRes = this.defdocApi.getDefDocByDefCode(zzcDefCode)).isSuccess()) {
            list.addAll((Collection)zzcRes.getData());
        }
        List<DefdocDetailVO> collect = list.stream().filter(vo -> 1 == vo.getEnabled()).collect(Collectors.toList());
        return collect;
    }

    private IPage<BatPlanVO> queryBatPlanVO(QueryParam param) {
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List batPlanVOList = BeanMapper.mapList((Iterable)page.getRecords(), BatPlanVO.class);
        for (BatPlanVO vo : batPlanVOList) {
            vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
        }
        pageData.setRecords(batPlanVOList);
        return pageData;
    }

    private void setDefaultParam(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("planName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("trusteesName");
        fuzzyFields.add("purchaseName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResponse = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgResponse.getData();
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put(CONDITION_ORG_ID, new Parameter("in", departmentIds));
        }
    }

    private BatPlanVO copyVoByEntity(BatPlanEntity entity) {
        BatPlanVO vo = (BatPlanVO)BeanMapper.map((Object)((Object)entity), BatPlanVO.class);
        vo.setPlanStateName(BatPlanEnum.getDescriptionByStateCode((Integer)vo.getPlanState()));
        return vo;
    }

    private String getBillStateName(Integer billState) {
        String billStateName = null;
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u81ea\u7531\u6001";
        } else if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5df2\u63d0\u4ea4";
        } else if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6838\u4e2d";
        } else if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6279\u901a\u8fc7";
        } else if (BillStateEnum.UNAPPROVED.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6279\u9a73\u56de";
        } else if (BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(billState)) {
            billStateName = "\u5ba1\u6838\u4e2d";
        }
        return billStateName;
    }
}

