/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.settlement.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractDetailEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractEntity;
import com.ejianc.business.steelstructure.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractService;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractDetailVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractVO;
import com.ejianc.business.steelstructure.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementCollectEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementDetailEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementFeeEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.mapper.PromaterialSettlementMapper;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementCollectService;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementDetailService;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementFeeService;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementService;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialCheckDetailVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialContractFlagEnum;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialContractSettlementRecordVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialPrintSettlementDetailVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialPrintSettlementFeeVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSettlementRecordVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSettlementVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSupSettlementCollectVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSupSettlementDetailVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSupSettlementFeeVO;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSupSettlementVO;
import com.ejianc.business.steelstructure.promaterial.utils.CommonUtils;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.settlement.api.ITemporarySettlementApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="promaterialSettlementService")
public class PromaterialSettlementServiceImpl
extends BaseServiceImpl<PromaterialSettlementMapper, PromaterialSettlementEntity>
implements IPromaterialSettlementService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE_C = "JS_CODE";
    private static final String BILL_CODE_H = "SHAHUN";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPromaterialContractService contractService;
    @Autowired
    private IPromaterialSettlementCollectService settlementCollectService;
    @Autowired
    private IAccountSettleApi accountSettleApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IPromaterialSettlementFeeService settlementFeeService;
    @Autowired
    private IPromaterialSettlementService settlementService;
    @Autowired
    private IPromaterialSettlementDetailService settlementDetailService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private final String OPERATE = "SETTLMENT_JS";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ITemporarySettlementApi temporarySettlementApi;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settlement/saveSettlement";
    private static final String MBILL_TYPE = "BT220309000000003";
    private static final String CBILL_TYPE = "BT220316000000005";
    private static final String M_PARAM_CODE_GC = "P-261sG051";
    private static final String M_PARAM_CODE_ZZ = "P-g9oJ340151";
    private static final String C_PARAM_CODE_GC = "P-p52jnO52";
    private static final String C_PARAM_CODE_ZZ = "P-4472DH0153";
    private static final String MN_PARAM_CODE_GC = "P-o0ydgH53";
    private static final String MN_PARAM_CODE_ZZ = "P-Zvb6nF0152";
    private static final String CN_PARAM_CODE_GC = "P-6lY70054";
    private static final String CN_PARAM_CODE_ZZ = "P-7Fq3830154";
    private static final String NO_CONTRACT_PARAM_CODE = "P-0w8vi00147";
    private static final String NO_CONTRACT_SUPPLIER_PARAM_CODE = "P-r958420148";
    private static final String CHECK_MNY_CON_CODE = "P-5E2vV80145";

    @Override
    public PromaterialSettlementRecordVO querySettleRecord(Long contractId) {
        PromaterialSettlementRecordVO vo = new PromaterialSettlementRecordVO();
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(contractId));
        vo.setContractId(contractId);
        vo.setContractTaxMny(promaterialContractEntity.getContractTaxMny());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PromaterialSettlementEntity::getContractId, (Object)contractId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.in(PromaterialSettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.orderByAsc(BaseEntity::getCreateTime);
        List list = super.list((Wrapper)wrapper);
        List vos = BeanMapper.mapList((Iterable)list, PromaterialSettlementVO.class);
        PromaterialSettlementVO promaterialSettlementVO = CollectionUtils.isNotEmpty((Collection)vos) ? (PromaterialSettlementVO)vos.get(0) : null;
        vo.setTotalSettlementTaxMny(null != promaterialSettlementVO && null != promaterialSettlementVO.getCurrentSettlementTaxMny() ? promaterialSettlementVO.getCurrentSettlementTaxMny() : BigDecimal.ZERO);
        if (vo.getContractTaxMny() == null || BigDecimal.ZERO.compareTo(vo.getContractTaxMny()) == 0) {
            vo.setSettleRatio(BigDecimal.ZERO);
        } else {
            vo.setSettleRatio(vo.getTotalSettlementTaxMny().divide(vo.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        vo.setSettlementList(vos);
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(PromaterialSettlementEntity::getContractId, (Object)contractId);
        wrapper2.eq(BaseEntity::getDr, (Object)0);
        wrapper2.eq(PromaterialSettlementEntity::getSignatureType, (Object)1);
        List list2 = super.list((Wrapper)wrapper2);
        vo.setFlag(Boolean.valueOf(!CollectionUtils.isNotEmpty((Collection)list2)));
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(PromaterialSettlementEntity::getContractId, (Object)contractId);
        wrapper3.eq(BaseEntity::getDr, (Object)0);
        wrapper3.notIn(PromaterialSettlementEntity::getBillState, new Object[]{1, 3});
        wrapper3.eq(PromaterialSettlementEntity::getSignatureType, (Object)0);
        List list3 = super.list((Wrapper)wrapper3);
        vo.setFlagTwo(Boolean.valueOf(!CollectionUtils.isNotEmpty((Collection)list3)));
        return vo;
    }

    @Override
    public CommonResponse<PromaterialSettlementVO> saveOrUpdate(PromaterialSettlementVO saveOrUpdateVO) {
        if (CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getCheckDetailList())) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u5f53\u524d\u7ed3\u7b97\u5355\u7684\u6750\u6599\u660e\u7ec6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01");
        }
        PromaterialSettlementEntity entity = (PromaterialSettlementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PromaterialSettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String BILL_CODE = "";
            switch (entity.getSettlementType()) {
                case 0: {
                    BILL_CODE = BILL_CODE_C;
                    break;
                }
                case 1: {
                    BILL_CODE = BILL_CODE_H;
                }
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (null != entity.getContractId() && this.queryExist(entity.getContractId())) {
                throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
            }
        } else {
            this.delCollect(entity.getId());
            ArrayList<PromaterialSettlementDetailEntity> detailDel = new ArrayList<PromaterialSettlementDetailEntity>();
            if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
                for (PromaterialSettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    if (!"del".equals(detail.getRowState())) continue;
                    detailDel.add(detail);
                }
            }
            this.deleteAccount(detailDel, entity.getContractId());
        }
        entity.setSignStatus(0);
        entity.setSignatureStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        if (entity.getContractId() != null && CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
            PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            List<PromaterialContractDetailEntity> contractDetailList = promaterialContractEntity.getContractDetailList();
            if (CollectionUtils.isEmpty(contractDetailList)) {
                throw new BusinessException("\u7ed3\u7b97\u660e\u7ec6\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u7ed3\u7b97");
            }
            List materialIds = contractDetailList.stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).map(item -> item.getMaterialId().toString()).collect(Collectors.toList());
            List materialTypeIds = contractDetailList.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).map(item -> item.getMaterialTypeId().toString()).collect(Collectors.toList());
            for (PromaterialSettlementDetailEntity detail : entity.getSettlementDetailList()) {
                String materialId;
                if ("del".equals(detail.getRowState())) continue;
                boolean flag = true;
                String materialTypeId = detail.getMaterialTypeId() == null ? "" : detail.getMaterialTypeId().toString();
                String string = materialId = detail.getMaterialId() == null ? "" : detail.getMaterialId().toString();
                if (materialTypeIds.contains(materialTypeId)) {
                    flag = false;
                }
                if (materialIds.contains(materialId)) {
                    flag = false;
                }
                if (!flag) continue;
                throw new BusinessException("\u6750\u6599\u3010" + detail.getMaterialName() + "\u3011\u5728\u5408\u540c\u3010" + entity.getContractName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u53d8\u66f4\u5408\u540c\u540e\u518d\u7ed3\u7b97");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        PromaterialSettlementVO vo = (PromaterialSettlementVO)BeanMapper.map((Object)((Object)entity), PromaterialSettlementVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public boolean queryExist(Long contractId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PromaterialSettlementEntity::getContractId, (Object)contractId);
        wrapper.notIn(PromaterialSettlementEntity::getBillState, new Object[]{1, 3});
        List list = super.list((Wrapper)wrapper);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    public void delCollect(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PromaterialSettlementCollectEntity::getSettlementId, (Object)id);
        List list = this.settlementCollectService.list((Wrapper)wrapper);
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            this.settlementCollectService.removeByIds(ids);
        }
    }

    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        String sTDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(PromaterialSettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(PromaterialSettlementEntity::getContractId, (Object)contractId);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            PromaterialSettlementEntity promaterialSettlementEntity = (PromaterialSettlementEntity)((Object)list.get(0));
            currentTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(PromaterialSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> e.getSettlementMny() != null).map(PromaterialSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            sTDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)promaterialSettlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny", currentTaxMny);
        map.put("currentMny", currentMny);
        map.put("sTDate", sTDate);
        map.put("settlementNum", list.size());
        return CommonResponse.success((String)"\u83b7\u53d6\u91d1\u989d\u548c\u65f6\u95f4\u3001\u7ed3\u7b97\u6b21\u6570\u6210\u529f,\uff01", map);
    }

    public void updateAccount(PromaterialSettlementEntity entity) {
        boolean flag = true;
    }

    public void updateContractId(List<Long> ids, Long contractId, String contractName) {
        this.logger.info("\u5408\u540cid\u66f4\u65b0\u4fe1\u606f\uff0c\u66f4\u65b0ids:{}--\u5408\u540cid:{}", (Object)JSONObject.toJSONString(ids), (Object)contractId);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
    }

    @Override
    public CommonResponse<String> delete(List<PromaterialSettlementVO> vos) {
        PromaterialSettlementEntity promaterialSettlementEntity = (PromaterialSettlementEntity)((Object)super.selectById((Serializable)vos.get(0).getId()));
        this.deleteAccount(promaterialSettlementEntity.getSettlementDetailList(), promaterialSettlementEntity.getContractId());
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public void deleteAccount(List<PromaterialSettlementDetailEntity> settlementDetail, Long contractId) {
        StoreApiVO storeApiVO = new StoreApiVO();
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        storeApiVO.setSettleFlag(Integer.valueOf(0));
        HashSet<Long> checkId = new HashSet<Long>();
        ArrayList<Long> idsDel = new ArrayList<Long>();
        for (PromaterialSettlementDetailEntity detailEntity : settlementDetail) {
            FlowVO flowVO = new FlowVO();
            if (null != contractId && PromaterialContractFlagEnum.\u65e0\u5408\u540c.getCode().equals(detailEntity.getContractFlag())) {
                checkId.add(detailEntity.getSourceId());
                flowVO.setCusDef1("NoContract");
            }
            if (detailEntity.getReconciliationDetailId() != null) {
                idsDel.add(detailEntity.getReconciliationDetailId());
            }
            flowVO.setSourceId(detailEntity.getSourceId());
            flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
            flowVOS.add(flowVO);
        }
        storeApiVO.setDetail(flowVOS);
        this.logger.info("\u5220\u9664\u7ed3\u7b97\u66f4\u65b0\u4fe1\u606f--" + JSONObject.toJSONString((Object)storeApiVO));
        CommonResponse response = this.accountSettleApi.changeAccountSettleByType(storeApiVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u5220\u9664\u7ed3\u7b97\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
        this.updateContractId(new ArrayList<Long>(checkId), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(PromaterialSettlementEntity entity, String billTypeCode) {
        String BILL_TYPE = entity.getSettlementType() == 1 ? CBILL_TYPE : MBILL_TYPE;
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            PromaterialSupSettlementVO promaterialSupSettlementVO = (PromaterialSupSettlementVO)BeanMapper.map((Object)((Object)entity), PromaterialSupSettlementVO.class);
            List promaterialSupSettlementDetailVOS = BeanMapper.mapList(entity.getSettlementDetailList(), PromaterialSupSettlementDetailVO.class);
            List promaterialSupSettlementFeeVOS = BeanMapper.mapList(entity.getSettlementFeeList(), PromaterialSupSettlementFeeVO.class);
            List promaterialSupSettlementCollectVOS = BeanMapper.mapList(entity.getSettlementCollectList(), PromaterialSupSettlementCollectVO.class);
            promaterialSupSettlementVO.setSettlementDetailList(promaterialSupSettlementDetailVOS);
            promaterialSupSettlementVO.setSettlementFeeList(promaterialSupSettlementFeeVOS);
            promaterialSupSettlementVO.setSettlementCollectList(promaterialSupSettlementCollectVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)promaterialSupSettlementVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "settlementProjectFile", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9644\u4ef6\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(files));
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/settlement/saveSettlement", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(PromaterialSettlementEntity entity, String billTypeCode, String url) {
        if (entity.getSettlementType() == 1) {
            BILL_TYPE = "BT220316000000005";
        } else {
            BILL_TYPE = "BT220309000000003";
        }
        locked = false;
        jedis = this.jedisPool.getResource();
        key = billTypeCode + "::" + entity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        ((PromaterialSettlementMapper)this.baseMapper).updateById((Object)entity);
        this.logger.info("\u4fee\u6539\u7b7e\u5b57\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                var9_10 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var9_10;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl40
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var12_15 = supHandleResp;
                return var12_15;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl40:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        PromaterialSettlementEntity promaterialSettlementEntity = (PromaterialSettlementEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String BILL_TYPE = promaterialSettlementEntity.getSettlementType() == 0 ? MBILL_TYPE : CBILL_TYPE;
        promaterialSettlementEntity.setSupOperateTime(supOperateTime);
        promaterialSettlementEntity.setSupOperatorName(supOperatorName);
        promaterialSettlementEntity.setSupOperatorPhone(supOperatorPhone);
        promaterialSettlementEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = BILL_TYPE + "::" + promaterialSettlementEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLMENT_JS", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)promaterialSettlementEntity.getId());
                this.releaseLock(jedis, false, key, "SETTLMENT_JS");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, promaterialSettlementEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            promaterialSettlementEntity.setAttachIds(attchIdsList);
            promaterialSettlementEntity.setSignStatus(1);
            super.saveOrUpdate((Object)promaterialSettlementEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)promaterialSettlementEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
            throw e;
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLMENT_JS");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public boolean pushSettleToPool(PromaterialSettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            if (vo.getContractId() == null) {
                if (vo.getSettlementType() == 1) {
                    spv.setBillCodeUrl("/ejc-steelstructure-frontend/#/concreteSettlementList/settlementNoCard?id=" + vo.getId());
                } else {
                    spv.setBillCodeUrl("/ejc-steelstructure-frontend/#/settlementList/settlementNoCard?id=" + vo.getId());
                }
            } else if (vo.getSettlementType() == 1) {
                spv.setBillCodeUrl("/ejc-steelstructure-frontend/#/concreteSettlementList/settlementCard?id=" + vo.getId());
            } else {
                spv.setBillCodeUrl("/ejc-steelstructure-frontend/#/settlementList/settlementCard?id=" + vo.getId());
            }
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(PromaterialSettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        switch (vo.getSettlementType()) {
            case 0: {
                if (vo.getContractId() != null) {
                    spv.setSourceType(SettleSourceTypeEnum.\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97.getCode());
                    break;
                }
                spv.setSourceType(SettleSourceTypeEnum.\u96f6\u661f\u6750\u6599\u7ed3\u7b97.getCode());
                break;
            }
            case 1: {
                spv.setSourceType(SettleSourceTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97.getCode());
            }
        }
        spv.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSettlePropertyName("\u652f\u51fa");
        spv.setSettleProperty(Integer.valueOf(0));
        spv.setSourceId(vo.getId());
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setContractFlag(Integer.valueOf(0));
        spv.setHandleType(Integer.valueOf(0));
        if (vo.getContractId() != null) {
            spv.setContractFlag(Integer.valueOf(1));
            PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            switch (promaterialContractEntity.getContractType()) {
                case 0: {
                    spv.setContractType(ContractTypeEnum.\u94a2\u6784\u516c\u53f8\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                    break;
                }
                case 1: {
                    spv.setContractType(ContractTypeEnum.\u94a2\u6784\u516c\u53f8\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                }
            }
            spv.setSupplementFlag(promaterialContractEntity.getSupplementFlag());
            spv.setMaiContractId(promaterialContractEntity.getMainContractId());
            spv.setMaiContractName(promaterialContractEntity.getMainContractName());
            spv.setMaiContractCode(promaterialContractEntity.getMainContractCode());
            spv.setContractCode(promaterialContractEntity.getBillCode());
            spv.setPartyaId(promaterialContractEntity.getCustomerId());
            spv.setPartyaName(promaterialContractEntity.getCustomerName());
            spv.setSignDate(promaterialContractEntity.getSignDate());
            spv.setLastTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny()));
            spv.setLastMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny()));
            spv.setLastTax(ComputeUtil.safeSub((BigDecimal)spv.getLastTaxMny(), (BigDecimal)spv.getLastMny()));
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(PromaterialSettlementVO promaterialSettlementVO, String linkUrl, Integer settlementType) {
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PromaterialSettlementEntity::getContractId, (Object)promaterialSettlementVO.getContractId());
        wrapper.in(PromaterialSettlementEntity::getBillState, Arrays.asList(1, 3));
        wrapper.eq(BaseEntity::getDr, (Object)0);
        List list = this.settlementService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u7ed3\u7b97\u6570\u636e\u4e0d\u5b58\u5728");
        }
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(PromaterialSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(PromaterialSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        PromaterialContractVO promaterialContractVO = this.contractService.queryDetail(promaterialSettlementVO.getContractId());
        List contractDetailList = promaterialContractVO.getContractDetailList();
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(promaterialSettlementVO.getId());
        totalVO.setTenantId(promaterialSettlementVO.getTenantId());
        totalVO.setBillCode(promaterialSettlementVO.getBillCode());
        if (settlementType == 0) {
            totalVO.setBillType(MBILL_TYPE);
        } else {
            totalVO.setBillType(CBILL_TYPE);
        }
        switch (promaterialContractVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(promaterialSettlementVO.getProjectId());
        totalVO.setOrgId(promaterialSettlementVO.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)promaterialContractVO.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)promaterialContractVO.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        List settleIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.in(PromaterialSettlementDetailEntity::getSettlementId, settleIdList);
        List settleDetailList = this.settlementDetailService.list((Wrapper)detailWrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
            Map<Long, List<PromaterialSettlementDetailEntity>> detailMaterialMap = settleDetailList.stream().collect(Collectors.groupingBy(PromaterialSettlementDetailEntity::getMaterialId));
            Map<Long, List<PromaterialContractDetailVO>> contractDetailMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.groupingBy(PromaterialContractDetailVO::getMaterialId));
            if (!contractDetailMap.isEmpty()) {
                for (Long materialId : detailMaterialMap.keySet()) {
                    List<PromaterialSettlementDetailEntity> detailMaterialList = detailMaterialMap.get(materialId);
                    List<PromaterialContractDetailVO> contractDetailList1 = contractDetailMap.get(materialId);
                    BigDecimal contractSumNum = contractDetailList1.stream().filter(e -> e.getNum() != null).map(PromaterialContractDetailVO::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumMny = contractDetailList1.stream().filter(e -> e.getMoney() != null).map(PromaterialContractDetailVO::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal contractSumTaxMny = contractDetailList1.stream().filter(e -> e.getDetailTaxMny() != null).map(PromaterialContractDetailVO::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumNum = detailMaterialList.stream().filter(e -> e.getNum() != null).map(PromaterialSettlementDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumMny = detailMaterialList.stream().filter(e -> e.getMny() != null).map(PromaterialSettlementDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sumTaxMny = detailMaterialList.stream().filter(e -> e.getTaxMny() != null).map(PromaterialSettlementDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    PromaterialSettlementDetailEntity planDetailVO = detailMaterialList.get(0);
                    DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                    detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                    detailExecutionVO.setSourceBillId(promaterialSettlementVO.getId());
                    detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                    detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                    if (planDetailVO.getMaterialId() == null) {
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                        detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                    } else {
                        detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                        detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                    }
                    detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                    detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                    MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCode());
                    }
                    detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                    detailExecutionVO.setName(planDetailVO.getMaterialName());
                    detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                    detailExecutionVO.setUnitName(planDetailVO.getUnit());
                    detailExecutionVO.setPrice(planDetailVO.getPrice());
                    detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
                    detailExecutionVO.setNum(ComputeUtil.safeSub((BigDecimal)sumNum, (BigDecimal)contractSumNum));
                    detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)contractSumMny));
                    detailExecutionVO.setSpec(planDetailVO.getSpec());
                    detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)contractSumTaxMny));
                    detailList.add(detailExecutionVO);
                }
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ParamsCheckVO checkParams(PromaterialSettlementVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null != vo.getContractId()) {
            this.logger.info("\u8be5\u7ed3\u7b97\u5355\u72b6\u6001---{}", (Object)vo.getSettlementType());
            Boolean flag = true;
            if (vo.getSettlementType() == 0 && !"proMaterial-1".equals(vo.getContractPropertyCode())) {
                flag = false;
            }
            if (!flag.booleanValue()) {
                // empty if block
            }
        } else {
            if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
                paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
            }
            paramsCheckVOS.addAll(this.checkParamsMny(vo));
            paramsCheckVOS.addAll(this.checkParamsMnyBySupplier(vo));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        String[] stringArray = paramsArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = stringArray[n2];
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType((String)s);
                paramsCheckVO.setDataSource((List)map.get(s));
                if (!CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                    return paramsCheckVO;
                }
                paramsCheckVO.setWarnType("none");
            }
            ++n2;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(PromaterialSettlementVO vo) {
        CommonResponse billParamByCode;
        List list;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = mny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PromaterialSettlementEntity::getProjectId, (Object)vo.getProjectId());
        wrapper.isNull(PromaterialSettlementEntity::getContractId);
        if (null != vo.getId()) {
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)wrapper)))) {
            BigDecimal totalSettleMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(PromaterialSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalSettleMny);
        }
        CommonResponse response = this.temporarySettlementApi.queryTemporarySettlementMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee\uff1a{}-\u4e0b\u6240\u6709\u72b6\u6001\u7684\u3010\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97\u91d1\u989d\u3011\u91d1\u989d\u7ed3\u679c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && null != response.getData()) {
            BigDecimal settleTaxMny = ((JSONObject)response.getData()).getBigDecimal("settleTaxMny");
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)settleTaxMny);
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u96f6\u661f\u673a\u68b0\u91d1\u989d\u3011\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u4e34\u673a\u8d39\u7528\u8d85\u65bd\u5de5\u5408\u540c\u989d");
                        paramsCheckDsVO.setWarnName("\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u4e34\u673a\u8d39\u7528\u7d2f\u8ba1\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u96f6\u6750\u3001\u96f6\u673a\u53d1\u751f\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public PromaterialContractSettlementRecordVO queryDetailRecord(Long contractId) {
        PromaterialContractSettlementRecordVO settleRecordVO = new PromaterialContractSettlementRecordVO();
        PromaterialContractEntity contract = (PromaterialContractEntity)((Object)this.contractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"settlement_date");
        List list = super.list((Wrapper)listQuery);
        List rentPromaterialSettlementVOS = BeanMapper.mapList((Iterable)list, PromaterialSettlementVO.class);
        settleRecordVO.setSettleList(rentPromaterialSettlementVOS);
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractSettleMny = list.stream().map(PromaterialSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);
        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        } else {
            settleRecordVO.setSettleRate(settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    @Override
    public void updateContractPoolSettle(PromaterialSettlementVO vo, Boolean type) {
        if (null != vo.getContractId()) {
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + (type != false ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0csettleEntity={}, \u8fc7\u7a0b\uff080\uff09/\u6700\u7ec8\uff081\uff09={}, type={}", new Object[]{vo, vo.getSignatureType(), type});
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
            BigDecimal totalSettleMny = BigDecimal.ZERO;
            BigDecimal totalSettleTax = BigDecimal.ZERO;
            if (type.booleanValue()) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            } else {
                totalSettleTaxMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)totalSettleMny);
            }
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);
            contractPoolVO.setTotalSettleMny(totalSettleMny);
            contractPoolVO.setTotalSettleTax(totalSettleTax);
            if (1 == vo.getSignatureType()) {
                if (type.booleanValue()) {
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode());
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                }
            }
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
            CommonResponse updateConPoolRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("ID\u4e3a\u3010" + vo.getContractId() + "\u3011\u7684\u5408\u540c " + vo.getBillCode() + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)updateConPoolRes));
        }
    }

    @Override
    public CommonResponse<PromaterialSettlementVO> pushCost(PromaterialSettlementVO vo) {
        PromaterialSettlementEntity entity = (PromaterialSettlementEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList())) {
            List detailEntityList = BeanMapper.mapList((Iterable)vo.getSettlementDetailList(), PromaterialSettlementDetailEntity.class);
            entity.setSettlementDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty(entity.getSettlementFeeList())) {
            List feeEntityList = BeanMapper.mapList((Iterable)vo.getSettlementFeeList(), PromaterialSettlementFeeEntity.class);
            entity.setSettlementFeeList(feeEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), PromaterialSettlementVO.class));
    }

    @Override
    public void costPush(PromaterialSettlementEntity entity) {
        String oldRelationFlag;
        this.logger.info("\u5f00\u59cbcostPush");
        List<PromaterialSettlementFeeEntity> feeList = entity.getSettlementFeeList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (PromaterialSettlementFeeEntity feeEntity : feeList) {
                if (null != feeEntity.getSubjectIdFee() && null != feeEntity.getWbsIdFee()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(feeList)) {
            newRelationFlag = "0";
        }
        if ("1".equals(oldRelationFlag = entity.getRelationFlag())) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                // empty if block
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(entity);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(PromaterialSettlementEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        entity.setRelationFlag(newRelationFlag);
    }

    private void saveCost(PromaterialSettlementEntity entity) {
        String linkUrl = "";
        String billName = "";
        String sourceType = "";
        if (entity.getSettlementType() == 0) {
            linkUrl = null == entity.getContractId() ? "/ejc-steelstructure-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : "/ejc-steelstructure-frontend/#/settlementList/settlementCard?id=" + entity.getId();
            billName = SourceTypeEnum.\u6750\u6599\u91c7\u8d2d\u7ed3\u7b97.getTypeName();
            sourceType = "MATERIAL";
        } else {
            linkUrl = null == entity.getContractId() ? "/ejc-steelstructure-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : "/ejc-steelstructure-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId();
            billName = SourceTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97.getTypeName();
            sourceType = "CONCRETE";
        }
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<PromaterialSettlementFeeEntity> feeList = entity.getSettlementFeeList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (PromaterialSettlementFeeEntity feeEntity : feeList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl(linkUrl);
                costDetailVO.setSubjectId(feeEntity.getSubjectIdFee());
                costDetailVO.setSubjectId(feeEntity.getSubjectIdFee());
                costDetailVO.setSubjectCode(feeEntity.getSubjectCodeFee());
                costDetailVO.setSubjectName(feeEntity.getSubjectNameFee());
                costDetailVO.setNum(feeEntity.getFeeNum());
                costDetailVO.setWbsId(feeEntity.getWbsIdFee());
                costDetailVO.setWbsCode(feeEntity.getWbsCodeFee());
                costDetailVO.setWbsName(feeEntity.getWbsNameFee());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(feeEntity.getId());
                costDetailVO.setHappenTaxMny(feeEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(feeEntity.getFeeMny());
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(sourceType + "_SETTLE");
                costDetailVO.setSourceTabType(sourceType + "_SETTLE_FEE");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            // empty if block
        }
    }

    @Override
    public List<PromaterialSettlementVO> querySettlementByContractId(PromaterialSettlementVO promaterialSettlementVO) {
        List<PromaterialSettlementEntity> list = this.queryListByContractId(promaterialSettlementVO);
        List<Object> rtnList = new ArrayList<PromaterialSettlementVO>();
        if (CollectionUtils.isNotEmpty(list)) {
            rtnList = BeanMapper.mapList(list, PromaterialSettlementVO.class);
            for (PromaterialSettlementVO promaterialSettlementVO2 : rtnList) {
                promaterialSettlementVO2.setSettlementDateStr(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)promaterialSettlementVO2.getSettlementDate()));
                promaterialSettlementVO2.setBillCodeLink(promaterialSettlementVO2.getBillCode());
                promaterialSettlementVO2.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)promaterialSettlementVO2.getBillState()).getDescription());
            }
        }
        return rtnList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(PromaterialSettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId(NO_CONTRACT_PARAM_CODE, vo.getOrgId());
        if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
            List data = (List)billParamByCodeAndOrgId.getData();
            this.logger.info("\u5355\u6b21\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal mny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u5355\u6b21\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u8d85\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)mny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCodeAndOrgId.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyBySupplier(PromaterialSettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCodeAndOrgId = this.paramConfigApi.getBillParamByCodeAndOrgId(NO_CONTRACT_SUPPLIER_PARAM_CODE, vo.getOrgId());
        if (billParamByCodeAndOrgId.isSuccess() && null != billParamByCodeAndOrgId.getData()) {
            List data = (List)billParamByCodeAndOrgId.getData();
            this.logger.info("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            BigDecimal mny = this.getNoContractSupplierMny(vo);
            BigDecimal thisMny = CommonUtils.setBigDecimalDefaultValue(vo.getSettlementTaxMny());
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(thisMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d").append(mny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)mny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCodeAndOrgId.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    private BigDecimal getNoContractSupplierMny(PromaterialSettlementVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("supplierId", new Parameter("eq", (Object)vo.getSupplierId()));
        queryParam.getParams().put("contractId", new Parameter("eq", null));
        if (vo.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        List entityList = super.queryList(queryParam, false);
        BigDecimal sum = CommonUtils.setBigDecimalDefaultValue(vo.getSettlementTaxMny());
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return sum;
        }
        for (PromaterialSettlementEntity entity : entityList) {
            sum = sum.add(CommonUtils.setBigDecimalDefaultValue(entity.getSettlementTaxMny()));
        }
        return sum;
    }

    @Override
    public List<PromaterialPrintSettlementDetailVO> queryPrintSettlementDetail(PromaterialSettlementVO promaterialSettlementVO) {
        ArrayList<Object> rtnList = new ArrayList<PromaterialPrintSettlementDetailVO>();
        List<PromaterialSettlementEntity> list = this.queryListByContractId(promaterialSettlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter("in", idList));
        List detailEntityList = this.settlementDetailService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)detailEntityList)) {
            return rtnList;
        }
        Map<Object, Object> thisMap = new HashMap();
        if (promaterialSettlementVO.getId() != null) {
            List thisDetailList = detailEntityList.stream().filter(t -> t.getSettlementId().equals(promaterialSettlementVO.getId())).collect(Collectors.toList());
            thisMap = thisDetailList.stream().collect(Collectors.groupingBy(PromaterialSettlementDetailEntity::getMaterialId));
        }
        HashMap<String, PromaterialPrintSettlementDetailVO> map = new HashMap<String, PromaterialPrintSettlementDetailVO>();
        for (PromaterialSettlementDetailEntity detailEntity : detailEntityList) {
            PromaterialPrintSettlementDetailVO printVo;
            String key = "" + detailEntity.getMaterialId() + detailEntity.getStoreTaxPrice() + detailEntity.getTaxPrice();
            if (map.containsKey(key)) {
                printVo = (PromaterialPrintSettlementDetailVO)map.get(key);
                BigDecimal storeSum = CommonUtils.addBigDecimal(printVo.getStoreNum(), detailEntity.getStoreNum());
                BigDecimal sum = CommonUtils.addBigDecimal(printVo.getNum(), detailEntity.getNum());
                BigDecimal storeTaxMny = CommonUtils.addBigDecimal(printVo.getStoreTaxMny(), detailEntity.getStoreTaxMny());
                BigDecimal taxMny = CommonUtils.addBigDecimal(printVo.getTaxMny(), detailEntity.getTaxMny());
                printVo.setStoreNum(storeSum);
                printVo.setNum(sum);
                printVo.setStoreTaxMny(storeTaxMny);
                printVo.setTaxMny(taxMny);
                printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
                continue;
            }
            printVo = (PromaterialPrintSettlementDetailVO)BeanMapper.map((Object)((Object)detailEntity), PromaterialPrintSettlementDetailVO.class);
            List thisMaterialList = (List)thisMap.get(detailEntity.getMaterialId());
            BigDecimal thisSettleNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)thisMaterialList)) {
                for (PromaterialSettlementDetailEntity promaterialSettlementDetailEntity : thisMaterialList) {
                    thisSettleNum = thisSettleNum.add(CommonUtils.setBigDecimalDefaultValue(promaterialSettlementDetailEntity.getNum()));
                }
            }
            printVo.setThisSettleNum(thisSettleNum);
            printVo.setSettleDiff(CommonUtils.subtractBigDecimal(printVo.getTaxMny(), printVo.getStoreTaxMny()));
            map.put(key, printVo);
        }
        rtnList = new ArrayList(map.values());
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PromaterialPrintSettlementDetailVO::getThisSettleNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed().thenComparing(PromaterialPrintSettlementDetailVO::getNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    @Override
    public List<PromaterialPrintSettlementFeeVO> queryPrintSettlementFee(PromaterialSettlementVO promaterialSettlementVO) {
        ArrayList<PromaterialPrintSettlementFeeVO> rtnList = new ArrayList<PromaterialPrintSettlementFeeVO>();
        List<PromaterialSettlementEntity> list = this.queryListByContractId(promaterialSettlementVO);
        if (CollectionUtils.isEmpty(list)) {
            return rtnList;
        }
        List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settlementId", new Parameter("in", idList));
        List feeEntityList = this.settlementFeeService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)feeEntityList)) {
            return rtnList;
        }
        Map<Object, Object> thisMap = new HashMap();
        Map<Object, Object> thisNoContractMap = new HashMap();
        if (promaterialSettlementVO.getId() != null) {
            List thisDetailList = feeEntityList.stream().filter(t -> t.getSettlementId().equals(promaterialSettlementVO.getId())).collect(Collectors.toList());
            thisMap = thisDetailList.stream().filter(t -> t.getSourceId() != null).collect(Collectors.groupingBy(PromaterialSettlementFeeEntity::getSourceDetailId));
            thisNoContractMap = thisDetailList.stream().filter(t -> t.getSourceId() == null).collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
        }
        HashMap<String, PromaterialPrintSettlementFeeVO> map = new HashMap<String, PromaterialPrintSettlementFeeVO>();
        for (PromaterialSettlementFeeEntity feeEntity : feeEntityList) {
            PromaterialPrintSettlementFeeVO printFeeVo;
            if (feeEntity.getSourceId() == null) {
                printFeeVo = (PromaterialPrintSettlementFeeVO)BeanMapper.map((Object)((Object)feeEntity), PromaterialPrintSettlementFeeVO.class);
                PromaterialSettlementFeeEntity thisFeeEntity = (PromaterialSettlementFeeEntity)((Object)thisNoContractMap.get(feeEntity.getId()));
                if (thisFeeEntity != null) {
                    printFeeVo.setThisFeeNum(CommonUtils.setBigDecimalDefaultValue(thisFeeEntity.getFeeNum()));
                }
                rtnList.add(printFeeVo);
                continue;
            }
            String key = "" + feeEntity.getSourceId() + feeEntity.getSourceDetailId();
            if (map.containsKey(key)) {
                printFeeVo = (PromaterialPrintSettlementFeeVO)map.get(key);
                BigDecimal feeNum = CommonUtils.addBigDecimal(printFeeVo.getFeeNum(), feeEntity.getFeeNum());
                BigDecimal feeTaxMny = CommonUtils.addBigDecimal(printFeeVo.getFeeTaxMny(), feeEntity.getFeeTaxMny());
                printFeeVo.setFeeNum(feeNum);
                printFeeVo.setFeeTaxMny(feeTaxMny);
                continue;
            }
            printFeeVo = (PromaterialPrintSettlementFeeVO)BeanMapper.map((Object)((Object)feeEntity), PromaterialPrintSettlementFeeVO.class);
            List thisFeeList = (List)thisMap.get(feeEntity.getSourceDetailId());
            BigDecimal thisNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)thisFeeList)) {
                for (PromaterialSettlementFeeEntity feeEntity1 : thisFeeList) {
                    thisNum = thisNum.add(CommonUtils.setBigDecimalDefaultValue(feeEntity1.getFeeNum()));
                }
            }
            printFeeVo.setThisFeeNum(thisNum);
            map.put(key, printFeeVo);
        }
        rtnList.addAll(new ArrayList(map.values()));
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PromaterialPrintSettlementFeeVO::getThisFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed().thenComparing(PromaterialPrintSettlementFeeVO::getFeeNum, Comparator.nullsLast(BigDecimal::compareTo)).reversed());
        }
        return rtnList;
    }

    private List<PromaterialSettlementEntity> queryListByContractId(PromaterialSettlementVO promaterialSettlementVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)promaterialSettlementVO.getContractId()));
        queryParam.getParams().put("settlementType", new Parameter("eq", (Object)promaterialSettlementVO.getSettlementType()));
        queryParam.getOrderMap().put("settlementDate", "desc");
        return super.queryList(queryParam, false);
    }

    @Override
    public PromaterialSettlementVO getDetailListData(PromaterialSettlementVO checkVO) {
        PromaterialContractEntity contractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(checkVO.getContractId()));
        List<PromaterialContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        List checkDetailListPC = checkVO.getCheckDetailList();
        Map contractDetailEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(PromaterialContractDetailEntity::getMaterialId, Function.identity()));
        Map contractDetailTypeEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() == null).collect(Collectors.toMap(PromaterialContractDetailEntity::getMaterialTypeId, Function.identity()));
        List materialIds = checkDetailListPC.stream().map(PromaterialCheckDetailVO::getMaterialId).collect(Collectors.toList());
        for (PromaterialCheckDetailVO checkDetailVO : checkDetailListPC) {
            PromaterialContractDetailEntity contractDetailEntity;
            if (contractDetailEntityMap.containsKey(checkDetailVO.getMaterialId())) {
                contractDetailEntity = (PromaterialContractDetailEntity)((Object)contractDetailEntityMap.get(checkDetailVO.getMaterialId()));
                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
                continue;
            }
            if (contractDetailTypeEntityMap.containsKey(checkDetailVO.getMaterialTypeId())) {
                contractDetailEntity = (PromaterialContractDetailEntity)((Object)contractDetailTypeEntityMap.get(checkDetailVO.getMaterialTypeId()));
                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
                continue;
            }
            checkDetailVO.setTaxRate(contractEntity.getTaxRate());
        }
        CommonResponse commonResponse = this.materialApi.queryMaterialItemByIds(materialIds);
        if (commonResponse.isSuccess()) {
            List materialVOList = (List)commonResponse.getData();
            Map materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            for (PromaterialCheckDetailVO checkDetailVO : checkDetailListPC) {
                if (!materialVOMap.containsKey(checkDetailVO.getMaterialId())) continue;
                MaterialVO materialVO = (MaterialVO)materialVOMap.get(checkDetailVO.getMaterialId());
                checkDetailVO.setSubjectId(materialVO.getSubjectId());
                checkDetailVO.setSubjectName(materialVO.getSubjectName());
            }
        }
        return checkVO;
    }
}

