/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.proother.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherChangeDetailEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherChangeEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherChangeOtherCostEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractClauseEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractDetailEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractOtherCostEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractPaymentEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherRecordEntity;
import com.ejianc.business.steelstructure.proother.contract.mapper.ProotherChangeMapper;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherChangeService;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractClauseService;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractPaymentService;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractService;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherRecordService;
import com.ejianc.business.steelstructure.proother.contract.vo.ChangeCompareVO;
import com.ejianc.business.steelstructure.proother.contract.vo.ChangeDetailVO;
import com.ejianc.business.steelstructure.proother.contract.vo.ChangeVO;
import com.ejianc.business.steelstructure.proother.contract.vo.ContractVO;
import com.ejianc.business.steelstructure.proother.enums.ChangeStatusEnum;
import com.ejianc.business.steelstructure.proother.enums.DraftTypeEnum;
import com.ejianc.business.steelstructure.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.steelstructure.proother.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.proother.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="prootherChangeService")
public class ProotherChangeServiceImpl
extends BaseServiceImpl<ProotherChangeMapper, ProotherChangeEntity>
implements IProotherChangeService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProotherContractService contractService;
    @Autowired
    private IProotherRecordService recordService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProotherContractClauseService contractClauseService;
    @Autowired
    private IProotherContractPaymentService contractPaymentService;
    @Autowired
    private ProotherChangeMapper prootherChangeMapper;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private final String OTHER_OUT_CHANGE_PARAM_CODE = "P-P7Ir1v95";
    private static final String CHECK_PARAM_CODE = "P-434f5499";

    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(id));
        ChangeVO changeVO = new ChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(prootherContractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : prootherContractEntity.getBaseTaxMny());
        changeVO.setContractTaxMny(prootherContractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : prootherContractEntity.getContractTaxMny());
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        param.getParams().put("performance_status", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
        param.getOrderMap().put("change_date", "desc");
        param.getOrderMap().put("create_time", "desc");
        Map resp = new HashMap();
        QueryWrapper wrapper = ProotherChangeServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(change_mny) as sumChangeMoney, count(*) as changeNum"});
        resp = super.getMap((Wrapper)wrapper);
        changeVO.setChangeList(BeanMapper.mapList((Iterable)this.queryList(param), ChangeVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != prootherContractEntity.getBaseTaxMny() && prootherContractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
            changeAmtRate = sumChangeMoney.divide(prootherContractEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
        }
        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long)resp.get("changeNum");
        changeVO.setChangeNum(Integer.valueOf(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0));
        changeVO.setChangeMnyRate(changeAmtRate);
        changeVO.setSupplementFlag(prootherContractEntity.getSupplementFlag());
        changeVO.setAddType(prootherContractEntity.getAddType());
        changeVO.setContractType(prootherContractEntity.getContractType());
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(prootherContractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(prootherContractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(prootherContractEntity.getBillState())) && !ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode().equals(prootherContractEntity.getPerformanceStatus()) && !ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode().equals(prootherContractEntity.getPerformanceStatus())) {
            String filingTypeFlag = this.contractService.getFilingTypeConfig();
            if ("0".equals(filingTypeFlag)) {
                changeVO.setEditFlag(this.editChangeFlag(id));
            } else if (this.editChangeFlag(id).booleanValue() && 1 == prootherContractEntity.getFilingStatus()) {
                changeVO.setEditFlag(Boolean.valueOf(true));
            } else {
                changeVO.setEditFlag(Boolean.valueOf(false));
            }
        } else {
            changeVO.setEditFlag(Boolean.valueOf(false));
        }
        return changeVO;
    }

    @Override
    public Boolean editChangeFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ProotherChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ProotherChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ProotherChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public ChangeVO addConvertByConId(Long contractId, Long changeId) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(contractId, orderMap));
        if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode().equals(prootherContractEntity.getChangeStatus()) && null == changeId) {
            return this.queryDetail(prootherContractEntity.getChangeId());
        }
        ChangeVO changeVO = (ChangeVO)BeanMapper.map((Object)((Object)prootherContractEntity), ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(prootherContractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(prootherContractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(prootherContractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(Integer.valueOf(prootherContractEntity.getChangeVersion() == null ? 1 : prootherContractEntity.getChangeVersion() + 1));
        changeVO.setSignatureStatus(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
        prootherContractEntity.setChangingMny(BigDecimal.ZERO);
        prootherContractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        this.resetSub(changeVO);
        return changeVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ChangeVO insertOrUpdate(ChangeVO changeVO, Boolean isControl) {
        isControl = false;
        ProotherContractEntity contract = (ProotherContractEntity)((Object)this.contractService.selectById(changeVO.getContractId()));
        if (CollectionUtils.isNotEmpty((Collection)changeVO.getAttachIds()) && null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }
        ProotherChangeEntity prootherChangeEntity = (ProotherChangeEntity)((Object)BeanMapper.map((Object)changeVO, ProotherChangeEntity.class));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ProotherChangeEntity::getContractId, (Object)changeVO.getContractId());
        if (changeVO.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ProotherChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ProotherChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (prootherChangeEntity.getId() == null) {
            prootherChangeEntity.setId(IdWorker.getId());
            prootherChangeEntity.setSignatureStatus(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
            prootherChangeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            prootherChangeEntity.setPerformanceStatus(ContractPerformanceStateEnum.\u672a\u7b7e\u8ba2.getStateCode());
            if (prootherChangeEntity.getChangeVersion() < 10) {
                prootherChangeEntity.setBillCode(prootherChangeEntity.getBillCode() + "-1-0" + prootherChangeEntity.getChangeVersion());
            } else {
                prootherChangeEntity.setBillCode(prootherChangeEntity.getBillCode() + "-1-" + prootherChangeEntity.getChangeVersion());
            }
        }
        if (prootherChangeEntity.getChangeFilingStatus() == FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()) {
            prootherChangeEntity.setFilingRef(0);
        } else {
            prootherChangeEntity.setFilingRef(null);
        }
        List<ProotherChangeDetailEntity> beforeDetails = prootherChangeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ProotherChangeDetailEntity detail : beforeDetails) {
                if (null == changeVO.getId() || null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (ProotherChangeDetailEntity detail : beforeDetails) {
                if (!StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
        ContractVO contractVO = this.contractService.queryDetail(changeVO.getContractId());
        if (Boolean.FALSE.equals(isControl)) {
            // empty if block
        }
        if (Boolean.FALSE.equals(isControl)) {
            super.saveOrUpdate((Object)prootherChangeEntity, false);
            this.saveWriteContract(prootherChangeEntity);
            return this.queryDetail(prootherChangeEntity.getId());
        }
        return (ChangeVO)BeanMapper.map((Object)((Object)prootherChangeEntity), ChangeVO.class);
    }

    private ExecutionVO getLastExecutionVO(Long contractId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)contractId)).orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)wrapper);
        if (!list.isEmpty()) {
            return null;
        }
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(contractId));
        return null;
    }

    @Override
    public String getLinkUrl(ChangeVO cv) {
        String linkUrl = 0 == cv.getAddType() ? this.BaseHost + "ejc-steelstructure-frontend/#/otherSubList/changeCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&cid=" + cv.getId() + "&cardType=otherSubCard" : this.BaseHost + "ejc-steelstructure-frontend/#/otherSubList/changeCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&cid=" + cv.getId() + "&cardType=otherSubDirectCard";
        return linkUrl;
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ProotherChangeEntity prootherChangeEntity = (ProotherChangeEntity)((Object)super.selectById((Serializable)id, orderMap));
        ChangeVO changeVO = new ChangeVO();
        if (null != prootherChangeEntity) {
            changeVO = (ChangeVO)BeanMapper.map((Object)((Object)prootherChangeEntity), ChangeVO.class);
        }
        ArrayList<Long> srcTblIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)changeVO.getDetailList())) {
            for (ChangeDetailVO detail : changeVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                srcTblIdList.add(detail.getSrcTblId());
            }
            changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeVO.getDetailList()));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ProotherChangeEntity entity = (ProotherChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)prootherContractEntity.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)query);
        prootherContractEntity.setChangeVersion(prootherContractEntity.getChangeVersion() - 1);
        prootherContractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        prootherContractEntity.setChangingMny(BigDecimal.ZERO);
        prootherContractEntity.setChangingTaxMny(BigDecimal.ZERO);
        prootherContractEntity.setChangeCode(null);
        prootherContractEntity.setChangeId(null);
        prootherContractEntity.setChangeDate(null);
        prootherContractEntity.setChangeDraftType(null);
        prootherContractEntity.setChangeContractSignatureStatus(null);
        prootherContractEntity.setChangeFileId(null);
        prootherContractEntity.setChangeContractName(null);
        this.contractService.update((Object)prootherContractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)prootherContractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<String, String>();
        orderByParams.put("treeIndex", "asc");
        HashMap<String, LinkedHashMap<String, String>> orders = new HashMap<String, LinkedHashMap<String, String>>();
        orders.put("detailList", orderByParams);
        ProotherChangeEntity prootherChangeEntity = (ProotherChangeEntity)((Object)super.selectById((Serializable)id, orders));
        ChangeCompareVO changeCompareVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)prootherChangeEntity), ChangeCompareVO.class);
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(prootherChangeEntity.getContractId()));
        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(prootherChangeEntity.getBillState())) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambda.eq(ProotherRecordEntity::getChangeId, (Object)id)).eq(ProotherRecordEntity::getContractId, (Object)prootherChangeEntity.getContractId())).orderByDesc(BaseEntity::getCreateTime);
            List recordList = this.recordService.list((Wrapper)lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null) {
                beforeChangeVO = (ChangeCompareVO)BeanMapper.map(recordList.get(0), ChangeCompareVO.class);
            }
        } else {
            beforeChangeVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)prootherContractEntity), ChangeCompareVO.class);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getDetailList())) {
                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree(changeCompareVO.getDetailList().stream().filter(detail -> StringUtils.isNotBlank((CharSequence)detail.getChangeType())).collect(Collectors.toList())));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getOtherCostList())) {
                changeCompareVO.setOtherCostList(changeCompareVO.getOtherCostList().stream().filter(cost -> null != cost.getChangeType()).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getClauseList())) {
                changeCompareVO.setClauseList(changeCompareVO.getClauseList().stream().filter(clause -> null == clause.getBeforeClauseContent() || !clause.getBeforeClauseContent().equals(clause.getClauseContent())).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getPaymentList())) {
                changeCompareVO.setPaymentList(changeCompareVO.getPaymentList().stream().filter(payment -> null == payment.getBeforePaymentScale() || !payment.getBeforePaymentScale().equals(payment.getPaymentScale())).collect(Collectors.toList()));
            }
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    private void saveWriteContract(ProotherChangeEntity prootherChangeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ProotherContractEntity::getChangeId, (Object)prootherChangeEntity.getId());
        if (null != prootherChangeEntity.getChangeMny() && null != prootherChangeEntity.getChangeTax()) {
            updateWrapper.set(ProotherContractEntity::getChangingMny, (Object)prootherChangeEntity.getChangeMny().subtract(prootherChangeEntity.getChangeTax()));
        }
        updateWrapper.set(ProotherContractEntity::getChangingTaxMny, (Object)prootherChangeEntity.getChangeMny());
        updateWrapper.set(ProotherContractEntity::getChangeCode, (Object)prootherChangeEntity.getBillCode());
        updateWrapper.set(ProotherContractEntity::getChangeVersion, (Object)prootherChangeEntity.getChangeVersion());
        updateWrapper.set(ProotherContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(ProotherContractEntity::getChangeDate, (Object)prootherChangeEntity.getChangeDate());
        updateWrapper.set(ProotherContractEntity::getChangeDraftType, (Object)prootherChangeEntity.getChangeDraftType());
        updateWrapper.set(ProotherContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(prootherChangeEntity.getSignatureStatus()));
        updateWrapper.set(ProotherContractEntity::getChangeFileId, (Object)prootherChangeEntity.getChangeFileId());
        updateWrapper.set(ProotherContractEntity::getChangeContractName, (Object)prootherChangeEntity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)prootherChangeEntity.getContractId());
        this.contractService.update(this.contractService.selectById(prootherChangeEntity.getContractId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public ChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)prootherContractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)changeId));
        queryParam.getOrderMap().put("createTime", "desc");
        List recordList = this.recordService.queryList(queryParam);
        ChangeVO changeVO = new ChangeVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            changeVO = (ChangeVO)BeanMapper.map(recordList.get(0), ChangeVO.class);
        }
        if (changeVO != null) {
            this.resetSub(changeVO);
        }
        return changeVO;
    }

    private void resetSub(ChangeVO changeVO) {
        List payList;
        List changeClauseList;
        List changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
            ArrayList srcTblIdList = new ArrayList();
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getDetailNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getDetailPrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getDetailTaxRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("edit");
                srcTblIdList.add(changeDetailVO.getSrcTblId());
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeDetailList));
        List changeOtherCostVOList = changeVO.getOtherCostList();
        if (CollectionUtils.isNotEmpty((Collection)changeOtherCostVOList)) {
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostTaxRate());
                changeOtherCostVO.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(changeClauseList = changeVO.getClauseList()))) {
            changeClauseList.forEach(changeClauseVO -> {
                changeClauseVO.setRowState("add");
                changeClauseVO.setSrcTblId(changeClauseVO.getId());
                changeClauseVO.setBeforeClauseContent(changeClauseVO.getClauseContent());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(payList = changeVO.getPaymentList()))) {
            payList.forEach(item -> {
                item.setRowState("add");
                item.setSrcTblId(item.getId());
                item.setBeforePaymentScale(item.getPaymentScale());
            });
        }
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState, boolean filingFlag) {
        List<ProotherContractOtherCostEntity> contractOtherCostList;
        List<ProotherContractDetailEntity> contractDetailList;
        CommonResponse resp = null;
        ProotherChangeEntity prootherChangeEntity = (ProotherChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        if (commitState.booleanValue()) {
            prootherChangeEntity.setCommitDate(new Date());
            prootherChangeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            prootherChangeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\uff01\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)prootherChangeEntity)));
        ContractVO contractVO = this.contractService.queryDetail(prootherChangeEntity.getContractId());
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"contract_id", (Object)contractVO.getId());
        countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int curRecordVersion = this.recordService.count((Wrapper)countQuery);
        HashMap contIdVersionMap = new HashMap();
        ProotherRecordEntity prootherRecordEntity = (ProotherRecordEntity)((Object)BeanMapper.map((Object)contractVO, ProotherRecordEntity.class));
        prootherRecordEntity.setContractId(prootherRecordEntity.getId());
        prootherRecordEntity.setChangeVersion(curRecordVersion + 1);
        prootherRecordEntity.setId(null);
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)prootherRecordEntity)));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(prootherRecordEntity.getDetailList()));
        if (CollectionUtils.isNotEmpty(prootherRecordEntity.getDetailList())) {
            prootherRecordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(prootherRecordEntity.getClauseList())) {
            prootherRecordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(prootherRecordEntity.getOtherCostList())) {
            prootherRecordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(prootherRecordEntity.getPaymentList())) {
            prootherRecordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString(prootherRecordEntity.getDetailList()));
        this.recordService.saveOrUpdate((Object)prootherRecordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        resp = this.copyFile(contractVO.getId().toString(), ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getBillTypeCode(), prootherRecordEntity.getId().toString(), ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u8bb0\u5f55.getBillTypeCode(), "subContractBill", true);
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u539f\u5408\u540c\u9644\u4ef6\u5230\u8bb0\u5f55\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u5408\u540c\u8868,contractVO---------------->: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)BeanMapper.map((Object)contractVO, ProotherContractEntity.class));
        prootherContractEntity.setContractName(prootherChangeEntity.getContractName());
        prootherContractEntity.setFirstPartyId(prootherChangeEntity.getFirstPartyId());
        prootherContractEntity.setFirstPartyName(prootherChangeEntity.getFirstPartyName());
        prootherContractEntity.setSupplierId(prootherChangeEntity.getSupplierId());
        prootherContractEntity.setSupplierName(prootherChangeEntity.getSupplierName());
        prootherContractEntity.setSignDate(prootherChangeEntity.getSignDate());
        prootherContractEntity.setSignPlace(prootherChangeEntity.getSignPlace());
        prootherContractEntity.setTaxRate(prootherChangeEntity.getTaxRate());
        prootherContractEntity.setDraftType(prootherChangeEntity.getDraftType());
        prootherContractEntity.setContractFilePath(prootherChangeEntity.getContractFilePath());
        prootherContractEntity.setContractFileId(prootherChangeEntity.getContractFileId());
        prootherContractEntity.setContractTemplateId(prootherChangeEntity.getContractTemplateId());
        prootherContractEntity.setContractTemplateName(prootherChangeEntity.getContractTemplateName());
        prootherContractEntity.setContractFileVersionId(prootherChangeEntity.getContractFileVersionId());
        prootherContractEntity.setContractFileVersion(prootherChangeEntity.getContractFileVersion());
        prootherContractEntity.setProjectAddress(prootherChangeEntity.getProjectAddress());
        prootherContractEntity.setInvoiceTypeName(prootherChangeEntity.getInvoiceTypeName());
        prootherContractEntity.setInvoiceTypeId(prootherChangeEntity.getInvoiceTypeId());
        prootherContractEntity.setTargetResultType(prootherChangeEntity.getTargetResultType());
        prootherContractEntity.setQualifyId(prootherChangeEntity.getQualifyId());
        prootherContractEntity.setQualifyName(prootherChangeEntity.getQualifyName());
        prootherContractEntity.setQualifyCertifyNo(prootherChangeEntity.getQualifyCertifyNo());
        prootherContractEntity.setQualifyLicenceIssuingAuthority(prootherChangeEntity.getQualifyLicenceIssuingAuthority());
        prootherContractEntity.setQualifyGrantDate(prootherChangeEntity.getQualifyGrantDate());
        prootherContractEntity.setQualifyValidTillDate(prootherChangeEntity.getQualifyValidTillDate());
        prootherContractEntity.setSafetyProductionLicenseNo(prootherChangeEntity.getSafetyProductionLicenseNo());
        prootherContractEntity.setSafetyCertifyGrantDate(prootherChangeEntity.getSafetyCertifyGrantDate());
        prootherContractEntity.setSafetyCertifyValidTillDate(prootherChangeEntity.getSafetyCertifyValidTillDate());
        prootherContractEntity.setProjectStartDate(prootherChangeEntity.getProjectStartDate());
        prootherContractEntity.setPlannedFinishDate(prootherChangeEntity.getPlannedFinishDate());
        prootherContractEntity.setContractDaysLimit(prootherChangeEntity.getContractDaysLimit());
        prootherContractEntity.setFirstPartyProjectManagerId(prootherChangeEntity.getFirstPartyProjectManagerId());
        prootherContractEntity.setFirstPartyProjectManagerLink(prootherChangeEntity.getFirstPartyProjectManagerLink());
        prootherContractEntity.setFirstPartyProjectManagerName(prootherChangeEntity.getFirstPartyProjectManagerName());
        prootherContractEntity.setFirstPartyProjectManagerPost(prootherChangeEntity.getFirstPartyProjectManagerPost());
        prootherContractEntity.setSupplierProjectManagerId(prootherChangeEntity.getSupplierProjectManagerId());
        prootherContractEntity.setSupplierProjectManagerIdCard(prootherChangeEntity.getSupplierProjectManagerIdCard());
        prootherContractEntity.setSupplierProjectManagerLink(prootherChangeEntity.getSupplierProjectManagerLink());
        prootherContractEntity.setSupplierProjectManagerName(prootherChangeEntity.getSupplierProjectManagerName());
        prootherContractEntity.setSupplierProjectManagerPost(prootherChangeEntity.getSupplierProjectManagerPost());
        prootherContractEntity.setContractTaxMny(prootherChangeEntity.getContractTaxMny());
        prootherContractEntity.setContractMny(prootherChangeEntity.getContractMny());
        prootherContractEntity.setContractTax(prootherChangeEntity.getContractTax());
        prootherContractEntity.setSubContractTaxMny(prootherChangeEntity.getSubContractTaxMny());
        prootherContractEntity.setSubContractMny(prootherChangeEntity.getSubContractMny());
        prootherContractEntity.setSubContractTax(prootherChangeEntity.getSubContractTax());
        prootherContractEntity.setOtherCostMny(prootherChangeEntity.getOtherCostMny());
        prootherContractEntity.setOtherCostTaxMny(prootherChangeEntity.getOtherCostTaxMny());
        prootherContractEntity.setOtherCostTaxMny(prootherChangeEntity.getOtherCostTaxMny());
        prootherContractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        prootherContractEntity.setChangingMny(null);
        prootherContractEntity.setChangingTaxMny(null);
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        prootherChangeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        prootherChangeEntity.setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
        prootherChangeEntity.setEffectiveDate(new Date());
        if (filingFlag) {
            prootherChangeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            prootherChangeEntity.setFilingRef(0);
        }
        if ((resp = this.copyFile(changeBillId.toString(), billTypeCode, prootherContractEntity.getId().toString(), ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getBillTypeCode(), "subChangeContractFile", false)) != null) {
            this.logger.error("\u540c\u6b65\u53d8\u66f4\u9644\u4ef6\u5230\u539f\u5408\u540c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        super.saveOrUpdate((Object)prootherChangeEntity, false);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u5408\u540c\u72b6\u6001\u548c\u6570\u636e,changeEntity---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)prootherChangeEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u5230\u4e3b\u5408\u540c\u5f00\u59cb----------->" + prootherContractEntity.getChangeStatus());
        ProotherContractEntity contractChangeEntity = (ProotherContractEntity)((Object)BeanMapper.map((Object)((Object)prootherChangeEntity), ProotherContractEntity.class));
        List<ProotherChangeDetailEntity> changeDetailList = prootherChangeEntity.getDetailList();
        HashMap changDetailIdMap = new HashMap();
        HashMap changeParentIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailEntity -> changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId() != null ? changeDetailEntity.getSrcTblId() : IdWorker.getId()));
            changeDetailList.forEach(changeDetailEntity -> {
                if (changeDetailEntity.getParentId() != null) {
                    changeParentIdMap.put(changeDetailEntity.getId(), changDetailIdMap.get(changeDetailEntity.getParentId()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(contractDetailList = contractChangeEntity.getDetailList())) {
            Long contractBid = null;
            for (ProotherContractDetailEntity prootherContractDetailEntity : contractDetailList) {
                contractBid = (Long)changDetailIdMap.get(prootherContractDetailEntity.getId());
                prootherContractDetailEntity.setContractId(prootherChangeEntity.getContractId());
                prootherContractDetailEntity.setChangeBid(prootherContractDetailEntity.getId());
                if (null != prootherContractDetailEntity.getParentId()) {
                    prootherContractDetailEntity.setParentId((Long)changDetailIdMap.get(prootherContractDetailEntity.getParentId()));
                }
                prootherContractDetailEntity.setId(contractBid);
                prootherContractDetailEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                prootherContractDetailEntity.setChangeType(null);
            }
        }
        prootherContractEntity.setDetailList(contractDetailList);
        List<ProotherChangeOtherCostEntity> changeOtherCostList = prootherChangeEntity.getOtherCostList();
        HashMap changOtherCostIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)) {
            changeOtherCostList.forEach(changeOtherCostEntity -> changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId()));
        }
        if (CollectionUtils.isNotEmpty(contractOtherCostList = contractChangeEntity.getOtherCostList())) {
            Long contractBid = null;
            for (ProotherContractOtherCostEntity prootherContractOtherCostEntity : contractOtherCostList) {
                contractBid = (Long)changOtherCostIdMap.get(prootherContractOtherCostEntity.getId());
                prootherContractOtherCostEntity.setChangeBid(prootherContractOtherCostEntity.getId());
                prootherContractOtherCostEntity.setId(contractBid);
                prootherContractOtherCostEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                prootherContractOtherCostEntity.setContractId(prootherContractEntity.getId());
            }
        }
        prootherContractEntity.setOtherCostList(contractOtherCostList);
        List<ProotherContractClauseEntity> contractClauseList = prootherContractEntity.getClauseList();
        List<ProotherContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if (CollectionUtils.isNotEmpty(contractClauseList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u6761\u6b3e\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractClauseList));
            this.contractClauseService.deleteByIds(contractClauseList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(prootherContractEntity.getId());
            });
        }
        prootherContractEntity.setClauseList(contractChangeClauseList);
        List<ProotherContractPaymentEntity> contractPayList = prootherContractEntity.getPaymentList();
        List<ProotherContractPaymentEntity> pList = contractChangeEntity.getPaymentList();
        if (CollectionUtils.isNotEmpty(contractPayList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u4ed8\u6b3e\u9636\u6bb5\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractPayList));
            this.contractPaymentService.deleteByIds(contractPayList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(prootherContractEntity.getId());
            });
        }
        prootherContractEntity.setPaymentList(pList);
        this.contractService.saveOrUpdate((Object)prootherContractEntity, false);
        this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)prootherContractEntity), ContractVO.class));
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)prootherContractEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public List<ChangeDetailVO> selectUsefulByIds(List<Long> srcTblIdList) {
        return this.prootherChangeMapper.selectUsefulByIds(srcTblIdList);
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {
        CommonResponse copyContractFileResp;
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, "subContractBill");
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractBill", targetBillId, targetBillTypeCode, "subContractBill", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        if (copyContractFile && !(copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile")).isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile", copyContractFileResp.getMsg()});
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg()));
        }
        return null;
    }

    @Override
    public Collection<? extends ParamsCheckVO> checkParamsConstruction(ChangeVO vo) {
        CommonResponse contractionData = this.contractPoolApi.queryContractionTaxMny(vo.getProjectId());
        if (!contractionData.isSuccess() || null == contractionData.getData()) {
            this.logger.info(contractionData.getMsg());
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        BigDecimal contractionTaxMny = new BigDecimal(String.valueOf(contractionData.getData()));
        this.logger.info("\u83b7\u53d6\u9879\u76ee\uff1a{}\u4e0b\uff0c\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)vo.getProjectId(), (Object)contractionTaxMny);
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        if (BigDecimal.ZERO.compareTo(contractionTaxMny) == 0) {
            return paramsCheckVOList;
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                CommonResponse projectData = this.executionApi.queryTotalContMny(vo.getProjectId());
                if (!projectData.isSuccess() || null == projectData.getData()) {
                    this.logger.info(projectData.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                BigDecimal allExpenseContractTaxMny = new BigDecimal(String.valueOf(projectData.getData()));
                this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u9879\u76ee\uff1a{}\u4e0b\uff0c\u6240\u6709\u652f\u51fa\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)vo.getProjectId(), (Object)allExpenseContractTaxMny);
                BigDecimal thisTimeChangeTaxMny = vo.getChangeMny();
                this.logger.info("\u672c\u6b21\u53d8\u52a8\u91d1\u989d\uff1a{}", (Object)thisTimeChangeTaxMny);
                for (BillParamVO billParamVO : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractionTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    this.logger.info("\u65bd\u5de5\u5408\u540c\u91d1\u989d*\u6bd4\u4f8b\u540e\u91d1\u989d\uff1a{}", (Object)comMny);
                    BigDecimal sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)allExpenseContractTaxMny, (BigDecimal)thisTimeChangeTaxMny).setScale(2, 4);
                    this.logger.info("\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a{}", (Object)sumPayContractTaxMny);
                    if (sumPayContractTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u652f\u51fa\u8d85\u65bd\u5de5\u5408\u540c");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u652f\u51fa\u5408\u540c\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(vo.getContractTaxMny()).append("\u5143\uff0c\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(sumPayContractTaxMny).append("\u5143\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumPayContractTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    this.logger.info("paramsCheckDsVO:{}", (Object)JSONObject.toJSONString((Object)paramsCheckDsVO));
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> changeMnyCtrl(ChangeVO changeVO, Boolean flag) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> checkList = new ArrayList<ParamsCheckVO>();
        CommonResponse paramListResp = this.paramConfigApi.getBillParamByCodeAndOrgId("P-P7Ir1v95", changeVO.getOrgId());
        if (!paramListResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6 \u5176\u4ed6\u652f\u51fa\u5408\u540c-\u53d8\u66f4 \u53c2\u6570\u63a7\u5236\u89c4\u5219\u5931\u8d25\uff0c {}", (Object)JSONObject.toJSONString((Object)paramListResp));
            return checkList;
        }
        BigDecimal roleValue = null;
        ParamsCheckVO paramsCheckVO = null;
        ArrayList<ParamsCheckDsVO> dataSource = null;
        for (BillParamVO billParamVO : (List)paramListResp.getData()) {
            dataSource = new ArrayList<ParamsCheckDsVO>();
            roleValue = billParamVO.getRoleValue();
            paramsCheckVO = new ParamsCheckVO();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                BigDecimal baseTaxMny = changeVO.getBaseTaxMny();
                BigDecimal contractTaxMny = changeVO.getContractTaxMny();
                BigDecimal changeTaxMny = contractTaxMny.subtract(baseTaxMny);
                BigDecimal changeTaxMnyTime = contractTaxMny.subtract(changeVO.getBeforeChangeTaxMny());
                BigDecimal conTaxMny = baseTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                if (changeTaxMny.compareTo(conTaxMny) > 0) {
                    BigDecimal overTaxMny = changeTaxMny.subtract(conTaxMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u53d8\u66f4\u8d85\u5408\u540c\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff1a").append(changeTaxMnyTime.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff1a").append(changeTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(conTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            checkList.add(paramsCheckVO);
        }
        return checkList;
    }
}

