/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.proother.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractEntity;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractService;
import com.ejianc.business.steelstructure.proother.enums.BillPushStatusEnum;
import com.ejianc.business.steelstructure.proother.settle.bean.ProotherSettleEntity;
import com.ejianc.business.steelstructure.proother.settle.enums.SettleTypeEnum;
import com.ejianc.business.steelstructure.proother.settle.service.IProotherSettleService;
import com.ejianc.business.steelstructure.proother.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="prootherSettle")
public class ProotherSettleBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProotherSettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProotherContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IExecutionApi executionApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        boolean poolRes;
        ProotherSettleEntity prootherSettleEntity = (ProotherSettleEntity)((Object)this.service.selectById(billId));
        if (prootherSettleEntity != null) {
            prootherSettleEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            prootherSettleEntity.setCommitDate(new Date());
            prootherSettleEntity.setCommitUserCode(userContext.getUserCode());
            prootherSettleEntity.setCommitUserName(userContext.getUserName());
        }
        prootherSettleEntity.setPushPoolFlag((poolRes = this.service.pushSettleToPool((SettleVO)BeanMapper.map((Object)((Object)prootherSettleEntity), SettleVO.class))) ? BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus() : BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.saveOrUpdate((Object)prootherSettleEntity, false);
        this.service.costPush(prootherSettleEntity);
        if (prootherSettleEntity.getSettleType() == 1) {
            if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || state.equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                String linkUrl = this.BaseHost + "ejc-proother-frontend/#/settleList/card?id=" + prootherSettleEntity.getId();
                ExecutionVO executionVO = this.service.targetCost((SettleVO)BeanMapper.map((Object)((Object)prootherSettleEntity), SettleVO.class), linkUrl);
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            }
            return CommonResponse.success((String)"\u5b8c\u5de5\u7ed3\u7b97\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u8fc7\u7a0b\u7ed3\u7b97\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5b8c\u5de5\u5355\u636ebillId-{}, state-{}, billTypeCode-{}\u64a4\u56de\u524d\u6821\u9a8c", new Object[]{billId, state, billTypeCode});
        ProotherSettleEntity prootherSettleEntity = (ProotherSettleEntity)((Object)this.service.selectById(billId));
        if (prootherSettleEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(ProotherSettleEntity::getContractId, (Object)prootherSettleEntity.getContractId());
        settleLambda.ne(BaseEntity::getId, (Object)billId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(ProotherSettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = this.service.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = null != ((ProotherSettleEntity)((Object)resultList.get(0))).getSettleType() ? SettleTypeEnum.getDescriptionByCode((Integer)((ProotherSettleEntity)((Object)resultList.get(0))).getSettleType()).getDescription() : "";
            return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684" + settleTypeName + "\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!"));
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)prootherSettleEntity.getContractId()));
        param.getOrderMap().put("create_time", "desc");
        List settleList = this.service.queryList(param);
        this.logger.info("\u67e5\u8be2\u8fc7\u7a0b\u7ed3\u7b97\u4fe1\u606f\uff1acontractId-" + prootherSettleEntity.getContractId());
        if (CollectionUtils.isNotEmpty((Collection)settleList) && null != settleList.get(0)) {
            this.logger.info("\u67e5\u8be2\u6700\u65b0\u7684\u8fc7\u7a0b\u7ed3\u7b97\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(settleList.get(0), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            ProotherSettleEntity processSettle = (ProotherSettleEntity)((Object)settleList.get(0));
            this.logger.info("nodeSettle.id-" + processSettle.getId());
            this.logger.info("billId-" + billId);
            if (!processSettle.getId().equals(billId)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u65b0\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(prootherSettleEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(prootherSettleEntity.getBillState())) {
            String unPushRes = this.service.delSettleFromPool(prootherSettleEntity.getId());
            if (StringUtils.isBlank((CharSequence)unPushRes)) {
                prootherSettleEntity.setPushPoolFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            } else {
                this.logger.error("\u5c06\u8fc7\u7a0b\u7ed3\u7b97\u5355-{}\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25\uff01", (Object)JSONObject.toJSONString((Object)((Object)prootherSettleEntity)));
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + unPushRes));
            }
        }
        if ("1".equals(prootherSettleEntity.getRelationFlag())) {
            this.service.costDeletePush(prootherSettleEntity);
        }
        if (prootherSettleEntity.getSettleType() == 1) {
            this.logger.info("\u5b8c\u5de5\u7ed3\u7b97\u5f03\u5ba1/\u64a4\u56de\u524d\u56de\u8c03\u7ed3\u7b97\u5b9e\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)prootherSettleEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            QueryParam qq = new QueryParam();
            qq.getParams().put("id", new Parameter("eq", (Object)prootherSettleEntity.getContractId()));
            List contractEntities = this.contractService.queryList(qq, false);
            ((ProotherContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            this.logger.info("======\u5b8c\u5de5\u7ed3\u7b97\u5f03\u5ba1\u524d\u56de\u8c03,\u4fee\u6539\u5408\u540c\u72b6\u6001\u4e3a\u5c65\u7ea6\u4e2d======,{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
            this.contractService.saveOrUpdate(contractEntities.get(0), false);
        } else {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(ProotherSettleEntity::getContractId, (Object)prootherSettleEntity.getContractId());
            lambda.eq(ProotherSettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
            int resultCount = this.service.count((Wrapper)lambda);
            this.logger.info("\u67e5\u8be2\u6700\u7ec8\u7ed3\u7b97\u4fe1\u606f\uff1acontractId-" + prootherSettleEntity.getContractId());
            this.logger.info("\u67e5\u8be2\u6700\u7ec8\u7ed3\u7b97\u7ed3\u679c\uff1aresultCount-" + resultCount);
            if (resultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6240\u7528\u5408\u540c\u5df2\u88ab\u5b8c\u5de5\u7ed3\u7b97\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        this.service.saveOrUpdate((Object)prootherSettleEntity, false);
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ExecutionVO executionVO = this.service.targetCost((SettleVO)BeanMapper.map((Object)((Object)prootherSettleEntity), SettleVO.class), "");
        totalExecutionVOList.add(executionVO.getTotalVO());
        this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

