/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.prosub.prosub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.ChangeCompareVO;
import com.ejianc.business.prosub.vo.ChangeDetailVO;
import com.ejianc.business.prosub.vo.ChangeVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ChangeDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ChangeEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ChangeOtherCostEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractClauseEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractOtherCostEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractPaymentEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.RecordEntity;
import com.ejianc.business.steelstructure.prosub.prosub.enums.ChangeStatusEnum;
import com.ejianc.business.steelstructure.prosub.prosub.enums.ContractFilingTypeEnum;
import com.ejianc.business.steelstructure.prosub.prosub.enums.DraftTypeEnum;
import com.ejianc.business.steelstructure.prosub.prosub.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.prosub.prosub.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.ChangeMapper;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.ContractMapper;
import com.ejianc.business.steelstructure.prosub.prosub.service.IChangeService;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractClauseService;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractFileService;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractPaymentService;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractService;
import com.ejianc.business.steelstructure.prosub.prosub.service.IRecordService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="changeService")
public class ChangeServiceImpl
extends BaseServiceImpl<ChangeMapper, ChangeEntity>
implements IChangeService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractFileService contractFileService;
    @Autowired
    private IRecordService recordService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractPaymentService contractPaymentService;
    @Autowired
    private ChangeMapper changeMapper;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";
    private final String LABORSUB_Bill_CODE = "BT211108000000002";
    private final String LABORSUB_RECORD_Bill_CODE = "BT211108000000004";
    private final String PROSUB_Bill_CODE = "BT220216000000003";
    private final String PROSUB_RECORD_Bill_CODE = "BT220216000000005";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private final String LAB_CHANGE_PARAM_CODE = "P-26y61564";
    private final String PRO_CHANGE_PARAM_CODE = "P-D73e5K68";
    private final String LAB_CHANGE_PLAN_NUM_CTRL_CON_NUM = "P-29O92c0105";
    private final String PRO_CHANGE_PLAN_NUM_CTRL_CON_NUM = "P-90sLe50106";
    private final String LAB_CHANGE_PLAN_MNY_CTRL_CON_MNY = "P-uOc2160107";
    private final String PRO_CHANGE_PLAN_MNY_CTRL_CON_MNY = "P-66ZB8r0108";
    private final String LAB_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-51g2FF0175";
    private final String PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-66o3LH0177";
    private final String LAB_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-sT2I640176";
    private final String PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-1L8c900178";
    private static final String PRICE_LIB_CHECK_TYPE = "P-5ukonG0162";
    private static final String CHECK_PARAM_CODE = "P-434f5499";
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    private String GenerateBillCodeType;

    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ChangeVO changeVO = new ChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        param.getParams().put("performance_status", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        param.getOrderMap().put("change_date", "desc");
        param.getOrderMap().put("create_time", "desc");
        Map resp = new HashMap();
        QueryWrapper wrapper = ChangeServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(change_mny) as sumChangeMoney, count(*) as changeNum"});
        resp = super.getMap((Wrapper)wrapper);
        changeVO.setChangeList(BeanMapper.mapList((Iterable)this.queryList(param), ChangeVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
            changeAmtRate = sumChangeMoney.divide(contractEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
        }
        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long)resp.get("changeNum");
        changeVO.setChangeNum(Integer.valueOf(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0));
        changeVO.setChangeMnyRate(changeAmtRate);
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        changeVO.setContractType(contractEntity.getContractType());
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getPerformanceStatus()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus())) {
            Boolean contractFilingFlag = this.contractService.checkFilingType(id, ContractFilingTypeEnum.\u5206\u5305\u5408\u540c\u53d8\u66f4.getTypeCode());
            if (this.editChangeFlag(id).booleanValue() && contractFilingFlag.booleanValue()) {
                changeVO.setEditFlag(Boolean.valueOf(true));
            } else {
                changeVO.setEditFlag(Boolean.valueOf(false));
            }
        } else {
            changeVO.setEditFlag(Boolean.valueOf(false));
        }
        return changeVO;
    }

    @Override
    public Boolean editChangeFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public ChangeVO addConvertByConId(Long contractId, Long changeId) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId, orderMap));
        if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            return this.queryDetail(contractEntity.getChangeId());
        }
        ChangeVO changeVO = (ChangeVO)BeanMapper.map((Object)((Object)contractEntity), ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(Integer.valueOf(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion() + 1));
        changeVO.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        this.resetSub(changeVO);
        return changeVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ChangeVO insertOrUpdate(ChangeVO changeVO, Boolean isControl) {
        List<ChangeDetailEntity> beforeDetails;
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(changeVO.getContractId()));
        if (CollectionUtils.isNotEmpty((Collection)changeVO.getAttachIds()) && null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }
        ChangeEntity changeEntity = (ChangeEntity)((Object)BeanMapper.map((Object)changeVO, ChangeEntity.class));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId, (Object)changeVO.getContractId());
        if (changeVO.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (changeEntity.getId() == null) {
            changeEntity.setId(IdWorker.getId());
            changeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (StringUtils.isBlank((CharSequence)changeEntity.getBillCode()) || contract.getBillCode().equals(changeEntity.getBillCode())) {
                String type = "-1-";
                if (changeEntity.getChangeVersion() < 10) {
                    changeEntity.setBillCode(contract.getBillCode() + type + "0" + changeEntity.getChangeVersion());
                } else {
                    changeEntity.setBillCode(contract.getBillCode() + type + changeEntity.getChangeVersion());
                }
            } else if (this.checkSameBillCode(changeEntity)) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            ChangeEntity dbEntity = (ChangeEntity)((Object)super.selectById((Serializable)changeEntity.getId()));
            if (StringUtils.isBlank((CharSequence)changeEntity.getBillCode())) {
                changeEntity.setBillCode(dbEntity.getBillCode());
            } else if (!dbEntity.getBillCode().equals(changeEntity.getBillCode()) && this.checkSameBillCode(changeEntity)) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if (changeEntity.getChangeFilingStatus() != null && FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode() == changeEntity.getChangeFilingStatus()) {
            changeEntity.setFilingRef(0);
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = changeEntity.getDetailList())) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ChangeDetailEntity detail : beforeDetails) {
                if (null == detail.getChangeId()) {
                    detail.setChangeId(changeEntity.getId());
                }
                if ("del".equals(detail.getRowState())) continue;
                if (null == changeVO.getId() || null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid().toString() + detail.getSourceType(), detail.getId());
                detail.setParentId(null);
            }
            for (ChangeDetailEntity detail : beforeDetails) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid().toString() + detail.getSourceType()));
            }
        }
        if (Boolean.FALSE.equals(isControl)) {
            boolean delFlag = false;
            if (changeEntity.getId() == null) {
                delFlag = true;
            } else {
                ChangeEntity dbEntity = (ChangeEntity)((Object)this.changeService.selectById(changeEntity.getId()));
                boolean bl = delFlag = dbEntity == null;
            }
            if (delFlag) {
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVO1 = this.getLastExecutionVO(changeEntity.getContractId());
                totalExecutionVOList.add(executionVO1.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(totalExecutionVOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            }
        }
        if (Boolean.FALSE.equals(isControl)) {
            super.saveOrUpdate((Object)changeEntity, false);
            this.saveWriteContract(changeEntity);
            String linkUrl = this.getLinkUrl((ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class));
            ExecutionVO executionVO = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)changeEntity), ContractVO.class), linkUrl, changeEntity.getContractType(), changeEntity.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode());
            this.logger.info("\u5408\u540c\u53d8\u66f4\u4fdd\u5b58\uff0c\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e\uff1a {}", (Object)JSON.toJSONString((Object)executionVO));
            return this.queryDetail(changeEntity.getId());
        }
        return (ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class);
    }

    private ExecutionVO getLastExecutionVO(Long contractId) {
        ExecutionVO executionVO1;
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)contractId)).orderByDesc((Object)"create_time");
        List list = this.changeService.list((Wrapper)wrapper);
        ChangeEntity delTargetEntity = null;
        if (!list.isEmpty()) {
            delTargetEntity = (ChangeEntity)((Object)list.get(0));
            executionVO1 = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)delTargetEntity), ContractVO.class), "", delTargetEntity.getContractType(), delTargetEntity.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode());
        } else {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
            executionVO1 = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), "", contractEntity.getContractType(), contractEntity.getContractType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode());
        }
        return executionVO1;
    }

    @Override
    public String getLinkUrl(ChangeVO cv) {
        String linkUrl = cv.getContractType() == 0 ? (cv.getAddType() == 0 ? this.BaseHost + "ejc-prosub-frontend/#/laborSubList/changeCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&routeType=1&cardType=laborSubCard&performanceStatus=" + cv.getPerformanceStatus() : this.BaseHost + "ejc-prosub-frontend/#/laborSubList/changeCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&routeType=1&cardType=laborSubDirectCard&performanceStatus=" + cv.getPerformanceStatus()) : (cv.getAddType() == 0 ? this.BaseHost + "ejc-prosub-frontend/#/proSubList/changeCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&routeType=1&cardType=proSubCard&performanceStatus=" + cv.getPerformanceStatus() : this.BaseHost + "ejc-prosub-frontend/#/proSubList/changeCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&routeType=1&cardType=proSubDirectCard&performanceStatus=" + cv.getPerformanceStatus());
        return linkUrl;
    }

    private boolean checkSameBillCode(ChangeEntity changeEntity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangeEntity::getBillCode, (Object)changeEntity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != changeEntity.getId() && changeEntity.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)changeEntity.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id, orderMap));
        ChangeVO changeVO = new ChangeVO();
        if (null != changeEntity) {
            changeVO = (ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class);
        }
        ArrayList<Long> srcTblIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)changeVO.getDetailList())) {
            for (ChangeDetailVO detail : changeVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                srcTblIdList.add(detail.getSrcTblId());
            }
            List<ChangeDetailVO> usefulDetailList = this.selectUsefulByIds(changeVO.getDetailList().stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
            HashMap<Long, Integer> usefulDetailMap = new HashMap<Long, Integer>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)) {
                for (ChangeDetailVO c : usefulDetailList) {
                    usefulDetailMap.put(c.getSrcTblId(), c.getUseNum());
                }
            }
            for (ChangeDetailVO c : changeVO.getDetailList()) {
                if (null != usefulDetailMap.get(c.getSrcTblId())) {
                    c.setUseNum(Integer.valueOf(1));
                    continue;
                }
                c.setUseNum(null);
            }
            List<ChangeDetailVO> minDetailNumList = this.selectMinDetailNumByIds(changeVO.getDetailList().stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
            HashMap<Long, BigDecimal> minDetailNumMap = new HashMap<Long, BigDecimal>();
            if (CollectionUtils.isNotEmpty(minDetailNumList)) {
                for (ChangeDetailVO c : minDetailNumList) {
                    minDetailNumMap.put(c.getSrcTblId(), c.getMinDetailNum());
                }
            }
            for (ChangeDetailVO c : changeVO.getDetailList()) {
                if (null != minDetailNumMap.get(c.getSrcTblId())) {
                    c.setMinDetailNum((BigDecimal)minDetailNumMap.get(c.getSrcTblId()));
                    continue;
                }
                c.setMinDetailNum(null);
            }
            changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeVO.getDetailList()));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ChangeEntity entity = (ChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractEntity.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)query);
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<String, String>();
        orderByParams.put("treeIndex", "asc");
        HashMap<String, LinkedHashMap<String, String>> orders = new HashMap<String, LinkedHashMap<String, String>>();
        orders.put("detailList", orderByParams);
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id, orders));
        ChangeCompareVO changeCompareVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), ChangeCompareVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambda.eq(RecordEntity::getChangeId, (Object)id)).eq(RecordEntity::getContractId, (Object)changeEntity.getContractId())).orderByDesc(BaseEntity::getCreateTime);
            List recordList = this.recordService.list((Wrapper)lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null) {
                beforeChangeVO = (ChangeCompareVO)BeanMapper.map(recordList.get(0), ChangeCompareVO.class);
            }
        } else {
            beforeChangeVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)contractEntity), ChangeCompareVO.class);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getDetailList())) {
                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree(changeCompareVO.getDetailList().stream().filter(detail -> StringUtils.isNotBlank((CharSequence)detail.getChangeType())).collect(Collectors.toList())));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getOtherCostList())) {
                changeCompareVO.setOtherCostList(changeCompareVO.getOtherCostList().stream().filter(cost -> StringUtils.isNotBlank((CharSequence)cost.getChangeType())).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getClauseList())) {
                changeCompareVO.setClauseList(changeCompareVO.getClauseList().stream().filter(clause -> null == clause.getBeforeClauseContent() || !clause.getBeforeClauseContent().equals(clause.getClauseContent())).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getPaymentList())) {
                changeCompareVO.setPaymentList(changeCompareVO.getPaymentList().stream().filter(payment -> null == payment.getBeforePaymentScale() || !payment.getBeforePaymentScale().equals(payment.getPaymentScale())).collect(Collectors.toList()));
            }
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    private void saveWriteContract(ChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getChangeId, (Object)changeEntity.getId());
        if (null != changeEntity.getChangeMny() && null != changeEntity.getChangeTax()) {
            updateWrapper.set(ContractEntity::getChangingMny, (Object)changeEntity.getChangeMny().subtract(changeEntity.getChangeTax()));
        }
        updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)changeEntity.getChangeMny());
        updateWrapper.set(ContractEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, (Object)changeEntity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeDraftType, (Object)changeEntity.getChangeDraftType());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(ContractEntity::getChangeFileId, (Object)changeEntity.getChangeFileId());
        updateWrapper.set(ContractEntity::getChangeContractName, (Object)changeEntity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
        this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public ChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)changeId));
        queryParam.getOrderMap().put("createTime", "desc");
        List recordList = this.recordService.queryList(queryParam);
        ChangeVO changeVO = new ChangeVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            changeVO = (ChangeVO)BeanMapper.map(recordList.get(0), ChangeVO.class);
        }
        if (changeVO != null) {
            this.resetSub(changeVO);
        }
        return changeVO;
    }

    private void resetSub(ChangeVO changeVO) {
        List payList;
        List changeClauseList;
        List changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
            ArrayList srcTblIdList = new ArrayList();
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getDetailNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getDetailPrice());
                changeDetailVO.setBeforeChangeArtificialPrice(changeDetailVO.getDetailArtificialPrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getDetailTaxRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("add");
                srcTblIdList.add(changeDetailVO.getSrcTblId());
            });
            List<ChangeDetailVO> usefulDetailList = this.selectUsefulByIds(changeDetailList.stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<Long, Integer>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)) {
                for (ChangeDetailVO c : usefulDetailList) {
                    usefulDetailMap.put(c.getSrcTblId(), c.getUseNum());
                }
            }
            for (ChangeDetailVO c : changeDetailList) {
                if (null != usefulDetailMap.get(c.getSrcTblId())) {
                    c.setUseNum(Integer.valueOf(1));
                    continue;
                }
                c.setUseNum(null);
            }
            List<ChangeDetailVO> minDetailNumList = this.selectMinDetailNumByIds(changeVO.getDetailList().stream().map(ChangeDetailVO::getSrcTblId).collect(Collectors.toList()));
            HashMap<Long, BigDecimal> minDetailNumMap = new HashMap<Long, BigDecimal>();
            if (CollectionUtils.isNotEmpty(minDetailNumList)) {
                for (ChangeDetailVO c : minDetailNumList) {
                    minDetailNumMap.put(c.getSrcTblId(), c.getMinDetailNum());
                }
            }
            for (ChangeDetailVO c : changeVO.getDetailList()) {
                if (null != minDetailNumMap.get(c.getSrcTblId())) {
                    c.setMinDetailNum((BigDecimal)minDetailNumMap.get(c.getSrcTblId()));
                    continue;
                }
                c.setMinDetailNum(null);
            }
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeDetailList));
        List changeOtherCostVOList = changeVO.getOtherCostList();
        if (CollectionUtils.isNotEmpty((Collection)changeOtherCostVOList)) {
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostTaxRate());
                changeOtherCostVO.setChangeType(null);
                changeOtherCostVO.setRowState("add");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(changeClauseList = changeVO.getClauseList()))) {
            changeClauseList.forEach(changeClauseVO -> {
                changeClauseVO.setRowState("add");
                changeClauseVO.setSrcTblId(changeClauseVO.getId());
                changeClauseVO.setChangeType(null);
                changeClauseVO.setBeforeClauseContent(changeClauseVO.getClauseContent());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(payList = changeVO.getPaymentList()))) {
            payList.forEach(item -> {
                item.setRowState("add");
                item.setSrcTblId(item.getId());
                item.setChangeType(null);
                item.setBeforePaymentScale(item.getPaymentScale());
            });
        }
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState, boolean filingFlag) {
        List<ContractOtherCostEntity> contractOtherCostList;
        List<ContractDetailEntity> oldContractDetailList;
        CommonResponse resp = null;
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(changeBillId));
        if (commitState.booleanValue()) {
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\uff01\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        ContractVO contractVO = this.contractService.queryDetail(changeEntity.getContractId());
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"contract_id", (Object)contractVO.getId());
        countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int curRecordVersion = this.recordService.count((Wrapper)countQuery);
        HashMap contIdVersionMap = new HashMap();
        RecordEntity recordEntity = (RecordEntity)((Object)BeanMapper.map((Object)contractVO, RecordEntity.class));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion + 1);
        recordEntity.setId(null);
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)recordEntity)));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getClauseList())) {
            recordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())) {
            recordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPaymentList())) {
            recordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        String srcBillCode = "BT220216000000003";
        String targetBillCode = "BT220216000000005";
        if (contractVO.getContractType().equals(0)) {
            srcBillCode = "BT211108000000002";
            targetBillCode = "BT211108000000004";
        }
        if ((resp = this.copyFile(contractVO.getId().toString(), srcBillCode, recordEntity.getId().toString(), targetBillCode, "subContractBill", true)) != null) {
            this.logger.error("\u540c\u6b65\u539f\u5408\u540c\u9644\u4ef6\u5230\u8bb0\u5f55\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u5408\u540c\u8868,contractVO---------------->: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        ContractEntity contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
        contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFilePath(changeEntity.getContractFilePath());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractEntity.setContractCategoryProperty(changeEntity.getContractCategoryProperty());
        contractEntity.setQualifyId(changeEntity.getQualifyId());
        contractEntity.setQualifyName(changeEntity.getQualifyName());
        contractEntity.setQualifyCertifyNo(changeEntity.getQualifyCertifyNo());
        contractEntity.setQualifyLicenceIssuingAuthority(changeEntity.getQualifyLicenceIssuingAuthority());
        contractEntity.setQualifyGrantDate(changeEntity.getQualifyGrantDate());
        contractEntity.setQualifyValidTillDate(changeEntity.getQualifyValidTillDate());
        contractEntity.setSafetyProductionLicenseNo(changeEntity.getSafetyProductionLicenseNo());
        contractEntity.setSafetyCertifyGrantDate(changeEntity.getSafetyCertifyGrantDate());
        contractEntity.setSafetyCertifyValidTillDate(changeEntity.getSafetyCertifyValidTillDate());
        contractEntity.setProjectStartDate(changeEntity.getProjectStartDate());
        contractEntity.setPlannedFinishDate(changeEntity.getPlannedFinishDate());
        contractEntity.setContractDaysLimit(changeEntity.getContractDaysLimit());
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerLink(changeEntity.getFirstPartyProjectManagerLink());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyProjectManagerPost(changeEntity.getFirstPartyProjectManagerPost());
        contractEntity.setSupplierProjectManagerId(changeEntity.getSupplierProjectManagerId());
        contractEntity.setSupplierProjectManagerIdCard(changeEntity.getSupplierProjectManagerIdCard());
        contractEntity.setSupplierProjectManagerLink(changeEntity.getSupplierProjectManagerLink());
        contractEntity.setSupplierProjectManagerName(changeEntity.getSupplierProjectManagerName());
        contractEntity.setSupplierProjectManagerPost(changeEntity.getSupplierProjectManagerPost());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setSubContractTaxMny(changeEntity.getSubContractTaxMny());
        contractEntity.setSubContractMny(changeEntity.getSubContractMny());
        contractEntity.setSubContractTax(changeEntity.getSubContractTax());
        contractEntity.setOtherCostMny(changeEntity.getOtherCostMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        if (filingFlag) {
            changeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            changeEntity.setFilingRef(0);
        }
        changeEntity.setEffectiveDate(new Date());
        resp = this.copyFile(changeBillId.toString(), billTypeCode, contractEntity.getId().toString(), srcBillCode, "subChangeContractFile", false);
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u53d8\u66f4\u9644\u4ef6\u5230\u539f\u5408\u540c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.changeService.saveOrUpdate((Object)changeEntity);
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(changeEntity.getChangeDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().equals(changeEntity.getChangeDraftType())) {
            this.contractFileService.getSignedFileInfo(changeBillId, "contractChange");
        }
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u5408\u540c\u72b6\u6001\u548c\u6570\u636e,changeEntity---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u5230\u4e3b\u5408\u540c\u5f00\u59cb----------->" + contractEntity.getChangeStatus());
        ContractEntity contractChangeEntity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), ContractEntity.class));
        List<ChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
        HashMap changDetailIdMap = new HashMap();
        HashMap changeParentIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailEntity -> changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId() != null ? changeDetailEntity.getSrcTblId() : IdWorker.getId()));
            changeDetailList.forEach(changeDetailEntity -> {
                if (changeDetailEntity.getParentId() != null) {
                    changeParentIdMap.put(changeDetailEntity.getId(), changDetailIdMap.get(changeDetailEntity.getParentId()));
                }
            });
        }
        List<ContractDetailEntity> contractDetailList = contractChangeEntity.getDetailList();
        Map<Object, Object> oldContractDetailMap = new HashMap();
        if (null != contractVO.getTargetResultId() && CollectionUtils.isNotEmpty(oldContractDetailList = ((ContractEntity)((Object)this.contractService.selectById(contractVO.getId()))).getDetailList())) {
            oldContractDetailMap = oldContractDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
            this.logger.info("\u53d8\u66f4\u5408\u540c\u751f\u6548\u56de\u5199\u6570\u636e-\u65e7\u5b50\u8868\u6570\u636e-oldContractDetailList\uff1a{}", (Object)JSONObject.toJSONString(oldContractDetailList));
            this.logger.info("\u53d8\u66f4\u5408\u540c\u751f\u6548\u56de\u5199\u6570\u636e-\u65e7\u5b50\u8868\u6570\u636e-oldContractDetailMap\uff1a{}", (Object)JSONObject.toJSONString(oldContractDetailMap));
        }
        if (CollectionUtils.isNotEmpty(contractDetailList)) {
            Long contractBid = null;
            for (ContractDetailEntity contractDetailEntity : contractDetailList) {
                contractBid = (Long)changDetailIdMap.get(contractDetailEntity.getId());
                contractDetailEntity.setContractId(changeEntity.getContractId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                if (null != contractDetailEntity.getParentId()) {
                    contractDetailEntity.setParentId((Long)changDetailIdMap.get(contractDetailEntity.getParentId()));
                }
                if (null != oldContractDetailMap && oldContractDetailMap.containsKey(contractBid)) {
                    contractDetailEntity.setDetailTargetResultNum(((ContractDetailEntity)((Object)oldContractDetailMap.get(contractBid))).getDetailTargetResultNum());
                    contractDetailEntity.setDetailTargetResultPrice(((ContractDetailEntity)((Object)oldContractDetailMap.get(contractBid))).getDetailTargetResultPrice());
                    contractDetailEntity.setDetailBaseTargetResultNum(((ContractDetailEntity)((Object)oldContractDetailMap.get(contractBid))).getDetailBaseTargetResultNum());
                    contractDetailEntity.setDetailTargetResultSellId(((ContractDetailEntity)((Object)oldContractDetailMap.get(contractBid))).getDetailTargetResultSellId());
                }
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractDetailEntity.setChangeType(null);
            }
        }
        contractEntity.setDetailList(contractDetailList);
        this.logger.info("\u53d8\u66f4\u5408\u540c\u751f\u6548\u56de\u5199\u6570\u636e-\u65b0\u5b50\u8868\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(contractDetailList));
        List<ChangeOtherCostEntity> changeOtherCostList = changeEntity.getOtherCostList();
        HashMap changOtherCostIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)) {
            changeOtherCostList.forEach(changeOtherCostEntity -> changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId()));
        }
        if (CollectionUtils.isNotEmpty(contractOtherCostList = contractChangeEntity.getOtherCostList())) {
            Long contractBid = null;
            for (ContractOtherCostEntity contractOtherCostEntity : contractOtherCostList) {
                contractBid = (Long)changOtherCostIdMap.get(contractOtherCostEntity.getId());
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setContractId(contractEntity.getId());
            }
        }
        contractEntity.setOtherCostList(contractOtherCostList);
        List<ContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        List<ContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if (CollectionUtils.isNotEmpty(contractClauseList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u6761\u6b3e\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractClauseList));
            this.contractClauseService.deleteByIds(contractClauseList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setClauseList(contractChangeClauseList);
        List<ContractPaymentEntity> contractPayList = contractEntity.getPaymentList();
        List<ContractPaymentEntity> pList = contractChangeEntity.getPaymentList();
        if (CollectionUtils.isNotEmpty(contractPayList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u4ed8\u6b3e\u9636\u6bb5\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractPayList));
            this.contractPaymentService.deleteByIds(contractPayList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setPaymentList(pList);
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        boolean pushContractRes = this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
        if (pushContractRes) {
            this.updateTotalChangeDataByContractId(changeEntity, "approve");
        }
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public void updateTotalChangeDataByContractId(ChangeEntity changeEntity, String type) {
        this.logger.info("\u5408\u540c\u53d8\u66f4" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u548c\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b\uff0c\u5f00\u59cb\uff0cchangeEntity={}\uff0ctype={}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)), (Object)type);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"contract_id", (Object)changeEntity.getContractId())).eq((Object)"performance_status", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        if ("back".equals(type)) {
            wrapper.ne((Object)"id", (Object)changeEntity.getId());
        }
        wrapper.select(new String[]{"sum(ifnull(change_mny, 0)) as totalChangeTaxMny, sum(ifnull(change_mny, 0) - ifnull(change_tax, 0)) as totalChangeMny, sum(ifnull(change_tax, 0)) as totalChangeTax"});
        Map totalChangeMap = this.changeService.getMap((Wrapper)wrapper);
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u5408\u540c\u7684\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u7684\u7d2f\u52a0\u503c\u4f5c\u4e3a\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)totalChangeMap);
        BigDecimal totalChangeTaxMny = BigDecimal.ZERO;
        BigDecimal totalChangeMny = BigDecimal.ZERO;
        BigDecimal totalChangeTax = BigDecimal.ZERO;
        BigDecimal totalChangeRate = BigDecimal.ZERO;
        if (MapUtils.isNotEmpty((Map)totalChangeMap)) {
            totalChangeTaxMny = totalChangeMap.get("totalChangeTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTaxMny").toString());
            totalChangeMny = totalChangeMap.get("totalChangeMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeMny").toString());
            BigDecimal bigDecimal = totalChangeTax = totalChangeMap.get("totalChangeTax") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTax").toString());
            if (null != changeEntity.getBaseTaxMny() && changeEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
                totalChangeRate = totalChangeTaxMny.divide(changeEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
            }
            this.logger.info("\u8ba1\u7b97\uff1a\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b = \u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\uff09 / \u5408\u540c\u521d\u59cb\u91d1\u989d\uff08\u542b\u7a0e\uff09 = {}", (Object)totalChangeRate);
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setTotalChangeTaxMny(totalChangeTaxMny);
            contractPoolVO.setTotalChangeMny(totalChangeMny);
            contractPoolVO.setTotalChangeTax(totalChangeTax);
            contractPoolVO.setTaotalChangeScale(totalChangeRate);
            contractPoolVO.setSourceId(changeEntity.getContractId());
            CommonResponse saveAfterChangeRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("\u5408\u540c\u53d8\u66f4" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u548c\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b\uff0c\u7ed3\u675f\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)saveAfterChangeRes));
        }
    }

    @Override
    public List<ChangeDetailVO> selectUsefulByIds(List<Long> srcTblIdList) {
        return this.changeMapper.selectUsefulByIds(srcTblIdList);
    }

    @Override
    public List<ChangeDetailVO> selectMinDetailNumByIds(List<Long> srcTblIdList) {
        return this.changeMapper.selectMinDetailNumByIds(srcTblIdList);
    }

    @Override
    public ExecutionVO targetCost(ChangeVO contractVO, String linkUrl, Integer contractType, String billTypeCode, boolean lastSourceId) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());
        if (lastSourceId) {
            if (null == contractVO.getId()) {
                totalVO.setLastSourceId(this.getLastExecutionVO(contractVO.getContractId()).getTotalVO().getSourceId());
            } else {
                ChangeEntity change = (ChangeEntity)((Object)super.selectById((Serializable)contractVO.getId()));
                if (null == change) {
                    totalVO.setLastSourceId(this.getLastExecutionVO(contractVO.getContractId()).getTotalVO().getSourceId());
                }
            }
        }
        totalVO.setBillType(billTypeCode);
        if (contractType == 0) {
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getCode());
        } else {
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            List changeDetailVOS = contractVO.getDetailList().stream().filter(item -> item.getDetailNum() != null).collect(Collectors.toList());
            for (ChangeDetailVO contractDetailVO : changeDetailVOS) {
                LabsubCategoryVO categoryVO;
                CommonResponse res;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(contractDetailVO.getId());
                detailExecutionVO.setSourceBillId(contractDetailVO.getChangeId());
                detailExecutionVO.setCategoryId(contractDetailVO.getDocCategoryId());
                if (contractDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                }
                detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                Assert.notNull((Object)contractDetailVO.getDocCategoryId(), (String)"\u6863\u6848\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
                if (0 == contractType) {
                    res = this.shareLabsubApi.queryLabSubByCategoryId(contractDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)contractDetailVO.getDocCategoryId());
                        throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                    }
                    categoryVO = (LabsubCategoryVO)res.getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                    }
                } else {
                    res = this.shareLabsubApi.queryMajorSubByCategoryId(contractDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)contractDetailVO.getDocCategoryId());
                        throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                    }
                    categoryVO = (ProsubCategoryVO)res.getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                    }
                }
                Assert.notNull((Object)contractDetailVO.getDocId(), (String)"\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
                detailExecutionVO.setDocId(contractDetailVO.getDocId());
                if (contractType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                }
                detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                detailExecutionVO.setName(contractDetailVO.getDetailName());
                detailExecutionVO.setUnitName(contractDetailVO.getDetailUnit());
                detailExecutionVO.setNum(contractDetailVO.getDetailNum());
                detailExecutionVO.setMoney(contractDetailVO.getDetailMny());
                detailExecutionVO.setTaxMoney(contractDetailVO.getDetailTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(ChangeVO changeVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        this.logger.info("prosub---ContractServiceImpl---historyPriceCtrlContractPrice()--- \u5386\u53f2\u4ef7\u63a7\u5408\u540c\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)changeVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse response = this.paramConfigApi.getByCode(PRICE_LIB_CHECK_TYPE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u4ef7\u683c\u5e93\u67e5\u8be2\u4ef7\u683c\u7c7b\u578b\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        if (StringUtils.isNotBlank((CharSequence)valueData) && valueData.contains("\u5168\u90e8")) {
            this.logger.info("\u83b7\u53d6\u5206\u5305\u4ef7\u683c\u5e93\u67e5\u8be2\u4ef7\u683c\u7c7b\u578b\u7cfb\u7edf\u53c2\u6570\u4e3a\u5168\u90e8\uff0c\u5219\u4e0d\u505a\u4ef7\u683c\u5e93\u6821\u9a8c\uff01");
            return paramsCheckVOList;
        }
        CommonResponse maxParamByCode = new CommonResponse();
        CommonResponse minParamByCode = new CommonResponse();
        Integer contractType = changeVO.getContractType();
        List detailList = changeVO.getDetailList();
        if (0 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-51g2FF0175", changeVO.getOrgId());
            minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-sT2I640176", changeVO.getOrgId());
        }
        if (1 == contractType) {
            maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-66o3LH0177", changeVO.getOrgId());
            minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-1L8c900178", changeVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u5206\u5305\u5408\u540c\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u5206\u5305\u5408\u540c\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (ChangeDetailVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    if (null == detailVO.getDocPriceTypeName() || !"\u7efc\u5408\u5355\u4ef7".equals(detailVO.getDocPriceTypeName()) || (getHistoryPriceArea = detailVO.getHistoryPriceArea()) == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getDetailName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getDetailPrice() == null ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                    paramsCheckDsVO.setWarnName("\u5206\u5305\u6e05\u5355\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5206\u5305\u6e05\u5355\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                if ("none".equals(paramsArray[minParamVO.getControlType()])) continue;
                for (ChangeDetailVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    if (null == detailVO.getDocPriceTypeName() || !"\u7efc\u5408\u5355\u4ef7".equals(detailVO.getDocPriceTypeName()) || (getHistoryPriceArea = detailVO.getHistoryPriceArea()) == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getDetailName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getDetailPrice() == null ? BigDecimal.ZERO : detailVO.getDetailPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                    paramsCheckDsVO.setWarnName("\u5206\u5305\u6e05\u5355\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5206\u5305\u6e05\u5355\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }
        return paramsCheckVOList;
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {
        CommonResponse copyContractFileResp;
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, "subContractBill");
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractBill", targetBillId, targetBillTypeCode, "subContractBill", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        if (copyContractFile && !(copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile")).isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile", copyContractFileResp.getMsg()});
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg()));
        }
        return null;
    }

    @Override
    public List<ParamsCheckVO> changeMnyCtrl(ChangeVO changeVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == changeVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-26y61564", changeVO.getOrgId());
        }
        if (1 == changeVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-D73e5K68", changeVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        List data = (List)billParamByCode.getData();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                BigDecimal baseTaxMny = changeVO.getBaseTaxMny();
                BigDecimal contractTaxMny = changeVO.getContractTaxMny();
                BigDecimal changeTaxMny = contractTaxMny.subtract(baseTaxMny);
                BigDecimal changeTaxMnyTime = contractTaxMny.subtract(changeVO.getBeforeChangeTaxMny());
                BigDecimal conTaxMny = baseTaxMny.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                if (changeTaxMny.compareTo(conTaxMny) > 0) {
                    BigDecimal overTaxMny = changeTaxMny.subtract(conTaxMny);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u53d8\u66f4\u8d85\u5408\u540c\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff1a").append(changeTaxMnyTime.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff1a").append(changeTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(conTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                } else {
                    paramsCheckVO.setWarnType(paramsArray[0]);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }
}

