/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.steelstructure.finance.bean.PaymentApplyDetailEntity;
import com.ejianc.business.steelstructure.finance.bean.PaymentApplyEntity;
import com.ejianc.business.steelstructure.finance.mapper.PaymentApplyDetailMapper;
import com.ejianc.business.steelstructure.finance.service.IPaymentApplyDetailService;
import com.ejianc.business.steelstructure.finance.service.IPaymentApplyService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paymentApplyDetailService")
public class PaymentApplyDetailServiceImpl
extends BaseServiceImpl<PaymentApplyDetailMapper, PaymentApplyDetailEntity>
implements IPaymentApplyDetailService {
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IPaymentApplyService applyService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPMPayApplyApi ipmPayApplyApi;

    @Override
    public BigDecimal queryAlreadyApplyMny(String sourceId) {
        BigDecimal alreadyApplyMny = BigDecimal.ZERO;
        BigDecimal advancePaymentDeduction = BigDecimal.ZERO;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("source_id", new Parameter("eq", (Object)sourceId));
        List paymentApplyDetailEntities = super.queryList(queryParam, false);
        for (PaymentApplyDetailEntity entity : paymentApplyDetailEntities) {
            if (entity.getCurrentApplyMny() != null) {
                alreadyApplyMny = alreadyApplyMny.add(entity.getCurrentApplyMny());
            }
            if (entity.getAdvancePaymentDeduction() == null) continue;
            advancePaymentDeduction = advancePaymentDeduction.add(entity.getAdvancePaymentDeduction());
        }
        return alreadyApplyMny.add(advancePaymentDeduction);
    }

    @Override
    public SettlePoolVO setResidueMny(SettlePoolVO settlePoolVO) {
        BigDecimal alreadyMny = BigDecimal.ZERO;
        BigDecimal residueMny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"source_id", (Object)settlePoolVO.getId());
        listQuery.select(new String[]{"sum(current_apply_mny)"});
        PaymentApplyDetailEntity entity = (PaymentApplyDetailEntity)((Object)super.getOne((Wrapper)listQuery));
        settlePoolVO.setResidueApplyMny(settlePoolVO.getCurTaxMny().subtract(entity.getCurrentApplyMny()));
        return settlePoolVO;
    }

    @Override
    public boolean releaseApplyList(PaymentApplyEntity entity) {
        boolean flag = false;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pay_id", new Parameter("eq", (Object)entity.getId()));
        List paymentApplyDetailEntities = super.queryList(queryParam);
        List sourceIdS = paymentApplyDetailEntities.stream().filter(item -> item.getSourceId() != null).map(PaymentApplyDetailEntity::getSourceId).collect(Collectors.toList());
        if (sourceIdS.size() > 0) {
            CommonResponse bySourceIds = this.settlePoolApi.getBySourceIds(sourceIdS);
            this.logger.info("\u6839\u636e\u7ed3\u7b97\u5355ids-{}\u67e5\u8be2\u5bf9\u5e94\u7ed3\u7b97\u5355\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(sourceIdS), (Object)JSONObject.toJSONString((Object)bySourceIds));
            if (!bySourceIds.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ed3\u7b97\u5355ids-{}\u67e5\u8be2\u5bf9\u5e94\u7ed3\u7b97\u5355\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(sourceIdS), (Object)JSONObject.toJSONString((Object)bySourceIds));
                throw new BusinessException("\u4ed8\u6b3e\u5355\u5173\u95ed\u5931\u8d25\uff0c\u6839\u636e\u7ed3\u7b97\u5355Id\u5217\u8868\u67e5\u8be2\u7ed3\u7b97\u5355\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List data = (List)bySourceIds.getData();
            Map<Long, PaymentApplyDetailEntity> detailMap = paymentApplyDetailEntities.stream().collect(Collectors.toMap(PaymentApplyDetailEntity::getSourceId, detailEntity -> detailEntity));
            this.logger.info("\u672c\u6b21\u5173\u95ed\u4ed8\u6b3e\u5355-{}\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u5217\u8868\uff1a{}", (Object)entity.getId().toString(), (Object)JSONObject.toJSONString((Object)data));
            for (SettlePoolVO poolVO : data) {
                PaymentApplyDetailEntity detailEntity2 = detailMap.get(poolVO.getSourceId());
                detailEntity2.setActualApplyMny(detailEntity2.getActualPaymentMny());
                this.logger.info("\u7ed3\u7b97\u5355 id-{}\uff0c\u5f53\u524d\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d-{}\uff0c\u672c\u6b21\u4ed8\u6b3e\u5355\u4e2d\u7684\u7533\u8bf7\u91d1\u989d-{}, \u5df2\u652f\u4ed8\u91d1\u989d-{}", new Object[]{poolVO.getId().toString(), poolVO.getResidueApplyMny(), detailEntity2.getCurrentApplyMny(), null != detailEntity2.getActualPaymentMny() ? detailEntity2.getActualPaymentMny() : BigDecimal.ZERO});
                poolVO.setResidueApplyMny(poolVO.getResidueApplyMny().add(detailEntity2.getCurrentApplyMny()).subtract(null != detailEntity2.getActualPaymentMny() ? detailEntity2.getActualPaymentMny() : BigDecimal.ZERO));
                if (poolVO.getSourceType().equals(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()) || poolVO.getSourceType().equals(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode())) {
                    if (poolVO.getTotalNodeTaxDifference() == null) continue;
                    poolVO.setAlreadyApplyMny(poolVO.getTotalNodeTaxDifference().subtract(poolVO.getResidueApplyMny()));
                    continue;
                }
                poolVO.setAlreadyApplyMny(poolVO.getCurTaxMny().subtract(poolVO.getResidueApplyMny()));
            }
            this.logger.info("\u672c\u6b21\u5173\u95ed\u4ed8\u6b3e\u5355-{}\u4fee\u6539\u7684\u7ed3\u7b97\u5355\u5217\u8868\uff1a{}", (Object)entity.getId().toString(), (Object)JSONObject.toJSONString((Object)data));
            CommonResponse listCommonResponse = this.settlePoolApi.saveOrUpdateBatch(data);
            this.logger.info("\u5173\u95ed\u4ed8\u6b3e\u5355-{}\u4fee\u6539\u7684\u7ed3\u7b97\u5355\u7ed3\u679c: {}", (Object)JSONObject.toJSONString((Object)listCommonResponse));
            if (!listCommonResponse.isSuccess()) {
                flag = false;
                this.logger.error("\u5173\u95ed\u4ed8\u6b3e\u5355-{}\u5931\u8d25\uff0c\u66f4\u65b0\u5176\u4e0b\u7ed3\u7b97\u5355\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d\u5931\u8d25\uff0c\u8c03\u7528\u7ed3\u7b97\u6c60\u670d\u52a1\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)), (Object)JSONObject.toJSONString((Object)listCommonResponse));
                throw new BusinessException("\u5173\u95ed\u4ed8\u6b3e\u5355\u5931\u8d25\uff0c\u66f4\u65b0\u5176\u4e0b\u7ed3\u7b97\u5355\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d\u5931\u8d25\uff01");
            }
            flag = true;
        } else {
            flag = true;
        }
        return flag;
    }
}

