/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.profinance.vo.PaymentApplyDetailVO;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.steelstructure.finance.bean.PaymentApplyDetailEntity;
import com.ejianc.business.steelstructure.finance.bean.PaymentApplyEntity;
import com.ejianc.business.steelstructure.finance.enums.PaymentTypeEnum;
import com.ejianc.business.steelstructure.finance.mapper.PaymentApplyMapper;
import com.ejianc.business.steelstructure.finance.service.IPaymentApplyDetailService;
import com.ejianc.business.steelstructure.finance.service.IPaymentApplyService;
import com.ejianc.business.temporary.userecord.api.ITemporaryUseRecordApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="paymentApplyService")
public class PaymentApplyServiceImpl
extends BaseServiceImpl<PaymentApplyMapper, PaymentApplyEntity>
implements IPaymentApplyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPERATE = "PROFINANCE_PAY_RESULT";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private PaymentApplyMapper paymentApplyMapper;
    @Autowired
    private IPaymentApplyDetailService detailService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IPMPayApplyApi ipmPayApplyApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITemporaryUseRecordApi recordApi;
    private static final String BILL_CODE = "PAY_CON_REF";
    private static final String NO_CONTRACT_BILL_CODE = "PAY_NO_CON_REF";

    @Override
    public CommonResponse updateSettlePool(List<Long> sourceIdS) {
        CommonResponse bySourceIds = this.settlePoolApi.getBySourceIds(sourceIdS);
        this.logger.info("\u67e5\u8be2\u4fe1\u606f" + JSONObject.toJSONString((Object)bySourceIds));
        if (bySourceIds.isSuccess()) {
            List data = (List)bySourceIds.getData();
            for (SettlePoolVO vo : data) {
                QueryWrapper listQuery = new QueryWrapper();
                listQuery.eq((Object)"source_id", (Object)vo.getSourceId());
                listQuery.select(new String[]{"ifnull(sum(current_apply_mny + advance_payment_deduction),0) as current_apply_mny"});
                listQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
                PaymentApplyDetailEntity entity = (PaymentApplyDetailEntity)((Object)this.detailService.getOne((Wrapper)listQuery));
                this.logger.info("\u7ed3\u7b97\u5355id-{}\u7d2f\u8ba1\u5df2\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\uff1a{}", (Object)vo.getSourceId(), (Object)entity.getCurrentApplyMny());
                String sourceType = vo.getSourceType();
                vo.setAlreadyApplyMny(entity.getCurrentApplyMny());
                if (sourceType.equals(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()) || sourceType.equals(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode())) {
                    if (vo.getTotalNodeTaxDifference() == null) continue;
                    vo.setResidueApplyMny(vo.getTotalNodeTaxDifference().subtract(vo.getAlreadyApplyMny()));
                    continue;
                }
                vo.setResidueApplyMny(vo.getCurTaxMny().subtract(vo.getAlreadyApplyMny()));
            }
            this.logger.info("\u4fee\u6539\u4fe1\u606f" + JSONObject.toJSONString((Object)data));
            CommonResponse listCommonResponse = this.settlePoolApi.saveOrUpdateBatch(data);
            this.logger.info("\u4fee\u6539\u8fd4\u56de\u4fe1\u606f" + JSONObject.toJSONString((Object)listCommonResponse));
            CommonResponse updateLate = this.settlePoolApi.getBySourceIds(sourceIdS);
            this.logger.info("\u4fee\u6539\u540e\u67e5\u8be2\u4fe1\u606f" + JSONObject.toJSONString((Object)updateLate));
            if (!listCommonResponse.isSuccess()) {
                this.logger.info("\u5408\u540c\u516c\u5171\u670d\u52a1\u9519\u8bef" + JSONObject.toJSONString((Object)listCommonResponse.getMsg()));
                throw new BusinessException(listCommonResponse.getMsg());
            }
        } else {
            this.logger.error(bySourceIds.getMsg());
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u7ed3\u7b97\u5355\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return CommonResponse.success();
    }

    @Override
    public boolean saveOrUpdatePaymentApply(PaymentApplyEntity entity, boolean syncEs) {
        if (entity.getPaymentContractFlag() == 0) {
            Integer finallyFlag;
            PaymentApplyEntity dbEntity = null;
            if (null != entity.getId()) {
                dbEntity = (PaymentApplyEntity)((Object)super.selectById((Serializable)entity.getId()));
            }
            if (0 == (finallyFlag = entity.getFinallyFlag())) {
                if (null == dbEntity || dbEntity.getFinallyFlag() == 1) {
                    this.logger.info("\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u7684\u662f\u5426\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u72b6\u6001\u4e3a \u662f \uff0c\u8c03\u7528\u5408\u540c\u63a5\u53e3\u4fee\u6539\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u4e3a\u5df2\u7ed3\u675f");
                    ContractPoolVO contractPoolVO = new ContractPoolVO();
                    contractPoolVO.setSyncWithContractBill(Boolean.valueOf(true));
                    contractPoolVO.setId(entity.getContractId());
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.\u5df2\u7ed3\u675f.getStateCode());
                    CommonResponse updateResp = this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                    if (!updateResp.isSuccess()) {
                        this.logger.error("\u4ed8\u6b3e\u7533\u8bf7\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u66f4\u6539\u5408\u540c\u5c65\u7ea6\u72b6\u6001\uff0c{}", (Object)JSONObject.toJSONString((Object)updateResp));
                        throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
                    }
                }
            } else if (null != dbEntity && dbEntity.getFinallyFlag() == 0) {
                if (null == dbEntity.getContractPerformanceStatus()) {
                    this.logger.error("\u4ed8\u6b3e\u5355\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u7531\u662f\u6539\u4e3a\u5426\uff0c\u5f53\u524d\u5355\u636e\u5e76\u672a\u5b58\u50a8\u5408\u540c-\u3010{}\u3011\u539f\u6709\u5c65\u7ea6\u72b6\u6001\uff0c\u8bf7\u5904\u7406\uff01", (Object)dbEntity.getContractId());
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
                }
                this.logger.info("\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u7684\u662f\u5426\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u72b6\u6001\u4e3a \u5426, \u65e7\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\u4e3a\u662f\uff0c\u8fd8\u539f\u5408\u540c-{}\u7684\u5c65\u7ea6\u72b6\u6001\u4e3a\uff1a{}", (Object)dbEntity.getContractId(), (Object)dbEntity.getContractPerformanceStatus());
                ContractPoolVO contractPoolVO = new ContractPoolVO();
                contractPoolVO.setSyncWithContractBill(Boolean.valueOf(true));
                contractPoolVO.setId(entity.getContractId());
                contractPoolVO.setPerformanceStatus(dbEntity.getContractPerformanceStatus());
                CommonResponse updateResp = this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
                if (!updateResp.isSuccess()) {
                    this.logger.error("\u4ed8\u6b3e\u7533\u8bf7\u6700\u540e\u4e00\u6b21\u4ed8\u6b3e\u66f4\u6539\u5408\u540c\u5c65\u7ea6\u72b6\u6001\uff0c{}", (Object)JSONObject.toJSONString((Object)updateResp));
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
        }
        return super.saveOrUpdate((Object)entity, syncEs);
    }

    @Override
    public CommonResponse<PaymentApplyVO> queryUnusedPaymentApply(Integer paymentType, Long projectId, Long supplierId, Date applyDate) {
        PaymentApplyVO paymentApplyVO = new PaymentApplyVO();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PaymentApplyEntity::getPaymentType, (Object)paymentType);
        lambda.eq(PaymentApplyEntity::getProjectId, (Object)projectId);
        lambda.eq(PaymentApplyEntity::getSupplierId, (Object)supplierId);
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(PaymentApplyEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u6761\u4ef6\uff08\u540c\u4e00\u9879\u76ee+\u4f9b\u5e94\u5546+\u4ed8\u6b3e\u7c7b\u578b\uff09\u5df2\u6709\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9879\u76ee\u3001\u4f9b\u5e94\u5546\u6216\u4ed8\u6b3e\u7c7b\u578b\uff01\u3002");
        }
        Date resultDate = this.queryMaxApplyDate(paymentType, projectId, supplierId);
        if (null == resultDate) {
            resultDate = null != applyDate ? applyDate : new Date();
            paymentApplyVO.setMinApplyDate(null);
        } else {
            resultDate = DateUtils.addSeconds((Date)resultDate, (int)1);
            paymentApplyVO.setMinApplyDate(resultDate);
            if (null != applyDate && applyDate.compareTo(resultDate) > 0) {
                resultDate = applyDate;
            }
        }
        paymentApplyVO.setApplyDate(resultDate);
        paymentApplyVO.setProjectId(projectId);
        paymentApplyVO.setSupplierId(supplierId);
        paymentApplyVO.setPaymentType(paymentType);
        this.queryNoContractTotalMny(paymentApplyVO);
        return CommonResponse.success((String)"\u5f53\u524d\u7533\u8bf7\u5355\u53ef\u64cd\u4f5c\uff01", (Object)paymentApplyVO);
    }

    private Date queryMaxApplyDate(Integer paymentType, Long projectId, Long supplierId) {
        return this.paymentApplyMapper.selectMaxPaymentApplyDate(paymentType, projectId, supplierId);
    }

    private Date queryMaxDate(Integer paymentType, Long projectId, Long contractId) {
        return this.paymentApplyMapper.selectMaxDate(paymentType, projectId, contractId);
    }

    @Override
    public CommonResponse<PaymentApplyVO> checkPayApply(PaymentApplyVO vo) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PaymentApplyEntity::getContractId, (Object)vo.getContractId());
        lambda.eq(PaymentApplyEntity::getProjectId, (Object)vo.getProjectId());
        lambda.eq(PaymentApplyEntity::getCloseState, (Object)0);
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(PaymentApplyEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u6761\u4ef6\uff08\u5408\u540c\uff09\u5df2\u6709\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\uff01");
        }
        PaymentApplyVO entity = new PaymentApplyVO();
        Date resultDate = this.queryMaxDate(vo.getPaymentType(), vo.getProjectId(), vo.getContractId());
        if (null == resultDate) {
            resultDate = null != vo.getApplyDate() ? vo.getApplyDate() : new Date();
            entity.setMinApplyDate(null);
        } else {
            resultDate = DateUtils.addSeconds((Date)resultDate, (int)1);
            entity.setMinApplyDate(resultDate);
            if (null != vo.getApplyDate() && vo.getApplyDate().compareTo(resultDate) > 0) {
                resultDate = vo.getApplyDate();
            }
        }
        entity.setApplyDate(resultDate);
        return CommonResponse.success((String)"\u5f53\u524d\u7533\u8bf7\u5355\u53ef\u64cd\u4f5c\uff01", (Object)entity);
    }

    @Override
    public BigDecimal queryAdvanceApplyMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("paymentType", new Parameter("eq", (Object)1));
        queryParam.getParams().put("close_state", new Parameter("eq", (Object)0));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List paymentApplyEntities = super.queryList(queryParam, false);
        BigDecimal advanceApplyMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            if (entity.getApprovalMny() == null) continue;
            advanceApplyMny = advanceApplyMny.add(entity.getApprovalMny());
        }
        return advanceApplyMny;
    }

    @Override
    public BigDecimal queryTotalPayMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List paymentApplyEntities = super.queryList(queryParam, false);
        BigDecimal totalPayMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            if (entity.getApplyMny() == null || entity.getActualMny() == null) continue;
            totalPayMny = totalPayMny.add(entity.getActualMny());
        }
        return totalPayMny;
    }

    @Override
    public BigDecimal queryLastApplyMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("close_state", new Parameter("eq", (Object)0));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List paymentApplyEntities = super.queryList(queryParam, false);
        BigDecimal advanceApplyMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            if (entity.getApprovalMny() == null) continue;
            advanceApplyMny = advanceApplyMny.add(entity.getApprovalMny());
        }
        return advanceApplyMny;
    }

    @Override
    public BigDecimal queryLastLitigationMny(PaymentApplyVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)vo.getContractId()));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("paymentType", new Parameter("eq", (Object)vo.getPaymentType()));
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("close_state", new Parameter("eq", (Object)0));
        List paymentApplyEntities = super.queryList(queryParam, false);
        BigDecimal lastLitigationMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            if (entity.getApprovalMny() == null) continue;
            lastLitigationMny = lastLitigationMny.add(entity.getApprovalMny());
        }
        return lastLitigationMny;
    }

    @Override
    public BigDecimal queryAlreadyApplyMny(String sourceId) {
        return this.detailService.queryAlreadyApplyMny(sourceId);
    }

    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = PaymentApplyServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(apply_mny) as totalApplyMny, sum(approval_mny) as totalApprovalMny, sum(actual_mny) as totalActualMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("totalApplyMny", 0);
            resp.put("totalApprovalMny", 0);
            resp.put("totalActualMny", 0);
        }
        return resp;
    }

    @Override
    public List<PaymentApplyVO> queryListByContractId(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("apply_date", "desc");
        List list = super.queryList(param);
        List<Object> vos = new ArrayList<PaymentApplyVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vos = BeanMapper.mapList((Iterable)list, PaymentApplyVO.class);
        }
        return vos;
    }

    @Override
    public CommonResponse<ContractPaymentResultVO> queryJsonByContractId(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("apply_date", "desc");
        List list = super.queryList(param);
        List vos = new ArrayList();
        BigDecimal totalApplyMny = BigDecimal.ZERO;
        BigDecimal totalApprovalMny = BigDecimal.ZERO;
        BigDecimal totalActualMny = BigDecimal.ZERO;
        BigDecimal paymentRate = BigDecimal.ZERO;
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal contractMny = BigDecimal.ZERO;
        BigDecimal totalStayActualMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            contractTaxMny = ((PaymentApplyEntity)((Object)list.get(0))).getContractTaxMny();
            contractMny = ((PaymentApplyEntity)((Object)list.get(0))).getContractMny();
            for (PaymentApplyEntity entity : list) {
                if (null != entity.getApplyMny()) {
                    totalApplyMny = totalApplyMny.add(entity.getApplyMny());
                }
                if (null != entity.getApprovalMny()) {
                    totalApprovalMny = totalApprovalMny.add(entity.getApprovalMny());
                }
                if (null == entity.getActualMny()) continue;
                totalActualMny = totalActualMny.add(entity.getActualMny());
            }
            paymentRate = totalActualMny.divide(contractTaxMny, 2);
            vos = BeanMapper.mapList((Iterable)list, PaymentApplyVO.class);
        }
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.eq((Object)"bill_state", (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        int resultCount = super.count((Wrapper)listQuery);
        if (resultCount > 0) {
            resultVO.setAddFlag(Boolean.valueOf(false));
        } else {
            resultVO.setAddFlag(Boolean.valueOf(true));
        }
        resultVO.setTotalStayActualMny(totalApplyMny.subtract(totalActualMny));
        resultVO.setContractId(contractId);
        resultVO.setContractMny(contractMny);
        resultVO.setContractTaxMny(contractTaxMny);
        resultVO.setTotalApplyMny(totalApplyMny);
        resultVO.setTotalApprovalMny(totalApprovalMny);
        resultVO.setTotalActualMny(totalActualMny);
        resultVO.setPaymentRate(paymentRate);
        resultVO.setPaymentApplyList(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)resultVO);
    }

    @Override
    public BigDecimal queryContractHonourMny(PaymentApplyVO vo) {
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        contractPoolVO.setContractId(vo.getContractId());
        contractPoolVO.setSourceTypeName(vo.getSourceCategoryTypeName());
        contractPoolVO.setSourceType(vo.getSourceCategoryType());
        CommonResponse res = this.contractPoolApi.queryContractHonourMny(contractPoolVO);
        if (!res.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u5408\u540c\u5c65\u7ea6\u91d1\u989d\u62a5\u9519\uff1a" + res.getMsg());
        }
        return (BigDecimal)res.getData();
    }

    @Override
    public Map<Long, BigDecimal> querySumMny(Map<String, List<Long>> map) {
        this.logger.info("\u6253\u5370\u5165\u53c2map:" + JSONObject.toJSONString(map));
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        List<Long> suplyIds = map.get("suplyIds");
        List<Long> orgIds = map.get("orgIds");
        if (null == suplyIds || null == orgIds) {
            this.logger.info("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25\uff01");
            return null;
        }
        List<PaymentApplyEntity> paymentApplyEntities = this.paymentApplyMapper.querySumMny(suplyIds, orgIds);
        for (PaymentApplyEntity entity : paymentApplyEntities) {
            resultMap.put(entity.getSupplierId(), entity.getActualMny());
        }
        return resultMap;
    }

    @Override
    public void batchDel(List<PaymentApplyVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : ids) {
            List<PaymentApplyDetailEntity> detailList;
            List sourceIdS;
            PaymentApplyEntity entity = (PaymentApplyEntity)((Object)super.selectById((Serializable)id));
            if (entity.getPaymentApplyDetailList().size() > 0 && (sourceIdS = (detailList = entity.getPaymentApplyDetailList()).stream().filter(item -> item.getSourceId() != null).map(PaymentApplyDetailEntity::getSourceId).collect(Collectors.toList())).size() > 0) {
                CommonResponse bySourceIds = this.settlePoolApi.getBySourceIds(sourceIdS);
                if (!bySourceIds.isSuccess()) {
                    throw new BusinessException(bySourceIds.getMsg());
                }
                List data = (List)bySourceIds.getData();
                Map<Long, PaymentApplyDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(PaymentApplyDetailEntity::getSourceId, detailEntity -> detailEntity));
                for (SettlePoolVO poolVO : data) {
                    PaymentApplyDetailEntity detailEntity2 = detailMap.get(poolVO.getSourceId());
                    poolVO.setResidueApplyMny(poolVO.getResidueApplyMny().add(detailEntity2.getCurrentApplyMny()).add(detailEntity2.getAdvancePaymentDeduction()));
                    if (poolVO.getSourceType().equals(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()) || poolVO.getSourceType().equals(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode())) {
                        if (poolVO.getTotalNodeTaxDifference() == null) continue;
                        poolVO.setAlreadyApplyMny(poolVO.getTotalNodeTaxDifference().subtract(poolVO.getResidueApplyMny()));
                        continue;
                    }
                    poolVO.setAlreadyApplyMny(poolVO.getCurTaxMny().subtract(poolVO.getResidueApplyMny()));
                }
                this.logger.info(JSONObject.toJSONString((Object)data) + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                CommonResponse listCommonResponse = this.settlePoolApi.saveOrUpdateBatch(data);
                if (!listCommonResponse.isSuccess()) {
                    throw new BusinessException(listCommonResponse.getMsg());
                }
            }
            if (entity.getFinallyFlag() == null || 0 != entity.getFinallyFlag() || null == entity.getContractId() || !StringUtils.isNotBlank((String)entity.getContractPerformanceStatus())) continue;
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSyncWithContractBill(Boolean.valueOf(true));
            contractPoolVO.setId(entity.getContractId());
            contractPoolVO.setPerformanceStatus(entity.getContractPerformanceStatus());
            this.logger.info("\u66f4\u65b0\u5408\u540c-\u3010{}\u3011\u5c65\u7ea6\u72b6\u6001\u4e3a-{}\uff1a", (Object)contractPoolVO.getId(), (Object)entity.getContractPerformanceStatus());
            CommonResponse updateResp = this.contractPoolApi.updatePerformanceStatusByContractId(contractPoolVO);
            if (updateResp.isSuccess()) continue;
            throw new BusinessException(StringUtils.isNotBlank((String)updateResp.getMsg()) ? updateResp.getMsg() : "\u64cd\u4f5c\u5931\u8d25\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u5c65\u7ea6\u72b6\u6001\u5931\u8d25\uff01");
        }
        super.removeByIds(ids, false);
    }

    @Override
    public PaymentApplyVO savePaymentApply(PaymentApplyVO saveOrUpdateVO) {
        PaymentApplyEntity entity = (PaymentApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PaymentApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)(saveOrUpdateVO.getPaymentContractFlag() == 0 ? BILL_CODE : NO_CONTRACT_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setPaymentStatus(1);
            entity.setCloseState(0);
            entity.setActualMny(BigDecimal.ZERO);
        }
        this.saveOrUpdatePaymentApply(entity, false);
        List<Long> sourceIdS = saveOrUpdateVO.getPaymentApplyDetailList().stream().filter(item -> item.getSourceId() != null).map(PaymentApplyDetailVO::getSourceId).collect(Collectors.toList());
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u7ed3\u7b97\u5355Id\u5217\u8868-{}", (Object)JSONObject.toJSONString(sourceIdS));
        if (CollectionUtils.isNotEmpty(sourceIdS)) {
            this.updateSettlePool(sourceIdS);
        }
        return (PaymentApplyVO)BeanMapper.map((Object)((Object)entity), PaymentApplyVO.class);
    }

    @Override
    public JSONObject queryDataModelInfo(Long projectId) {
        this.logger.info("queryDataModelInfo--");
        JSONObject data = new JSONObject();
        DecimalFormat df1 = new DecimalFormat("0.##");
        BigDecimal totalPerformanceMny = BigDecimal.ZERO;
        BigDecimal checkTaxMny = BigDecimal.ZERO;
        BigDecimal recordTaxMny = BigDecimal.ZERO;
        BigDecimal totalSettleMny = BigDecimal.ZERO;
        BigDecimal totalActualMny = BigDecimal.ZERO;
        BigDecimal totalApprovalMny = BigDecimal.ZERO;
        CommonResponse response = this.recordApi.queryTemporaryUseProject(projectId);
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        this.logger.info("\u4e34\u65f6\u8bbe\u5907\u4f7f\u7528\u8bb0\u5f55 \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)response.isSuccess(), (Object)JSONObject.toJSONString((Object)response));
        recordTaxMny = null != response.getData() && ((JSONObject)response.getData()).get((Object)"useMny") != null ? new BigDecimal(((JSONObject)response.getData()).get((Object)"useMny").toString()) : BigDecimal.ZERO;
        totalPerformanceMny = recordTaxMny.add(checkTaxMny);
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setProjectId(projectId);
        poolVO.setContractFlag(Integer.valueOf(0));
        poolVO.setSourceType("sporadic_material,temp_equip");
        CommonResponse settleRep = this.settlePoolApi.queryNoContractTotalMny(poolVO);
        this.logger.info("\u83b7\u53d6\u7ed3\u7b97\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)settleRep.isSuccess(), (Object)JSONObject.toJSONString((Object)settleRep));
        if (!settleRep.isSuccess()) {
            throw new BusinessException(settleRep.getMsg());
        }
        totalSettleMny = null != settleRep && ((JSONObject)settleRep.getData()).get((Object)"totalSettleMny") != null ? new BigDecimal(((JSONObject)settleRep.getData()).get((Object)"totalSettleMny").toString()) : BigDecimal.ZERO;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in((Object)"payment_type", Arrays.asList(PaymentTypeEnum.\u4e34\u65f6\u673a\u68b0.getCode(), PaymentTypeEnum.\u96f6\u661f\u6750\u6599.getCode()));
        List queryList = super.list((Wrapper)queryWrapper);
        for (PaymentApplyEntity entity : queryList) {
            if (entity.getActualMny() != null) {
                totalActualMny = totalActualMny.add(entity.getActualMny());
            }
            if (entity.getApprovalMny() == null) continue;
            totalApprovalMny = totalApprovalMny.add(entity.getApprovalMny());
        }
        totalApprovalMny = totalApprovalMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : totalApprovalMny;
        BigDecimal contractTaxMny = this.querySumContractMny(projectId);
        BigDecimal contractRate = BigDecimal.ZERO;
        if (contractTaxMny.compareTo(BigDecimal.ZERO) != 0 && totalApprovalMny.compareTo(BigDecimal.ZERO) != 0) {
            this.logger.info("totalApprovalMny--{}", (Object)totalApprovalMny);
            this.logger.info("contractTaxMny--{}", (Object)contractTaxMny);
            contractRate = totalApprovalMny.divide(contractTaxMny, 2);
            contractRate = contractRate.multiply(new BigDecimal("100"));
        }
        data.put("totalPerformanceMny", (Object)df1.format(totalPerformanceMny));
        data.put("totalSettleMny", (Object)df1.format(totalSettleMny));
        data.put("totalActualMny", (Object)df1.format(totalActualMny));
        data.put("totalApprovalMny", (Object)df1.format(totalApprovalMny));
        data.put("contractTaxMny", (Object)df1.format(contractTaxMny));
        if (contractRate != BigDecimal.ZERO) {
            String format = df1.format(contractRate);
            data.put("contractRate", (Object)format);
        } else {
            data.put("contractRate", (Object)"0");
        }
        return data;
    }

    private BigDecimal querySumContractMny(Long projectId) {
        QueryParam query = new QueryParam();
        query.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        query.getParams().put("source_type", new Parameter("eq", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        query.getParams().put("performance_status", new Parameter("in", Arrays.asList(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode(), ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode())));
        CommonResponse bigDecimalCommonResponse = this.contractPoolApi.querySumContractMny(query);
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        if (!bigDecimalCommonResponse.isSuccess()) {
            throw new BusinessException(bigDecimalCommonResponse.getMsg());
        }
        if (bigDecimalCommonResponse.getData() != null && bigDecimalCommonResponse.getData() != BigDecimal.ZERO) {
            contractTaxMny = new BigDecimal(((BigDecimal)bigDecimalCommonResponse.getData()).toString());
        }
        return contractTaxMny.compareTo(new BigDecimal("0E-8")) == 0 ? new BigDecimal("0") : contractTaxMny;
    }

    public PaymentApplyVO queryNoContractTotalMny(PaymentApplyVO vo) {
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setProjectId(vo.getProjectId());
        poolVO.setPartybId(vo.getSupplierId());
        poolVO.setContractFlag(Integer.valueOf(0));
        poolVO.setSourceType(vo.getPaymentType() == 3 ? "sporadic_material" : "temp_equip");
        CommonResponse settleRep = this.settlePoolApi.queryNoContractTotalMny(poolVO);
        this.logger.info("\u83b7\u53d6\u7ed3\u7b97\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)settleRep.isSuccess(), (Object)JSONObject.toJSONString((Object)settleRep));
        if (!settleRep.isSuccess()) {
            throw new BusinessException(settleRep.getMsg());
        }
        if (((JSONObject)settleRep.getData()).containsKey((Object)"totalSettleMny")) {
            BigDecimal checkTaxMny = ((JSONObject)settleRep.getData()).get((Object)"totalSettleMny") != null ? new BigDecimal(((JSONObject)settleRep.getData()).get((Object)"totalSettleMny").toString()) : BigDecimal.ZERO;
            vo.setTotalSettleMny(checkTaxMny);
        }
        if (vo.getPaymentType() != 3) {
            CommonResponse recordRsp = this.recordApi.queryTemporaryUseRecordMny(vo.getProjectId(), vo.getSupplierId());
            this.logger.info("\u83b7\u53d6\u5c65\u7ea6\u91d1\u989d \u7ed3\u679c\uff1a____{}\u8fd4\u56de\u5185\u5bb9:____{}", (Object)recordRsp.isSuccess(), (Object)JSONObject.toJSONString((Object)recordRsp));
            if (!recordRsp.isSuccess()) {
                throw new BusinessException(recordRsp.getMsg());
            }
            if (((JSONObject)recordRsp.getData()).containsKey((Object)"useMny")) {
                BigDecimal useMny = ((JSONObject)recordRsp.getData()).get((Object)"useMny") != null ? new BigDecimal(((JSONObject)recordRsp.getData()).get((Object)"useMny").toString()) : BigDecimal.ZERO;
                vo.setTotalPerformanceMny(useMny);
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)vo.getProjectId()));
        queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)vo.getSupplierId()));
        queryParam.getParams().put("payment_type", new Parameter("eq", (Object)vo.getPaymentType()));
        List applyList = super.queryList(queryParam);
        BigDecimal totalActualMny = BigDecimal.ZERO;
        for (PaymentApplyEntity entity : applyList) {
            if (entity.getActualMny() == null) continue;
            totalActualMny = totalActualMny.add(entity.getActualMny());
        }
        vo.setTotalActualMny(totalActualMny);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

