/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.finance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.financeintegration.PMReceiptRegister.api.IPMSKSJApi;
import com.ejianc.business.financeintegration.PMReceiptRegister.vo.PMSKSJVO;
import com.ejianc.business.steelstructure.finance.bean.ReceiptRegisterEntity;
import com.ejianc.business.steelstructure.finance.mapper.ReceiptRegisterMapper;
import com.ejianc.business.steelstructure.finance.service.IReceiptRegisterService;
import com.ejianc.business.steelstructure.finance.vo.ReceiptRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareCustomerApi;
import com.ejianc.foundation.support.api.IShareSupplierWebApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="receiptRegisterService")
public class ReceiptRegisterServiceImpl
extends BaseServiceImpl<ReceiptRegisterMapper, ReceiptRegisterEntity>
implements IReceiptRegisterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IContractPoolApi contractApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IShareSupplierWebApi iShareSupplierWebApi;
    @Autowired
    private IShareCustomerApi shareCustomerApi;
    @Autowired
    private IPMSKSJApi ipmsksjApi;
    private static final String BILL_CODE = "RECEIPT_REGISTER";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        List defList = (List)this.getRespData(this.defdocApi.getDefDocByDefCode("profinance-clause-property"), true, "\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u6b3e\u9879\u5c5e\u6027\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        List defSettleList = (List)this.getRespData(this.defdocApi.getDefDocByDefCode("profinance-settle-type"), true, "\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u6863\u6848\u4e0b\u7ed3\u7b97\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        List defFeeList = (List)this.getRespData(this.defdocApi.getDefDocByDefCode("no_contract_fee_type"), true, "\u5bfc\u5165\u5931\u8d25\uff0c\u67e5\u8be2\u6863\u6848\u4e0b\u65e0\u5408\u540c\u8d39\u7528\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        Map defFeeMap = defFeeList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        Map defSettleMap = defSettleList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        Map defMap = defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        HashMap poolSetVOMap = new HashMap();
        HashMap orgVOMap = new HashMap();
        HashMap contractMap = new HashMap();
        HashMap customerMap = new HashMap();
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            ArrayList<ReceiptRegisterVO> voList = new ArrayList<ReceiptRegisterVO>();
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ReceiptRegisterVO vo2 = new ReceiptRegisterVO();
                String warnType = "";
                vo2.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    vo2.setParentOrgName(null);
                    warnType = warnType + "[\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4e3a\u7a7a]";
                } else if (orgVOMap.containsKey(datas.get(0))) {
                    vo2.setParentOrgName((String)datas.get(0));
                    vo2.setParentOrgCode(((OrgVO)orgVOMap.get(datas.get(0))).getCode());
                    vo2.setParentOrgId(((OrgVO)orgVOMap.get(datas.get(0))).getId());
                } else {
                    CommonResponse orgVORes = this.iOrgApi.findByNameAndTenantId((String)datas.get(0), tenantId);
                    if (orgVORes.isSuccess() && orgVORes.getData() != null) {
                        OrgVO orgVOs = (OrgVO)orgVORes.getData();
                        orgVOMap.put(datas.get(0), orgVOs);
                        vo2.setParentOrgName((String)datas.get(0));
                        vo2.setParentOrgCode(orgVOs.getCode());
                        vo2.setParentOrgId(orgVOs.getId());
                    } else {
                        vo2.setParentOrgName(null);
                        warnType = warnType + "[\u7ec4\u7ec7\u7ba1\u7406\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u7ec4\u7ec7]";
                    }
                }
                if ("\u6709\u5408\u540c\u6536\u6b3e".equals(datas.get(3))) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        vo2.setClausePropertyName(null);
                        warnType = warnType + "[\u6761\u6b3e\u5c5e\u6027\u4e3a\u7a7a]";
                    } else if (defMap.get(datas.get(1)) == null) {
                        vo2.setClausePropertyName(null);
                        warnType = warnType + "[\u6863\u6848\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u6761\u6b3e\u5c5e\u6027]";
                    } else {
                        vo2.setClausePropertyId(((DefdocDetailVO)defMap.get(datas.get(1))).getId());
                        vo2.setClausePropertyName((String)datas.get(1));
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    vo2.setReceiptDate(null);
                    warnType = warnType + "[\u6536\u6b3e\u65e5\u671f\u4e3a\u7a7a]";
                } else {
                    Date date = DateUtil.getJavaDate((double)Double.parseDouble((String)datas.get(2)));
                    vo2.setReceiptDate(date);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    vo2.setReceiptContractFlag(null);
                    warnType = warnType + "[\u6536\u5165\u7c7b\u578b\u4e3a\u7a7a]";
                } else {
                    vo2.setReceiptContractFlag(Integer.valueOf("\u6709\u5408\u540c\u6536\u6b3e".equals(datas.get(3)) ? 0 : 1));
                }
                if ("\u6709\u5408\u540c\u6536\u6b3e".equals(datas.get(3))) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4))) || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                        vo2.setContractName(null);
                        warnType = warnType + "[\u5408\u540c\u540d\u79f0\u548c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a]";
                    } else if (contractMap.containsKey(datas.get(5))) {
                        if (!((String)datas.get(4)).equals(((ContractPoolVO)contractMap.get(datas.get(5))).getContractName())) {
                            warnType = warnType + "[\u5408\u540c\u6c60\u4e2d\u5f53\u524d\u540d\u79f0\u548c\u7f16\u53f7\u4e0d\u7b26\u5408]";
                        } else {
                            vo2.setContractName((String)datas.get(4));
                            vo2.setContractId(((ContractPoolVO)contractMap.get(datas.get(5))).getContractId());
                            vo2.setContractCode((String)datas.get(5));
                            vo2.setContractTaxMny(((ContractPoolVO)contractMap.get(datas.get(5))).getContractTaxMny());
                            vo2.setContractMny(((ContractPoolVO)contractMap.get(datas.get(5))).getContractMny());
                            vo2.setOrgId(((ContractPoolVO)contractMap.get(datas.get(5))).getOrgId());
                            vo2.setOrgCode(((ContractPoolVO)contractMap.get(datas.get(5))).getOrgCode());
                            vo2.setOrgName(((ContractPoolVO)contractMap.get(datas.get(5))).getOrgName());
                            vo2.setProjectName(((ContractPoolVO)contractMap.get(datas.get(5))).getProjectName());
                            vo2.setProjectId(((ContractPoolVO)contractMap.get(datas.get(5))).getProjectId());
                            vo2.setProjectCode(((ContractPoolVO)contractMap.get(datas.get(5))).getProjectCode());
                            vo2.setParentOrgName(((ContractPoolVO)contractMap.get(datas.get(5))).getParentOrgName());
                            vo2.setParentOrgCode(((ContractPoolVO)contractMap.get(datas.get(5))).getParentOrgCode());
                            vo2.setParentOrgId(((ContractPoolVO)contractMap.get(datas.get(5))).getParentOrgId());
                            vo2.setCustomerId(((ContractPoolVO)contractMap.get(datas.get(5))).getPartyaId());
                            vo2.setCustomerName(((ContractPoolVO)contractMap.get(datas.get(5))).getPartyaName());
                            vo2.setSourceCategoryType(((ContractPoolVO)contractMap.get(datas.get(5))).getSourceType());
                            vo2.setSourceCategoryTypeName(((ContractPoolVO)contractMap.get(datas.get(5))).getSourceTypeName());
                            vo2.setContractCategoryId(((ContractPoolVO)contractMap.get(datas.get(5))).getCategoryId());
                            vo2.setContractCategoryName(((ContractPoolVO)contractMap.get(datas.get(5))).getCategoryName());
                        }
                    } else {
                        CommonResponse contractData = this.contractApi.queryContractByCode((String)datas.get(5));
                        if (contractData.isSuccess() && contractData.getData() != null) {
                            contractMap.put(datas.get(5), contractData.getData());
                            if (!((String)datas.get(4)).equals(((ContractPoolVO)contractMap.get(datas.get(5))).getContractName())) {
                                warnType = warnType + "[\u5408\u540c\u6c60\u4e2d\u5f53\u524d\u540d\u79f0\u548c\u7f16\u53f7\u4e0d\u7b26\u5408]";
                            } else {
                                vo2.setContractName((String)datas.get(4));
                                vo2.setContractId(((ContractPoolVO)contractMap.get(datas.get(5))).getContractId());
                                vo2.setContractCode((String)datas.get(5));
                                vo2.setContractTaxMny(((ContractPoolVO)contractMap.get(datas.get(5))).getContractTaxMny());
                                vo2.setContractMny(((ContractPoolVO)contractMap.get(datas.get(5))).getContractMny());
                                vo2.setOrgId(((ContractPoolVO)contractMap.get(datas.get(5))).getOrgId());
                                vo2.setOrgCode(((ContractPoolVO)contractMap.get(datas.get(5))).getOrgCode());
                                vo2.setOrgName(((ContractPoolVO)contractMap.get(datas.get(5))).getOrgName());
                                vo2.setProjectName(((ContractPoolVO)contractMap.get(datas.get(5))).getProjectName());
                                vo2.setProjectId(((ContractPoolVO)contractMap.get(datas.get(5))).getProjectId());
                                vo2.setProjectCode(((ContractPoolVO)contractMap.get(datas.get(5))).getProjectCode());
                                vo2.setParentOrgName(((ContractPoolVO)contractMap.get(datas.get(5))).getParentOrgName());
                                vo2.setParentOrgCode(((ContractPoolVO)contractMap.get(datas.get(5))).getParentOrgCode());
                                vo2.setParentOrgId(((ContractPoolVO)contractMap.get(datas.get(5))).getParentOrgId());
                                vo2.setCustomerId(((ContractPoolVO)contractMap.get(datas.get(5))).getPartyaId());
                                vo2.setCustomerName(((ContractPoolVO)contractMap.get(datas.get(5))).getPartyaName());
                                vo2.setSourceCategoryType(((ContractPoolVO)contractMap.get(datas.get(5))).getSourceType());
                                vo2.setSourceCategoryTypeName(((ContractPoolVO)contractMap.get(datas.get(5))).getSourceTypeName());
                                vo2.setContractCategoryId(((ContractPoolVO)contractMap.get(datas.get(5))).getCategoryId());
                                vo2.setContractCategoryName(((ContractPoolVO)contractMap.get(datas.get(5))).getCategoryName());
                            }
                        } else {
                            warnType = warnType + "[\u5408\u540c\u6c60\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u5408\u540c\u7f16\u7801\u7684\u5408\u540c]";
                        }
                    }
                }
                if ("\u65e0\u5408\u540c\u6536\u6b3e".equals(datas.get(3))) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6)))) {
                        vo2.setFeeName(null);
                        warnType = warnType + "[\u65e0\u5408\u540c\u8d39\u7528\u7c7b\u578b\u4e3a\u7a7a]";
                    } else if (defFeeMap.get(datas.get(6)) == null) {
                        vo2.setFeeName(null);
                        warnType = warnType + "[\u6863\u6848\u4e0d\u5b58\u5728\u5f53\u524d\u65e0\u5408\u540c\u8d39\u7528\u7c7b\u578b]";
                    } else {
                        vo2.setFeeName((String)datas.get(6));
                        vo2.setFeeId(((DefdocDetailVO)defFeeMap.get(datas.get(6))).getId());
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7))) || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(8)))) {
                        vo2.setProjectName(null);
                        vo2.setProjectCode(null);
                        warnType = warnType + "[\u9879\u76ee\u540d\u79f0\u548c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a]";
                    } else if (poolSetVOMap.containsKey(datas.get(7))) {
                        vo2.setProjectId(((ProjectPoolSetVO)poolSetVOMap.get(datas.get(7))).getId());
                        vo2.setProjectCode(((ProjectPoolSetVO)poolSetVOMap.get(datas.get(7))).getCode());
                        vo2.setProjectName(((ProjectPoolSetVO)poolSetVOMap.get(datas.get(7))).getName());
                        vo2.setOrgId(((ProjectPoolSetVO)poolSetVOMap.get(datas.get(7))).getProjectDepartmentId());
                        vo2.setOrgName(((ProjectPoolSetVO)poolSetVOMap.get(datas.get(7))).getProjectDepartmentName());
                        vo2.setParentOrgName(((ProjectPoolSetVO)poolSetVOMap.get(datas.get(7))).getOrgName());
                        vo2.setParentOrgId(((ProjectPoolSetVO)poolSetVOMap.get(datas.get(7))).getOrgId());
                    } else {
                        CommonResponse projectListRes = this.projectPoolApi.queryProjectListByNameAndCodeAndTenantId((String)datas.get(7), (String)datas.get(8), tenantId);
                        if (projectListRes.isSuccess()) {
                            List projectLists = (List)projectListRes.getData();
                            if (CollectionUtils.isEmpty((Collection)projectLists)) {
                                warnType = warnType + "[\u9879\u76ee\u6c60\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u9879\u76ee]";
                            } else if (projectLists.size() == 1) {
                                ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)projectLists.get(0);
                                poolSetVOMap.put(datas.get(7), projectPoolSetVO);
                                vo2.setProjectId(projectPoolSetVO.getId());
                                vo2.setProjectCode(projectPoolSetVO.getCode());
                                vo2.setProjectName(projectPoolSetVO.getName());
                                vo2.setOrgId(projectPoolSetVO.getProjectDepartmentId());
                                vo2.setOrgName(projectPoolSetVO.getProjectDepartmentName());
                                vo2.setParentOrgName(projectPoolSetVO.getOrgName());
                                vo2.setParentOrgId(projectPoolSetVO.getOrgId());
                            } else {
                                warnType = warnType + "[\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u6210\u529f\uff0c\u4f46\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e]";
                            }
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(9)))) {
                        vo2.setCustomerName(null);
                        warnType = warnType + "[\u6536\u6b3e\u5355\u4f4d\u4e3a\u7a7a]";
                    } else if (customerMap.containsKey(datas.get(9))) {
                        vo2.setCustomerId(((CustomerVO)customerMap.get(datas.get(9))).getId());
                        vo2.setCustomerName((String)datas.get(9));
                    } else {
                        CommonResponse vos = this.shareCustomerApi.findOneByName((String)datas.get(9), tenantId);
                        if (vos.isSuccess() && vos.getData() != null) {
                            customerMap.put(datas.get(9), vos.getData());
                            vo2.setCustomerId(((CustomerVO)vos.getData()).getId());
                            vo2.setCustomerName((String)datas.get(9));
                        } else {
                            vo2.setCustomerName(null);
                            warnType = warnType + "[\u5ba2\u6237\u6863\u6848\u6570\u636e\u4e0d\u5b58\u5728]";
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    vo2.setSumReceivedMny(null);
                    warnType = warnType + "[\u672c\u6b21\u5b9e\u6536\u91d1\u989d\u4e3a\u7a7a]";
                } else {
                    vo2.setSumReceivedMny(new BigDecimal((String)datas.get(10)));
                }
                vo2.setReceiptReason((String)datas.get(11));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    vo2.setSettleTypeName(null);
                    warnType = warnType + "[\u7ed3\u7b97\u7c7b\u578b\u4e3a\u7a7a]";
                } else if (defSettleMap.containsKey(datas.get(13))) {
                    vo2.setSettleTypeName((String)datas.get(13));
                    vo2.setSettleTypeId(((DefdocDetailVO)defSettleMap.get(datas.get(13))).getId());
                } else {
                    vo2.setSettleTypeName(null);
                    warnType = warnType + "[\u6863\u6848\u4e0b\u4e0d\u5b58\u5728\u5f53\u524d\u7ed3\u7b97\u7c7b\u578b]";
                }
                vo2.setWarnType(warnType);
                vo2.setRowState("add");
                voList.add(vo2);
            }
            if (CollectionUtils.isNotEmpty(voList)) {
                voList.forEach(vo -> {
                    if (StringUtils.isBlank((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<ReceiptRegisterVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List entityList = BeanMapper.mapList(importVOS, ReceiptRegisterEntity.class);
        ReceiptRegisterVO vo = null;
        Map<Object, Object> mny = new HashMap();
        for (ReceiptRegisterEntity entity : entityList) {
            mny = this.queryReceiptMny(entity.getContractId(), null);
            entity.setTotalReceiptMny((BigDecimal)mny.get("sumReceivedMny"));
            vo = (ReceiptRegisterVO)BeanMapper.map((Object)((Object)entity), ReceiptRegisterVO.class);
            if (entity.getId() == null && entity.getId() == 0L) continue;
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                continue;
            }
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        super.saveOrUpdateBatch(entityList, entityList.size(), false);
        return "\u4fdd\u5b58\u6210\u529f";
    }

    @Override
    public Map<String, BigDecimal> queryReceiptMny(Long contractId, Long projectId) {
        HashMap<String, BigDecimal> info = new HashMap<String, BigDecimal>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum( sum_received_Mny ) AS sumReceivedMny"});
        if (projectId != null) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = super.getMap((Wrapper)queryWrapper);
        info.put("sumReceivedMny", null != resultMap && null != resultMap.get("sumReceivedMny") ? new BigDecimal(resultMap.get("sumReceivedMny").toString()) : BigDecimal.ZERO);
        return info;
    }

    @Override
    public String validateContract(Long contractId, Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.notIn(ReceiptRegisterEntity::getBillState, new Object[]{1, 3});
        if (id != null) {
            queryWrapper.ne(BaseEntity::getId, (Object)id);
        }
        queryWrapper.eq(ReceiptRegisterEntity::getContractId, (Object)contractId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u6536\u6b3e\u767b\u8bb0\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u6210\u529f\uff01";
    }

    @Override
    public BigDecimal getTotalColumnInfo(QueryParam param, boolean isEs) {
        QueryWrapper wrapper = ReceiptRegisterServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ReceiptRegisterVO> list = ((ReceiptRegisterMapper)this.baseMapper).queryPageList(null, wrapper);
        BigDecimal sumReceivedMny = list.stream().filter(entity -> entity.getSumReceivedMny() != null).map(ReceiptRegisterVO::getSumReceivedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sumReceivedMny;
    }

    @Override
    public void autoPMReceipt() {
        CommonResponse pmVos = this.ipmsksjApi.queryList();
        List pmList = new ArrayList();
        if (pmVos.isSuccess()) {
            pmList = (List)pmVos.getData();
        } else {
            this.logger.error(pmVos.getMsg());
        }
        ArrayList<ReceiptRegisterEntity> updateList = new ArrayList<ReceiptRegisterEntity>();
        ArrayList<ReceiptRegisterEntity> registerList = new ArrayList<ReceiptRegisterEntity>();
        if (CollectionUtils.isNotEmpty(pmList)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            CommonResponse contractList = this.contractApi.queryList(queryParam);
            Map<Object, Object> contractMap = new HashMap();
            if (contractList.isSuccess()) {
                contractMap = ((List)contractList.getData()).stream().collect(Collectors.toMap(ContractPoolVO::getContractId, Function.identity(), (key1, key2) -> key2));
            } else {
                this.logger.error(contractList.getMsg());
            }
            CommonResponse resp = this.projectPoolApi.queryProjectPoolList(null, null, null);
            List result = new ArrayList();
            Map<Object, Object> projectMap = new HashMap();
            if (resp.isSuccess()) {
                result = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectPoolSetVO.class);
                projectMap = result.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key2));
            } else {
                this.logger.error(resp.getMsg());
            }
            for (PMSKSJVO vo : pmList) {
                ReceiptRegisterEntity entity = new ReceiptRegisterEntity();
                entity.setBillCode(StringUtils.isNotBlank((CharSequence)vo.getBillCode()) ? vo.getBillCode() : null);
                if (!StringUtils.isNotBlank((CharSequence)vo.getProjectId())) continue;
                entity.setProjectId(Long.valueOf(vo.getProjectId().trim()));
                if (!projectMap.containsKey(entity.getProjectId())) continue;
                ProjectPoolSetVO poolSetVO = (ProjectPoolSetVO)projectMap.get(entity.getProjectId());
                entity.setProjectCode(poolSetVO.getCode());
                entity.setProjectName(poolSetVO.getName());
                if (StringUtils.isBlank((CharSequence)vo.getContractId()) || vo.getContractId().equals("999")) {
                    poolSetVO = (ProjectPoolSetVO)projectMap.get(entity.getProjectId());
                    entity.setContractId(999L);
                    entity.setContractCode("999");
                    entity.setContractName("999");
                    entity.setOrgId(poolSetVO.getProjectDepartmentId());
                    entity.setOrgName(poolSetVO.getProjectDepartmentName());
                    entity.setParentOrgId(poolSetVO.getOrgId());
                    entity.setParentOrgName(poolSetVO.getOrgName());
                    entity.setCustomerId(poolSetVO.getConstructId());
                    entity.setCustomerName(poolSetVO.getConstructName());
                } else {
                    entity.setContractId(Long.valueOf(vo.getContractId().trim()));
                    if (!contractMap.containsKey(entity.getContractId())) continue;
                    ContractPoolVO cvo = (ContractPoolVO)contractMap.get(Long.valueOf(vo.getContractId().trim()));
                    entity.setContractCode(cvo.getContractCode());
                    entity.setContractTaxMny(cvo.getContractTaxMny());
                    entity.setContractMny(cvo.getContractMny());
                    entity.setContractCategoryId(cvo.getCategoryId());
                    entity.setContractCategoryName(cvo.getCategoryName());
                    entity.setSourceCategoryType(cvo.getSourceType());
                    entity.setSourceCategoryTypeName(cvo.getSourceTypeName());
                    entity.setOrgId(cvo.getOrgId());
                    entity.setOrgCode(cvo.getOrgCode());
                    entity.setOrgName(cvo.getOrgName());
                    entity.setParentOrgId(cvo.getParentOrgId());
                    entity.setParentOrgCode(cvo.getParentOrgCode());
                    entity.setParentOrgName(cvo.getParentOrgName());
                    entity.setCustomerId(cvo.getPartyaId());
                    entity.setCustomerName(cvo.getPartyaName());
                    entity.setTotalReceiptMny(cvo.getTotalActualPayRecTaxMny());
                }
                entity.setClausePropertyId(1522567880378720258L);
                entity.setClausePropertyName("\u8fdb\u5ea6\u6b3e");
                if (StringUtils.isNotBlank((CharSequence)vo.getReceiptDate())) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                    try {
                        entity.setReceiptDate(dateFormat.parse(vo.getReceiptDate()));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    entity.setReceiptDate(new Date());
                }
                entity.setSumReceivedMny(vo.getSumReceivedMny() != null ? vo.getSumReceivedMny() : BigDecimal.ZERO);
                entity.setReceiptReason(vo.getMemo());
                entity.setSourceFlag(1);
                entity.setBillState(3);
                entity.setReceiptContractFlag(0);
                if (entity.getContractId() != 999L) {
                    updateList.add(entity);
                }
                registerList.add(entity);
            }
        }
        if (CollectionUtils.isNotEmpty(registerList)) {
            ReceiptRegisterVO vo = null;
            for (ReceiptRegisterEntity entity : registerList) {
                if (!StringUtils.isBlank((CharSequence)entity.getBillCode())) continue;
                vo = (ReceiptRegisterVO)BeanMapper.map((Object)((Object)entity), ReceiptRegisterVO.class);
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                    continue;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            super.saveOrUpdateBatch(registerList, registerList.size(), false);
            List projectIds = registerList.stream().map(ReceiptRegisterEntity::getProjectId).collect(Collectors.toList());
            List contractIds = registerList.stream().map(ReceiptRegisterEntity::getContractId).collect(Collectors.toList());
            PMSKSJVO pmvo = new PMSKSJVO();
            pmvo.setProjectIds(projectIds);
            pmvo.setContractIds(contractIds);
            pmvo.setCwFlag("1");
            SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            pmvo.setUpdateTime(dateFormat1.format(new Date()));
            this.ipmsksjApi.updateFlag(pmvo);
            if (CollectionUtils.isNotEmpty(updateList)) {
                for (ReceiptRegisterEntity entity : updateList) {
                    if (entity.getSumReceivedMny() == null || entity.getSumReceivedMny().equals(BigDecimal.ZERO)) continue;
                    this.contractApi.updateActualPayRecMny(entity.getContractId(), entity.getSumReceivedMny(), entity.getSumReceivedMny(), true);
                }
            }
        }
    }
}

