/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.vo.SubjectReportVO;
import com.ejianc.business.steelstructure.income.bean.BudgetEntity;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.enums.BudgetEnum;
import com.ejianc.business.steelstructure.income.service.IBudgetService;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.utils.MathUtil;
import com.ejianc.business.steelstructure.income.utils.ParamUtil;
import com.ejianc.business.steelstructure.income.vo.BudgetDetailReportVO;
import com.ejianc.business.steelstructure.income.vo.BudgetHistoryVO;
import com.ejianc.business.steelstructure.income.vo.BudgetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"budget"})
public class BudgetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBudgetService service;
    @Autowired
    private IContractRegisterService contractService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetVO> saveOrUpdate(@RequestBody BudgetVO saveorUpdateVO) {
        BudgetVO vo = this.service.saveOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u7f16\u8f91\u4fdd\u5b58\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveBudget"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetVO> saveBudget(@RequestBody BudgetVO saveorUpdateVO) {
        BudgetVO vo = this.service.saveBudget(saveorUpdateVO);
        return CommonResponse.success((String)"\u7f16\u8f91\u4fdd\u5b58\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkBudget"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkBudget(Long projectId) {
        List budgetEntities = this.service.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).eq(BudgetEntity::getProjectId, (Object)projectId));
        BigDecimal totalBudgetTaxMny = BigDecimal.ZERO;
        BigDecimal totalNicContractMny = BigDecimal.ZERO;
        for (Object budgetEntity : budgetEntities) {
            BigDecimal budgetTaxMny = budgetEntity.getBudgetTaxMny();
            if (budgetTaxMny != null) {
                totalBudgetTaxMny = totalBudgetTaxMny.add(budgetTaxMny);
                continue;
            }
            totalBudgetTaxMny = totalBudgetTaxMny.add(BigDecimal.ZERO);
        }
        List registerEntities = this.contractService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).eq(ContractRegisterEntity::getProjectId, (Object)projectId));
        for (ContractRegisterEntity contractRegisterEntity : registerEntities) {
            BigDecimal nicContractMny = contractRegisterEntity.getNicContractMny();
            if (nicContractMny != null) {
                totalNicContractMny = totalNicContractMny.add(nicContractMny);
                continue;
            }
            totalBudgetTaxMny = totalBudgetTaxMny.add(BigDecimal.ZERO);
        }
        BigDecimal above = totalBudgetTaxMny.subtract(totalNicContractMny);
        if (above.compareTo(BigDecimal.ZERO) > 0) {
            return CommonResponse.success((String)"\u7d2f\u8ba1\u9884\u7b97\u4e66\u91d1\u989d\u8d85\u51fa,\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff01", (Object)false);
        }
        return CommonResponse.success((String)"\u7d2f\u8ba1\u9884\u7b97\u4e66\u91d1\u989d\u6b63\u5e38\uff0c\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff01", (Object)true);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetVO> queryDetail(Long id) {
        BudgetVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryBudgetDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetVO> queryBudgetDetail(Long id) {
        BudgetVO vo = this.service.queryBudgetDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetVO> vos) {
        this.service.delete(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("budgetName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Budget-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetVO>> refBudgetData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("budgetName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            }
            if (null != conditionMap.get("budgetSource")) {
                Integer budgetSource = Integer.parseInt(conditionMap.get("budgetSource").toString());
                queryParam.getParams().put("budgetSource", new Parameter("eq", (Object)budgetSource));
            }
            if (null != conditionMap.get("incomeFlag")) {
                Integer incomeFlag = Integer.parseInt(conditionMap.get("incomeFlag").toString());
                queryParam.getParams().put("incomeFlag", new Parameter("eq", (Object)incomeFlag));
            }
            if (null != conditionMap.get("useFlag")) {
                Integer useFlag = Integer.parseInt(conditionMap.get("useFlag").toString());
                if (useFlag == 1) {
                    if (null != conditionMap.get("claimId")) {
                        Long claimId = Long.valueOf(conditionMap.get("claimId").toString());
                        ComplexParam useId = ParamUtil.getOrParam("useId", new Parameter("eq", null), new Parameter("eq", (Object)claimId));
                        queryParam.getComplexParams().add(useId);
                    } else {
                        queryParam.getParams().put("useId", new Parameter("eq", null));
                    }
                } else {
                    queryParam.getParams().put("useId", new Parameter("ne", null));
                }
            }
            if (null == conditionMap.get("operateFlag")) {
                queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(1, 3)));
            }
        }
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.service.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List budgetVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), BudgetVO.class);
        for (BudgetVO vo : budgetVOS) {
            vo.setBudgetSourceName(BudgetEnum.getEnumByStateCode(vo.getBudgetSource()).getName());
        }
        result.setRecords(budgetVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budget-info-import.xlsx", (String)"\u9879\u76ee\u9884\u7b97\u4e66\u5bfc\u5165\u6a21\u677f(\u6e05\u5355\u6a21\u5f0f)");
    }

    @RequestMapping(value={"/downloadCost"})
    @ResponseBody
    public void downloadCost(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budget-cost-import.xlsx", (String)"\u9879\u76ee\u9884\u7b97\u4e66\u5bfc\u5165\u6a21\u677f(\u8d39\u7528\u9879\u6a21\u5f0f)");
    }

    @RequestMapping(value={"/downloadZzyjInfo"})
    @ResponseBody
    public void downloadZzyjInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budget-zzyj-import.xlsx", (String)"\u9879\u76ee\u9884\u7b97\u4e66\u5bfc\u5165\u6a21\u677f(\u90d1\u5dde\u4e00\u5efa\u9884\u7b97\u6e05\u5355)");
    }

    @RequestMapping(value={"/excelImportCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportCost(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportCost(request, response);
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportInfo(request, response);
    }

    @RequestMapping(value={"/excelImportZzyjInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportZzyjInfo(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportZzyjInfo(request, response);
    }

    @RequestMapping(value={"/queryBudgetHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetHistoryVO> queryBudgetHistory(@RequestParam(value="id") Long id, @RequestParam(value="accountingId", required=false) Long accountingId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryBudgetHistory(id, accountingId));
    }

    @RequestMapping(value={"/queryBudgetList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<BudgetVO>> queryBudgetList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("budgetName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter("in", billStatus));
        param.getParams().put("incomeFlag", new Parameter("eq", (Object)1));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param, false);
        List budgetVOS = BeanMapper.mapList((Iterable)list, BudgetVO.class);
        Long contractId = Long.parseLong(((Parameter)param.getParams().get("contractId")).getValue().toString());
        BudgetHistoryVO budgetHistoryVO = this.service.queryBudgetHistory(contractId, null);
        for (BudgetVO vo : budgetVOS) {
            BigDecimal budgetRate = MathUtil.safeMultiply(MathUtil.safeDiv(vo.getBudgetTaxMny(), budgetHistoryVO.getAllTaxMny()), new BigDecimal(100));
            vo.setBudgetRate(budgetRate);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)budgetVOS);
    }

    @RequestMapping(value={"/getCostAllDetails"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SubjectReportVO>> getCostAllDetails(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.getCostAllDetails(param));
    }

    @RequestMapping(value={"/getBudgetReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetDetailReportVO>> getBudgetReport(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.getBudgetReport(param, false));
    }

    @RequestMapping(value={"/budgetDetailExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void budgetDetailExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<BudgetDetailReportVO> page = this.service.getBudgetReport(param, true);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            page.getRecords().forEach(vo -> {
                if (null != vo.getBudgetModel() && 0 == vo.getBudgetModel()) {
                    vo.setBudgetModelName("\u6e05\u5355\u6a21\u5f0f");
                } else if (null != vo.getBudgetModel() && 1 == vo.getBudgetModel()) {
                    vo.setBudgetModelName("\u8d39\u7528\u9879\u6a21\u5f0f");
                } else if (null != vo.getBudgetModel() && 2 == vo.getBudgetModel()) {
                    vo.setBudgetModelName("\u90d1\u5dde\u4e00\u5efa\u9884\u7b97\u6e05\u5355");
                }
            });
        }
        beans.put("records", page.getRecords());
        ExcelExport.getInstance().export("budget-detail-export.xlsx", beans, response);
    }
}

