/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.income.bean.ContractReviewEntity;
import com.ejianc.business.steelstructure.income.service.IContractReviewService;
import com.ejianc.business.steelstructure.income.vo.ContractReviewVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"historyModify"})
public class HistoryModifyController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IContractReviewService reviewService;

    private String getContractReview(String oldReviewCode, List<ContractReviewEntity> list) {
        List entityList = this.reviewService.list((Wrapper)Wrappers.lambdaQuery().eq(ContractReviewEntity::getBillCode, (Object)oldReviewCode));
        if (entityList != null) {
            oldReviewCode = ((ContractReviewEntity)((Object)entityList.get(0))).getOldReviewCode();
            list.add((ContractReviewEntity)((Object)entityList.get(0)));
            return oldReviewCode;
        }
        return null;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractReviewVO>> queryList(@RequestBody QueryParam param) {
        String oldReviewCode = ((Parameter)param.getParams().get("oldReviewCode")).getValue().toString();
        ArrayList<ContractReviewEntity> list = new ArrayList<ContractReviewEntity>();
        while (oldReviewCode != null) {
            oldReviewCode = this.getContractReview(oldReviewCode, list);
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        page.setRecords(list);
        page.setTotal((long)list.size());
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

