/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.business.steelstructure.income.bean.TaskEntity;
import com.ejianc.business.steelstructure.income.enums.SteelSpecialityEnum;
import com.ejianc.business.steelstructure.income.service.ITaskService;
import com.ejianc.business.steelstructure.income.vo.TaskVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"task"})
public class TaskController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ITaskService service;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TaskVO> saveOrUpdate(@RequestBody TaskVO saveOrUpdateVO) {
        TaskEntity entity = (TaskEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TaskEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        TaskVO vo = (TaskVO)BeanMapper.map((Object)((Object)entity), TaskVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TaskVO> queryDetail(Long id) {
        TaskEntity entity = (TaskEntity)((Object)this.service.selectById(id));
        TaskVO vo = (TaskVO)BeanMapper.map((Object)((Object)entity), TaskVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaskVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TaskVO taskVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Task-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTaskData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> refTaskData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getContractValueByOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getContractValueByOrgId(@RequestParam(value="orgId", required=true) Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> departmentIds.add(org.getId()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("ywDate", new Parameter("between", (Object)(LocalDate.now().getYear() + "-1-1," + LocalDate.now().getYear() + "-12-31")));
        BigDecimal bigDecimal = new BigDecimal(0.0);
        BigDecimal bigDecimal1 = new BigDecimal(10000);
        List undertakeEntities = this.service.queryList(param);
        this.logger.info("-----------\u83b7\u53d6\u627f\u63fd\u4efb\u52a1\u6570\u636e\u5171{}\u6761\u3002", (Object)undertakeEntities.size());
        this.logger.info("-----------\u83b7\u53d6\u627f\u63fd\u4efb\u52a1\u6570\u636e:{}\u3002", (Object)undertakeEntities.size());
        for (TaskEntity entity : undertakeEntities) {
            bigDecimal = bigDecimal.add(entity.getProjectCost());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u603b\u91d1\u989d\u6210\u529f\uff01", (Object)bigDecimal.multiply(bigDecimal1));
    }

    @RequestMapping(value={"/getUndertakeInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<UndertakeApiVO>> getUndertakeInfo(@RequestParam(value="orgId", required=true) Long orgId, Integer time, Integer dateIn) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> {
            if (3 == org.getOrgType() || 2 == org.getOrgType()) {
                departmentIds.add(org.getId());
            }
        });
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        if (time != null) {
            if (time.equals(1)) {
                param.getParams().put("ywDate", new Parameter("between", (Object)(TaskController.getMonthStartTime(dateTimeFormatter) + "," + TaskController.getMonthEndTime(dateTimeFormatter))));
            } else if (time.equals(2)) {
                param.getParams().put("ywDate", new Parameter("between", (Object)(TaskController.getFromThisQuarterStartTime(nowDate, dateTimeFormatter) + "," + TaskController.getFromThisQuarterEndTime(nowDate, dateTimeFormatter))));
            } else {
                param.getParams().put("ywDate", new Parameter("between", (Object)(TaskController.getFromThisYearStartTime(nowDate, dateTimeFormatter) + "," + TaskController.getFromThisYearEndTime(nowDate, dateTimeFormatter))));
            }
        } else if (dateIn != null) {
            param.getParams().put("ywDate", new Parameter("between", (Object)(dateIn + "-01-01," + dateIn + "-12-31")));
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"speciality_id"});
        List<UndertakeApiVO> undertakeVOS = this.service.queryUndertakeInfoList(wrapper);
        QueryWrapper wrapper1 = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper1.groupBy(new Object[]{"speciality_id"});
        List<UndertakeApiVO> undertakeVOS1 = this.service.queryUndertakeInfoList(wrapper1);
        ArrayList<UndertakeApiVO> undertakeApiVOS = new ArrayList<UndertakeApiVO>();
        UndertakeApiVO vo1 = new UndertakeApiVO(SteelSpecialityEnum.CODE_1.getCode(), SteelSpecialityEnum.CODE_1.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo2 = new UndertakeApiVO(SteelSpecialityEnum.CODE_2.getCode(), SteelSpecialityEnum.CODE_2.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo3 = new UndertakeApiVO(SteelSpecialityEnum.CODE_3.getCode(), SteelSpecialityEnum.CODE_3.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo4 = new UndertakeApiVO(SteelSpecialityEnum.CODE_4.getCode(), SteelSpecialityEnum.CODE_4.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo5 = new UndertakeApiVO(SteelSpecialityEnum.CODE_5.getCode(), SteelSpecialityEnum.CODE_5.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo6 = new UndertakeApiVO(SteelSpecialityEnum.CODE_6.getCode(), SteelSpecialityEnum.CODE_6.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo7 = new UndertakeApiVO(SteelSpecialityEnum.CODE_7.getCode(), SteelSpecialityEnum.CODE_7.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        for (UndertakeApiVO vo : undertakeVOS) {
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_1.getCode())) {
                vo1.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_2.getCode())) {
                vo2.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_3.getCode())) {
                vo3.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_4.getCode())) {
                vo4.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_5.getCode())) {
                vo5.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_6.getCode())) {
                vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (!vo.getSpeciality().equals(SteelSpecialityEnum.CODE_7.getCode())) continue;
            vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
        }
        for (UndertakeApiVO vo : undertakeVOS1) {
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_1.getCode())) {
                vo1.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_2.getCode())) {
                vo2.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_3.getCode())) {
                vo3.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_4.getCode())) {
                vo4.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_5.getCode())) {
                vo5.setSum(vo.getSum());
                continue;
            }
            if (vo.getSpeciality().equals(SteelSpecialityEnum.CODE_6.getCode())) {
                vo6.setSum(vo.getSum());
                continue;
            }
            if (!vo.getSpeciality().equals(SteelSpecialityEnum.CODE_7.getCode())) continue;
            vo6.setSum(vo.getSum());
        }
        undertakeApiVOS.add(vo1);
        undertakeApiVOS.add(vo2);
        undertakeApiVOS.add(vo3);
        undertakeApiVOS.add(vo4);
        undertakeApiVOS.add(vo5);
        undertakeApiVOS.add(vo6);
        undertakeApiVOS.add(vo7);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", undertakeApiVOS);
    }

    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, 0);
        cal.add(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    private static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, 0);
        cal.add(2, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }

    public static String getFromThisQuarterStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);
    }

    public static String getFromThisQuarterEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    public static String getFromThisYearStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    public static String getFromThisYearEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }

    @RequestMapping(value={"/getDeptOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DeptOrderApiVO>> getDeptOrder(@RequestParam(value="type", required=true) Integer type, @RequestParam(value="time", required=true) Integer time, @RequestParam(value="dateIn", required=false) Integer dateIn) {
        if (time == null || type == null) {
            return CommonResponse.error((String)"\u8f93\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        if (dateIn != null) {
            nowDate = LocalDate.of((int)dateIn, 12, 31);
        }
        if (time != null) {
            String ywDate = TaskController.getFromThisYearStartTime(nowDate, dateTimeFormatter) + "," + TaskController.getFromThisYearEndTime(nowDate, dateTimeFormatter);
            if (time.equals(1)) {
                ywDate = TaskController.getMonthStartTime(dateTimeFormatter) + "," + TaskController.getMonthEndTime(dateTimeFormatter);
            } else if (time.equals(2)) {
                ywDate = TaskController.getFromThisQuarterStartTime(nowDate, dateTimeFormatter) + "," + TaskController.getFromThisQuarterEndTime(nowDate, dateTimeFormatter);
            }
            if (type.equals(2)) {
                param.getParams().put("statDate", new Parameter("between", (Object)ywDate));
            } else {
                param.getParams().put("ywDate", new Parameter("between", (Object)ywDate));
            }
        }
        List<Object> deptOrderApiVOS = new ArrayList();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"make_org_id"});
        deptOrderApiVOS = this.service.queryDeptOrderList(wrapper);
        int i = 0;
        int index = -1;
        for (DeptOrderApiVO deptOrderApiVO : deptOrderApiVOS) {
            OrgVO data;
            if ("G9\u9879\u76ee".equals(deptOrderApiVO.getDeptName())) {
                index = i;
            }
            deptOrderApiVO.setValue(deptOrderApiVO.getValue());
            CommonResponse oneById = this.iOrgApi.getOneById(deptOrderApiVO.getDeptId());
            if (oneById.getCode() == 0 && (data = (OrgVO)oneById.getData()) != null) {
                deptOrderApiVO.setDeptType(data.getOrgType());
            }
            ++i;
        }
        if (index > -1) {
            deptOrderApiVOS.remove(index);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", deptOrderApiVOS);
    }
}

