/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.service;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonBillCodeService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private final String REGEX = "\\{(.*?)}";

    public String getCode(String codeRule, Map<String, String> valMap, BaseVO vo) {
        CommonResponse resp = this.billCodeApi.getCodeBatchByRuleCode(codeRule, InvocationInfoProxy.getTenantid());
        if (!resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resp.getMsg()}) ? resp.getMsg() : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String code = (String)resp.getData();
        if (vo != null) {
            String jsonString1 = JSON.toJSONString((Object)vo);
            Map map = (Map)JSON.parseObject((String)jsonString1, Map.class);
            resultMap.putAll(map);
        }
        if (valMap != null && valMap.size() > 0) {
            resultMap.putAll(valMap);
        }
        if (resultMap != null && resultMap.size() > 0) {
            Pattern pattern = Pattern.compile("\\{(.*?)}");
            Matcher matcher = pattern.matcher(code);
            while (matcher.find()) {
                String key = matcher.group(1);
                String _key = "{" + key + "}";
                if (resultMap.get(key) == null) continue;
                code = code.replace(_key, resultMap.get(key) != null ? String.valueOf(resultMap.get(key)) : _key);
            }
        }
        return code;
    }

    public String getCodeByOrgId(Long orgId, String codeRule, BaseVO vo) {
        CommonResponse parents;
        String orgCode = "";
        HashMap<String, String> valMap = new HashMap<String, String>();
        if (null != orgId && (parents = this.orgApi.findParentsByOrgId(orgId)) != null && parents.getData() != null && CollectionUtils.isNotEmpty((Collection)((Collection)parents.getData()))) {
            List orgs = (List)parents.getData();
            Collections.sort(orgs, Comparator.comparing(OrgVO::getOrgType));
            Map<Integer, String> map = orgs.stream().collect(Collectors.toMap(OrgVO::getOrgType, OrgVO::getCode, (key1, key2) -> key2));
            String fCode = map.get(2);
            orgCode = StringUtils.isNotEmpty((CharSequence)fCode) ? fCode : (orgs.size() > 1 ? ((OrgVO)orgs.get(orgs.size() - 2)).getCode() : ((OrgVO)orgs.get(0)).getCode());
            valMap.put("orgCode", orgCode);
        }
        return this.getCode(codeRule, valMap, vo);
    }
}

