/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.FinalizedEntity;
import com.ejianc.business.steelstructure.income.bean.SettleReportEntity;
import com.ejianc.business.steelstructure.income.enums.FinalStageEnum;
import com.ejianc.business.steelstructure.income.mapper.FinalizedMapper;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IFinalizedService;
import com.ejianc.business.steelstructure.income.service.ISettleReportService;
import com.ejianc.business.steelstructure.income.utils.BillTypeCodeEnum;
import com.ejianc.business.steelstructure.income.utils.ValidateUtil;
import com.ejianc.business.steelstructure.income.vo.ContractRegisterVO;
import com.ejianc.business.steelstructure.income.vo.FinalizedHistoryVO;
import com.ejianc.business.steelstructure.income.vo.FinalizedVO;
import com.ejianc.business.steelstructure.income.vo.SettleReportVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="finalizedService")
public class FinalizedServiceImpl
extends BaseServiceImpl<FinalizedMapper, FinalizedEntity>
implements IFinalizedService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final String FINALIZED_CODE = "FINALIZED";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISettleReportService reportService;
    @Autowired
    private ValidateUtil validateUtil;
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IContractRegisterService contractService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRoleApi roleApi;
    @Value(value="${msg.anentId}")
    private String anentId;
    @Value(value="${msg.secret}")
    private String secret;
    @Value(value="${msg.enUrl}")
    private String enUrl;
    @Value(value="${msg.finalized.roleId}")
    private Long roleId;

    @Override
    public FinalizedVO saveOrUpdate(FinalizedVO saveOrUpdateVO) {
        if (!Objects.equals(null, saveOrUpdateVO.getContractId()) && !this.validateUtil.validateUpStreamVersion(String.valueOf(saveOrUpdateVO.getContractId()), BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c.getCode(), saveOrUpdateVO.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        this.querySettleReport(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getContractId());
        FinalizedVO finalizedVO = null;
        FinalizedEntity entity = (FinalizedEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FinalizedEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)FINALIZED_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            finalizedVO = this.queryFinalizedList(entity.getProjectId(), entity.getContractId(), null);
            this.validateFinalStage(entity.getProjectId(), entity.getContractId(), entity.getFinalStage(), null);
        } else {
            finalizedVO = this.queryFinalizedList(entity.getProjectId(), entity.getContractId(), entity.getId());
            this.validateFinalStage(entity.getProjectId(), entity.getContractId(), entity.getFinalStage(), entity.getId());
            FinalizedEntity oldEneity = (FinalizedEntity)((Object)this.selectById(entity.getId()));
            if (!Objects.equals(oldEneity.getContractId(), entity.getContractId()) && Objects.equals(oldEneity.getFinalStage(), FinalStageEnum.\u7ec8\u5ba1.getCode())) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(ContractRegisterEntity::getIsFinish, (Object)0);
                wrapper.set(ContractRegisterEntity::getContractStatus, (Object)"1");
                wrapper.eq(BaseEntity::getId, (Object)oldEneity.getContractId());
                this.registerService.update((Wrapper)wrapper);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        FinalizedVO vo = (FinalizedVO)BeanMapper.map((Object)((Object)entity), FinalizedVO.class);
        return vo;
    }

    @Override
    public SettleReportVO querySettleReport(Long projectId, Long contractId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(SettleReportEntity::getProjectId, (Object)projectId);
        }
        wrapper.eq(SettleReportEntity::getContractId, (Object)contractId);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.reportService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            throw new BusinessException("\u8bf7\u5148\u505a\u7ed3\u7b97\u62a5\u5ba1\uff01");
        }
        boolean billStateFlag = list.stream().anyMatch(entity -> entity.getBillState() == 1 || entity.getBillState() == 3);
        if (!billStateFlag) {
            throw new BusinessException("\u8bf7\u5148\u505a\u7ed3\u7b97\u62a5\u5ba1\uff01");
        }
        SettleReportVO vo = new SettleReportVO();
        for (SettleReportEntity entity2 : list) {
            if (entity2.getBillState() != 1 && entity2.getBillState() != 3) continue;
            vo = (SettleReportVO)BeanMapper.map((Object)((Object)entity2), SettleReportVO.class);
            break;
        }
        return vo;
    }

    @Override
    public FinalizedVO queryFinalizedList(Long projectId, Long contractId, Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(FinalizedEntity::getProjectId, (Object)projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        wrapper.eq(FinalizedEntity::getContractId, (Object)contractId);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new FinalizedVO();
        }
        long count = list.stream().filter(entity -> entity.getBillState() != 1 && entity.getBillState() != 3).count();
        if (count > 0L) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u5de5\u7a0b\u5b9a\u6848\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
        }
        return (FinalizedVO)BeanMapper.map(list.get(0), FinalizedVO.class);
    }

    @Override
    public Boolean validateFinalStage(Long projectId, Long contractId, String finalStage, Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(FinalizedEntity::getProjectId, (Object)projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        wrapper.eq(FinalizedEntity::getContractId, (Object)contractId);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            if (Objects.equals(finalStage, FinalStageEnum.\u7ec8\u5ba1.getCode())) {
                return true;
            }
            if (!Objects.equals(finalStage, FinalStageEnum.\u4e00\u5ba1.getCode())) {
                throw new BusinessException("\u8bf7\u5148\u5b8c\u6210\u4e00\u5ba1\uff01");
            }
        }
        List finalStageList = list.stream().map(FinalizedEntity::getFinalStage).collect(Collectors.toList());
        if (Objects.equals(finalStage, FinalStageEnum.\u7ec8\u5ba1.getCode())) {
            LambdaQueryWrapper reportWrapper = new LambdaQueryWrapper();
            if (!Objects.equals(null, projectId)) {
                reportWrapper.eq(SettleReportEntity::getProjectId, (Object)projectId);
            }
            reportWrapper.eq(SettleReportEntity::getContractId, (Object)contractId);
            reportWrapper.orderByDesc(BaseEntity::getCreateTime);
            List reportEntityList = this.reportService.list((Wrapper)reportWrapper);
            long count = reportEntityList.stream().filter(entity -> entity.getBillState() != 1 && entity.getBillState() != 3).count();
            if (count > 0L) {
                throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u5b58\u672a\u751f\u6548\u7684\u7ed3\u7b97\u62a5\u5ba1\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u7ec8\u5ba1\u5b9a\u6848\uff01");
            }
        }
        return true;
    }

    @Override
    public FinalizedHistoryVO queryFinalizedRecord(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(id));
        FinalizedHistoryVO vo = new FinalizedHistoryVO();
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(FinalizedEntity::getContractId, (Object)id);
        wrapper.in(FinalizedEntity::getBillState, billStateList);
        wrapper.orderByDesc(FinalizedEntity::getCheckDate);
        List list = super.list((Wrapper)wrapper);
        BigDecimal sumCheckTaxMny = list.stream().filter(e -> e.getCheckTaxMny() != null).map(FinalizedEntity::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReviewSubtractMny = list.stream().filter(e -> e.getReviewSubtractMny() != null).map(FinalizedEntity::getReviewSubtractMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setSumCheckMny(sumCheckTaxMny);
        vo.setSumReviewSubtractMny(sumReviewSubtractMny);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, FinalizedVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(FinalizedVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean pushContract(ContractRegisterVO vo, String performanceStatus) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            CommonResponse transDataResp;
            this.registerService.delContractFromPool(vo.getId());
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setPerformanceStatus(performanceStatus);
            data.setChangeStatus(Integer.valueOf(Integer.parseInt(vo.getChangeStatus())));
            data.setContractProperty(Integer.valueOf(1));
            data.setSourceType(ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-steelstructure-frontend/#/contractRegister/contractApprove?id=" + vo.getId() : "/ejc-steelstructure-frontend/#/contractRegister/supplementCard?id=";
            data.setCategoryId(Long.valueOf(1524001989040545793L));
            data.setPcCardUrl(url);
            data.setEstimationTaxMny(vo.getEstimationTaxMny());
            CommonResponse projectPoolSetVO = this.projectSetApi.getProjectId(data.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
                CommonResponse defDocById;
                ProjectPoolSetVO data1 = (ProjectPoolSetVO)projectPoolSetVO.getData();
                if (data1.getAreaName() != null) {
                    data.setAreaName(data1.getAreaName());
                }
                if (data1.getAddress() != null) {
                    data.setAddress(data1.getAddress());
                }
                if (data1.getEngineeringType() != null && (defDocById = this.defdocApi.getDefDocById(data1.getEngineeringTypeId())).getCode() == 0 && defDocById.getData() != null) {
                    data.setEngineeringType(((DefdocDetailVO)defDocById.getData()).getName());
                }
            }
            if ((transDataResp = this.contractPoolApi.saveOrUpdateContract(data)).isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    private void convertSettleVOToSettlePoolVO(FinalizedVO vo, SettlePoolVO spv) {
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        spv.setSourceType("project_decide");
        spv.setSourceId(vo.getId());
        spv.setId(vo.getId());
        spv.setSettleProperty(Integer.valueOf(1));
        spv.setUltimateFlag(Integer.valueOf(0));
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setBillCodeUrl("/ejc-steelstructure-frontend/#/finalized/card?id=" + vo.getId());
        if (vo.getContractId() != null) {
            ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.contractService.selectById(vo.getContractId()));
            spv.setContractType("contraction");
            spv.setContractFlag(Integer.valueOf(1));
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getBillCode());
            spv.setPartyaId(contractEntity.getCustomerId());
            spv.setPartyaName(contractEntity.getCustomerName());
            spv.setPartybId(contractEntity.getSupplierId());
            spv.setPartybName(contractEntity.getSupplierName());
            spv.setSignDate(contractEntity.getSignDate());
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal lastTax = BigDecimal.ZERO;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            wrapper.in(FinalizedEntity::getBillState, new Object[]{1, 3});
            wrapper.eq(BaseEntity::getDr, (Object)0);
            wrapper.eq(FinalizedEntity::getContractId, (Object)vo.getContractId());
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
            wrapper.eq(FinalizedEntity::getFinalStage, (Object)"4");
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (FinalizedEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getCheckTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getCheckTaxMny();
                    BigDecimal settMny = settlementEntity.getCheckMny() == null ? BigDecimal.ZERO : settlementEntity.getCheckMny();
                    BigDecimal settTax = settlementEntity.getTax() == null ? BigDecimal.ZERO : settlementEntity.getTax();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);
            spv.setLastMny(lastMny);
            spv.setLastTax(lastTax);
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210");
    }

    @Override
    public boolean sendMsg(List<FinalizedVO> vos) {
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(this.roleId);
        CommonResponse roleResp = this.roleApi.getRoleUser(roleIds, null);
        if (!roleResp.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u53d1\u9001\u4fe1\u606f\u89d2\u8272\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List relationVOS = (List)roleResp.getData();
        List userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());
        BigDecimal sumMny = vos.stream().map(FinalizedVO::getReportSettleTaxMny).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        String subject = "\u3010" + vos.get(0).getContractName() + "\u3011\u5171" + vos.size() + "\u9879\u5de5\u7a0b\u5b9a\u6848\u5df2\u5f52\u6863";
        String content = "\u5408\u540c\u540d\u79f0:\u3010" + vos.get(0).getContractName() + "\u3011" + '\n' + "\u786e\u8ba4\u5b9a\u6848\u91d1\u9896\uff1a" + sumMny + "\u5143";
        String detail = "\n\u5171" + vos.size() + "\u9879\u5de5\u7a0b\u5b9a\u6848\u5df2\u5f52\u6863,\u8bf7\u524d\u5f80\u7535\u8111\u7aef\u67e5\u770b!";
        String pcUrl = "/ejc-steelstructure-frontend/#/finalized/card?id=" + vos.get(0).getId();
        Iterator iterator = userIds.iterator();
        if (iterator.hasNext()) {
            String userId = (String)iterator.next();
            String moUrl = this.enUrl + "/portal/sso/index?&userid=" + userId + "&targeturl=" + this.enUrl + "/ejc-steelstructure-frontend/#/finalized/card?id=" + vos.get(0).getId();
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("weixinee");
            channel.add("sys");
            String[] receivers = new String[]{userId};
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject(content + detail);
            parameter.setContent(content + detail);
            parameter.setPcUrl(pcUrl);
            parameter.setMobileUrl(moUrl);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)this.anentId);
            weixineeParams.put("secret", (Object)this.secret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)subject);
            weixineeParams.put("description", (Object)content);
            weixineeParams.put("url", (Object)(this.enUrl + "/portal/sso/index?&userid=" + userId + "&targeturl=" + this.enUrl + "/ejc-steelstructure-frontend/#/finalized/card?id=" + vos.get(0).getId()));
            parameter.setWeixineeParams(weixineeParams);
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                return true;
            }
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return false;
        }
        return true;
    }
}

