/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.SettleReportEntity;
import com.ejianc.business.steelstructure.income.mapper.SettleReportMapper;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.ISettleReportService;
import com.ejianc.business.steelstructure.income.vo.SettleReportHistoryVO;
import com.ejianc.business.steelstructure.income.vo.SettleReportVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="settleReportService")
public class SettleReportServiceImpl
extends BaseServiceImpl<SettleReportMapper, SettleReportEntity>
implements ISettleReportService {
    @Autowired
    private IContractRegisterService registerService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IContractRegisterService contractService;
    @Value(value="${msg.anentId}")
    private String anentId;
    @Value(value="${msg.secret}")
    private String secret;
    @Value(value="${msg.enUrl}")
    private String enUrl;
    @Value(value="${msg.settleReport.roleId}")
    private Long roleId;

    @Override
    public SettleReportHistoryVO querySettleReportHistory(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(id));
        SettleReportHistoryVO vo = new SettleReportHistoryVO();
        vo.setContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getOrderMap().put("reportDate", "desc");
        queryParam.getOrderMap().put("createTime", "desc");
        List list = super.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return vo;
        }
        BigDecimal sumReportSettleMny = list.stream().map(SettleReportEntity::getReportSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumReportSettleTaxMny = list.stream().map(SettleReportEntity::getReportSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setSumReportSettleMny(sumReportSettleMny);
        vo.setSumReportSettleTaxMny(sumReportSettleTaxMny);
        vo.setReportRecord(BeanMapper.mapList((Iterable)list, SettleReportVO.class));
        return vo;
    }

    @Override
    public boolean pushSettleToPool(SettleReportVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            if (res.isSuccess()) {
                flag = true;
                this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u6210\u529f---{}", (Object)res.getMsg());
            } else {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u5408\u540c\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(SettleReportVO vo, SettlePoolVO spv) {
        spv.setSourceType("settle_verify");
        spv.setId(vo.getId());
        spv.setSourceId(vo.getId());
        spv.setId(vo.getId());
        spv.setSettleProperty(Integer.valueOf(1));
        spv.setUltimateFlag(Integer.valueOf(0));
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setBillCodeUrl("/ejc-steelstructure-frontend/#/settleReport/card?id=" + vo.getId());
        if (vo.getContractId() != null) {
            ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.contractService.selectById(vo.getContractId()));
            spv.setContractType("contraction");
            spv.setContractFlag(Integer.valueOf(1));
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getBillCode());
            spv.setPartyaId(contractEntity.getCustomerId());
            spv.setPartyaName(contractEntity.getCustomerName());
            spv.setPartybId(contractEntity.getSupplierId());
            spv.setPartybName(contractEntity.getSupplierName());
            spv.setSignDate(contractEntity.getSignDate());
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal lastTax = BigDecimal.ZERO;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            wrapper.in(SettleReportEntity::getBillState, new Object[]{1, 3});
            wrapper.eq(BaseEntity::getDr, (Object)0);
            wrapper.eq(SettleReportEntity::getContractId, (Object)vo.getContractId());
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (SettleReportEntity settlementEntity : list) {
                    BigDecimal settTaxMny = settlementEntity.getReportSettleTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getReportSettleTaxMny();
                    BigDecimal settMny = settlementEntity.getReportSettleMny() == null ? BigDecimal.ZERO : settlementEntity.getReportSettleMny();
                    BigDecimal settTax = settlementEntity.getTax() == null ? BigDecimal.ZERO : settlementEntity.getTax();
                    lastTaxMny = lastTaxMny.add(settTaxMny);
                    lastMny = lastMny.add(settMny);
                    lastTax = lastTax.add(settTax);
                }
            }
            spv.setLastTaxMny(lastTaxMny);
            spv.setLastMny(lastMny);
            spv.setLastTax(lastTax);
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210");
    }

    @Override
    public boolean sendMsg(List<SettleReportVO> vos) {
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(this.roleId);
        CommonResponse roleResp = this.roleApi.getRoleUser(roleIds, null);
        if (!roleResp.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u53d1\u9001\u4fe1\u606f\u89d2\u8272\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List relationVOS = (List)roleResp.getData();
        List userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());
        BigDecimal sumMny = vos.stream().map(SettleReportVO::getReportSettleTaxMny).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        String subject = "\u3010" + vos.get(0).getContractName() + "\u3011\u5171" + vos.size() + "\u9879\u7ed3\u7b97\u62a5\u5ba1\u5df2\u5f52\u6863";
        String content = "\u5408\u540c\u540d\u79f0:\u3010" + vos.get(0).getContractName() + "\u3011" + '\n' + "\u786e\u8ba4\u62a5\u5ba1\u91d1\u9896\uff1a" + sumMny + "\u5143";
        String detail = "\n\u5171" + vos.size() + "\u9879\u7ed3\u7b97\u62a5\u5ba1\u5df2\u5f52\u6863,\u8bf7\u524d\u5f80\u7535\u8111\u7aef\u67e5\u770b!";
        String pcUrl = "/ejc-steelstructure-frontend/#/settleReport/card?id=" + vos.get(0).getId();
        Iterator iterator = userIds.iterator();
        if (iterator.hasNext()) {
            String userId = (String)iterator.next();
            String moUrl = this.enUrl + "/portal/sso/index?&userid=" + userId + "&targeturl=" + this.enUrl + "/ejc-steelstructure-frontend/#/settleReport/card?id=" + vos.get(0).getId();
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("weixinee");
            channel.add("sys");
            String[] receivers = new String[]{userId};
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject(content + detail);
            parameter.setContent(content + detail);
            parameter.setPcUrl(pcUrl);
            parameter.setMobileUrl(moUrl);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)this.anentId);
            weixineeParams.put("secret", (Object)this.secret);
            weixineeParams.put("msgtype", (Object)"textcard");
            weixineeParams.put("title", (Object)subject);
            weixineeParams.put("description", (Object)content);
            weixineeParams.put("url", (Object)(this.enUrl + "/portal/sso/index?&userid=" + userId + "&targeturl=" + this.enUrl + "/ejc-steelstructure-frontend/#/settleReport/card?id=" + vos.get(0).getId()));
            parameter.setWeixineeParams(weixineeParams);
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                return true;
            }
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return false;
        }
        return true;
    }
}

