/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherSettleEntity;
import com.ejianc.business.steelstructure.other.history.OtherSettleHistoryVO;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.service.IOtherSettleService;
import com.ejianc.business.steelstructure.other.vo.OtherSettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"otherSettle"})
public class OtherSettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOtherSettleService service;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OtherSettleVO> saveOrUpdate(@RequestBody OtherSettleVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherSettleVO> queryDetail(Long id) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)this.service.selectById(id));
        OtherSettleVO vo = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherSettleVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(BaseEntity::getId, ids);
        List finishEntities = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)finishEntities)) {
            List contractIds = finishEntities.stream().map(OtherSettleEntity::getContractId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OtherContractEntity::getIsFinish, (Object)0);
            updateWrapper.in(BaseEntity::getId, contractIds);
            this.contractService.update((Wrapper)updateWrapper);
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherSettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage pageData = this.service.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), OtherSettleVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("OtherSettle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOtherSettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherSettleVO>> refOtherSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherSettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/verifyContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> verifyContract(@RequestParam Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        int num;
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)contractId);
        lambdaQuery.notIn(OtherSettleEntity::getBillState, new Object[]{1, 3});
        if (billId != null && billId > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)billId);
        }
        if ((num = this.service.count((Wrapper)lambdaQuery)) > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u7ed3\u7b97!");
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/querySettleHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherSettleHistoryVO> querySettleHistory(@RequestParam Long id) {
        OtherSettleHistoryVO vo = this.service.querySettleHistory(id);
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"/syncPushSettlePool"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value="id") Long id) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)this.service.selectById(id));
        OtherSettleVO vo = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
        return CommonResponse.success((String)"\u540c\u6b65\u7ed3\u7b97\u6c60\u6210\u529f\uff01", (Object)this.service.pushSettleToPool(vo));
    }
}

