/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.mapper.OtherContractMapper;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.vo.OtherContractVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="otherContractService")
public class OtherContractServiceImpl
extends BaseServiceImpl<OtherContractMapper, OtherContractEntity>
implements IOtherContractService {
    private static final String INCOME_CONTRACT_BILL_CODE = "OTHER_CONTRACT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OtherContractMapper contractMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public OtherContractVO saveOrUpdate(OtherContractVO otherContractVO) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = (OtherContractEntity)((Object)BeanMapper.map((Object)otherContractVO, OtherContractEntity.class));
        if (otherContractVO.getId() != null && otherContractVO.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)otherContractVO.getBillCode())) {
                throw new BusinessException("\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)otherContractVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_BILL_CODE, (Long)tenantId, (BaseVO)otherContractVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity.setIsFinish(0);
        }
        if (otherContractVO.getId() != null && otherContractVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, (Object)otherContractVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)otherContractVO.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OtherContractEntity::getBillCode, (Object)otherContractVO.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setIsSuspend(0);
        entity.setIsRelieve(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());
        entity.setBaseMoney(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        this.saveOrUpdate((Object)entity, false);
        OtherContractVO vo = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        return vo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = OtherContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Date getSignDate(Long id) {
        return this.contractMapper.getSignDate(id);
    }

    @Override
    public OtherContractVO contractDetail(Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.contractMapper.selectById(id));
        OtherContractVO otherContractVO = (OtherContractVO)BeanMapper.map((Object)((Object)entity), OtherContractVO.class);
        OtherContractVO vo = new OtherContractVO();
        vo.setId(otherContractVO.getId());
        vo.setContractName(otherContractVO.getContractName());
        vo.setContractTaxMny(otherContractVO.getContractTaxMny());
        vo.setTaxRate(otherContractVO.getTaxRate());
        vo.setProjectId(otherContractVO.getProjectId());
        vo.setProjectName(otherContractVO.getProjectName());
        vo.setCustomerId(otherContractVO.getCustomerId());
        vo.setCustomerName(otherContractVO.getCustomerName());
        vo.setSupplierId(otherContractVO.getSupplierId());
        vo.setSupplierName(otherContractVO.getSupplierName());
        vo.setOrgId(otherContractVO.getOrgId());
        vo.setOrgName(otherContractVO.getOrgName());
        vo.setVersion(otherContractVO.getVersion());
        return vo;
    }

    @Override
    public boolean pushContract(OtherContractVO vo, Boolean updateLevel) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            CommonResponse transDataResp;
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            if (updateLevel.booleanValue()) {
                this.delContractFromPool(vo.getId());
            }
            if ("1".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("1");
            }
            if ("2".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("2");
            }
            if ("3".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("3");
            }
            if ("4".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("5");
            }
            if ("5".equals(vo.getContractStatus())) {
                data.setPerformanceStatus("4");
            }
            data.setChangeStatus(Integer.valueOf(Integer.parseInt(vo.getChangeStatus())));
            data.setContractProperty(Integer.valueOf(1));
            data.setSourceType(ContractTypeEnum.\u5176\u4ed6\u6536\u5165\u5408\u540c.getTypeCode());
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-steelstructure-frontend/#/otherContract/otherContractApprove?id=" + vo.getId() : "/ejc-steelstructure-frontend/#/otherContract/otherContractSupplement?id=" + vo.getId();
            data.setPcCardUrl(url);
            data.setCategoryId(Long.valueOf(1524002474627813378L));
            CommonResponse projectPoolSetVO = this.projectSetApi.getProjectId(data.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
                CommonResponse defDocById;
                ProjectPoolSetVO data1 = (ProjectPoolSetVO)projectPoolSetVO.getData();
                if (data1.getAreaName() != null) {
                    data.setAreaName(data1.getAreaName());
                }
                if (data1.getAddress() != null) {
                    data.setAddress(data1.getAddress());
                }
                if (data1.getEngineeringType() != null && (defDocById = this.defdocApi.getDefDocById(data1.getEngineeringTypeId())).getCode() == 0 && defDocById.getData() != null) {
                    data.setEngineeringType(((DefdocDetailVO)defDocById.getData()).getName());
                }
            }
            if ((transDataResp = this.contractPoolApi.saveOrUpdateContract(data)).isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }
}

