/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.other.service.impl;

import com.ejianc.business.steelstructure.income.utils.MathUtil;
import com.ejianc.business.steelstructure.other.bean.OtherContractEntity;
import com.ejianc.business.steelstructure.other.bean.OtherDetailEntity;
import com.ejianc.business.steelstructure.other.bean.OtherSupplementDetailEntity;
import com.ejianc.business.steelstructure.other.bean.OtherSupplementEntity;
import com.ejianc.business.steelstructure.other.service.IOtherContractService;
import com.ejianc.business.steelstructure.other.service.IOtherDetailService;
import com.ejianc.business.steelstructure.other.service.IOtherSupplementService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherSupplement")
public class OtherSupplementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOtherSupplementService supplementService;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherDetailService contractDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OtherSupplementEntity otherSupplementEntity = (OtherSupplementEntity)((Object)this.supplementService.selectById(billId));
        OtherContractEntity otherContractEntity = (OtherContractEntity)((Object)this.contractService.selectById(otherSupplementEntity.getMainContractId()));
        otherContractEntity.setContractMny(MathUtil.safeAdd(otherContractEntity.getContractMny(), otherSupplementEntity.getContractMny()));
        otherContractEntity.setContractTaxMny(MathUtil.safeAdd(otherContractEntity.getContractTaxMny(), otherSupplementEntity.getContractTaxMny()));
        otherContractEntity.setTaxMny(MathUtil.safeSub(otherContractEntity.getContractTaxMny(), otherContractEntity.getContractMny()));
        otherSupplementEntity.setChangeStatus("2");
        this.supplementService.updateById((Object)otherSupplementEntity);
        this.contractService.updateById((Object)otherContractEntity);
        this.dealDetailData(otherSupplementEntity, otherContractEntity);
        return CommonResponse.success();
    }

    private void dealDetailData(OtherSupplementEntity otherSupplementEntity, OtherContractEntity otherContractEntity) {
        List<OtherDetailEntity> detailList = otherContractEntity.getCheckList();
        if (CollectionUtils.isNotEmpty(otherSupplementEntity.getCheckList())) {
            for (OtherSupplementDetailEntity detailEntity : otherSupplementEntity.getCheckList()) {
                OtherDetailEntity OtherDetailEntity2 = (OtherDetailEntity)((Object)BeanMapper.map((Object)((Object)detailEntity), OtherDetailEntity.class));
                OtherDetailEntity2.setId(null);
                OtherDetailEntity2.setContractId(otherContractEntity.getId());
                OtherDetailEntity2.setSrcSupplementDetailId(detailEntity.getId());
                OtherDetailEntity2.setSrcSupplementFlag(1);
                OtherDetailEntity2.setSrcSupplementId(otherSupplementEntity.getId());
                detailList.add(OtherDetailEntity2);
            }
            this.contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8865\u5145\u534f\u8bae\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

