/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractRelieveEntity;
import com.ejianc.business.steelstructure.promaterial.contract.enums.DraftTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractRelieveService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractService;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractRelieveVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="promaterialcontractRelieve")
public class PromaterialContractRelieveBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPromaterialContractRelieveService service;
    @Autowired
    private IPromaterialContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        PromaterialContractRelieveEntity entity = (PromaterialContractRelieveEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)entity);
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PromaterialContractRelieveEntity promaterialContractRelieveEntity = (PromaterialContractRelieveEntity)((Object)this.service.selectById(billId));
        if (promaterialContractRelieveEntity != null) {
            if (promaterialContractRelieveEntity.getDraftType() == 2) {
                promaterialContractRelieveEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                promaterialContractRelieveEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode());
                promaterialContractRelieveEntity.setEffectiveDate(new Date());
                this.service.saveOrUpdate((Object)promaterialContractRelieveEntity, false);
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter("eq", (Object)promaterialContractRelieveEntity.getContractId()));
                List contractList = this.contractService.queryList(queryParam);
                PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)contractList.get(0));
                promaterialContractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode());
                this.contractService.saveOrUpdate((Object)promaterialContractEntity, false);
                this.contractService.pushContract((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class));
                String linkUrl = promaterialContractEntity.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/contractRelieve/card?id=" + promaterialContractRelieveEntity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/contractRelieve/card?id=" + promaterialContractRelieveEntity.getId();
                if (promaterialContractEntity.getPurchaseType().equals("1")) {
                    ExecutionVO executionVO = this.service.targetCost((PromaterialContractRelieveVO)BeanMapper.map((Object)((Object)promaterialContractRelieveEntity), PromaterialContractRelieveVO.class), linkUrl, promaterialContractEntity.getContractType());
                    this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                }
                this.logger.info("\u7ec8\u5ba1\u5df2\u7b7e\u7ae0\u5904\u7406\u5b8c\u6210\uff01");
            } else if (promaterialContractRelieveEntity.getDraftType() == 1) {
                promaterialContractRelieveEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                this.service.saveOrUpdate((Object)promaterialContractRelieveEntity, false);
                this.logger.info("\u7ec8\u5ba1\u4e0a\u4f20\u89e3\u9664\u534f\u8bae\u5904\u7406\u5b8c\u6210\uff0c\u521d\u59cb\u5316\u4e3a\u672a\u7b7e\u7ae0");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5408\u540c\u89e3\u9664\u8fdb\u5165\u5f03\u5ba1\u524d\u4e8b\u4ef6\uff0c\u5408\u540cid\uff1a{}", (Object)billId);
        PromaterialContractRelieveEntity entity = (PromaterialContractRelieveEntity)((Object)this.service.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().equals(entity.getDraftType()) && !statusList.contains(entity.getSignatureStatus())) {
            return CommonResponse.error((String)("\u5408\u540c\u89e3\u9664" + (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(entity.getSignatureStatus()) ? "\u5df2\u751f\u6548" : "\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b") + "\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1!"));
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(entity.getSignatureStatus())) {
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            this.service.saveOrUpdate((Object)entity, false);
        }
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        promaterialContractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)promaterialContractEntity, false);
        this.contractService.pushContract((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class));
        return CommonResponse.success((String)"\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5408\u540c\u89e3\u9664\u8fdb\u5165\u5f03\u5ba1\u540e\u4e8b\u4ef6\uff0c\u5408\u540cid\uff1a{}", (Object)billId);
        PromaterialContractRelieveEntity promaterialContractRelieveEntity = (PromaterialContractRelieveEntity)((Object)this.service.selectById(billId));
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(promaterialContractRelieveEntity.getContractId()));
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        if (promaterialContractEntity.getPurchaseType().equals("1")) {
            ExecutionVO executionVO = this.service.targetCost((PromaterialContractRelieveVO)BeanMapper.map((Object)((Object)promaterialContractRelieveEntity), PromaterialContractRelieveVO.class), "", promaterialContractEntity.getContractType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            totalExecutionVOList.add(executionVO.getTotalVO());
        }
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success((String)"\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

