/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractAdmixtureEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractChangeAdmixtureEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractChangeEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractClauseEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractDetailEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractFeeEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractRecordEntity;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractStageEntity;
import com.ejianc.business.steelstructure.promaterial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.DraftTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.steelstructure.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.mapper.PromaterialContractChangeMapper;
import com.ejianc.business.steelstructure.promaterial.contract.mapper.PromaterialContractMapper;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractAdmixtureService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractChangeAsyncService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractChangeService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractClauseService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractDetailService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractFeeService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractRecordService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractService;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractStageService;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractChangeAdmixtureVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractChangeClauseVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractChangeCompareVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractChangeDetailVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractChangeFeeVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractChangeStageVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractChangeVO;
import com.ejianc.business.steelstructure.promaterial.contract.vo.PromaterialContractVO;
import com.ejianc.business.steelstructure.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.steelstructure.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="promaterialContractChangeService")
public class PromaterialPromaterialContractChangeServiceImpl
extends BaseServiceImpl<PromaterialContractChangeMapper, PromaterialContractChangeEntity>
implements IPromaterialContractChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONTRACT_CHANGE = "CONTRACT_CHANGE";
    private static final String CONTRACT_CONCRETE_CHANGE = "CONTRACT_CONCRETE_CHANGE";
    private final String CONTRACT_FILE_SOURCE_TYPE = "mContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "proMaterialContractBill";
    private static final String CONTRACT_MATERIAL = "BT211227000000003";
    private static final String CONTRACT_MATERIAL_RECORD = "BT220105000000028";
    private static final String CONTRACT_CONCRETE = "BT220215000000001";
    private static final String CONTRACT_CONCRETE_RECORD = "BT220215000000003";
    private static final String CHECK_PARAM_CODE = "P-434f5499";
    private static final Integer CONTRACT_TYPE_0 = 0;
    private static final Integer CONTRACT_TYPE_1 = 1;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPromaterialContractService contractService;
    @Autowired
    private PromaterialContractMapper PromaterialContractMapper;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IPromaterialContractChangeService contractChangeService;
    @Autowired
    private IPromaterialContractClauseService contractClauseService;
    @Autowired
    private IPromaterialContractFeeService contractFeeService;
    @Autowired
    private IPromaterialContractStageService contractStageService;
    @Autowired
    private IPromaterialContractDetailService contractDetailService;
    @Autowired
    private IPromaterialContractAdmixtureService contractAdmixtureService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IPromaterialContractRecordService contractRecordService;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IPromaterialContractChangeAsyncService contractChangeAsyncService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String M_PARAM_CODE = "P-bGD9cO62";
    private static final String C_PARAM_CODE = "P-715t0u63";
    private static final String M_PLAN_CODE = "P-CcZ6rO87";
    private static final String C_PLAN_CODE = "P-00g5A089";

    @Override
    public PromaterialContractChangeVO insertOrUpdate(PromaterialContractChangeVO promaterialContractChangeVO, Boolean isControl) {
        PromaterialContractChangeVO res;
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        PromaterialContractEntity contract = (PromaterialContractEntity)((Object)this.contractService.selectById(promaterialContractChangeVO.getContractId()));
        if (CollectionUtils.isNotEmpty((Collection)promaterialContractChangeVO.getAttachIds()) && null != contract.getContractFileId()) {
            promaterialContractChangeVO.getAttachIds().remove(contract.getContractFileId());
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        PromaterialContractChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        this.contractService.checkContract(promaterialContractChangeVO.getContractId(), promaterialContractChangeVO.getId());
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(PromaterialContractChangeEntity::getContractId, (Object)promaterialContractChangeVO.getContractId());
        if (promaterialContractChangeVO.getId() != null && promaterialContractChangeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)promaterialContractChangeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(PromaterialContractChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(PromaterialContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        LambdaQueryWrapper lambdaQuery2 = Wrappers.lambdaQuery();
        lambdaQuery2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery2.eq(PromaterialContractEntity::getMainContractId, (Object)promaterialContractChangeVO.getContractId());
        lambdaQuery2.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(PromaterialContractEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(PromaterialContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int nums = this.contractService.count((Wrapper)lambdaQuery2);
        if (nums > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        PromaterialContractEntity pcentity = (PromaterialContractEntity)((Object)this.contractService.selectById(promaterialContractChangeVO.getContractId()));
        if (!isControl.booleanValue() && (StringUtils.isBlank((CharSequence)promaterialContractChangeVO.getBillCode()) || contract.getBillCode().equals(promaterialContractChangeVO.getBillCode()))) {
            QueryParam billCodeParam = new QueryParam();
            billCodeParam.getParams().put("contract_id", new Parameter("eq", (Object)promaterialContractChangeVO.getContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            billCodeParam.getParams().put("bill_state", new Parameter("in", billStateList));
            List billCodeChangeEntityList = super.queryList(billCodeParam, false);
            String changeNum = "";
            changeNum = billCodeChangeEntityList.size() < 9 ? changeNum + "0" + (billCodeChangeEntityList.size() + 1) : changeNum + (billCodeChangeEntityList.size() + 1);
            String type = "-1-";
            promaterialContractChangeVO.setBillCode(contract.getBillCode() + type + changeNum);
        }
        if (promaterialContractChangeVO.getId() != null && promaterialContractChangeVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(PromaterialContractChangeEntity::getBillCode, (Object)promaterialContractChangeVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(PromaterialContractChangeEntity::getContractId, (Object)promaterialContractChangeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)promaterialContractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)promaterialContractChangeVO.getContractId()));
            entitiesc = this.contractService.queryList(queryParam, false);
            pcentity.setId(promaterialContractChangeVO.getContractId());
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(PromaterialContractChangeEntity::getBillCode, (Object)promaterialContractChangeVO.getBillCode());
            lambda.ne(PromaterialContractChangeEntity::getContractId, (Object)promaterialContractChangeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)promaterialContractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)promaterialContractChangeVO.getContractId()));
            entitiesc = this.contractService.queryList(queryParam, false);
            pcentity.setId(promaterialContractChangeVO.getContractId());
            pcentity.setChangeVersion(promaterialContractChangeVO.getChangeVersion() + 1);
            promaterialContractChangeVO.setChangeVersion(Integer.valueOf(promaterialContractChangeVO.getChangeVersion() + 1));
            if (isControl.booleanValue()) {
                promaterialContractChangeVO.setId(Long.valueOf(IdWorker.getId()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)promaterialContractChangeVO.getContractDetailList())) {
            promaterialContractChangeVO.getContractDetailList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(promaterialContractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(promaterialContractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)promaterialContractChangeVO.getContractFeeList())) {
            promaterialContractChangeVO.getContractFeeList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(promaterialContractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(promaterialContractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)promaterialContractChangeVO.getContractClauseList())) {
            promaterialContractChangeVO.getContractClauseList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(promaterialContractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(promaterialContractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)promaterialContractChangeVO.getContractStageList())) {
            promaterialContractChangeVO.getContractStageList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(promaterialContractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(promaterialContractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)promaterialContractChangeVO.getContractAdmixtureList())) {
            promaterialContractChangeVO.getContractAdmixtureList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(promaterialContractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(promaterialContractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (PromaterialContractChangeEntity)((Object)BeanMapper.map((Object)promaterialContractChangeVO, PromaterialContractChangeEntity.class));
        if (entity.getFilingRef() == null) {
            entity.setFilingRef(0);
        }
        if (!isControl.booleanValue()) {
            if (entity.getId() == null && entity.getPurchaseType().equals("1")) {
                ExecutionVO executionVO1;
                int type;
                QueryWrapper wrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)entity.getContractId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
                List list = this.contractChangeService.list((Wrapper)wrapper);
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                if (list.size() > 0) {
                    type = 1;
                    executionVO1 = this.contractService.targetCost((PromaterialContractVO)BeanMapper.map(list.get(0), PromaterialContractVO.class), "", type, ((PromaterialContractChangeEntity)((Object)list.get(0))).getContractType());
                } else {
                    type = 0;
                    PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
                    executionVO1 = this.contractService.targetCost((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class), "", type, promaterialContractEntity.getContractType());
                }
                totalExecutionVOList.add(executionVO1.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            }
            super.saveOrUpdate((Object)entity, false);
        }
        pcentity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        pcentity.setChangingMny(entity.getContractMny());
        pcentity.setChangingMnyWithTax(entity.getContractTaxMny());
        pcentity.setChangeDate(entity.getChangeDate());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        pcentity.setChangeContractSignatureStatus(Integer.valueOf(entity.getSignatureStatus()));
        pcentity.setChangeFileId(entity.getChangeFileId());
        pcentity.setChangeContractName(entity.getContractName());
        if (!isControl.booleanValue()) {
            this.contractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        }
        BigDecimal contractTaxMny = (res = (PromaterialContractChangeVO)BeanMapper.map((Object)((Object)entity), PromaterialContractChangeVO.class)).getContractTaxMny() == null ? BigDecimal.ZERO : res.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeMnyWithTax() == null ? BigDecimal.ZERO : pcentity.getBeforeChangeMnyWithTax();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        if (!isControl.booleanValue() && res.getPurchaseType().equals("1")) {
            String linkUrl = res.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/contractChange/card?id=" + res.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/contractChange/card?id=" + res.getId();
            ExecutionVO executionVO = this.contractService.targetCost((PromaterialContractVO)BeanMapper.map((Object)res, PromaterialContractVO.class), linkUrl, 1, res.getContractType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        }
        return res;
    }

    private boolean isInsertContractChange(PromaterialContractChangeVO promaterialContractChangeVO) {
        return promaterialContractChangeVO.getId() == null || promaterialContractChangeVO.getId() == 0L;
    }

    @Override
    public PromaterialContractChangeVO queryDetailRecord(Long id) {
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(id));
        PromaterialContractChangeVO changeVO = new PromaterialContractChangeVO();
        BigDecimal baseTaxMoney = promaterialContractEntity.getBaseMoneyWithTax() == null ? BigDecimal.ZERO : promaterialContractEntity.getBaseMoneyWithTax();
        BigDecimal contractTaxMny = promaterialContractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : promaterialContractEntity.getContractTaxMny();
        changeVO.setId(id);
        changeVO.setContractId(id);
        changeVO.setBaseMoneyWithTax(baseTaxMoney);
        changeVO.setContractTaxMny(contractTaxMny);
        changeVO.setAllChangeAmt(contractTaxMny.subtract(baseTaxMoney));
        changeVO.setOrgId(promaterialContractEntity.getParentOrgId());
        if (changeVO.getAllChangeAmt().compareTo(BigDecimal.ZERO) != 0 && baseTaxMoney.compareTo(BigDecimal.ZERO) != 0) {
            changeVO.setChangeAmtRate(new BigDecimal(100).multiply(changeVO.getAllChangeAmt().divide(baseTaxMoney, 8, 5)));
        } else {
            changeVO.setChangeAmtRate(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PromaterialContractChangeEntity::getContractId, (Object)id);
        lambda.eq(PromaterialContractChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        lambda.in(PromaterialContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)entities)) {
            changeVO.setChangeList(BeanMapper.mapList((Iterable)entities, PromaterialContractChangeVO.class));
            changeVO.setChangeNum(Integer.valueOf(entities.size()));
        } else {
            changeVO.setChangeNum(Integer.valueOf(0));
        }
        changeVO.setSupplementFlag(promaterialContractEntity.getSupplementFlag());
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(promaterialContractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(promaterialContractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(promaterialContractEntity.getBillState()))) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    @Override
    public PromaterialContractChangeVO queryChangeRecord(Long contractId, Long changeId) {
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)promaterialContractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)changeId));
        queryParam.getOrderMap().put("createTime", "desc");
        List recordList = this.contractRecordService.queryList(queryParam);
        PromaterialContractChangeVO changeVO = new PromaterialContractChangeVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            changeVO = (PromaterialContractChangeVO)BeanMapper.map(recordList.get(0), PromaterialContractChangeVO.class);
        }
        return changeVO;
    }

    @Override
    public PromaterialContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        PromaterialContractEntity entity = (PromaterialContractEntity)((Object)this.contractService.selectById(contractId));
        PromaterialContractChangeVO purchaseChangeVo = (PromaterialContractChangeVO)BeanMapper.map((Object)((Object)entity), PromaterialContractChangeVO.class);
        purchaseChangeVo.setContractId(purchaseChangeVo.getId());
        purchaseChangeVo.setId(null);
        purchaseChangeVo.setBillState(null);
        purchaseChangeVo.setCreateUserCode(null);
        purchaseChangeVo.setCreateTime(null);
        purchaseChangeVo.setUpdateUserCode(null);
        purchaseChangeVo.setUpdateTime(null);
        purchaseChangeVo.setChangeDate(new Date());
        purchaseChangeVo.setBeforeContractName(entity.getContractName());
        purchaseChangeVo.setBeforeChangeMny(entity.getContractMny());
        purchaseChangeVo.setBeforeChangeMnyWithTax(entity.getContractTaxMny());
        purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());
        purchaseChangeVo.setBeforeChangeTax(entity.getContractTax());
        purchaseChangeVo.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().toString());
        purchaseChangeVo.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().toString());
        purchaseChangeVo.setChangeDraftType(DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString());
        purchaseChangeVo.setChangeFileId(null);
        purchaseChangeVo.setChangeFilePath(null);
        purchaseChangeVo.setWatermarkContractFileId(null);
        purchaseChangeVo.setContractType(entity.getContractType());
        purchaseChangeVo.setChangeFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PromaterialContractDetailEntity::getContractId, (Object)contractId);
        lambda.ne(PromaterialContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u4e2d\u6b62\u9879);
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            purchaseChangeVo.setContractDetailList(BeanMapper.mapList((Iterable)details, PromaterialContractChangeDetailVO.class));
            purchaseChangeVo.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setChangeType("0");
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        } else {
            purchaseChangeVo.setContractDetailList(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractFeeList())) {
            purchaseChangeVo.getContractFeeList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractClauseList())) {
            purchaseChangeVo.getContractClauseList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractStageList())) {
            purchaseChangeVo.getContractStageList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractAdmixtureList())) {
            purchaseChangeVo.getContractAdmixtureList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        return purchaseChangeVo;
    }

    public Boolean editChangeFlag(Long contractId) {
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(contractId));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(promaterialContractEntity.getPerformanceStatus())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PromaterialContractChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(PromaterialContractChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(PromaterialContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<String, String>();
        orderByParams.put("treeIndex", "asc");
        HashMap<String, LinkedHashMap<String, String>> orders = new HashMap<String, LinkedHashMap<String, String>>();
        orders.put("detailList", orderByParams);
        PromaterialContractChangeEntity changeEntity = (PromaterialContractChangeEntity)((Object)super.selectById((Serializable)id, orders));
        PromaterialContractChangeCompareVO changeCompareVO = (PromaterialContractChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), PromaterialContractChangeCompareVO.class);
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        PromaterialContractChangeCompareVO beforeChangeVO = new PromaterialContractChangeCompareVO();
        Map<Object, Object> beforeDetailMap = new HashMap();
        Map<Object, Object> beforeFeeMap = new HashMap();
        Map<Object, Object> beforeClauseMap = new HashMap();
        Map<Object, Object> beforeStageMap = new HashMap();
        Map<Object, Object> beforAdminxtureMap = new HashMap();
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(changeEntity.getSignatureStatus())) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambda.eq(PromaterialContractRecordEntity::getChangeId, (Object)id)).eq(PromaterialContractRecordEntity::getContractId, (Object)changeEntity.getContractId())).orderByDesc(BaseEntity::getCreateTime);
            List recordList = this.contractRecordService.list((Wrapper)lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null) {
                Long recordId = ((PromaterialContractRecordEntity)((Object)recordList.get(0))).getId();
                PromaterialContractRecordEntity recordEntity = (PromaterialContractRecordEntity)((Object)this.contractRecordService.selectById(recordId));
                beforeChangeVO = (PromaterialContractChangeCompareVO)BeanMapper.map((Object)((Object)recordEntity), PromaterialContractChangeCompareVO.class);
                beforeDetailMap = beforeChangeVO.getContractDetailList().stream().collect(Collectors.toMap(PromaterialContractChangeDetailVO::getSrcTblId, detail -> detail, (v1, v2) -> v2));
                beforeFeeMap = beforeChangeVO.getContractFeeList().stream().collect(Collectors.toMap(PromaterialContractChangeFeeVO::getSrcTblId, fee -> fee, (v1, v2) -> v2));
                beforeClauseMap = beforeChangeVO.getContractClauseList().stream().collect(Collectors.toMap(PromaterialContractChangeClauseVO::getSrcTblId, clause -> clause, (v1, v2) -> v2));
                beforeStageMap = beforeChangeVO.getContractStageList().stream().collect(Collectors.toMap(PromaterialContractChangeStageVO::getSrcTblId, item -> item, (v1, v2) -> v2));
                if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(((PromaterialContractRecordEntity)((Object)recordList.get(0))).getContractType()) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)beforeChangeVO.getContractAdmixtureList())) {
                    beforAdminxtureMap = beforeChangeVO.getContractAdmixtureList().stream().collect(Collectors.toMap(PromaterialContractChangeAdmixtureVO::getSrcTblId, item -> item, (v1, v2) -> v2));
                }
            }
        } else {
            beforeChangeVO = (PromaterialContractChangeCompareVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractChangeCompareVO.class);
            beforeDetailMap = beforeChangeVO.getContractDetailList().stream().collect(Collectors.toMap(BaseVO::getId, detail -> detail, (v1, v2) -> v2));
            beforeFeeMap = beforeChangeVO.getContractFeeList().stream().collect(Collectors.toMap(BaseVO::getId, fee -> fee, (v1, v2) -> v2));
            beforeClauseMap = beforeChangeVO.getContractClauseList().stream().collect(Collectors.toMap(BaseVO::getId, clause -> clause, (v1, v2) -> v2));
            beforeStageMap = beforeChangeVO.getContractStageList().stream().collect(Collectors.toMap(BaseVO::getId, item -> item, (v1, v2) -> v2));
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            ArrayList newDetail = new ArrayList();
            Map<Object, Object> finalBeforeDetailMap = beforeDetailMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractDetailList())) {
                changeCompareVO.getContractDetailList().stream().forEach(detail -> {
                    if (!detail.getChangeType().equals(String.valueOf(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode()))) {
                        if (detail.getSrcTblId() == null) {
                            newDetail.add(detail);
                        }
                        if (finalBeforeDetailMap.containsKey(detail.getSrcTblId())) {
                            detail.setBeforeChangeRate(((PromaterialContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getDetailTaxRate());
                            detail.setBeforeChangePrice(((PromaterialContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getPrice());
                            detail.setBeforeChangeNum(((PromaterialContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getNum());
                            newDetail.add(detail);
                            finalBeforeDetailMap.remove(detail.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setContractDetailList(newDetail);
            ArrayList newFee = new ArrayList();
            Map<Object, Object> finalBeforeFeeMap = beforeFeeMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractFeeList())) {
                changeCompareVO.getContractFeeList().stream().forEach(fee -> {
                    if (!String.valueOf(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode()).equals(fee.getChangeType())) {
                        if (fee.getSrcTblId() == null) {
                            newFee.add(fee);
                        }
                        if (finalBeforeFeeMap.containsKey(fee.getSrcTblId())) {
                            fee.setBeforeChangeCostRate(((PromaterialContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreeTaxRate());
                            fee.setBeforeChangeCostPrice(((PromaterialContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreePrice());
                            fee.setBeforeChangeCostNum(((PromaterialContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreeNum());
                            newFee.add(fee);
                            finalBeforeFeeMap.remove(fee.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setContractFeeList(newFee);
            ArrayList newClauses = new ArrayList();
            Map<Object, Object> finalBeforeClauseMap = beforeClauseMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractClauseList())) {
                changeCompareVO.getContractClauseList().stream().forEach(clause -> {
                    if (clause.getSrcTblId() == null) {
                        clause.setChangeType("\u589e\u8865\u9879");
                        newClauses.add(clause);
                    } else if (finalBeforeClauseMap.containsKey(clause.getSrcTblId())) {
                        if (!((PromaterialContractChangeClauseVO)finalBeforeClauseMap.get(clause.getSrcTblId())).getClauseContent().equals(clause.getClauseContent())) {
                            clause.setBeforeChangeClauseContent(((PromaterialContractChangeClauseVO)finalBeforeClauseMap.get(clause.getSrcTblId())).getClauseContent());
                            clause.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                            newClauses.add(clause);
                        }
                        finalBeforeClauseMap.remove(clause.getSrcTblId());
                    }
                });
            }
            if (MapUtils.isNotEmpty(finalBeforeClauseMap)) {
                finalBeforeClauseMap.values().forEach(c -> {
                    c.setChangeType("\u5220\u9664\u9879");
                    newClauses.add(c);
                });
            }
            changeCompareVO.setContractClauseList(newClauses);
            ArrayList<PromaterialContractChangeStageVO> newStageList = new ArrayList<PromaterialContractChangeStageVO>();
            Map<Object, Object> finalBeforeStageMap = beforeStageMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractStageList())) {
                PromaterialContractChangeStageVO beforeItem = null;
                for (PromaterialContractChangeStageVO curItem : changeCompareVO.getContractStageList()) {
                    if (curItem.getSrcTblId() == null) {
                        curItem.setChangeType("\u589e\u8865\u9879");
                        newStageList.add(curItem);
                        continue;
                    }
                    if (!finalBeforeStageMap.containsKey(curItem.getSrcTblId())) continue;
                    beforeItem = (PromaterialContractChangeStageVO)finalBeforeStageMap.get(curItem.getSrcTblId());
                    if (!beforeItem.getStageName().equals(curItem.getStageName()) || !beforeItem.getStageScale().equals(curItem.getStageScale())) {
                        curItem.setBeforePaymentName(beforeItem.getStageName());
                        curItem.setBeforePaymentScale(beforeItem.getStageScale());
                        curItem.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                        newStageList.add(curItem);
                    }
                    finalBeforeStageMap.remove(curItem.getSrcTblId());
                }
            }
            if (MapUtils.isNotEmpty(finalBeforeStageMap)) {
                finalBeforeStageMap.values().forEach(c -> {
                    c.setChangeType("\u5220\u9664\u9879");
                    newStageList.add((PromaterialContractChangeStageVO)c);
                });
            }
            changeCompareVO.setContractStageList(newStageList);
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(changeEntity.getContractType())) {
                ArrayList newAdminxtureList = new ArrayList();
                HashMap finalbeforAdminxtureMap = beforAdminxtureMap;
                if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractAdmixtureList())) {
                    changeCompareVO.getContractAdmixtureList().forEach(adminxture -> {
                        if (adminxture.getSrcTblId() == null) {
                            adminxture.setChangeType("\u589e\u8865\u9879");
                            newAdminxtureList.add(adminxture);
                        } else if (finalbeforAdminxtureMap.containsKey(adminxture.getSrcTblId())) {
                            PromaterialContractChangeAdmixtureVO beforeAdmixture = (PromaterialContractChangeAdmixtureVO)finalbeforAdminxtureMap.get(adminxture.getSrcTblId());
                            if (beforeAdmixture.getPrice().compareTo(adminxture.getPrice()) != 0) {
                                adminxture.setBeforPrice(beforeAdmixture.getPrice());
                                adminxture.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                            }
                            finalbeforAdminxtureMap.remove(adminxture.getSrcTblId());
                        }
                    });
                }
                if (MapUtils.isNotEmpty(finalbeforAdminxtureMap)) {
                    finalbeforAdminxtureMap.values().forEach(c -> {
                        c.setChangeType("\u5220\u9664\u9879");
                        newAdminxtureList.add(c);
                    });
                }
                changeCompareVO.setContractAdmixtureList(newAdminxtureList);
            }
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        PromaterialContractChangeEntity changeEntity = (PromaterialContractChangeEntity)((Object)super.selectById((Serializable)billId));
        if (changeEntity != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                this.effectiveSaveWriteContract(billId, changeEntity.getBillCode(), false, true);
                return true;
            }
            changeEntity.setSignatureStatus(String.valueOf(status));
            super.saveOrUpdate((Object)changeEntity);
            this.logger.info("\u53d8\u66f4\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            updateWrapper.set(PromaterialContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
            this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
            this.logger.info("\u7b7e\u7ae0\u72b6\u6001\u4e3a\u5df2\u7b7e\u7ae0\uff0c\u56de\u5199\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001---------------->");
            return true;
        }
        return false;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long billId, String billTypeCode, Boolean commitState, Boolean filingFlag) {
        PromaterialContractChangeEntity changeEntity = (PromaterialContractChangeEntity)((Object)super.selectById((Serializable)billId));
        CommonResponse resp = null;
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        PromaterialContractRecordEntity recordEntity = (PromaterialContractRecordEntity)((Object)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractRecordEntity.class));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- changeEntity:" + (Object)((Object)changeEntity) + "  contractEntity:" + (Object)((Object)promaterialContractEntity));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getContractDetailList())) {
            recordEntity.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractFeeList())) {
            recordEntity.getContractFeeList().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractClauseList())) {
            recordEntity.getContractClauseList().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractStageList())) {
            recordEntity.getContractStageList().forEach(vo -> {
                vo.setContractStageId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractAdmixtureList())) {
            recordEntity.getContractAdmixtureList().forEach(vo -> {
                vo.setChangeId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        this.contractRecordService.saveOrUpdate((Object)recordEntity, false);
        String contractBillType = CONTRACT_MATERIAL;
        String contractRecordBillType = CONTRACT_MATERIAL_RECORD;
        if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(promaterialContractEntity.getContractType())) {
            contractBillType = CONTRACT_CONCRETE;
            contractRecordBillType = CONTRACT_CONCRETE_RECORD;
        }
        if ((resp = this.copyFile(promaterialContractEntity.getId().toString(), contractBillType, recordEntity.getId().toString(), contractRecordBillType, "proMaterialContractBill")) != null) {
            return resp;
        }
        promaterialContractEntity.setContractMny(changeEntity.getContractMny());
        promaterialContractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        promaterialContractEntity.setContractTax(changeEntity.getContractTax());
        promaterialContractEntity.setDetailTaxMny(changeEntity.getDetailTaxMny());
        promaterialContractEntity.setDetailMny(changeEntity.getDetailMny());
        promaterialContractEntity.setDetailTax(changeEntity.getDetailTax());
        promaterialContractEntity.setFreeTaxMny(changeEntity.getFreeTaxMny());
        promaterialContractEntity.setFreeMny(changeEntity.getFreeMny());
        promaterialContractEntity.setFreeTax(changeEntity.getFreeTax());
        promaterialContractEntity.setMemo(changeEntity.getMemo());
        promaterialContractEntity.setSignDate(changeEntity.getSignDate());
        promaterialContractEntity.setCustomerId(changeEntity.getCustomerId());
        promaterialContractEntity.setCustomerName(changeEntity.getCustomerName());
        promaterialContractEntity.setSupplierId(changeEntity.getSupplierId());
        promaterialContractEntity.setSupplierName(changeEntity.getSupplierName());
        promaterialContractEntity.setContractName(changeEntity.getContractName());
        promaterialContractEntity.setTaxRate(changeEntity.getTaxRate());
        promaterialContractEntity.setPayScale(changeEntity.getPayScale());
        promaterialContractEntity.setEmployeeId(changeEntity.getEmployeeId());
        promaterialContractEntity.setEmployeeName(changeEntity.getEmployeeName());
        promaterialContractEntity.setPricingType(changeEntity.getPricingType());
        promaterialContractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        promaterialContractEntity.setSupplierEmployeeMobile(changeEntity.getSupplierEmployeeMobile());
        promaterialContractEntity.setProjectPlace(changeEntity.getProjectPlace());
        promaterialContractEntity.setSignPlace(changeEntity.getSignPlace());
        promaterialContractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        promaterialContractEntity.setChangingMny(null);
        promaterialContractEntity.setChangingMnyWithTax(null);
        promaterialContractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        promaterialContractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        promaterialContractEntity.setSettlementPayment(changeEntity.getSettlementPayment());
        promaterialContractEntity.setPriceFloatType(changeEntity.getPriceFloatType());
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setEffectiveDate(new Date());
        if (filingFlag.booleanValue()) {
            changeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            changeEntity.setFilingRef(0);
        }
        this.copyFile(billId.toString(), billTypeCode, promaterialContractEntity.getId().toString(), contractBillType, "materialChangeContractFile");
        if (resp != null) {
            return resp;
        }
        changeEntity.setChangeDate(new Date());
        this.contractChangeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--2");
        this.contractClauseService.deleteByContractId(changeEntity.getContractId());
        this.contractFeeService.deleteByContractId(changeEntity.getContractId());
        this.contractStageService.deleteByContractId(changeEntity.getContractId());
        promaterialContractEntity.setContractClauseList(null);
        promaterialContractEntity.setContractFeeList(null);
        promaterialContractEntity.setContractStageList(null);
        if (CollectionUtils.isNotEmpty(changeEntity.getContractDetailList())) {
            this.logger.info("\u590d\u5236\u5b50\u8868\u5f00\u59cb--" + changeEntity.getContractDetailList());
            changeEntity.getContractDetailList().forEach(vo -> {
                this.logger.info("\u590d\u5236\u5b50\u8868--" + vo.getContractDetailId() + "---type" + vo.getChangeType());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = promaterialContractEntity.getContractDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            promaterialContractEntity.setContractDetailList(BeanMapper.mapList(changeEntity.getContractDetailList(), PromaterialContractDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractFeeList())) {
            changeEntity.getContractFeeList().forEach(vo -> vo.setId(null));
            promaterialContractEntity.setContractFeeList(BeanMapper.mapList(changeEntity.getContractFeeList(), PromaterialContractFeeEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractClauseList())) {
            changeEntity.getContractClauseList().forEach(vo -> vo.setId(null));
            promaterialContractEntity.setContractClauseList(BeanMapper.mapList(changeEntity.getContractClauseList(), PromaterialContractClauseEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractStageList())) {
            changeEntity.getContractStageList().forEach(vo -> vo.setId(null));
            promaterialContractEntity.setContractStageList(BeanMapper.mapList(changeEntity.getContractStageList(), PromaterialContractStageEntity.class));
        }
        if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(promaterialContractEntity.getContractType())) {
            this.contractAdmixtureService.deleteByContractId(changeEntity.getContractId());
            promaterialContractEntity.setContractAdmixtureList(null);
            if (CollectionUtils.isNotEmpty(changeEntity.getContractAdmixtureList())) {
                for (PromaterialContractChangeAdmixtureEntity vo2 : changeEntity.getContractAdmixtureList()) {
                    vo2.setId(null);
                }
                promaterialContractEntity.setContractAdmixtureList(BeanMapper.mapList(changeEntity.getContractAdmixtureList(), PromaterialContractAdmixtureEntity.class));
            }
        }
        boolean flag = this.contractService.saveOrUpdate((Object)promaterialContractEntity, false);
        boolean pushFlag = this.contractService.pushContract((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class));
        if (pushFlag) {
            this.updateTotalChangeDataByContractId(changeEntity, "approve");
        }
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        PromaterialContractChangeEntity entity = (PromaterialContractChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        if (entity.getPurchaseType().equals("1")) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ArrayList<Object> promaterialContractEntityList = new ArrayList<Object>();
            ExecutionVO executionVO = this.contractService.targetCost((PromaterialContractVO)BeanMapper.map((Object)((Object)entity), PromaterialContractVO.class), "", 1, entity.getContractType());
            totalExecutionVOList.add(executionVO.getTotalVO());
            promaterialContractEntityList.add(this.contractService.selectById(entity.getContractId()));
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            for (PromaterialContractEntity promaterialContractEntity : promaterialContractEntityList) {
                ExecutionVO executionVO1;
                String linkUrl;
                List promaterialContractChangeEntityList = this.contractChangeService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)promaterialContractEntity.getId())).orderByDesc((Object)"create_time"));
                if (promaterialContractChangeEntityList.size() > 1) {
                    linkUrl = entity.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/contractChange/card?id=" + entity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/contractChange/card?id=" + entity.getId();
                    executionVO1 = this.contractService.targetCost((PromaterialContractVO)BeanMapper.map(promaterialContractChangeEntityList.get(1), PromaterialContractVO.class), linkUrl, 1, ((PromaterialContractChangeEntity)((Object)promaterialContractChangeEntityList.get(1))).getContractType());
                } else {
                    linkUrl = entity.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/card?id=" + entity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/card?id=" + entity.getId();
                    executionVO1 = this.contractService.targetCost((PromaterialContractVO)BeanMapper.map((Object)((Object)promaterialContractEntity), PromaterialContractVO.class), linkUrl, 0, entity.getContractType());
                }
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO1));
            }
        }
        PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)promaterialContractEntity.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)query);
        promaterialContractEntity.setChangeVersion(promaterialContractEntity.getChangeVersion() - 1);
        promaterialContractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        promaterialContractEntity.setChangingMny(BigDecimal.ZERO);
        promaterialContractEntity.setChangingMnyWithTax(BigDecimal.ZERO);
        promaterialContractEntity.setChangeCode(null);
        promaterialContractEntity.setChangeId(null);
        promaterialContractEntity.setChangeDate(null);
        promaterialContractEntity.setChangeDraftType(null);
        promaterialContractEntity.setChangeContractSignatureStatus(null);
        promaterialContractEntity.setChangeFileId(null);
        promaterialContractEntity.setChangeContractName(null);
        this.contractService.update((Object)promaterialContractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)promaterialContractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType) {
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, "proMaterialContractBill");
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "proMaterialContractBill", targetBillId, targetBillTypeCode, "proMaterialContractBill", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        CommonResponse copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, "mContractFile", targetBillId, targetBillTypeCode, "mContractFile");
        if (!copyContractFileResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "mContractFile", targetBillId, targetBillTypeCode, "mContractFile", copyContractFileResp.getMsg()});
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg()));
        }
        return null;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(PromaterialContractChangeVO promaterialContractChangeVO) {
        PromaterialContractChangeVO promaterialContractChangeVO1 = this.insertOrUpdate(promaterialContractChangeVO, true);
        String linkUrl = promaterialContractChangeVO1.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/contractChange/card?id=" + promaterialContractChangeVO1.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/contractChange/card?id=" + promaterialContractChangeVO1.getId();
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)promaterialContractChangeVO1.getContractId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
        List list = this.contractChangeService.list((Wrapper)wrapper);
        if (list.size() > 0) {
            promaterialContractChangeVO1.setMainContractId(((PromaterialContractChangeEntity)((Object)list.get(0))).getId());
        } else {
            promaterialContractChangeVO1.setMainContractId(promaterialContractChangeVO.getContractId());
        }
        ExecutionVO executionVO = this.contractService.targetCost((PromaterialContractVO)BeanMapper.map((Object)promaterialContractChangeVO1, PromaterialContractVO.class), linkUrl, 1, promaterialContractChangeVO1.getContractType());
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a8\u9001\u63a7\u5236" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a7\u5236\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)response));
        ParamsCheckVO paramsCheckVO = this.checkParams(promaterialContractChangeVO1, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        PromaterialContractChangeVO promaterialContractChangeVO1 = this.queryDetail(id);
        String linkUrl = promaterialContractChangeVO1.getContractType() == 0 ? this.BaseHost + "ejc-steelstructure-frontend/#/contractMaterial/contractChange/card?id=" + promaterialContractChangeVO1.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/contractConcrete/contractChange/card?id=" + promaterialContractChangeVO1.getId();
        ExecutionVO executionVO = this.contractService.targetCost((PromaterialContractVO)BeanMapper.map((Object)promaterialContractChangeVO1, PromaterialContractVO.class), linkUrl, 1, promaterialContractChangeVO1.getContractType());
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a8\u9001\u63a7\u5236" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(promaterialContractChangeVO1, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public PromaterialContractChangeVO queryDetail(Long id) {
        PromaterialContractChangeEntity entity = (PromaterialContractChangeEntity)((Object)this.contractChangeService.selectById(id));
        PromaterialContractChangeVO vo = (PromaterialContractChangeVO)BeanMapper.map((Object)((Object)entity), PromaterialContractChangeVO.class);
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(PromaterialContractChangeVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        paramsCheckVOS.addAll(this.checkParamsMny(vo));
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        if (!"proMaterial-2".equals(vo.getContractPropertyCode()) || !MaterialContractTypeEnum.\u6d88\u8017\u6750.getCode().equals(vo.getContractType())) {
            paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(PromaterialContractChangeVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(vo.getPurchaseType())) {
            return paramsCheckVOS;
        }
        BigDecimal changeMoney = vo.getChangeMoney() == null ? BigDecimal.ZERO : vo.getChangeMoney();
        BigDecimal contractTaxMny = vo.getBaseMoneyWithTax() == null ? BigDecimal.ZERO : vo.getBaseMoneyWithTax();
        BigDecimal totalChangeMoney = changeMoney;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PromaterialContractChangeEntity::getContractId, (Object)vo.getContractId());
        lambda.eq(PromaterialContractChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        lambda.in(PromaterialContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
            for (PromaterialContractChangeEntity changeEntity : list) {
                totalChangeMoney = ComputeUtil.safeAdd((BigDecimal)changeEntity.getChangeMoney(), (BigDecimal)totalChangeMoney);
            }
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getContractType()) {
            case 0: {
                CHECK_PARAM_CODE = M_PARAM_CODE;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = C_PARAM_CODE;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalChangeMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u53d8\u66f4\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff1a").append(changeMoney.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff1a").append(totalChangeMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalChangeMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(PromaterialContractChangeVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(vo.getPurchaseType())) {
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        BigDecimal planTaxMny = BigDecimal.ZERO;
        BigDecimal totalMoney = contractTaxMny;
        LambdaQueryWrapper planLambda = new LambdaQueryWrapper();
        planLambda.eq(MasterPlanEntity::getProjectId, (Object)vo.getProjectId());
        planLambda.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        planLambda.eq(BaseEntity::getDr, (Object)0);
        planLambda.eq(MasterPlanEntity::getPlanType, (Object)vo.getContractType());
        List planList = this.masterPlanService.list((Wrapper)planLambda);
        if (!CollectionUtils.isNotEmpty((Collection)planList)) {
            return paramsCheckVOS;
        }
        planTaxMny = planList.stream().filter(e -> e.getTotalPlanAmt() != null).map(MasterPlanEntity::getTotalPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper Lambda = new LambdaQueryWrapper();
        Lambda.eq(PromaterialContractEntity::getProjectId, (Object)vo.getProjectId());
        Lambda.orderByDesc(BaseEntity::getCreateTime);
        Lambda.eq(PromaterialContractEntity::getContractType, (Object)vo.getContractType());
        if (MaterialContractTypeEnum.\u6d88\u8017\u6750.getCode().equals(vo.getContractType())) {
            Lambda.ne(PromaterialContractEntity::getContractPropertyCode, (Object)"proMaterial-2");
        }
        Lambda.ne(BaseEntity::getId, (Object)vo.getContractId());
        List list = this.contractService.list((Wrapper)Lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<Long> collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<PromaterialContractChangeVO> contractChangeList = this.PromaterialContractMapper.getContractChangeList(collect);
            Map<Long, PromaterialContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(PromaterialContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
            List<PromaterialSettlementVO> settlementList = this.PromaterialContractMapper.getSettlementList(collect);
            Map<Long, PromaterialSettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(PromaterialSettlementVO::getContractId, item -> item, (v1, v2) -> v2));
            for (PromaterialContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;
                if (PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode().equals(entity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(entity.getPerformanceStatus())) {
                    if (mapSettle.containsKey(entity.getId())) {
                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
                    }
                } else {
                    zero = mapChange.containsKey(entity.getId()) ? mapChange.get(entity.getId()).getContractTaxMny() : entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd((BigDecimal)zero, (BigDecimal)totalMoney);
            }
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getContractType()) {
            case 0: {
                CHECK_PARAM_CODE = M_PLAN_CODE;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = C_PLAN_CODE;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u91c7\u8d2d\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u91c7\u8d2d\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\uff1a").append(totalMoney.setScale(2, 4)).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(PromaterialContractChangeVO vo) {
        CommonResponse contractionData = this.contractPoolApi.queryContractionTaxMny(vo.getProjectId());
        if (!contractionData.isSuccess() || null == contractionData.getData()) {
            this.logger.info(contractionData.getMsg());
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        BigDecimal contractionTaxMny = new BigDecimal(String.valueOf(contractionData.getData()));
        this.logger.info("\u83b7\u53d6\u9879\u76ee\uff1a{}\u4e0b\uff0c\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)vo.getProjectId(), (Object)contractionTaxMny);
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        if (BigDecimal.ZERO.compareTo(contractionTaxMny) == 0) {
            return paramsCheckVOList;
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                CommonResponse projectData = this.executionApi.queryTotalContMny(vo.getProjectId());
                if (!projectData.isSuccess() || null == projectData.getData()) {
                    this.logger.info(projectData.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                BigDecimal allExpenseContractTaxMny = new BigDecimal(String.valueOf(projectData.getData()));
                this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u9879\u76ee\uff1a{}\u4e0b\uff0c\u6240\u6709\u652f\u51fa\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)vo.getProjectId(), (Object)allExpenseContractTaxMny);
                BigDecimal thisTimeChangeTaxMny = vo.getChangeMoney();
                this.logger.info("\u672c\u6b21\u53d8\u52a8\u91d1\u989d\uff1a{}", (Object)thisTimeChangeTaxMny);
                for (BillParamVO billParamVO : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractionTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    this.logger.info("\u65bd\u5de5\u5408\u540c\u91d1\u989d*\u6bd4\u4f8b\u540e\u91d1\u989d\uff1a{}", (Object)comMny);
                    BigDecimal sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)allExpenseContractTaxMny, (BigDecimal)thisTimeChangeTaxMny).setScale(2, 4);
                    this.logger.info("\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a{}", (Object)sumPayContractTaxMny);
                    if (sumPayContractTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u652f\u51fa\u8d85\u65bd\u5de5\u5408\u540c");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u652f\u51fa\u5408\u540c\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(vo.getContractTaxMny()).append("\u5143\uff0c\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(sumPayContractTaxMny).append("\u5143\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumPayContractTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    this.logger.info("paramsCheckDsVO:{}", (Object)JSONObject.toJSONString((Object)paramsCheckDsVO));
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public void updateTotalChangeDataByContractId(PromaterialContractChangeEntity changeEntity, String type) {
        this.logger.info("\u5408\u540c\u53d8\u66f4" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u548c\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b\uff0c\u5f00\u59cb\uff0cchangeEntity={}\uff0ctype={}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)), (Object)type);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"contract_id", (Object)changeEntity.getContractId())).eq((Object)"performance_status", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        if ("back".equals(type)) {
            wrapper.ne((Object)"id", (Object)changeEntity.getId());
        }
        wrapper.select(new String[]{"sum(ifnull(change_money, 0)) as totalChangeTaxMny, sum(ifnull(change_money, 0) - ifnull(change_rate, 0)) as totalChangeMny, sum(ifnull(change_rate, 0)) as totalChangeTax"});
        Map totalChangeMap = super.getMap((Wrapper)wrapper);
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u5408\u540c\u7684\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u7684\u7d2f\u52a0\u503c\u4f5c\u4e3a\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)totalChangeMap);
        BigDecimal totalChangeTaxMny = BigDecimal.ZERO;
        BigDecimal totalChangeMny = BigDecimal.ZERO;
        BigDecimal totalChangeTax = BigDecimal.ZERO;
        BigDecimal totalChangeRate = BigDecimal.ZERO;
        if (MapUtils.isNotEmpty((Map)totalChangeMap)) {
            totalChangeTaxMny = totalChangeMap.get("totalChangeTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTaxMny").toString());
            totalChangeMny = totalChangeMap.get("totalChangeMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeMny").toString());
            BigDecimal bigDecimal = totalChangeTax = totalChangeMap.get("totalChangeTax") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTax").toString());
            if (null != changeEntity.getBaseMoneyWithTax() && changeEntity.getBaseMoneyWithTax().compareTo(BigDecimal.ZERO) > 0) {
                totalChangeRate = totalChangeTaxMny.divide(changeEntity.getBaseMoneyWithTax(), 8, 5).multiply(new BigDecimal(100));
            }
            this.logger.info("\u8ba1\u7b97\uff1a\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b = \u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\uff09 / \u5408\u540c\u521d\u59cb\u91d1\u989d\uff08\u542b\u7a0e\uff09 = {}", (Object)totalChangeRate);
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setTotalChangeTaxMny(totalChangeTaxMny);
            contractPoolVO.setTotalChangeMny(totalChangeMny);
            contractPoolVO.setTotalChangeTax(totalChangeTax);
            contractPoolVO.setTaotalChangeScale(totalChangeRate);
            contractPoolVO.setSourceId(changeEntity.getContractId());
            CommonResponse saveAfterChangeRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("\u5408\u540c\u53d8\u66f4" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u548c\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b\uff0c\u7ed3\u675f\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)saveAfterChangeRes));
        }
    }

    @Override
    public void asyncWatermarkById(Long id) {
        PromaterialContractChangeEntity changeEntity = (PromaterialContractChangeEntity)((Object)super.selectById((Serializable)id));
        this.logger.info("\u5f00\u59cb\u83b7\u53d6\u6c34\u5370\u53c2\u6570\u4fe1\u606f\uff0c\u53d8\u66f4\u5408\u540cid\uff1a{}--------", (Object)id);
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        this.logger.info("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            String billType = "BT211227000000004";
            String sourceType = "contractMaterial";
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(changeEntity.getContractType())) {
                billType = "BT220215000000002";
                sourceType = "contractConcrete";
            }
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(), changeEntity.getBillCode(), billType, sourceType);
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractChangeAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }
}

