/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.plan.service.impl;

import com.ejianc.business.steelstructure.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.steelstructure.promaterial.plan.service.IBatPlanService;
import com.ejianc.business.steelstructure.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="promaterialBatPlan")
public class BatPlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SIGN = "plan";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBatPlanService batPlanService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------\u64a4\u56de\u524d\u56de\u8c03------------");
        this.logger.info("billId:{},state:{},billTypeCode:{}", new Object[]{billId, state, billTypeCode});
        BatPlanEntity batPlanEntity = (BatPlanEntity)((Object)this.batPlanService.selectById(billId));
        if (BatPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(batPlanEntity.getPlanState())) {
            return CommonResponse.success();
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u68c0\u67e5\u7ed3\u679c\uff1a{}", (Object)resp);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)"\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        BatPlanEntity batPlanEntity;
        this.logger.info("-------------------\u5ba1\u6279\u524d\u56de\u8c03------------------------");
        this.logger.info("sign-->>{}", (Object)sign);
        if (SIGN.equals(sign) && ((batPlanEntity = (BatPlanEntity)((Object)this.batPlanService.selectById(billId))) == null || batPlanEntity.getTrusteesId() == null)) {
            return CommonResponse.error((String)"\u8bf7\u5148\u9009\u62e9\u62db\u6807\u7ecf\u529e\u4eba\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("-------------------\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03------------------------");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("------------\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03------------");
        this.logger.info("\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03===billId:{},state:{},billTypeCode:{}", new Object[]{billId, state, billTypeCode});
        BatPlanEntity batPlanEntity = (BatPlanEntity)((Object)this.batPlanService.selectById(billId));
        if (BatPlanEnum.PLAN_STATE_WAIT.getPlanState().equals(batPlanEntity.getPlanState())) {
            return CommonResponse.success();
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u68c0\u67e5\u7ed3\u679c\uff1a{}", (Object)resp);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)"\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

