/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.steelstructure.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.steelstructure.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.steelstructure.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="promaterialMasterPlan")
public class MasterPlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMasterPlanService masterPlanService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MasterPlanEntity e = (MasterPlanEntity)((Object)this.masterPlanService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.masterPlanService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        MasterPlanEntity e = (MasterPlanEntity)((Object)this.masterPlanService.selectById(billId));
        this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u64a4\u56de\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MasterPlanEntity e = (MasterPlanEntity)((Object)this.masterPlanService.selectById(billId));
        e.setEffectiveDate(new Date());
        if (state == 1) {
            UserContext userContext = this.sessionManager.getUserContext();
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
        }
        this.masterPlanService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MasterPlanEntity e = (MasterPlanEntity)((Object)this.masterPlanService.selectById(billId));
        if (e != null) {
            if (e.getChangeState() == MasterPlanVO.PLAN_CHANGE_STATE_CHANGING) {
                return CommonResponse.error((String)"\u53d8\u66f4\u4e2d\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
            if (e.getChangeState() == MasterPlanVO.PLAN_CHANGE_STATE_CHANGED) {
                return CommonResponse.error((String)"\u5df2\u53d8\u66f4\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
        }
        this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u7269\u8d44\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

