/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.settlement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statistic"})
public class PromaterialStatisticController
implements Serializable {
    @Autowired
    private IPromaterialSettlementService service;

    @RequestMapping(value={"/getSettlementInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getSettlementInfo(Long projectDepartmentId, String settlementDate) {
        JSONObject jo = new JSONObject();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        if (projectDepartmentId != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.select(new String[]{"count(id) AS businessCount, IFNULL( sum(settlement_tax_mny),0) AS settlementTaxMny"});
            wrapper.in((Object)"bill_state", list);
            wrapper.eq((Object)"org_id", (Object)projectDepartmentId);
            if (StringUtils.isNotBlank((String)settlementDate)) {
                String[] split = settlementDate.split(",");
                wrapper.ge((Object)"settlement_date", (Object)split[0]);
                wrapper.le((Object)"settlement_date", (Object)split[1]);
            }
            wrapper.apply("contract_id is null AND contract_name is null", new Object[0]);
            PromaterialSettlementEntity one = (PromaterialSettlementEntity)((Object)this.service.getOne((Wrapper)wrapper));
            jo.put("businessCount", (Object)one.getBusinessCount());
            jo.put("settlementTaxMny", (Object)one.getSettlementTaxMny());
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jo);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u7f3a\u5c11\u9879\u76ee\u90e8id\uff01", (Object)jo);
    }

    @RequestMapping(value={"/getCheckInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getCheckInfo(Long projectDepartmentId, String settlementDate) {
        JSONObject jo = new JSONObject();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        if (projectDepartmentId != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.select(new String[]{"count(id) AS businessCount, IFNULL( sum(check_all_tax_mny),0) AS settlementTaxMny"});
            wrapper.in((Object)"bill_state", list);
            wrapper.eq((Object)"org_id", (Object)projectDepartmentId);
            if (StringUtils.isNotBlank((String)settlementDate)) {
                String[] split = settlementDate.split(",");
                wrapper.ge((Object)"instore_date", (Object)split[0]);
                wrapper.le((Object)"instore_date", (Object)split[1]);
            }
            wrapper.apply("contract_id is null AND contract_name is null", new Object[0]);
            PromaterialSettlementEntity one = (PromaterialSettlementEntity)((Object)this.service.getOne((Wrapper)wrapper));
            jo.put("businessCount", (Object)one.getBusinessCount());
            jo.put("settlementTaxMny", (Object)one.getSettlementTaxMny());
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jo);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u7f3a\u5c11\u9879\u76ee\u90e8id\uff01", (Object)jo);
    }
}

