/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.promaterial.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.steelstructure.promaterial.contract.bean.PromaterialContractEntity;
import com.ejianc.business.steelstructure.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.steelstructure.promaterial.contract.service.IPromaterialContractService;
import com.ejianc.business.steelstructure.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementDetailEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.bean.PromaterialSettlementEntity;
import com.ejianc.business.steelstructure.promaterial.settlement.service.IPromaterialSettlementService;
import com.ejianc.business.steelstructure.promaterial.settlement.vo.PromaterialSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.tender.abolish.vo.FlowVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="promaterialSettlement")
public class PromaterialSettlementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPromaterialSettlementService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settlement/delSettlement";
    @Autowired
    private IPromaterialContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        PromaterialSettlementEntity entity = (PromaterialSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(promaterialContractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(promaterialContractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + promaterialContractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(promaterialContractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        PromaterialSettlementEntity entity = (PromaterialSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(promaterialContractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(promaterialContractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + promaterialContractEntity.getContractName() + "},\u5408\u540c\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(promaterialContractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PromaterialSettlementEntity entity = (PromaterialSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(promaterialContractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(promaterialContractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + promaterialContractEntity.getContractName() + "},\u5408\u540c\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(promaterialContractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            this.logger.info("\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u5f00\u59cb\uff01");
            PromaterialSettlementEntity entity = (PromaterialSettlementEntity)((Object)this.service.selectById(billId));
            PromaterialSettlementVO promaterialSettlementVO = (PromaterialSettlementVO)BeanMapper.map((Object)((Object)entity), PromaterialSettlementVO.class);
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            ArrayList<Long> ids = new ArrayList<Long>();
            this.logger.info("\u8be5\u7ed3\u7b97\u5355\u72b6\u6001---{}", (Object)entity.getSettlementType());
            Boolean flag = true;
            if (entity.getSettlementType() == 0 && "proMaterial-2".equals(entity.getContractPropertyCode())) {
                flag = false;
            }
            if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList()) && flag.booleanValue()) {
                this.logger.info("\u5b50\u8868\u4fe1\u606f\u5904\u7406\u5f00\u59cb\uff01" + JSONObject.toJSONString(entity.getSettlementDetailList()));
                for (PromaterialSettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    BigDecimal taxPrice;
                    BigDecimal storeTaxPrice;
                    if (detail.getReconciliationDetailId() != null) {
                        ids.add(detail.getReconciliationDetailId());
                    }
                    if ((storeTaxPrice = detail.getStoreTaxPrice() == null ? BigDecimal.ZERO : detail.getStoreTaxPrice()).compareTo(taxPrice = detail.getTaxPrice() == null ? BigDecimal.ZERO : detail.getTaxPrice()) == 0) continue;
                    FlowVO flowVO = new FlowVO();
                    flowVOS.add(flowVO);
                }
            }
            if (entity.getContractId() != null && entity.getSignatureType() == 1) {
                PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
                promaterialContractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode());
                this.contractService.saveOrUpdate((Object)promaterialContractEntity);
                this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)promaterialContractEntity)));
            }
            this.service.updateContractPoolSettle(promaterialSettlementVO, true);
            boolean pool = this.service.pushSettleToPool(promaterialSettlementVO);
            if (!pool) {
                throw new BusinessException("\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
            if (entity.getSignatureType() != null && entity.getSignatureType() == 1 && entity.getContractId() != null) {
                String linkUrl = entity.getSettlementType() == 0 ? (null == entity.getContractId() || 0L == entity.getContractId() ? this.BaseHost + "ejc-steelstructure-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/settlementList/settlementCard?id=" + entity.getId()) : (null == entity.getContractId() || 0L == entity.getContractId() ? this.BaseHost + "ejc-steelstructure-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : this.BaseHost + "ejc-steelstructure-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId());
                ExecutionVO executionVO = this.service.targetCost((PromaterialSettlementVO)BeanMapper.map((Object)((Object)entity), PromaterialSettlementVO.class), linkUrl, entity.getSettlementType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            }
            Boolean pushFlag = this.service.pushBillToSupCenter(entity, billTypeCode);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
            if (!pushFlag.booleanValue()) {
                entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            } else {
                entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            }
            this.service.updateById((Object)entity);
            this.service.costPush(entity);
            return CommonResponse.success((String)"\u5ba1\u6279\u901a\u8fc7\u903b\u8f91\u64cd\u4f5c\u5b8c\u6210");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res2 = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res2.isSuccess() + "----" + res2.getMsg());
        if (!res2.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        PromaterialSettlementEntity entity = (PromaterialSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getSignStatus() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (entity.getContractId() != null) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(PromaterialSettlementEntity::getContractId, (Object)entity.getContractId());
            lambda.eq(PromaterialSettlementEntity::getSettlementType, (Object)entity.getSettlementType());
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List list = this.service.list((Wrapper)lambda);
            PromaterialSettlementEntity promaterialSettlementEntity = (PromaterialSettlementEntity)((Object)list.get(0));
            if (!entity.getId().equals(promaterialSettlementEntity.getId())) {
                throw new BusinessException("\u53ea\u80fd\u64a4\u56de\u6700\u65b0\u7684\u7ed3\u7b97\u5355\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PromaterialSettlementEntity entity = (PromaterialSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null && entity.getSignatureType() == 1) {
            PromaterialContractEntity promaterialContractEntity = (PromaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            promaterialContractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            this.contractService.saveOrUpdate((Object)promaterialContractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)promaterialContractEntity)));
        }
        this.service.updateContractPoolSettle((PromaterialSettlementVO)BeanMapper.map((Object)((Object)entity), PromaterialSettlementVO.class), false);
        this.logger.info("\u5220\u9664\u8c03\u5dee\u5355---");
        boolean pool = this.service.delSettleFromPool(billId);
        if (!pool) {
            throw new BusinessException("\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            this.logger.info("\u4f9b\u65b9\u64a4\u56de---");
            this.logger.info("\u8be5\u7ed3\u7b97\u5355\u72b6\u6001---{}", (Object)entity.getSettlementType());
            CommonResponse<String> response = this.service.updatePushBill(entity, billTypeCode, "/ejc-supbusiness-web/openapi/settlement/delSettlement");
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.service.updateById((Object)entity);
            this.logger.info("\u4f9b\u65b9\u64a4\u56de\u6210\u529f---" + JSONObject.toJSONString((Object)((Object)entity)));
        }
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u7ed3\u7b97Id---{}", (Object)entity.getId());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(PromaterialSettlementEntity::getRelationFlag, (Object)"0");
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }
}

