/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.prosub.prosub.dataModel.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.dataModel.vo.ContractDataModelVO;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ChangeDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ChangeEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractEntity;
import com.ejianc.business.steelstructure.prosub.prosub.dataModel.enums.DetailSourceTypeEnum;
import com.ejianc.business.steelstructure.prosub.prosub.dataModel.service.IDataModelService;
import com.ejianc.business.steelstructure.prosub.prosub.enums.ChangeStatusEnum;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.ContractDetailMapper;
import com.ejianc.business.steelstructure.prosub.prosub.service.IChangeDetailService;
import com.ejianc.business.steelstructure.prosub.prosub.service.IChangeService;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractDetailService;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractService;
import com.ejianc.business.steelstructure.prosub.settle.bean.SettleDetailEntity;
import com.ejianc.business.steelstructure.prosub.settle.service.ISettleDetailService;
import com.ejianc.business.steelstructure.prosub.settle.service.ISettleService;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.vo.DutyDetailItemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dataModelService")
public class DataModelServiceImpl
implements IDataModelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IChangeDetailService changeDetailService;
    @Autowired
    private ContractDetailMapper contractDetailMapper;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private ISettleDetailService settleDetailService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IDutyApi dutyApi;

    @Override
    public List<ContractDataModelVO> queryListByContract(JSONObject param) {
        List<ContractDetailEntity> detailEntityList;
        Long contractId;
        List settleDetailEntityList = new ArrayList();
        String billTypeCode = null;
        if (param != null) {
            this.logger.info("\u5408\u540c\u60c5\u51b5\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)param));
            Object bill = param.get((Object)"bill");
            JSONObject content = new JSONObject((Map)((HashMap)bill));
            this.logger.info("\u83b7\u5f97\u5355\u636e\u5185\u5bb9\uff1a{}", (Object)JSONObject.toJSONString((Object)content));
            billTypeCode = (String)param.get((Object)"billTypeCode");
            Long billTypeId = content.getLong("id");
            if (null == billTypeId) {
                return new ArrayList<ContractDataModelVO>();
            }
            this.logger.info("\u83b7\u5f97\u5355\u636e\u7c7b\u578b\uff1a{}", (Object)billTypeCode);
            if (StringUtils.isNotBlank((CharSequence)billTypeCode) && (billTypeCode.equals(ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode()))) {
                contractId = content.getLong("id");
            } else if (StringUtils.isNotBlank((CharSequence)billTypeCode) && (billTypeCode.equals(ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode()))) {
                contractId = content.getLong("contractId");
            } else {
                JSONObject contractIdObject = new JSONObject((Map)((HashMap)content.get((Object)"contractId")));
                contractId = contractIdObject.getLong("id");
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("settleId", new Parameter("eq", (Object)billTypeId));
                queryParam.getParams().put("settleNum", new Parameter("ne", null));
                settleDetailEntityList = this.settleDetailService.queryList(queryParam);
            }
            this.logger.info("\u83b7\u5f97\u5408\u540cid\uff1a{}", (Object)contractId);
        } else {
            contractId = 1552975212769120258L;
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("settleId", new Parameter("eq", (Object)629279231448858629L));
            queryParam.getParams().put("settleNum", new Parameter("ne", null));
            settleDetailEntityList = this.settleDetailService.queryList(queryParam);
            billTypeCode = ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getBillTypeCode();
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (contractEntity == null) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570contractId");
        }
        Boolean changeFlag = false;
        HashMap<Long, Long> changeIdMap = new HashMap<Long, Long>();
        if ((ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode().equals(contractEntity.getChangeStatus()) || billTypeCode.equals(ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode()) || billTypeCode.equals(ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode())) && contractEntity.getChangeId() != null) {
            ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(contractEntity.getChangeId()));
            if (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(changeEntity.getBillState()) || BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
                this.logger.info("\u5f53\u524d\u5408\u540c\u5904\u4e8e\u53d8\u66f4\u4e2d\uff0c\u4e14\u53d8\u66f4\u5355\u7684\u72b6\u6001\u4e3a\u5ba1\u6279\u4e2d\u3002");
                changeFlag = true;
                contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), ContractEntity.class));
                this.logger.info("\u6570\u636e\u8f6c\u6362\u540e\u7684\u4e3b\u5408\u540c:{}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
                for (ChangeDetailEntity changeDetailEntity : changeEntity.getDetailList()) {
                    changeIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId());
                }
                this.logger.info("\u53d8\u66f4\u5408\u540c\u5b50\u8868id\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(changeIdMap));
            }
        }
        if (CollectionUtils.isEmpty(detailEntityList = contractEntity.getDetailList())) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u5b50\u8868\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570contractId");
        }
        List<ContractDetailEntity> detailList = detailEntityList.stream().filter(item -> item.getDetailNum() != null).collect(Collectors.toList());
        this.logger.info("\u83b7\u53d6\u5230\u6240\u6709\u672b\u7ea7\u6e05\u5355\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(detailList));
        if ((ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u8282\u70b9\u7ed3\u7b97.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u5b8c\u5de5\u7ed3\u7b97.getBillTypeCode().equals(billTypeCode)) && CollectionUtils.isNotEmpty(settleDetailEntityList)) {
            HashMap<Long, ContractDetailEntity> contractDetailListMap = new HashMap<Long, ContractDetailEntity>();
            for (ContractDetailEntity detailEntity : detailList) {
                if (changeFlag.booleanValue()) {
                    contractDetailListMap.put(null != changeIdMap.get(detailEntity.getId()) ? (Long)changeIdMap.get(detailEntity.getId()) : detailEntity.getId(), detailEntity);
                    continue;
                }
                contractDetailListMap.put(detailEntity.getId(), detailEntity);
            }
            detailList = new ArrayList();
            ArrayList<Long> docIds = new ArrayList<Long>();
            ArrayList<Long> contractDetailIds = new ArrayList<Long>();
            for (SettleDetailEntity settleDetailEntity : settleDetailEntityList) {
                ContractDetailEntity sourceDetailEntity;
                ContractDetailEntity detailEntity = new ContractDetailEntity();
                detailEntity.setId(settleDetailEntity.getContractDetailId());
                if (null == contractDetailListMap.get(settleDetailEntity.getContractDetailId()) || docIds.contains((sourceDetailEntity = (ContractDetailEntity)((Object)contractDetailListMap.get(settleDetailEntity.getContractDetailId()))).getDocId()) && contractDetailIds.contains(settleDetailEntity.getContractDetailId())) continue;
                detailEntity.setSourceType(sourceDetailEntity.getSourceType());
                detailEntity.setDetailCode(sourceDetailEntity.getDetailCode());
                detailEntity.setDetailName(sourceDetailEntity.getDetailName());
                detailEntity.setDetailWorkContent(sourceDetailEntity.getDetailWorkContent());
                detailEntity.setDetailMeasurementRules(sourceDetailEntity.getDetailMeasurementRules());
                detailEntity.setDetailUnit(sourceDetailEntity.getDetailUnit());
                detailEntity.setDocId(sourceDetailEntity.getDocId());
                detailEntity.setContractId(contractId);
                detailEntity.setDetailNum(sourceDetailEntity.getDetailNum());
                detailEntity.setDetailMny(sourceDetailEntity.getDetailMny());
                detailEntity.setDetailTaxMny(sourceDetailEntity.getDetailTaxMny());
                docIds.add(sourceDetailEntity.getDocId());
                contractDetailIds.add(settleDetailEntity.getContractDetailId());
                detailList.add(detailEntity);
            }
        }
        List<ContractDataModelVO> contractDataModelVOList = new ArrayList<ContractDataModelVO>();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Boolean stateFlag = false;
            if (contractEntity.getBillState().equals(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode()) || contractEntity.getBillState().equals(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()) || contractEntity.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || contractEntity.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                stateFlag = true;
            }
            for (ContractDetailEntity detail : detailList) {
                if (changeFlag.booleanValue()) {
                    detail.setId(null != changeIdMap.get(detail.getId()) ? (Long)changeIdMap.get(detail.getId()) : detail.getId());
                }
                ContractDataModelVO contractDataModelVO = new ContractDataModelVO();
                contractDataModelVO.setSourceType(detail.getSourceType());
                contractDataModelVO.setSourceTypeName(DetailSourceTypeEnum.getByCode(detail.getSourceType()).getName());
                contractDataModelVO.setDetailCode(detail.getDetailCode());
                contractDataModelVO.setDetailName(detail.getDetailName());
                contractDataModelVO.setDetailWorkContent(detail.getDetailWorkContent());
                contractDataModelVO.setDetailMeasurementRules(detail.getDetailMeasurementRules());
                contractDataModelVO.setDetailUnit(detail.getDetailUnit());
                contractDataModelVO.setDocId(detail.getDocId());
                contractDataModelVO.setContractId(contractId);
                contractDataModelVO.setDetailId(detail.getId());
                if (stateFlag.booleanValue()) {
                    contractDataModelVO.setDetailNum(detail.getDetailNum());
                    contractDataModelVO.setDetailMny(detail.getDetailMny());
                    contractDataModelVO.setDetailTaxMny(detail.getDetailTaxMny());
                }
                contractDataModelVOList.add(contractDataModelVO);
            }
        }
        this.logger.info("\u5f97\u5230\u7684\u5408\u540c\u5b50\u8868\u76f8\u5173\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(contractDataModelVOList));
        this.logger.info("\u5408\u540c\u72b6\u6001\uff1a{}", (Object)BillStateEnum.getEnumByStateCode((Integer)contractEntity.getBillState()).getDescription());
        if (!(contractEntity.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || contractEntity.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode()) || changeFlag.booleanValue())) {
            return contractDataModelVOList;
        }
        contractDataModelVOList = this.setSettleData(contractDataModelVOList, contractId, detailList);
        this.setScale(contractDataModelVOList);
        return contractDataModelVOList;
    }

    private List<ContractDataModelVO> setSettleData(List<ContractDataModelVO> contractDataModelVOList, Long contractId, List<ContractDetailEntity> detailList) {
        QueryParam settleQuery = new QueryParam();
        settleQuery.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        settleQuery.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        List settleEntityList = this.settleService.queryList(settleQuery);
        this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u7b97\u5355\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString((Object)settleEntityList));
        if (CollectionUtils.isEmpty((Collection)settleEntityList)) {
            return contractDataModelVOList;
        }
        List settleIdList = settleEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u7b97\u5355id\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(settleIdList));
        List contractDetailIdList = detailList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.logger.info("\u5408\u540c\u6e05\u5355id\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(contractDetailIdList));
        QueryParam settleDetailQuery = new QueryParam();
        settleDetailQuery.getParams().put("settleId", new Parameter("in", settleIdList));
        settleDetailQuery.getParams().put("contractDetailId", new Parameter("in", contractDetailIdList));
        List settleDetailEntityList = this.settleDetailService.queryList(settleDetailQuery);
        if (CollectionUtils.isEmpty((Collection)settleDetailEntityList)) {
            return contractDataModelVOList;
        }
        this.logger.info("\u67e5\u51fa\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u7b97\u5355\u672b\u7ea7\u6e05\u5355\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString((Object)settleDetailEntityList));
        Map<Integer, List<SettleDetailEntity>> settleDetailMapBySettleType = settleDetailEntityList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getSettleType));
        this.logger.info("\u4f9d\u7167\u7ed3\u7b97\u7c7b\u578b\u5206\u7ec4\u540e\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(settleDetailMapBySettleType));
        Map<Object, Object> processSettleNumMap = new HashMap();
        Map<Object, Object> processSettleTaxMnyMap = new HashMap();
        Map<Object, Object> processSettleMnyMap = new HashMap();
        Map<Object, Object> finishSettleNumMap = new HashMap();
        Map<Object, Object> finishSettleTaxMnyMap = new HashMap();
        Map<Object, Object> finishSettleMnyMap = new HashMap();
        Map<Object, Object> nodeSettleNumMap = new HashMap();
        Map<Object, Object> nodeSettleTaxMnyMap = new HashMap();
        Map<Object, Object> nodeSettleMnyMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settleDetailMapBySettleType.get(0))) {
            List<SettleDetailEntity> processSettleDetailList = settleDetailMapBySettleType.get(0);
            processSettleNumMap = processSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleNum, BigDecimal::add)));
            processSettleTaxMnyMap = processSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleTaxMny, BigDecimal::add)));
            processSettleMnyMap = processSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleMny, BigDecimal::add)));
        }
        if (CollectionUtils.isNotEmpty((Collection)settleDetailMapBySettleType.get(1))) {
            List<SettleDetailEntity> finishSettleDetailList = settleDetailMapBySettleType.get(1);
            finishSettleNumMap = finishSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleNum, BigDecimal::add)));
            finishSettleTaxMnyMap = finishSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleTaxMny, BigDecimal::add)));
            finishSettleMnyMap = finishSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleMny, BigDecimal::add)));
        }
        if (CollectionUtils.isNotEmpty((Collection)settleDetailMapBySettleType.get(2))) {
            List<SettleDetailEntity> nodeSettleDetailList = settleDetailMapBySettleType.get(2);
            nodeSettleNumMap = nodeSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleNum, BigDecimal::add)));
            nodeSettleTaxMnyMap = nodeSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleTaxMny, BigDecimal::add)));
            nodeSettleMnyMap = nodeSettleDetailList.stream().collect(Collectors.groupingBy(SettleDetailEntity::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailEntity::getSettleMny, BigDecimal::add)));
        }
        for (ContractDataModelVO vo : contractDataModelVOList) {
            if (processSettleNumMap.containsKey(vo.getDetailId())) {
                vo.setTotalProcessNum((BigDecimal)processSettleNumMap.get(vo.getDetailId()));
            }
            if (processSettleTaxMnyMap.containsKey(vo.getDetailId())) {
                vo.setTotalProcessTaxMny((BigDecimal)processSettleTaxMnyMap.get(vo.getDetailId()));
            }
            if (processSettleMnyMap.containsKey(vo.getDetailId())) {
                vo.setTotalProcessMny((BigDecimal)processSettleMnyMap.get(vo.getDetailId()));
            }
            if (finishSettleNumMap.containsKey(vo.getDetailId())) {
                vo.setTotalFinishNum((BigDecimal)finishSettleNumMap.get(vo.getDetailId()));
            }
            if (finishSettleTaxMnyMap.containsKey(vo.getDetailId())) {
                vo.setTotalFinishTaxMny((BigDecimal)finishSettleTaxMnyMap.get(vo.getDetailId()));
            }
            if (finishSettleMnyMap.containsKey(vo.getDetailId())) {
                vo.setTotalFinishMny((BigDecimal)finishSettleMnyMap.get(vo.getDetailId()));
            }
            if (nodeSettleNumMap.containsKey(vo.getDetailId())) {
                vo.setTotalNodeNum((BigDecimal)nodeSettleNumMap.get(vo.getDetailId()));
            }
            if (nodeSettleTaxMnyMap.containsKey(vo.getDetailId())) {
                vo.setTotalNodeTaxMny((BigDecimal)nodeSettleTaxMnyMap.get(vo.getDetailId()));
            }
            if (!nodeSettleMnyMap.containsKey(vo.getDetailId())) continue;
            vo.setTotalNodeMny((BigDecimal)nodeSettleMnyMap.get(vo.getDetailId()));
        }
        this.logger.info("\u5f97\u5230\u7ed3\u7b97\u4fe1\u606f\u8d4b\u503c\u540e\u7684\u5408\u540c\u5b50\u8868\u76f8\u5173\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(contractDataModelVOList));
        return contractDataModelVOList;
    }

    @Override
    public List<ContractDataModelVO> queryListByProject(JSONObject param) {
        Long projectId = null;
        List<Object> docIdList = new ArrayList();
        String billTypeCode = null;
        int contractType = 1;
        if (param != null) {
            this.logger.info("\u66f4\u65b0\u73af\u5883\u540e-\u5408\u540c\u60c5\u51b5\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)param));
            Object bill = param.get((Object)"bill");
            JSONObject content = new JSONObject((Map)((HashMap)bill));
            this.logger.info("\u83b7\u5f97\u5355\u636e\u5185\u5bb9\uff1a{}", (Object)JSONObject.toJSONString((Object)content));
            billTypeCode = (String)param.get((Object)"billTypeCode");
            this.logger.info("\u83b7\u5f97\u5355\u636e\u7c7b\u578b\uff1a{}", (Object)billTypeCode);
            Long billTypeId = content.getLong("id");
            Integer supplementFlag = content.getInteger("supplementFlag");
            this.logger.info("\u83b7\u5f97\u5355\u636eid:{}", (Object)billTypeId);
            if (ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode().equals(billTypeCode)) {
                if (ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode().equals(billTypeCode)) {
                    contractType = 0;
                }
                if (ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode().equals(billTypeCode)) {
                    if (0 == supplementFlag) {
                        JSONObject jSONObject = new JSONObject((Map)((HashMap)content.get((Object)"projectId")));
                        projectId = jSONObject.getLong("id");
                    } else {
                        projectId = content.getLong("projectId");
                    }
                    this.logger.info("\u83b7\u5f97\u5408\u540c\u9879\u76eeid\uff1a{}", (Object)projectId);
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("contractId", new Parameter("eq", (Object)billTypeId));
                    queryParam.getParams().put("detailNum", new Parameter("ne", null));
                    List contractDetailEntityList = this.contractDetailService.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty((Collection)contractDetailEntityList)) {
                        docIdList = contractDetailEntityList.stream().map(ContractDetailEntity::getDocId).collect(Collectors.toList());
                    }
                } else {
                    projectId = content.getLong("projectId");
                    this.logger.info("\u83b7\u5f97\u53d8\u66f4\u8fc7\u5408\u540c\u9879\u76eeid\uff1a{}", (Object)projectId);
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("changeId", new Parameter("eq", (Object)billTypeId));
                    queryParam.getParams().put("detailNum", new Parameter("ne", null));
                    List changeDetailEntityList = this.changeDetailService.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty((Collection)changeDetailEntityList)) {
                        docIdList = changeDetailEntityList.stream().map(ChangeDetailEntity::getDocId).collect(Collectors.toList());
                    }
                }
            } else if (!ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212.getBillTypeCode().equals(billTypeCode) && !ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212.getBillTypeCode().equals(billTypeCode)) {
                if (content.getString("projectId").contains("id")) {
                    JSONObject jSONObject = new JSONObject((Map)((HashMap)content.get((Object)"projectId")));
                    projectId = jSONObject.getLong("id");
                } else {
                    projectId = content.getLong("projectId");
                }
                this.logger.info("\u83b7\u5f97\u7ed3\u7b97\u9879\u76eeid\uff1a{}", (Object)projectId);
                if (ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u8282\u70b9\u7ed3\u7b97.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u5b8c\u5de5\u7ed3\u7b97.getBillTypeCode().equals(billTypeCode)) {
                    contractType = 0;
                }
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("settleId", new Parameter("eq", (Object)billTypeId));
                queryParam.getParams().put("settleNum", new Parameter("ne", null));
                List settleDetailEntityList = this.settleDetailService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)settleDetailEntityList)) {
                    docIdList = settleDetailEntityList.stream().map(SettleDetailEntity::getDocId).collect(Collectors.toList());
                }
            }
            this.logger.info("\u9875\u9762\u6863\u6848id\u96c6\u5408:{}", docIdList);
            this.logger.info("\u5408\u540c\u7c7b\u578b 0 \u52b3\u52a1 1 \u4e13\u4e1a:{}", (Object)contractType);
        } else {
            projectId = 586573422415986776L;
            docIdList = Arrays.asList(1493470196962140161L, 1493470196953751554L);
            contractType = 0;
            projectId = 592750047901925456L;
            docIdList = Arrays.asList(546727233671806980L, 1493128925534679041L, 1493128925698256897L, 1493128925635342337L);
            contractType = 1;
            projectId = 614864965224513589L;
            docIdList = Arrays.asList(1493470196911808513L, 1493470196932780034L, 1493470196945362946L, 1493470196953751554L, 1493470196962140161L, 1493470196970528770L);
            contractType = 0;
            projectId = 627804093024976938L;
            docIdList = Arrays.asList(1493470196911808513L, 1493470196953751554L, 1493470196962140161L, 620268264174010448L, 622147447699423321L, 1493470196932780034L);
            contractType = 0;
            billTypeCode = ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode();
        }
        List<Object> contractDataModelVOList = new ArrayList();
        if (ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getBillTypeCode().equals(billTypeCode)) {
            this.logger.info("\u4e3b\u5408\u540c\u7ef4\u5ea6\uff1a\u5355\u636e\u7c7b\u578b\uff1a{}", (Object)billTypeCode);
            contractDataModelVOList = this.contractDetailMapper.queryContractDataModelByContract(projectId, docIdList, contractType);
        } else if (ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c\u53d8\u66f4.getBillTypeCode().equals(billTypeCode)) {
            this.logger.info("\u53d8\u66f4\u7ef4\u5ea6\uff1a\u5355\u636e\u7c7b\u578b\uff1a{}", (Object)billTypeCode);
            contractDataModelVOList = this.contractDetailMapper.queryContractDataModelByChange(projectId, docIdList, contractType);
        } else if (ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212.getBillTypeCode().equals(billTypeCode) || ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212.getBillTypeCode().equals(billTypeCode)) {
            this.logger.info("\u603b\u8ba1\u5212\u7ef4\u5ea6\uff1a\u5355\u636e\u7c7b\u578b\uff1a{}", (Object)billTypeCode);
            contractDataModelVOList = this.contractDetailMapper.queryContractDataModelByPlan(projectId, docIdList, contractType);
        } else {
            this.logger.info("\u7ed3\u7b97\u7ef4\u5ea6\uff1a\u5355\u636e\u7c7b\u578b\uff1a{}", (Object)billTypeCode);
            contractDataModelVOList = this.contractDetailMapper.queryContractDataModelBySettle(projectId, docIdList, contractType);
        }
        this.logger.info("\u6839\u636e\u9879\u76ee\u7ef4\u5ea6\u67e5\u51fa\u7684\u5408\u540c\u5b50\u8868\u6570\u636e\u6a21\u578b\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(contractDataModelVOList));
        if (CollectionUtils.isNotEmpty(contractDataModelVOList)) {
            CommonResponse mapCommonResponse = this.dutyApi.queryDocDutyDetailItem(projectId, Integer.valueOf(contractType == 0 ? 1 : 2));
            this.logger.info("\u67e5\u8be2\u76ee\u6807\u91cf\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)mapCommonResponse));
            if (mapCommonResponse.isSuccess()) {
                Map targetMap = (Map)mapCommonResponse.getData();
                for (ContractDataModelVO contractDataModelVO : contractDataModelVOList) {
                    if (targetMap == null || targetMap.get(contractDataModelVO.getDocId()) == null) continue;
                    DutyDetailItemVO dutyDetailItemVO = (DutyDetailItemVO)targetMap.get(contractDataModelVO.getDocId());
                    contractDataModelVO.setTargetNum(dutyDetailItemVO.getAmount());
                    contractDataModelVO.setTargetMny(dutyDetailItemVO.getTaxMny());
                    if (null != contractDataModelVO.getDetailNum() && null != contractDataModelVO.getTargetNum()) {
                        contractDataModelVO.setTargetRemainderNum(contractDataModelVO.getTargetNum().subtract(contractDataModelVO.getDetailNum()));
                    }
                    if (null == contractDataModelVO.getDetailTaxMny() || null == contractDataModelVO.getTargetMny()) continue;
                    contractDataModelVO.setTargetRemainderMny(contractDataModelVO.getTargetMny().subtract(contractDataModelVO.getDetailTaxMny()));
                }
            }
        }
        this.logger.info("\u9879\u76ee\u7ef4\u5ea6\u5408\u540c\u660e\u7ec6\u6570\u636e\u6a21\u578b\u4fe1\u606f\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString(contractDataModelVOList));
        this.setScale(contractDataModelVOList);
        return contractDataModelVOList;
    }

    private void setScale(List<ContractDataModelVO> contractDataModelVOList) {
        if (CollectionUtils.isNotEmpty(contractDataModelVOList)) {
            for (ContractDataModelVO contractDataModelVO : contractDataModelVOList) {
                contractDataModelVO.setDetailNum(null != contractDataModelVO.getDetailNum() ? contractDataModelVO.getDetailNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setDetailTaxMny(null != contractDataModelVO.getDetailTaxMny() ? contractDataModelVO.getDetailTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalProcessNum(null != contractDataModelVO.getTotalProcessNum() ? contractDataModelVO.getTotalProcessNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalProcessTaxMny(null != contractDataModelVO.getTotalProcessTaxMny() ? contractDataModelVO.getTotalProcessTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalFinishNum(null != contractDataModelVO.getTotalFinishNum() ? contractDataModelVO.getTotalFinishNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalFinishTaxMny(null != contractDataModelVO.getTotalFinishTaxMny() ? contractDataModelVO.getTotalFinishTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalNodeNum(null != contractDataModelVO.getTotalNodeNum() ? contractDataModelVO.getTotalNodeNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTotalNodeTaxMny(null != contractDataModelVO.getTotalNodeTaxMny() ? contractDataModelVO.getTotalNodeTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setPlanNum(null != contractDataModelVO.getPlanNum() ? contractDataModelVO.getPlanNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setPlanTaxMny(null != contractDataModelVO.getPlanTaxMny() ? contractDataModelVO.getPlanTaxMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTargetNum(null != contractDataModelVO.getTargetNum() ? contractDataModelVO.getTargetNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTargetMny(null != contractDataModelVO.getTargetMny() ? contractDataModelVO.getTargetMny().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTargetRemainderNum(null != contractDataModelVO.getTargetRemainderNum() ? contractDataModelVO.getTargetRemainderNum().setScale(2, RoundingMode.HALF_UP) : null);
                contractDataModelVO.setTargetRemainderMny(null != contractDataModelVO.getTargetRemainderMny() ? contractDataModelVO.getTargetRemainderMny().setScale(2, RoundingMode.HALF_UP) : null);
            }
        }
    }
}

