/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.prosub.prosub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.steelstructure.prosub.prosub.bean.CategoryDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.CategoryEntity;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.CategoryDetailMapper;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.CategoryMapper;
import com.ejianc.business.steelstructure.prosub.prosub.service.ICategoryDetailService;
import com.ejianc.business.steelstructure.prosub.prosub.service.ICategoryService;
import com.ejianc.business.steelstructure.prosub.prosub.vo.CategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="categoryService")
public class CategoryServiceImpl
extends BaseServiceImpl<CategoryMapper, CategoryEntity>
implements ICategoryService {
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "LSC_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICategoryDetailService labsubItemService;
    @Autowired
    private CategoryDetailMapper labsubCategoryMapper;
    @Autowired
    private ICategoryService service;

    @Override
    public List<Long> queryUnenabledCategoryListId() {
        return ((CategoryMapper)this.baseMapper).queryUnenabledCategoryListId();
    }

    @Override
    public List<CategoryVO> queryRemoveListByIds(Long pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("parentId", pid);
        List<CategoryVO> materialCategoryList = ((CategoryMapper)this.baseMapper).queryRemoveListByIds(params);
        return materialCategoryList;
    }

    @Override
    public List<CategoryVO> queryLabsubCategoryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<CategoryVO> resultList = ((CategoryMapper)this.baseMapper).queryLabsubCategoryList(condition);
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<CategoryVO> saveOrUpdateLabsubCategory(CategoryVO saveorUpdateVO) {
        CategoryEntity labsubCategoryEntity;
        CategoryEntity entity = (CategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CategoryEntity.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)saveorUpdateVO.getCategoryCode()));
        List labsubCategoryEntities = this.queryList(queryParam);
        if (saveorUpdateVO.getId() != null ? !(labsubCategoryEntity = (CategoryEntity)((Object)this.selectById(saveorUpdateVO.getId()))).getCategoryCode().equals(saveorUpdateVO.getCategoryCode()) && CollectionUtils.isNotEmpty((Collection)labsubCategoryEntities) : CollectionUtils.isNotEmpty((Collection)labsubCategoryEntities)) {
            return CommonResponse.error((String)"\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getCategoryCode())) {
                entity.setCategoryCode((String)billCode.getData());
            } else {
                entity.setCategoryCode(saveorUpdateVO.getCategoryCode());
            }
        } else {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            updateWrapper.set(CategoryEntity::getCategoryName, (Object)saveorUpdateVO.getCategoryName());
            updateWrapper.set(CategoryEntity::getCategoryCode, (Object)saveorUpdateVO.getCategoryCode());
            updateWrapper.set(CategoryEntity::getOrgId, (Object)this.sessionManager.getUserContext().getOrgId());
            updateWrapper.set(CategoryEntity::getOrgName, (Object)this.sessionManager.getUserContext().getOrgName());
            updateWrapper.set(CategoryEntity::getSubjectId, (Object)saveorUpdateVO.getSubjectId());
            updateWrapper.set(CategoryEntity::getSubjectName, (Object)saveorUpdateVO.getSubjectName());
            updateWrapper.set(CategoryEntity::getRemarks, (Object)saveorUpdateVO.getRemarks());
            updateWrapper.set(CategoryEntity::getSequence, (Object)saveorUpdateVO.getSequence());
            this.update((Wrapper)updateWrapper);
            Long tenantId = InvocationInfoProxy.getTenantid();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(entity.getId());
            List<CategoryEntity> labsubCategoryEntities1 = ((CategoryMapper)this.baseMapper).queryByInnerCodes(tenantId, ids);
            ids.clear();
            labsubCategoryEntities1.forEach(item -> {
                ids.add(item.getId());
                this.labsubItemService.updateByCategoryId(item.getId(), entity.getSubjectId(), entity.getSubjectName());
            });
            CategoryEntity labsubCategoryEntity2 = (CategoryEntity)((Object)this.selectById(saveorUpdateVO.getId()));
            if (labsubCategoryEntity2 == null) return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
            LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
            lambdaUpdateWrapper.eq(CategoryDetailEntity::getCategoryId, (Object)saveorUpdateVO.getId());
            lambdaUpdateWrapper.set(CategoryDetailEntity::getCategoryName, (Object)labsubCategoryEntity2.getCategoryName());
            this.labsubItemService.update((Wrapper)lambdaUpdateWrapper);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
        }
        entity.setId(IdWorker.getId());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            labsubCategoryEntity = (CategoryEntity)((Object)this.selectById(entity.getParentId()));
            entity.setInnerCode(labsubCategoryEntity.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        entity.setEnabled(1);
        this.save((Object)entity);
        CategoryVO vo = (CategoryVO)BeanMapper.map((Object)((Object)entity), CategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<String> deleteById(List<CategoryVO> vos) {
        List collect = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id", new Parameter("in", collect));
        List prosubItemEntities = this.labsubItemService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)prosubItemEntities)) {
            return CommonResponse.error((String)"\u5206\u7c7b\u4e0b\u5173\u8054\u4e13\u4e1a\u5206\u5305\u6863\u6848\uff01");
        }
        QueryParam queryClassifyParam = new QueryParam();
        queryClassifyParam.getParams().put("parent_id", new Parameter("in", collect));
        List prosubItems = this.service.queryList(queryClassifyParam);
        if (CollectionUtils.isNotEmpty((Collection)prosubItems)) {
            return CommonResponse.error((String)"\u5206\u7c7b\u4e0b\u5173\u8054\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

