/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.prosub.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.prosub.settlePayment.SettlePaymentVO;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractDetailEntity;
import com.ejianc.business.steelstructure.prosub.prosub.bean.ContractEntity;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.ContractDetailMapper;
import com.ejianc.business.steelstructure.prosub.prosub.service.IContractService;
import com.ejianc.business.steelstructure.prosub.prosub.settlePayment.service.ISettlePaymentService;
import com.ejianc.business.steelstructure.prosub.settle.bean.SettleEntity;
import com.ejianc.business.steelstructure.prosub.settle.mapper.SettleDetailMapper;
import com.ejianc.business.steelstructure.prosub.settle.mapper.SettleMapper;
import com.ejianc.business.steelstructure.prosub.settle.service.INodeSettleService;
import com.ejianc.business.steelstructure.prosub.settle.service.ISettleService;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="NodeSettleService")
public class NodeSettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements INodeSettleService {
    private static final String LAB_CHECK_PARAM_CODE = "P-5X7L2j41";
    private static final String PRO_CHECK_PARAM_NAME = "P-645vGj44";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettlePaymentService settlePaymentService;
    @Autowired
    private ContractDetailMapper contractDetailMapper;
    @Autowired
    private SettleDetailMapper settleDetailMapper;
    private static final String LAB_NODE_NUM_CHECK_PARAM_CODE = "P-56R00879";
    private static final String PRO_NODE_NUM_CHECK_PARAM_NAME = "P-M5768278";

    @Override
    public ParamsCheckVO mnyCtrl(SettleVO settleVO, Boolean flag) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        if (1 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, settleVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            BigDecimal contractTaxMny;
            ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if ("none".equals(paramsCheck.getWarnType())) continue;
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
            if (null == contract) {
                this.logger.info("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            BigDecimal taxMny = settleVO.getTaxMny();
            BigDecimal totalTaxMny = this.settleService.getLastTaxMny(settleVO.getContractId(), SettleTypeEnum.\u8282\u70b9.getCode(), taxMny, flag);
            if (totalTaxMny.compareTo(contractTaxMny = this.settleService.getContractTaxMny(contract.getContractTaxMny(), roleValue)) > 0) {
                BigDecimal overTaxMny = this.settleService.getOverTaxMny(totalTaxMny, contractTaxMny);
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8282\u70b9\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u8282\u70b9\u7ed3\u7b97\u91d1\u989d\uff1a").append(taxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u8282\u70b9\u7ed3\u7b97\u91d1\u989d\uff1a").append(totalTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u7ed3\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                checkDsVOS.add(paramsCheckDsVO);
                paramsCheck.setDataSource(checkDsVOS);
                paramsCheckVOList.add(paramsCheck);
                continue;
            }
            paramsCheck.setWarnType(paramsArray[0]);
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO numCtrl(SettleVO settleVO, Boolean flag) {
        this.logger.info("NodeSettleServiceImpl--numCtrl()--begin--\u5f53\u524d\u4e3a\u8282\u70b9\u7ed3\u7b97\uff0c\u3010\u5408\u540c\u91cf\u3011\u63a7\u3010\u8282\u70b9\u7ed3\u7b97\u91cf\u3011--\u5165\u53c2\uff1asettleVO={}", (Object)JSONObject.toJSONString((Object)settleVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(LAB_NODE_NUM_CHECK_PARAM_CODE, settleVO.getOrgId());
        }
        if (1 == settleVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PRO_NODE_NUM_CHECK_PARAM_NAME, settleVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVO;
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            ArrayList<ParamsCheckDsVO> dataSource = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheck.getWarnType())) {
                List<Map<String, Object>> contractDetailSettleNumQueryMaps;
                Long tenantid = InvocationInfoProxy.getTenantid();
                List settleDetailList = settleVO.getSettleDetailList();
                HashMap<Long, SettleDetailVO> settleDetailMap = new HashMap<Long, SettleDetailVO>();
                ArrayList<Long> settleDetailIdList = new ArrayList<Long>();
                HashMap<Long, BigDecimal> settleNumMap = new HashMap<Long, BigDecimal>();
                if (CollectionUtils.isNotEmpty((Collection)settleDetailList)) {
                    for (SettleDetailVO settleDetailVO : settleDetailList) {
                        if (settleDetailVO.getDetailNum() == null || "del".equals(settleDetailVO.getRowState())) continue;
                        settleDetailMap.put(settleDetailVO.getContractDetailId(), settleDetailVO);
                        if (settleDetailVO.getId() != null) {
                            settleDetailIdList.add(settleDetailVO.getId());
                        }
                        BigDecimal settleNum = settleDetailVO.getSettleNum() == null ? BigDecimal.ZERO : settleDetailVO.getSettleNum();
                        BigDecimal settleNumTotalOld = (BigDecimal)settleNumMap.get(settleDetailVO.getContractDetailId());
                        settleNumTotalOld = settleNumTotalOld == null ? BigDecimal.ZERO : settleNumTotalOld;
                        settleNumMap.put(settleDetailVO.getContractDetailId(), settleNumTotalOld.add(settleNum));
                    }
                }
                this.logger.info("\u5f85\u4fdd\u5b58\u6570\u636e\u540c\u4e00\u5408\u540c\u6e05\u5355\u4e0b\u7684\u672c\u671f\u7ed3\u7b97\u91cf\u7684\u4e3a\uff1amap={}", (Object)JSONObject.toJSONString(settleNumMap));
                List contractDetailEntityList = new ArrayList();
                QueryWrapper cdWrapper = new QueryWrapper();
                Set settleNumMapKeySet = settleNumMap.keySet();
                if (MapUtils.isNotEmpty(settleNumMap)) {
                    cdWrapper = new QueryWrapper();
                    ((QueryWrapper)((QueryWrapper)cdWrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).in((Object)"id", settleNumMapKeySet);
                    contractDetailEntityList = this.contractDetailMapper.selectList((Wrapper)cdWrapper);
                }
                this.logger.info("\u67e5\u8be2\u5230\u7684\u5f85\u4fdd\u5b58\u6570\u636e\u6240\u5c5e\u7684\u5408\u540c\u6e05\u5355\u6570\u636e\uff1alist={}", (Object)JSONObject.toJSONString(contractDetailEntityList));
                HashMap<Long, Object> contractDetailEntityMap = new HashMap<Long, Object>();
                if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
                    for (Object contractDetailEntity : contractDetailEntityList) {
                        contractDetailEntityMap.put(contractDetailEntity.getId(), contractDetailEntity);
                    }
                }
                HashMap<Long, BigDecimal> cdSettleNumMap = new HashMap<Long, BigDecimal>();
                if (MapUtils.isNotEmpty(settleNumMap) && settleNumMapKeySet.size() > 0) {
                    Object contractDetailEntity;
                    contractDetailEntity = settleNumMapKeySet.iterator();
                    while (contractDetailEntity.hasNext()) {
                        Long key = (Long)contractDetailEntity.next();
                        cdSettleNumMap.put(key, BigDecimal.ZERO);
                    }
                }
                if (CollectionUtils.isNotEmpty(settleNumMapKeySet) && CollectionUtils.isNotEmpty(contractDetailSettleNumQueryMaps = this.settleDetailMapper.queryCountSettleNumByContractSettleType(tenantid, 2, new ArrayList<Long>(settleNumMapKeySet), CollectionUtils.isNotEmpty(settleDetailIdList) ? settleDetailIdList : null))) {
                    for (Map<String, Object> detailSettleNumQueryMap : contractDetailSettleNumQueryMaps) {
                        if (MapUtils.isEmpty(detailSettleNumQueryMap)) continue;
                        Object settleNumTotalObj = detailSettleNumQueryMap.get("settleTotalNum");
                        cdSettleNumMap.put(Long.parseLong(detailSettleNumQueryMap.get("contractDetailId").toString()), new BigDecimal(settleNumTotalObj != null ? settleNumTotalObj.toString() : "0"));
                    }
                }
                this.logger.info("\u67e5\u8be2\u5230\u7684\u5f85\u4fdd\u5b58\u6570\u636e\u7684\u7ed3\u7b97\u6e05\u5355\u6240\u5728\u7684\u5408\u540c\u6e05\u5355\u7684\u665a\u671f\u7684\u672c\u671f\u7ed3\u7b97\u91cf\u7684\u7d2f\u8ba1\u503c\uff1amap={}", (Object)JSONObject.toJSONString(cdSettleNumMap));
                if (MapUtils.isNotEmpty(settleDetailMap)) {
                    Set keySet = settleDetailMap.keySet();
                    if (keySet.size() > 0) {
                        this.logger.info("\u53c2\u6570\u63a7\u5236----begin");
                        for (Long key : keySet) {
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355id\uff1aid={}", (Object)JSONObject.toJSONString((Object)key));
                            BigDecimal settleNumTotalOld = (BigDecimal)cdSettleNumMap.get(key);
                            settleNumTotalOld = settleNumTotalOld == null ? BigDecimal.ZERO : settleNumTotalOld;
                            this.logger.info("\u5408\u540c\u6e05\u5355\u4e0b\u7684\u4e0d\u542b\u672c\u671f\u7d2f\u8ba1\u7ed3\u7b97\u91cf\u4e3a:settleNumTotalOld={}", (Object)settleNumTotalOld);
                            BigDecimal settleNum = (BigDecimal)settleNumMap.get(key);
                            settleNum = settleNum == null ? BigDecimal.ZERO : settleNum;
                            this.logger.info("\u5f85\u4fdd\u5b58\u7684\u7ed3\u7b97\u6e05\u5355\u540c\u4e00\u5408\u540c\u6e05\u5355\u4e0b\u7684\u672c\u671f\u7ed3\u7b97\u91cf\u4e3a:settleNum={}", (Object)settleNum);
                            BigDecimal settleTotalNum = settleNumTotalOld.add(settleNum);
                            this.logger.info("\u5408\u540c\u6e05\u5355\u4e0b\u7684\u542b\u672c\u671f\u7d2f\u8ba1\u7ed3\u7b97\u91cf\u4e3a:settleTotalNum={}", (Object)settleTotalNum);
                            ContractDetailEntity cdEntiey = (ContractDetailEntity)((Object)contractDetailEntityMap.get(key));
                            if (cdEntiey == null) continue;
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355\u6570\u636e\uff1acontractDetailVO={}", (Object)JSONObject.toJSONString((Object)((Object)cdEntiey)));
                            String detailName = cdEntiey.getDetailName();
                            detailName = StringUtils.isBlank((String)detailName) ? "" : detailName;
                            this.logger.info("\u5f53\u524d\u5408\u540c\u6e05\u5355\u540d\u79f0\uff1adetailName={}", (Object)detailName);
                            String detailRule = cdEntiey.getDetailMeasurementRules();
                            detailRule = StringUtils.isBlank((String)detailRule) ? "" : detailRule;
                            this.logger.info("\u5f53\u524d\u8ba1\u91cf\u89c4\u5219\uff1adetailRule={}", (Object)detailRule);
                            BigDecimal detailNum = cdEntiey.getDetailNum() == null ? BigDecimal.ZERO : cdEntiey.getDetailNum();
                            this.logger.info("\u5f53\u524d\u5408\u540c\u91cf\uff1adetailNum={}", (Object)detailNum);
                            BigDecimal conNum = detailNum.multiply(roleValue).divide(new BigDecimal(100), 8, 4);
                            this.logger.info("\u5f53\u524d\u5408\u540c\u91cf*" + roleValue.toString() + "%\uff1aconNum={}", (Object)conNum);
                            this.logger.info("\u518d\u6b21\u6253\u5370\u65e5\u5fd7\uff0c\u542b\u672c\u671f\u7d2f\u8ba1\u7ed3\u7b97\u91cf = {}\uff0c\u5408\u540c\u91cf*" + roleValue.toString() + "% = {}", (Object)settleTotalNum, (Object)conNum);
                            if (settleTotalNum.compareTo(conNum) <= 0) continue;
                            BigDecimal overNum = settleTotalNum.subtract(conNum);
                            this.logger.info("\u8d85\u51fa\u6570\u91cf={}", (Object)overNum);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setWarnItem(detailName + detailRule);
                            paramsCheckDsVO.setWarnName("\u8282\u70b9\u7ed3\u7b97\u6570\u91cf\u5927\u4e8e\u5408\u540c\u6570\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u8282\u70b9\u7ed3\u7b97\u6570\u91cf\uff1a").append(settleNum.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u8282\u70b9\u7ed3\u7b97\u6570\u91cf\uff1a").append(settleTotalNum.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%\uff1a").append(conNum.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(overNum.setScale(2, RoundingMode.DOWN));
                            paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            dataSource.add(paramsCheckDsVO);
                            paramsCheck.setDataSource(dataSource);
                        }
                        this.logger.info("\u53c2\u6570\u63a7\u5236--end");
                    } else {
                        paramsCheck.setWarnType(paramsArray[0]);
                    }
                } else {
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
            this.logger.info("NodeSettleServiceImpl--numCtrl()--end--\u5f53\u524d\u4e3a\u8282\u70b9\u7ed3\u7b97\uff0c\u3010\u5408\u540c\u91cf\u3011\u63a7\u3010\u8282\u70b9\u7ed3\u7b97\u91cf\u3011--\u8fd4\u56de\u7ed3\u679c\uff1aparamsCheckVO={}", (Object)JSONObject.toJSONString((Object)paramsCheck));
            paramsCheckVOList.add(paramsCheck);
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    @Override
    public Boolean addSettlePaymentFlag(Long settleId, Long settlePaymentId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter("eq", (Object)settleId));
        if (null != settlePaymentId) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)settlePaymentId));
        }
        queryParam.getParams().put("billState", new Parameter("not_in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List list = this.settlePaymentService.queryList(queryParam);
        return list.isEmpty();
    }

    @Override
    public SettleVO querySettlePaymentRecord(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("createTime", "desc");
        List settlePaymentList = this.settlePaymentService.queryList(queryParam);
        SettleVO settleVO = new SettleVO();
        if (CollectionUtils.isNotEmpty((Collection)settlePaymentList)) {
            settleVO.setSettlePaymentList(BeanMapper.mapList((Iterable)settlePaymentList, SettlePaymentVO.class));
        }
        return settleVO;
    }
}

